/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import edu.umd.cs.findbugs.annotations.Nullable;

public final class StringUtils {
    private StringUtils() {
    }

    @Nullable
    public static String trimNullable(@Nullable String input) {
        return input != null ? input.trim() : null;
    }

    public static boolean isBlank(@Nullable String input) {
        return input == null || input.matches("\\s*");
    }

    public static String repeat(String input, int count) {
        if (count < 0) {
            String message = String.format("was expecting `count >= 0`, found: %d", count);
            throw new IllegalArgumentException(message);
        }
        int length = Math.multiplyExact(input.length(), count);
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i = 0; i < count; ++i) {
            stringBuilder.append(input);
        }
        return stringBuilder.toString();
    }
}

