/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.logger;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.kit.logger.internal.DefaultLogBuilder;
import org.apache.logging.log4j.kit.message.RecyclingMessageFactory;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.MessageFactory2;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.MessageSupplier;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class AbstractLogger
implements ExtendedLogger {
    public static final Marker FLOW_MARKER = MarkerManager.getMarker((String)"FLOW");
    public static final Marker ENTRY_MARKER = MarkerManager.getMarker((String)"ENTER").setParents(new Marker[]{FLOW_MARKER});
    public static final Marker EXIT_MARKER = MarkerManager.getMarker((String)"EXIT").setParents(new Marker[]{FLOW_MARKER});
    public static final Marker EXCEPTION_MARKER = MarkerManager.getMarker((String)"EXCEPTION");
    public static final Marker THROWING_MARKER = MarkerManager.getMarker((String)"THROWING").setParents(new Marker[]{EXCEPTION_MARKER});
    public static final Marker CATCHING_MARKER = MarkerManager.getMarker((String)"CATCHING").setParents(new Marker[]{EXCEPTION_MARKER});
    private static final String FQCN = AbstractLogger.class.getName();
    private static final String THROWING = "Throwing";
    private static final String CATCHING = "Catching";
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final ThreadLocal<int[]> recursionDepthHolder = new ThreadLocal();
    private final String name;
    private final MessageFactory2 messageFactory;
    private final FlowMessageFactory flowMessageFactory;
    private final Recycler<DefaultLogBuilder> recycler;
    private final Logger statusLogger;

    protected AbstractLogger(String name, MessageFactory messageFactory, FlowMessageFactory flowMessageFactory, RecyclerFactory recyclerFactory, Logger statusLogger) {
        MessageFactory2Adapter messageFactory2Adapter;
        this.name = name;
        if (messageFactory instanceof MessageFactory2) {
            MessageFactory2 messageFactory2 = (MessageFactory2)messageFactory;
            messageFactory2Adapter = messageFactory2;
        } else {
            messageFactory2Adapter = new MessageFactory2Adapter(messageFactory);
        }
        this.messageFactory = messageFactory2Adapter;
        this.flowMessageFactory = flowMessageFactory;
        this.recycler = recyclerFactory.create(DefaultLogBuilder::new);
        this.statusLogger = statusLogger;
    }

    private static void incrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        nArray[0] = nArray[0] + 1;
    }

    private static void decrementRecursionDepth() {
        int[] nArray = AbstractLogger.getRecursionDepthHolder();
        nArray[0] = nArray[0] - 1;
        int newDepth = nArray[0];
        if (newDepth < 0) {
            throw new IllegalStateException("Recursion depth became negative: " + newDepth);
        }
    }

    public abstract boolean isEnabled(Level var1, @Nullable Marker var2);

    protected abstract void doLog(String var1, @Nullable StackTraceElement var2, Level var3, @Nullable Marker var4, @Nullable Message var5, @Nullable Throwable var6);

    protected LogBuilder getLogBuilder(Level level) {
        DefaultLogBuilder builder = this.recycler.acquire();
        return builder.reset(this, level);
    }

    public static int getRecursionDepth() {
        return AbstractLogger.getRecursionDepthHolder()[0];
    }

    private static int[] getRecursionDepthHolder() {
        int[] result = recursionDepthHolder.get();
        if (result == null) {
            result = new int[1];
            recursionDepthHolder.set(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive
    private void logMessageSafely(String fqcn, @Nullable StackTraceElement location, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        try {
            this.logMessageTrackRecursion(fqcn, location, level, marker, message, throwable);
        }
        finally {
            this.recycle(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive
    private void logMessageTrackRecursion(String fqcn, @Nullable StackTraceElement location, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        try {
            AbstractLogger.incrementRecursionDepth();
            this.tryLogMessage(fqcn, location, level, marker, message, throwable);
        }
        finally {
            AbstractLogger.decrementRecursionDepth();
        }
    }

    @PerformanceSensitive
    private static @Nullable Throwable getThrowable(@Nullable Message message, @Nullable Throwable throwable) {
        return throwable != null ? throwable : (message != null ? message.getThrowable() : null);
    }

    @PerformanceSensitive
    private void recycle(@Nullable Message message) {
        MessageFactory2 messageFactory2 = this.messageFactory;
        if (messageFactory2 instanceof RecyclingMessageFactory) {
            RecyclingMessageFactory recyclingMessageFactory = (RecyclingMessageFactory)messageFactory2;
            recyclingMessageFactory.recycle(message);
        }
    }

    @PerformanceSensitive
    private void tryLogMessage(String fqcn, @Nullable StackTraceElement location, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        try {
            this.doLog(fqcn, location, level, marker, message, AbstractLogger.getThrowable(message, throwable));
        }
        catch (Throwable t) {
            this.handleLogMessageException(t, fqcn, message);
        }
    }

    private void handleLogMessageException(Throwable throwable, String fqcn, @Nullable Message message) {
        if (throwable instanceof LoggingException) {
            throw (LoggingException)throwable;
        }
        this.statusLogger.warn("{} caught {} logging {}: {}", (Object)fqcn, (Object)throwable.getClass().getName(), (Object)(message != null ? message.getClass().getSimpleName() : null), (Object)(message != null ? message.getFormat() : null), (Object)throwable);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message), throwable);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message), throwable);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, LambdaUtil.get((MessageSupplier)messageSupplier), throwable);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, LambdaUtil.getMessage(messageSupplier, (MessageFactory)this.messageFactory), throwable);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message), throwable);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0), null);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9), null);
    }

    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, LambdaUtil.getAll(paramSuppliers)), null);
    }

    @PerformanceSensitive
    protected void logMessage(String fqcn, Level level, @Nullable Marker marker, String message, Object ... params) {
        this.logMessageSafely(fqcn, null, level, marker, this.messageFactory.newMessage(message, params), null);
    }

    protected @Nullable EntryMessage logEnterMessage(String fqcn, @Nullable String format, Object ... params) {
        EntryMessage entryMessage = this.flowMessageFactory.newEntryMessage(format, params);
        this.logMessageSafely(fqcn, null, Level.TRACE, ENTRY_MARKER, (Message)entryMessage, null);
        return entryMessage;
    }

    protected @Nullable EntryMessage logEnterMessage(String fqcn, @Nullable Message message) {
        EntryMessage entryMessage = this.flowMessageFactory.newEntryMessage(message);
        this.logMessageSafely(fqcn, null, Level.TRACE, ENTRY_MARKER, (Message)entryMessage, null);
        return entryMessage;
    }

    protected void logExitMessage(String fqcn, @Nullable EntryMessage message, @Nullable Object result) {
        this.logMessageSafely(fqcn, null, Level.TRACE, EXIT_MARKER, (Message)this.flowMessageFactory.newExitMessage(result, message), null);
    }

    protected void logExitMessage(String fqcn, @Nullable Message message, @Nullable Object result) {
        this.logMessageSafely(fqcn, null, Level.TRACE, EXIT_MARKER, (Message)this.flowMessageFactory.newExitMessage(result, message), null);
    }

    protected void logExitMessage(String fqcn, @Nullable String format, @Nullable Object result) {
        this.logMessageSafely(fqcn, null, Level.TRACE, EXIT_MARKER, (Message)this.flowMessageFactory.newExitMessage(format, result), null);
    }

    protected void logCatchingMessage(String fqcn, Level level, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, CATCHING_MARKER, this.messageFactory.newMessage(CATCHING), throwable);
    }

    protected void logPrintfMessage(String fqcn, Level level, @Nullable Marker marker, String format, Object ... params) {
        this.logMessageSafely(fqcn, null, level, marker, (Message)new StringFormattedMessage(format, params), null);
    }

    protected void logThrowingMessage(String fqcn, Level level, Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, THROWING_MARKER, this.messageFactory.newMessage(THROWING), throwable);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    public boolean isDebugEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.DEBUG, marker);
    }

    public boolean isEnabled(Level level) {
        return this.isEnabled(level, null);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, @Nullable Throwable throwable) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object ... params) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.isEnabled(level, marker);
    }

    public boolean isEnabled(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.isEnabled(level, marker);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR);
    }

    public boolean isErrorEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.ERROR, marker);
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL);
    }

    public boolean isFatalEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.FATAL, marker);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO);
    }

    public boolean isInfoEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.INFO, marker);
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE);
    }

    public boolean isTraceEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.TRACE, marker);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN);
    }

    public boolean isWarnEnabled(@Nullable Marker marker) {
        return this.isEnabled(Level.WARN, marker);
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            this.logMessageSafely(fqcn, null, level, marker, message, throwable);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, messageSupplier, throwable)) {
            this.logMessage(fqcn, level, marker, messageSupplier, throwable);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            this.logMessage(fqcn, level, marker, message, throwable);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            this.logMessage(fqcn, level, marker, message, throwable);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, messageSupplier, throwable)) {
            this.logMessage(fqcn, level, marker, messageSupplier, throwable);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message) {
        if (this.isEnabled(level, marker, message)) {
            this.logMessage(fqcn, level, marker, message, (Throwable)null);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        if (this.isEnabled(level, marker, message)) {
            this.logMessage(fqcn, level, marker, message, paramSuppliers);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object ... params) {
        if (this.isEnabled(level, marker, message, params)) {
            this.logMessage(fqcn, level, marker, message, params);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0) {
        if (this.isEnabled(level, marker, message, p0)) {
            this.logMessage(fqcn, level, marker, message, p0);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1) {
        if (this.isEnabled(level, marker, message, p0, p1)) {
            this.logMessage(fqcn, level, marker, message, p0, p1);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        if (this.isEnabled(level, marker, message, p0, p1, p2)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
        }
    }

    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        if (this.isEnabled(level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9)) {
            this.logMessage(fqcn, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }
    }

    @PerformanceSensitive
    public void logIfEnabled(String fqcn, Level level, @Nullable Marker marker, String message, @Nullable Throwable throwable) {
        if (this.isEnabled(level, marker, message, throwable)) {
            this.logMessage(fqcn, level, marker, message, throwable);
        }
    }

    @PerformanceSensitive
    public void logMessage(String fqcn, Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, null, level, marker, message, throwable);
    }

    @PerformanceSensitive
    public void logMessage(Level level, @Nullable Marker marker, String fqcn, StackTraceElement location, @Nullable Message message, @Nullable Throwable throwable) {
        this.logMessageSafely(fqcn, location, level, marker, message, throwable);
    }

    public LogBuilder atTrace() {
        return this.atLevel(Level.TRACE);
    }

    public LogBuilder atDebug() {
        return this.atLevel(Level.DEBUG);
    }

    public LogBuilder atInfo() {
        return this.atLevel(Level.INFO);
    }

    public LogBuilder atWarn() {
        return this.atLevel(Level.WARN);
    }

    public LogBuilder atError() {
        return this.atLevel(Level.ERROR);
    }

    public LogBuilder atFatal() {
        return this.atLevel(Level.FATAL);
    }

    public LogBuilder always() {
        return this.getLogBuilder(Level.OFF);
    }

    public LogBuilder atLevel(Level level) {
        return this.isEnabled(level) ? this.getLogBuilder(level) : LogBuilder.NOOP;
    }

    public void debug(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, null);
    }

    public void debug(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, throwable);
    }

    public void debug(Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, (Throwable)null);
    }

    public void debug(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, throwable);
    }

    public void debug(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, null);
    }

    public void debug(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, throwable);
    }

    public void debug(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, (Throwable)null);
    }

    public void debug(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, params);
    }

    public void debug(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, throwable);
    }

    public void debug(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, (Throwable)null);
    }

    public void debug(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, throwable);
    }

    public void debug(CharSequence message) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, null);
    }

    public void debug(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, throwable);
    }

    public void debug(Object message) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, null);
    }

    public void debug(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, null, message, throwable);
    }

    public void debug(String message) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, (Throwable)null);
    }

    public void debug(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, params);
    }

    public void debug(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, throwable);
    }

    public void debug(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void debug(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, messageSupplier, throwable);
    }

    public void debug(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, messageSupplier, (Throwable)null);
    }

    public void debug(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, paramSuppliers);
    }

    public void debug(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, messageSupplier, throwable);
    }

    public void debug(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, paramSuppliers);
    }

    public void debug(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, messageSupplier, (Throwable)null);
    }

    public void debug(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, messageSupplier, throwable);
    }

    public void debug(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void debug(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, messageSupplier, throwable);
    }

    public void debug(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void debug(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.DEBUG, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void debug(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0);
    }

    public void debug(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1);
    }

    public void debug(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void debug(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.DEBUG, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void error(@Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, (Throwable)null);
    }

    public void error(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, throwable);
    }

    public void error(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, null);
    }

    public void error(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, throwable);
    }

    public void error(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, null);
    }

    public void error(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, throwable);
    }

    public void error(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, (Throwable)null);
    }

    public void error(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, params);
    }

    public void error(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, throwable);
    }

    public void error(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, (Throwable)null);
    }

    public void error(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, throwable);
    }

    public void error(CharSequence message) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, null);
    }

    public void error(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, throwable);
    }

    public void error(Object message) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, null);
    }

    public void error(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, null, message, throwable);
    }

    public void error(String message) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, (Throwable)null);
    }

    public void error(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, params);
    }

    public void error(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, throwable);
    }

    public void error(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void error(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, messageSupplier, throwable);
    }

    public void error(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, messageSupplier, (Throwable)null);
    }

    public void error(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, paramSuppliers);
    }

    public void error(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, messageSupplier, throwable);
    }

    public void error(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, paramSuppliers);
    }

    public void error(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, messageSupplier, (Throwable)null);
    }

    public void error(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, messageSupplier, throwable);
    }

    public void error(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void error(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, messageSupplier, throwable);
    }

    public void error(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void error(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.ERROR, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void error(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0);
    }

    public void error(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1);
    }

    public void error(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void error(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.ERROR, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void fatal(@Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, (Throwable)null);
    }

    public void fatal(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, throwable);
    }

    public void fatal(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, null);
    }

    public void fatal(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, throwable);
    }

    public void fatal(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, null);
    }

    public void fatal(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, throwable);
    }

    public void fatal(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, (Throwable)null);
    }

    public void fatal(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, params);
    }

    public void fatal(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, throwable);
    }

    public void fatal(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, (Throwable)null);
    }

    public void fatal(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, throwable);
    }

    public void fatal(CharSequence message) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, null);
    }

    public void fatal(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, throwable);
    }

    public void fatal(Object message) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, null);
    }

    public void fatal(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, null, message, throwable);
    }

    public void fatal(String message) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, (Throwable)null);
    }

    public void fatal(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, params);
    }

    public void fatal(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, throwable);
    }

    public void fatal(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void fatal(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, messageSupplier, throwable);
    }

    public void fatal(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, messageSupplier, (Throwable)null);
    }

    public void fatal(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, paramSuppliers);
    }

    public void fatal(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, messageSupplier, throwable);
    }

    public void fatal(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, paramSuppliers);
    }

    public void fatal(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, messageSupplier, (Throwable)null);
    }

    public void fatal(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, messageSupplier, throwable);
    }

    public void fatal(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void fatal(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, messageSupplier, throwable);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void fatal(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.FATAL, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void fatal(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0);
    }

    public void fatal(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1);
    }

    public void fatal(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void fatal(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.FATAL, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void info(@Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, (Throwable)null);
    }

    public void info(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, throwable);
    }

    public void info(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, null);
    }

    public void info(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, throwable);
    }

    public void info(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, null);
    }

    public void info(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, throwable);
    }

    public void info(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, (Throwable)null);
    }

    public void info(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, params);
    }

    public void info(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, throwable);
    }

    public void info(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, (Throwable)null);
    }

    public void info(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, throwable);
    }

    public void info(CharSequence message) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, null);
    }

    public void info(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, throwable);
    }

    public void info(Object message) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, null);
    }

    public void info(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, null, message, throwable);
    }

    public void info(String message) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, (Throwable)null);
    }

    public void info(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, params);
    }

    public void info(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, throwable);
    }

    public void info(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void info(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, messageSupplier, throwable);
    }

    public void info(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.INFO, marker, messageSupplier, (Throwable)null);
    }

    public void info(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, paramSuppliers);
    }

    public void info(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, messageSupplier, throwable);
    }

    public void info(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, paramSuppliers);
    }

    public void info(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.INFO, marker, messageSupplier, (Throwable)null);
    }

    public void info(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, marker, messageSupplier, throwable);
    }

    public void info(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void info(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, messageSupplier, throwable);
    }

    public void info(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void info(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.INFO, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void info(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0);
    }

    public void info(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1);
    }

    public void info(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void info(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.INFO, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void log(Level level, @Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, level, marker, message, (Throwable)null);
    }

    public void log(Level level, @Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, message, throwable);
    }

    public void log(Level level, @Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, level, marker, message, null);
    }

    public void log(Level level, @Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, message, throwable);
    }

    public void log(Level level, @Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, level, marker, message, null);
    }

    public void log(Level level, @Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, message, throwable);
    }

    public void log(Level level, @Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, level, marker, message, (Throwable)null);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, level, marker, message, params);
    }

    public void log(Level level, @Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, message, throwable);
    }

    public void log(Level level, @Nullable Message message) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, (Throwable)null);
    }

    public void log(Level level, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, throwable);
    }

    public void log(Level level, CharSequence message) {
        this.logIfEnabled(FQCN, level, null, message, null);
    }

    public void log(Level level, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, null, message, throwable);
    }

    public void log(Level level, Object message) {
        this.logIfEnabled(FQCN, level, null, message, null);
    }

    public void log(Level level, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, null, message, throwable);
    }

    public void log(Level level, String message) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, (Throwable)null);
    }

    public void log(Level level, String message, Object ... params) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, params);
    }

    public void log(Level level, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, throwable);
    }

    public void log(Level level, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, level, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void log(Level level, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, (Marker)null, messageSupplier, throwable);
    }

    public void log(Level level, @Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, level, marker, messageSupplier, (Throwable)null);
    }

    public void log(Level level, @Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, level, marker, message, paramSuppliers);
    }

    public void log(Level level, @Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, messageSupplier, throwable);
    }

    public void log(Level level, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, paramSuppliers);
    }

    public void log(Level level, @Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, level, marker, messageSupplier, (Throwable)null);
    }

    public void log(Level level, @Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, marker, messageSupplier, throwable);
    }

    public void log(Level level, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, level, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void log(Level level, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, level, (Marker)null, messageSupplier, throwable);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, level, marker, message, p0);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void log(Level level, @Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, level, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void log(Level level, String message, Object p0) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0);
    }

    public void log(Level level, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void log(Level level, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, level, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void trace(@Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, (Throwable)null);
    }

    public void trace(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, throwable);
    }

    public void trace(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, null);
    }

    public void trace(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, throwable);
    }

    public void trace(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, null);
    }

    public void trace(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, throwable);
    }

    public void trace(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, (Throwable)null);
    }

    public void trace(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, params);
    }

    public void trace(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, throwable);
    }

    public void trace(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, (Throwable)null);
    }

    public void trace(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, throwable);
    }

    public void trace(CharSequence message) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, null);
    }

    public void trace(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, throwable);
    }

    public void trace(Object message) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, null);
    }

    public void trace(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, null, message, throwable);
    }

    public void trace(String message) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, (Throwable)null);
    }

    public void trace(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, params);
    }

    public void trace(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, throwable);
    }

    public void trace(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void trace(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, messageSupplier, throwable);
    }

    public void trace(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, messageSupplier, (Throwable)null);
    }

    public void trace(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, paramSuppliers);
    }

    public void trace(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, messageSupplier, throwable);
    }

    public void trace(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, paramSuppliers);
    }

    public void trace(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, messageSupplier, (Throwable)null);
    }

    public void trace(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, messageSupplier, throwable);
    }

    public void trace(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void trace(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, messageSupplier, throwable);
    }

    public void trace(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void trace(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.TRACE, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void trace(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0);
    }

    public void trace(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1);
    }

    public void trace(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void trace(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.TRACE, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void warn(@Nullable Marker marker, @Nullable Message message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, (Throwable)null);
    }

    public void warn(@Nullable Marker marker, @Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, throwable);
    }

    public void warn(@Nullable Marker marker, CharSequence message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, null);
    }

    public void warn(@Nullable Marker marker, CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, throwable);
    }

    public void warn(@Nullable Marker marker, Object message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, null);
    }

    public void warn(@Nullable Marker marker, Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, throwable);
    }

    public void warn(@Nullable Marker marker, String message) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, (Throwable)null);
    }

    public void warn(@Nullable Marker marker, String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, params);
    }

    public void warn(@Nullable Marker marker, String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, throwable);
    }

    public void warn(@Nullable Message message) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, (Throwable)null);
    }

    public void warn(@Nullable Message message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, throwable);
    }

    public void warn(CharSequence message) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, null);
    }

    public void warn(CharSequence message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, throwable);
    }

    public void warn(Object message) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, null);
    }

    public void warn(Object message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, null, message, throwable);
    }

    public void warn(String message) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, (Throwable)null);
    }

    public void warn(String message, Object ... params) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, params);
    }

    public void warn(String message, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, throwable);
    }

    public void warn(Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void warn(Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, messageSupplier, throwable);
    }

    public void warn(@Nullable Marker marker, Supplier<?> messageSupplier) {
        this.logIfEnabled(FQCN, Level.WARN, marker, messageSupplier, (Throwable)null);
    }

    public void warn(@Nullable Marker marker, String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, paramSuppliers);
    }

    public void warn(@Nullable Marker marker, Supplier<?> messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, messageSupplier, throwable);
    }

    public void warn(String message, Supplier<?> ... paramSuppliers) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, paramSuppliers);
    }

    public void warn(@Nullable Marker marker, MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.WARN, marker, messageSupplier, (Throwable)null);
    }

    public void warn(@Nullable Marker marker, MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, marker, messageSupplier, throwable);
    }

    public void warn(MessageSupplier messageSupplier) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, messageSupplier, (Throwable)null);
    }

    public void warn(MessageSupplier messageSupplier, @Nullable Throwable throwable) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, messageSupplier, throwable);
    }

    public void warn(@Nullable Marker marker, String message, Object p0) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4, p5);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void warn(@Nullable Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.WARN, marker, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    public void warn(String message, Object p0) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0);
    }

    public void warn(String message, Object p0, Object p1) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1);
    }

    public void warn(String message, Object p0, Object p1, Object p2) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4, p5);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    public void warn(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        this.logIfEnabled(FQCN, Level.WARN, (Marker)null, message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    private @Nullable EntryMessage enter(@Nullable String format, Object ... params) {
        EntryMessage entryMessage = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER)) {
            entryMessage = this.logEnterMessage(FQCN, format, params);
        }
        return entryMessage;
    }

    public final @Nullable EntryMessage traceEntry() {
        return this.enter(null, EMPTY_PARAMS);
    }

    public final @Nullable EntryMessage traceEntry(String format, Object ... params) {
        return this.enter(format, params);
    }

    private @Nullable EntryMessage enter(@Nullable String format, Supplier<?> ... paramSuppliers) {
        EntryMessage entryMessage = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER)) {
            entryMessage = this.logEnterMessage(FQCN, format, LambdaUtil.getAll(paramSuppliers));
        }
        return entryMessage;
    }

    public final @Nullable EntryMessage traceEntry(Supplier<?> ... paramSuppliers) {
        return this.enter((String)null, paramSuppliers);
    }

    public final @Nullable EntryMessage traceEntry(String format, Supplier<?> ... paramSuppliers) {
        return this.enter(format, paramSuppliers);
    }

    public final @Nullable EntryMessage traceEntry(@Nullable Message message) {
        EntryMessage entryMessage = null;
        if (this.isEnabled(Level.TRACE, ENTRY_MARKER)) {
            entryMessage = this.logEnterMessage(FQCN, message);
        }
        return entryMessage;
    }

    private <R> @Nullable R exit(@Nullable String format, @Nullable R result) {
        if (this.isEnabled(Level.TRACE, EXIT_MARKER)) {
            this.logExitMessage(FQCN, format, result);
        }
        return result;
    }

    public final void traceExit() {
        this.exit((String)null, null);
    }

    public final <R> @Nullable R traceExit(@Nullable R result) {
        return this.exit((String)null, result);
    }

    public final <R> @Nullable R traceExit(String format, @Nullable R result) {
        return this.exit(format, result);
    }

    private <R> @Nullable R exit(@Nullable EntryMessage message, @Nullable R result) {
        if (message != null && this.isEnabled(Level.TRACE, EXIT_MARKER, (Message)message, (Throwable)null)) {
            this.logExitMessage(FQCN, message, result);
        }
        return result;
    }

    public final void traceExit(EntryMessage message) {
        this.exit(message, null);
    }

    public final <R> @Nullable R traceExit(EntryMessage message, @Nullable R result) {
        return this.exit(message, result);
    }

    public final <R> @Nullable R traceExit(@Nullable Message message, @Nullable R result) {
        if (message != null && this.isEnabled(Level.TRACE, EXIT_MARKER, message, (Throwable)null)) {
            this.logExitMessage(FQCN, message, result);
        }
        return result;
    }

    public void entry() {
        this.enter(null, EMPTY_PARAMS);
    }

    public void entry(Object ... params) {
        this.enter(null, params);
    }

    public void exit() {
        this.exit((String)null, null);
    }

    public <R> R exit(R result) {
        return this.exit((String)null, result);
    }

    public final void catching(Level level, @Nullable Throwable throwable) {
        if (this.isEnabled(level, CATCHING_MARKER)) {
            this.logCatchingMessage(FQCN, level, throwable);
        }
    }

    public final void catching(@Nullable Throwable throwable) {
        this.catching(Level.ERROR, throwable);
    }

    public final void printf(Level level, @Nullable Marker marker, String format, Object ... params) {
        if (this.isEnabled(level, marker, format, params)) {
            this.logPrintfMessage(FQCN, level, marker, format, params);
        }
    }

    public final void printf(Level level, String format, Object ... params) {
        this.printf(level, null, format, params);
    }

    public final <T extends Throwable> T throwing(T throwable) {
        return this.throwing(Level.ERROR, throwable);
    }

    public final <T extends Throwable> T throwing(Level level, T throwable) {
        if (this.isEnabled(level, THROWING_MARKER)) {
            this.logThrowingMessage(FQCN, level, throwable);
        }
        return throwable;
    }

    public <MF extends MessageFactory> MF getMessageFactory() {
        return (MF)this.messageFactory;
    }

    public FlowMessageFactory getFlowMessageFactory() {
        return this.flowMessageFactory;
    }

    public String getName() {
        return this.name;
    }
}

