/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.util.ArrayList;
import java.util.Collection;
import opennlp.tools.parser.AbstractContextGenerator;
import opennlp.tools.parser.Parse;

public class CheckContextGenerator
extends AbstractContextGenerator {
    public String[] getContext(Object o) {
        Object[] params = (Object[])o;
        return this.getContext((Parse[])params[0], (String)params[1], (Integer)params[2], (Integer)params[3]);
    }

    public String[] getContext(Parse[] constituents, String type, int start, int end) {
        int ps = constituents.length;
        ArrayList<String> features = new ArrayList<String>(100);
        features.add("default");
        features.add("fl=" + constituents[0].getLabel());
        Parse pstart = constituents[start];
        Parse pend = constituents[end];
        this.checkcons(pstart, "begin", type, features);
        this.checkcons(pend, "last", type, features);
        StringBuilder production = new StringBuilder(20);
        StringBuilder punctProduction = new StringBuilder(20);
        production.append("p=").append(type).append("->");
        punctProduction.append("pp=").append(type).append("->");
        for (int pi = start; pi < end; ++pi) {
            Parse p = constituents[pi];
            this.checkcons(p, pend, type, features);
            production.append(p.getType()).append(",");
            punctProduction.append(p.getType()).append(",");
            Collection<Parse> nextPunct = p.getNextPunctuationSet();
            if (nextPunct == null) continue;
            for (Parse punct : nextPunct) {
                punctProduction.append(punct.getType()).append(",");
            }
        }
        production.append(pend.getType());
        punctProduction.append(pend.getType());
        features.add(production.toString());
        features.add(punctProduction.toString());
        Parse p_2 = null;
        Parse p_1 = null;
        Parse p1 = null;
        Parse p2 = null;
        Collection<Parse> p1s = constituents[end].getNextPunctuationSet();
        Collection<Parse> p2s = null;
        Collection<Parse> p_1s = constituents[start].getPreviousPunctuationSet();
        Collection<Parse> p_2s = null;
        if (start - 2 >= 0) {
            p_2 = constituents[start - 2];
        }
        if (start - 1 >= 0) {
            p_1 = constituents[start - 1];
            p_2s = p_1.getPreviousPunctuationSet();
        }
        if (end + 1 < ps) {
            p1 = constituents[end + 1];
            p2s = p1.getNextPunctuationSet();
        }
        if (end + 2 < ps) {
            p2 = constituents[end + 2];
        }
        this.surround(p_1, -1, type, p_1s, features);
        this.surround(p_2, -2, type, p_2s, features);
        this.surround(p1, 1, type, p1s, features);
        this.surround(p2, 2, type, p2s, features);
        return features.toArray(new String[0]);
    }
}

