/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.SearchTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.TopScoreDocCollectorManager;

public class SearchWithCollectorTask
extends SearchTask {
    protected String clnName;

    public SearchWithCollectorTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        if (config.get("collector.class", null) != null) {
            throw new IllegalArgumentException("collector.class is no longer supported as a config parameter, use collector.manager.class instead to provide a CollectorManager class name");
        }
        this.clnName = config.get("collector.manager.class", "");
    }

    @Override
    public boolean withCollector() {
        return true;
    }

    @Override
    protected CollectorManager<?, ?> createCollectorManager() throws Exception {
        CollectorManager collectorManager = this.clnName.equalsIgnoreCase("topScoreDoc") ? new TopScoreDocCollectorManager(this.numHits(), Integer.MAX_VALUE) : (this.clnName.length() > 0 ? Class.forName(this.clnName).asSubclass(CollectorManager.class).getConstructor(new Class[0]).newInstance(new Object[0]) : super.createCollectorManager());
        return collectorManager;
    }

    @Override
    public QueryMaker getQueryMaker() {
        return this.getRunData().getQueryMaker(this);
    }

    @Override
    public boolean withRetrieve() {
        return false;
    }

    @Override
    public boolean withSearch() {
        return true;
    }

    @Override
    public boolean withTraverse() {
        return false;
    }

    @Override
    public boolean withWarm() {
        return false;
    }
}

