/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.tests.index.MismatchedLeafReader;

public class MismatchedCodecReader
extends FilterCodecReader {
    private final FieldInfos shuffled;

    public MismatchedCodecReader(CodecReader in, Random random) {
        super(in);
        this.shuffled = MismatchedLeafReader.shuffleInfos(in.getFieldInfos(), random);
    }

    public FieldInfos getFieldInfos() {
        return this.shuffled;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public StoredFieldsReader getFieldsReader() {
        StoredFieldsReader in = super.getFieldsReader();
        if (in == null) {
            return null;
        }
        return new MismatchedStoredFieldsReader(in, this.shuffled);
    }

    public DocValuesProducer getDocValuesReader() {
        DocValuesProducer in = super.getDocValuesReader();
        if (in == null) {
            return null;
        }
        return new MismatchedDocValuesProducer(in, this.shuffled, super.getFieldInfos());
    }

    public NormsProducer getNormsReader() {
        NormsProducer in = super.getNormsReader();
        if (in == null) {
            return null;
        }
        return new MismatchedNormsProducer(in, this.shuffled, super.getFieldInfos());
    }

    private static class MismatchedStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader in;
        private final FieldInfos shuffled;

        MismatchedStoredFieldsReader(StoredFieldsReader in, FieldInfos shuffled) {
            this.in = Objects.requireNonNull(in);
            this.shuffled = shuffled;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public StoredFieldsReader clone() {
            return new MismatchedStoredFieldsReader(this.in.clone(), this.shuffled);
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            this.in.document(docID, (StoredFieldVisitor)new MismatchedLeafReader.MismatchedVisitor(visitor, this.shuffled));
        }
    }

    private static class MismatchedDocValuesProducer
    extends DocValuesProducer {
        private final DocValuesProducer in;
        private final FieldInfos shuffled;
        private final FieldInfos orig;

        MismatchedDocValuesProducer(DocValuesProducer in, FieldInfos shuffled, FieldInfos orig) {
            this.in = Objects.requireNonNull(in);
            this.shuffled = shuffled;
            this.orig = orig;
        }

        public void close() throws IOException {
            this.in.close();
        }

        private FieldInfo remapFieldInfo(FieldInfo field) {
            FieldInfo fi = this.shuffled.fieldInfo(field.name);
            assert (fi != null && fi.number == field.number);
            return this.orig.fieldInfo(field.name);
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            return this.in.getNumeric(this.remapFieldInfo(field));
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            return this.in.getBinary(this.remapFieldInfo(field));
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            return this.in.getSorted(this.remapFieldInfo(field));
        }

        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            return this.in.getSortedNumeric(this.remapFieldInfo(field));
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            return this.in.getSortedSet(this.remapFieldInfo(field));
        }

        public DocValuesSkipper getSkipper(FieldInfo field) throws IOException {
            return this.in.getSkipper(this.remapFieldInfo(field));
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }

    private static class MismatchedNormsProducer
    extends NormsProducer {
        private final NormsProducer in;
        private final FieldInfos shuffled;
        private final FieldInfos orig;

        MismatchedNormsProducer(NormsProducer in, FieldInfos shuffled, FieldInfos orig) {
            this.in = Objects.requireNonNull(in);
            this.shuffled = shuffled;
            this.orig = orig;
        }

        public void close() throws IOException {
            this.in.close();
        }

        private FieldInfo remapFieldInfo(FieldInfo field) {
            FieldInfo fi = this.shuffled.fieldInfo(field.name);
            assert (fi != null && fi.number == field.number);
            return this.orig.fieldInfo(field.name);
        }

        public NumericDocValues getNorms(FieldInfo field) throws IOException {
            return this.in.getNorms(this.remapFieldInfo(field));
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }
}

