/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene103.blocktree;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class TrieBuilder {
    static final int SIGN_NO_CHILDREN = 0;
    static final int SIGN_SINGLE_CHILD_WITH_OUTPUT = 1;
    static final int SIGN_SINGLE_CHILD_WITHOUT_OUTPUT = 2;
    static final int SIGN_MULTI_CHILDREN = 3;
    static final int LEAF_NODE_HAS_TERMS = 32;
    static final int LEAF_NODE_HAS_FLOOR = 64;
    static final long NON_LEAF_NODE_HAS_TERMS = 2L;
    static final long NON_LEAF_NODE_HAS_FLOOR = 1L;
    private final Node root = new Node(0, null);
    private final BytesRef minKey;
    private BytesRef maxKey;
    private Status status = Status.BUILDING;

    static TrieBuilder bytesRefToTrie(BytesRef k, Output v) {
        return new TrieBuilder(k, v);
    }

    private TrieBuilder(BytesRef k, Output v) {
        this.minKey = this.maxKey = BytesRef.deepCopyOf(k);
        if (k.length == 0) {
            this.root.output = v;
            return;
        }
        Node parent = this.root;
        for (int i = 0; i < k.length; ++i) {
            Node node;
            int b = k.bytes[i + k.offset] & 0xFF;
            Output output = i == k.length - 1 ? v : null;
            parent.firstChild = parent.lastChild = (node = new Node(b, output));
            parent.childrenNum = 1;
            parent = node;
        }
    }

    void append(TrieBuilder trieBuilder) {
        if (this.status != Status.BUILDING || trieBuilder.status != Status.BUILDING) {
            throw new IllegalStateException("tries have wrong status, got this: " + String.valueOf((Object)this.status) + ", append: " + String.valueOf((Object)trieBuilder.status));
        }
        assert (this.maxKey.compareTo(trieBuilder.minKey) < 0);
        int mismatch = Arrays.mismatch(this.maxKey.bytes, this.maxKey.offset, this.maxKey.offset + this.maxKey.length, trieBuilder.minKey.bytes, trieBuilder.minKey.offset, trieBuilder.minKey.offset + trieBuilder.minKey.length);
        Node a = this.root;
        Node b = trieBuilder.root;
        for (int i = 0; i < mismatch; ++i) {
            Node aLast = a.lastChild;
            Node bFirst = b.firstChild;
            assert (aLast.label == bFirst.label);
            if (b.childrenNum > 1) {
                aLast.next = bFirst.next;
                a.childrenNum += b.childrenNum - 1;
                a.lastChild = b.lastChild;
                assert (TrieBuilder.assertChildrenLabelInOrder(a));
            }
            a = aLast;
            b = bFirst;
        }
        assert (b.childrenNum > 0);
        if (a.childrenNum == 0) {
            a.firstChild = b.firstChild;
            a.lastChild = b.lastChild;
            a.childrenNum = b.childrenNum;
        } else {
            assert (a.lastChild.label < b.firstChild.label);
            a.lastChild.next = b.firstChild;
            a.lastChild = b.lastChild;
            a.childrenNum += b.childrenNum;
        }
        assert (TrieBuilder.assertChildrenLabelInOrder(a));
        this.maxKey = trieBuilder.maxKey;
        trieBuilder.status = Status.DESTROYED;
    }

    Output getEmptyOutput() {
        return this.root.output;
    }

    void visit(BiConsumer<BytesRef, Output> consumer) {
        assert (this.status == Status.BUILDING);
        if (this.root.output != null) {
            consumer.accept(new BytesRef(), this.root.output);
        }
        this.visit(this.root.firstChild, new BytesRefBuilder(), consumer);
    }

    private void visit(Node first, BytesRefBuilder key, BiConsumer<BytesRef, Output> consumer) {
        while (first != null) {
            key.append((byte)first.label);
            if (first.output != null) {
                consumer.accept(key.toBytesRef(), first.output);
            }
            this.visit(first.firstChild, key, consumer);
            key.setLength(key.length() - 1);
            first = first.next;
        }
    }

    void save(DataOutput meta, IndexOutput index) throws IOException {
        if (this.status != Status.BUILDING) {
            throw new IllegalStateException("only unsaved trie can be saved, got: " + String.valueOf((Object)this.status));
        }
        meta.writeVLong(index.getFilePointer());
        this.saveNodes(index);
        meta.writeVLong(this.root.fp);
        index.writeLong(0L);
        meta.writeVLong(index.getFilePointer());
        this.status = Status.SAVED;
    }

    void saveNodes(IndexOutput index) throws IOException {
        long startFP = index.getFilePointer();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.peek();
            assert (node.fp == -1L);
            assert (TrieBuilder.assertChildrenLabelInOrder(node));
            int childrenNum = node.childrenNum;
            if (childrenNum == 0) {
                assert (node.output != null) : "leaf nodes should have output.";
                node.fp = index.getFilePointer() - startFP;
                stack.pop();
                Output output = node.output;
                int outputFpBytes = TrieBuilder.bytesRequiredVLong(output.fp);
                int header = 0 | outputFpBytes - 1 << 2 | (output.hasTerms ? 32 : 0) | (output.floorData != null ? 64 : 0);
                index.writeByte((byte)header);
                TrieBuilder.writeLongNBytes(output.fp, outputFpBytes, index);
                if (output.floorData == null) continue;
                index.writeBytes(output.floorData.bytes, output.floorData.offset, output.floorData.length);
                continue;
            }
            if (node.savedTo == null) {
                node.savedTo = node.firstChild;
                stack.push(node.savedTo);
                continue;
            }
            if (node.savedTo.next != null) {
                assert (node.savedTo.fp >= 0L);
                node.savedTo = node.savedTo.next;
                stack.push(node.savedTo);
                continue;
            }
            assert (TrieBuilder.assertNonLeafNodePreparingSaving(node));
            node.fp = index.getFilePointer() - startFP;
            stack.pop();
            if (childrenNum == 1) {
                long childDeltaFp = node.fp - node.firstChild.fp;
                assert (childDeltaFp > 0L) : "parent node is always written after children: " + childDeltaFp;
                int childFpBytes = TrieBuilder.bytesRequiredVLong(childDeltaFp);
                int encodedOutputFpBytes = node.output == null ? 0 : TrieBuilder.bytesRequiredVLong(node.output.fp << 2);
                int sign = node.output != null ? 1 : 2;
                int header = sign | childFpBytes - 1 << 2 | encodedOutputFpBytes - 1 << 5;
                index.writeByte((byte)header);
                index.writeByte((byte)node.firstChild.label);
                TrieBuilder.writeLongNBytes(childDeltaFp, childFpBytes, index);
                if (node.output == null) continue;
                Output output = node.output;
                long encodedFp = this.encodeFP(output);
                TrieBuilder.writeLongNBytes(encodedFp, encodedOutputFpBytes, index);
                if (output.floorData == null) continue;
                index.writeBytes(output.floorData.bytes, output.floorData.offset, output.floorData.length);
                continue;
            }
            int minLabel = node.firstChild.label;
            int maxLabel = node.lastChild.label;
            assert (maxLabel > minLabel);
            ChildSaveStrategy childSaveStrategy = ChildSaveStrategy.choose(minLabel, maxLabel, childrenNum);
            int strategyBytes = childSaveStrategy.needBytes(minLabel, maxLabel, childrenNum);
            assert (strategyBytes > 0 && strategyBytes <= 32);
            long maxChildDeltaFp = node.fp - node.firstChild.fp;
            assert (maxChildDeltaFp > 0L) : "parent always written after all children";
            int childrenFpBytes = TrieBuilder.bytesRequiredVLong(maxChildDeltaFp);
            int encodedOutputFpBytes = node.output == null ? 1 : TrieBuilder.bytesRequiredVLong(node.output.fp << 2);
            int header = 3 | childrenFpBytes - 1 << 2 | (node.output != null ? 1 : 0) << 5 | encodedOutputFpBytes - 1 << 6 | childSaveStrategy.code << 9 | strategyBytes - 1 << 11 | minLabel << 16;
            TrieBuilder.writeLongNBytes(header, 3, index);
            if (node.output != null) {
                Output output = node.output;
                long encodedFp = this.encodeFP(output);
                TrieBuilder.writeLongNBytes(encodedFp, encodedOutputFpBytes, index);
                if (output.floorData != null) {
                    index.writeByte((byte)(childrenNum - 1));
                }
            }
            long strategyStartFp = index.getFilePointer();
            childSaveStrategy.save(node, childrenNum, strategyBytes, index);
            assert (index.getFilePointer() == strategyStartFp + (long)strategyBytes) : childSaveStrategy.name() + " strategy bytes compute error, computed: " + strategyBytes + " actual: " + (index.getFilePointer() - strategyStartFp);
            Node child = node.firstChild;
            while (child != null) {
                assert (node.fp > child.fp) : "parent always written after all children";
                TrieBuilder.writeLongNBytes(node.fp - child.fp, childrenFpBytes, index);
                child = child.next;
            }
            if (node.output == null || node.output.floorData == null) continue;
            BytesRef floorData = node.output.floorData;
            index.writeBytes(floorData.bytes, floorData.offset, floorData.length);
        }
    }

    private long encodeFP(Output output) {
        assert (output.fp < 0x4000000000000000L);
        return (output.floorData != null ? 1L : 0L) | (output.hasTerms ? 2L : 0L) | output.fp << 2;
    }

    private static int bytesRequiredVLong(long v) {
        return 8 - (Long.numberOfLeadingZeros(v | 1L) >>> 3);
    }

    private static void writeLongNBytes(long v, int n, DataOutput out) throws IOException {
        for (int i = 0; i < n; ++i) {
            out.writeByte((byte)v);
            v >>>= 8;
        }
        assert (v == 0L);
    }

    private static boolean assertChildrenLabelInOrder(Node node) {
        if (node.childrenNum == 0) {
            assert (node.firstChild == null);
            assert (node.lastChild == null);
        } else if (node.childrenNum == 1) {
            assert (node.firstChild == node.lastChild);
            assert (node.firstChild.next == null);
        } else if (node.childrenNum > 1) {
            int n = 0;
            Node child = node.firstChild;
            while (child != null) {
                ++n;
                assert (child.next == null || child.label < child.next.label) : " the label of children nodes should always be in strictly increasing order.";
                child = child.next;
            }
            assert (node.childrenNum == n);
        }
        return true;
    }

    private static boolean assertNonLeafNodePreparingSaving(Node node) {
        assert (TrieBuilder.assertChildrenLabelInOrder(node));
        assert (node.childrenNum != 0);
        if (node.childrenNum == 1) {
            assert (node.firstChild == node.lastChild);
            assert (node.firstChild.next == null);
            assert (node.savedTo == node.firstChild);
            assert (node.firstChild.fp >= 0L);
        } else {
            int n = 0;
            Node child = node.firstChild;
            while (child != null) {
                ++n;
                assert (child.fp >= 0L);
                assert (child.next == null || child.fp < child.next.fp) : " the fp or children nodes should always be in order.";
                child = child.next;
            }
            assert (node.childrenNum == n);
            assert (node.lastChild == node.savedTo);
            assert (node.savedTo.next == null);
        }
        return true;
    }

    record Output(long fp, boolean hasTerms, BytesRef floorData) {
    }

    private static class Node {
        private final int label;
        private Output output;
        private int childrenNum;
        private Node next;
        private Node firstChild;
        private Node lastChild;
        private long fp = -1L;
        private Node savedTo;

        Node(int label, Output output) {
            this.label = label;
            this.output = output;
        }
    }

    private static enum Status {
        BUILDING,
        SAVED,
        DESTROYED;

    }

    static abstract sealed class ChildSaveStrategy
    extends Enum<ChildSaveStrategy> {
        public static final /* enum */ ChildSaveStrategy BITS = new ChildSaveStrategy(2){

            @Override
            int needBytes(int minLabel, int maxLabel, int labelCnt) {
                int byteDistance = maxLabel - minLabel + 1;
                return byteDistance + 7 >>> 3;
            }

            @Override
            void save(Node parent, int labelCnt, int strategyBytes, IndexOutput output) throws IOException {
                byte presenceBits = 1;
                int presenceIndex = 0;
                int previousLabel = parent.firstChild.label;
                Node child = parent.firstChild.next;
                while (child != null) {
                    int label = child.label;
                    assert (label > previousLabel);
                    presenceIndex += label - previousLabel;
                    while (presenceIndex >= 8) {
                        output.writeByte(presenceBits);
                        presenceBits = 0;
                        presenceIndex -= 8;
                    }
                    presenceBits = (byte)(presenceBits | 1 << presenceIndex);
                    previousLabel = label;
                    child = child.next;
                }
                assert (presenceIndex == (parent.lastChild.label - parent.firstChild.label) % 8);
                assert (presenceBits != 0);
                assert ((presenceBits & 1 << presenceIndex) != 0);
                output.writeByte(presenceBits);
            }

            @Override
            int lookup(int targetLabel, RandomAccessInput in, long offset, int strategyBytes, int minLabel) throws IOException {
                long mask;
                int bitIndex = targetLabel - minLabel;
                if (bitIndex >= strategyBytes << 3) {
                    return -1;
                }
                int wordIndex = bitIndex >>> 6;
                long wordFp = offset + (long)(wordIndex << 3);
                long word = in.readLong(wordFp);
                if ((word & (mask = 1L << bitIndex)) == 0L) {
                    return -1;
                }
                int pos = 0;
                for (long fp = offset; fp < wordFp; fp += 8L) {
                    pos += Long.bitCount(in.readLong(fp));
                }
                return pos += Long.bitCount(word & mask - 1L);
            }
        };
        public static final /* enum */ ChildSaveStrategy ARRAY = new ChildSaveStrategy(1){

            @Override
            int needBytes(int minLabel, int maxLabel, int labelCnt) {
                return labelCnt - 1;
            }

            @Override
            void save(Node parent, int labelCnt, int strategyBytes, IndexOutput output) throws IOException {
                Node child = parent.firstChild.next;
                while (child != null) {
                    output.writeByte((byte)child.label);
                    child = child.next;
                }
            }

            @Override
            int lookup(int targetLabel, RandomAccessInput in, long offset, int strategyBytes, int minLabel) throws IOException {
                int low = 0;
                int high = strategyBytes - 1;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int midLabel = in.readByte(offset + (long)mid) & 0xFF;
                    if (midLabel < targetLabel) {
                        low = mid + 1;
                        continue;
                    }
                    if (midLabel > targetLabel) {
                        high = mid - 1;
                        continue;
                    }
                    return mid + 1;
                }
                return -1;
            }
        };
        public static final /* enum */ ChildSaveStrategy REVERSE_ARRAY = new ChildSaveStrategy(0){

            @Override
            int needBytes(int minLabel, int maxLabel, int labelCnt) {
                int byteDistance = maxLabel - minLabel + 1;
                return byteDistance - labelCnt + 1;
            }

            @Override
            void save(Node parent, int labelCnt, int strategyBytes, IndexOutput output) throws IOException {
                output.writeByte((byte)parent.lastChild.label);
                int lastLabel = parent.firstChild.label;
                Node child = parent.firstChild.next;
                while (child != null) {
                    while (++lastLabel < child.label) {
                        output.writeByte((byte)lastLabel);
                    }
                    child = child.next;
                }
            }

            @Override
            int lookup(int targetLabel, RandomAccessInput in, long offset, int strategyBytes, int minLabel) throws IOException {
                int maxLabel;
                if (targetLabel >= (maxLabel = in.readByte(offset++) & 0xFF)) {
                    return targetLabel == maxLabel ? maxLabel - minLabel - strategyBytes + 1 : -1;
                }
                if (strategyBytes == 1) {
                    return targetLabel - minLabel;
                }
                int low = 0;
                int high = strategyBytes - 2;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int midLabel = in.readByte(offset + (long)mid) & 0xFF;
                    if (midLabel < targetLabel) {
                        low = mid + 1;
                        continue;
                    }
                    if (midLabel > targetLabel) {
                        high = mid - 1;
                        continue;
                    }
                    return -1;
                }
                return targetLabel - minLabel - low;
            }
        };
        private static final ChildSaveStrategy[] STRATEGIES_IN_PRIORITY_ORDER;
        private static final ChildSaveStrategy[] STRATEGIES_BY_CODE;
        final int code;
        private static final /* synthetic */ ChildSaveStrategy[] $VALUES;

        public static ChildSaveStrategy[] values() {
            return (ChildSaveStrategy[])$VALUES.clone();
        }

        public static ChildSaveStrategy valueOf(String name) {
            return Enum.valueOf(ChildSaveStrategy.class, name);
        }

        private ChildSaveStrategy(int code) {
            this.code = code;
        }

        abstract int needBytes(int var1, int var2, int var3);

        abstract void save(Node var1, int var2, int var3, IndexOutput var4) throws IOException;

        abstract int lookup(int var1, RandomAccessInput var2, long var3, int var5, int var6) throws IOException;

        static ChildSaveStrategy byCode(int code) {
            return STRATEGIES_BY_CODE[code];
        }

        static ChildSaveStrategy choose(int minLabel, int maxLabel, int labelCnt) {
            ChildSaveStrategy childSaveStrategy = null;
            int strategyBytes = Integer.MAX_VALUE;
            for (ChildSaveStrategy strategy : STRATEGIES_IN_PRIORITY_ORDER) {
                int strategyCost = strategy.needBytes(minLabel, maxLabel, labelCnt);
                if (strategyCost >= strategyBytes) continue;
                childSaveStrategy = strategy;
                strategyBytes = strategyCost;
            }
            assert (childSaveStrategy != null);
            assert (strategyBytes > 0 && strategyBytes <= 32);
            return childSaveStrategy;
        }

        private static /* synthetic */ ChildSaveStrategy[] $values() {
            return new ChildSaveStrategy[]{BITS, ARRAY, REVERSE_ARRAY};
        }

        static {
            $VALUES = ChildSaveStrategy.$values();
            STRATEGIES_IN_PRIORITY_ORDER = new ChildSaveStrategy[]{BITS, ARRAY, REVERSE_ARRAY};
            STRATEGIES_BY_CODE = new ChildSaveStrategy[ChildSaveStrategy.values().length];
            for (ChildSaveStrategy strategy : ChildSaveStrategy.values()) {
                assert (STRATEGIES_BY_CODE[strategy.code] == null);
                ChildSaveStrategy.STRATEGIES_BY_CODE[strategy.code] = strategy;
            }
        }
    }
}

