/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsCollectorManager;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.range.DynamicRangeUtil;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.NamedThreadFactory;

public class DynamicRangeFacetsExample {
    private final Directory indexDir = new ByteBuffersDirectory();
    private final FacetsConfig config = new FacetsConfig();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        Document doc = new Document();
        doc.add((IndexableField)new StringField("Author", "J. R. R. Tolkien", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("Popularity", 96L));
        doc.add((IndexableField)new NumericDocValuesField("Books", 24L));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new StringField("Author", "C. S. Lewis", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("Popularity", 83L));
        doc.add((IndexableField)new NumericDocValuesField("Books", 48L));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new StringField("Author", "G. K. Chesterton", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("Popularity", 63L));
        doc.add((IndexableField)new NumericDocValuesField("Books", 90L));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        indexWriter.commit();
        doc = new Document();
        doc.add((IndexableField)new StringField("Author", "Fyodor Dostoevsky", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("Popularity", 79L));
        doc.add((IndexableField)new NumericDocValuesField("Books", 11L));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        doc = new Document();
        doc.add((IndexableField)new StringField("Author", "Leo Tolstoy", Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("Popularity", 75L));
        doc.add((IndexableField)new NumericDocValuesField("Books", 47L));
        indexWriter.addDocument((Iterable)this.config.build(doc));
        indexWriter.close();
    }

    private List<DynamicRangeUtil.DynamicRangeInfo> search() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        LongValuesSource valuesSource = LongValuesSource.fromLongField((String)"Popularity");
        LongValuesSource weightsSource = LongValuesSource.fromLongField((String)"Books");
        FacetsCollectorManager fcm = new FacetsCollectorManager();
        FacetsCollector fc = FacetsCollectorManager.search((IndexSearcher)searcher, (Query)new MatchAllDocsQuery(), (int)10, (FacetsCollectorManager)fcm).facetsCollector();
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("dynamic-ranges"));
        List res = DynamicRangeUtil.computeDynamicRanges((String)"Books", (LongValuesSource)weightsSource, (LongValuesSource)valuesSource, (FacetsCollector)fc, (int)2, (ExecutorService)executor);
        executor.shutdown();
        return res;
    }

    public List<DynamicRangeUtil.DynamicRangeInfo> runSearch() throws IOException {
        this.index();
        return this.search();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Dynamic range facets example:");
        System.out.println("-----------------------");
        DynamicRangeFacetsExample example = new DynamicRangeFacetsExample();
        List<DynamicRangeUtil.DynamicRangeInfo> results = example.runSearch();
        for (DynamicRangeUtil.DynamicRangeInfo range : results) {
            System.out.printf(Locale.ROOT, "min: %d max: %d centroid: %f count: %d weight: %d%n", range.min, range.max, range.centroid, range.count, range.weight);
        }
    }
}

