/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AlreadyExistsException;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.BadVersionException;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.NodeRoles;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.util.NumberUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assign {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static String getCounterNodePath(String collection) {
        return "/collections/" + collection + "/counter";
    }

    public static int incAndGetId(DistribStateManager stateManager, String collection, int defaultValue) {
        String path = "/collections/" + collection;
        try {
            if (!stateManager.hasData(path)) {
                try {
                    stateManager.makePath(path);
                }
                catch (AlreadyExistsException alreadyExistsException) {
                    // empty catch block
                }
            }
            if (!stateManager.hasData(path = path + "/counter")) {
                try {
                    stateManager.createData(path, NumberUtils.intToBytes(defaultValue), CreateMode.PERSISTENT);
                }
                catch (AlreadyExistsException alreadyExistsException) {}
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, (Throwable)e);
        }
        catch (IOException | KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating counter node in Zookeeper for collection:" + collection, e);
        }
        while (true) {
            try {
                int version = 0;
                int currentId = 0;
                VersionedData data = stateManager.getData(path, null);
                if (data != null) {
                    currentId = NumberUtils.bytesToInt(data.getData());
                    version = data.getVersion();
                }
                byte[] bytes = NumberUtils.intToBytes(++currentId);
                stateManager.setData(path, bytes, version);
                return currentId;
            }
            catch (BadVersionException e) {
                continue;
            }
            catch (IOException | KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error inc and get counter from Zookeeper for collection:" + collection, (Throwable)e);
            }
            break;
        }
    }

    public static String assignCoreNodeName(DistribStateManager stateManager, DocCollection collection) {
        int defaultValue = Assign.defaultCounterValue(collection, false);
        String coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        while (collection.getReplica(coreNodeName) != null) {
            coreNodeName = "core_node" + Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        }
        return coreNodeName;
    }

    public static String assignShard(DocCollection collection, Integer numShards) {
        Map sliceMap;
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map map = sliceMap = collection != null ? collection.getActiveSlicesMap() : null;
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map2.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, (o1, o2) -> {
            Integer one = (Integer)map2.get(o1);
            Integer two = (Integer)map2.get(o2);
            return one.compareTo(two);
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }

    public static String buildSolrCoreName(String collectionName, String shard, Replica.Type type, int replicaNum) {
        return String.format(Locale.ROOT, "%s_%s_replica_%s%s", collectionName, shard, type.name().substring(0, 1).toLowerCase(Locale.ROOT), replicaNum);
    }

    private static int defaultCounterValue(DocCollection collection, boolean newCollection, String shard) {
        if (newCollection) {
            return 0;
        }
        if (collection.getSlice(shard) != null && collection.getSlice(shard).getReplicas().isEmpty()) {
            return 0;
        }
        int defaultValue = collection.getReplicas().size() * 2;
        if (collection.getReplicationFactor() != null) {
            defaultValue = Math.max(defaultValue, collection.getReplicationFactor() * collection.getSlices().size());
        }
        return defaultValue;
    }

    private static int defaultCounterValue(DocCollection collection, boolean newCollection) {
        if (newCollection) {
            return 0;
        }
        int defaultValue = collection.getReplicas().size();
        return defaultValue;
    }

    public static String buildSolrCoreName(DistribStateManager stateManager, DocCollection collection, String shard, Replica.Type type, boolean newCollection) {
        Slice slice = collection.getSlice(shard);
        int defaultValue = Assign.defaultCounterValue(collection, newCollection, shard);
        int replicaNum = Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
        String coreName = Assign.buildSolrCoreName(collection.getName(), shard, type, replicaNum);
        while (Assign.existCoreName(coreName, slice)) {
            replicaNum = Assign.incAndGetId(stateManager, collection.getName(), defaultValue);
            coreName = Assign.buildSolrCoreName(collection.getName(), shard, type, replicaNum);
        }
        return coreName;
    }

    public static String buildSolrCoreName(DistribStateManager stateManager, DocCollection collection, String shard, Replica.Type type) {
        return Assign.buildSolrCoreName(stateManager, collection, shard, type, false);
    }

    private static boolean existCoreName(String coreName, Slice slice) {
        if (slice == null) {
            return false;
        }
        for (Replica replica : slice.getReplicas()) {
            if (!coreName.equals(replica.getStr("core"))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random, DistribStateManager zk) {
        ArrayList<String> nodeList;
        List createNodeList;
        String createNodeSetStr = message.getStr("createNodeSet");
        List list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart((String)("EMPTY".equals(createNodeSetStr) ? "" : createNodeSetStr), (String)",", (boolean)true));
        if (createNodeList != null) {
            nodeList = new ArrayList(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool("createNodeSet.shuffle", true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(Assign.filterNonDataNodes(zk, liveNodes));
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    public static Collection<String> filterNonDataNodes(DistribStateManager zk, Collection<String> liveNodes) {
        try {
            List<String> noData = ClusterAPI.getNodesByRole(NodeRoles.Role.DATA, "off", zk);
            if (noData.isEmpty()) {
                return liveNodes;
            }
            liveNodes = new HashSet<String>(liveNodes);
            liveNodes.removeAll(noData);
            return liveNodes;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching roles from Zookeeper", (Throwable)e);
        }
    }

    public static boolean usePolicyFramework(SolrCloudManager cloudManager) throws IOException, InterruptedException {
        Objects.requireNonNull(cloudManager, "The SolrCloudManager instance cannot be null");
        return Assign.usePolicyFramework(Optional.empty(), cloudManager);
    }

    public static boolean usePolicyFramework(DocCollection collection, SolrCloudManager cloudManager) throws IOException, InterruptedException {
        Objects.requireNonNull(collection, "The DocCollection instance cannot be null");
        Objects.requireNonNull(cloudManager, "The SolrCloudManager instance cannot be null");
        return Assign.usePolicyFramework(Optional.of(collection), cloudManager);
    }

    private static boolean usePolicyFramework(Optional<DocCollection> collection, SolrCloudManager cloudManager) throws IOException, InterruptedException {
        boolean useLegacyAssignment = true;
        Map clusterProperties = cloudManager.getClusterStateProvider().getClusterProperties();
        if (clusterProperties.containsKey("defaults")) {
            Map defaults = (Map)clusterProperties.get("defaults");
            Map collectionDefaults = defaults.getOrDefault("cluster", Collections.emptyMap());
            useLegacyAssignment = Boolean.parseBoolean(collectionDefaults.getOrDefault("useLegacyReplicaAssignment", "true").toString());
        }
        if (!useLegacyAssignment) {
            return true;
        }
        AutoScalingConfig autoScalingConfig = cloudManager.getDistribStateManager().getAutoScalingConfig();
        if (autoScalingConfig.getPolicy().isEmpty()) {
            return false;
        }
        if (!autoScalingConfig.getPolicy().isEmptyPreferences()) {
            return true;
        }
        if (!autoScalingConfig.getPolicy().getClusterPolicy().isEmpty()) {
            return true;
        }
        return !collection.isPresent() || collection.get().getPolicyName() != null;
    }

    public static List<ReplicaPosition> getNodesForNewReplicas(ClusterState clusterState, String collectionName, String shard, int nrtReplicas, int tlogReplicas, int pullReplicas, Object createNodeSet, SolrCloudManager cloudManager) throws IOException, InterruptedException, AssignmentException {
        log.debug("getNodesForNewReplicas() shard: {} , nrtReplicas : {} , tlogReplicas: {} , pullReplicas: {} , createNodeSet {}", new Object[]{shard, nrtReplicas, tlogReplicas, pullReplicas, createNodeSet});
        DocCollection coll = clusterState.getCollection(collectionName);
        int maxShardsPerNode = coll.getMaxShardsPerNode() == -1 ? Integer.MAX_VALUE : coll.getMaxShardsPerNode();
        List createNodeList = null;
        createNodeList = createNodeSet instanceof List ? (List)createNodeSet : (createNodeSet == null ? null : new ArrayList(new LinkedHashSet(StrUtils.splitSmart((String)((String)createNodeSet), (String)",", (boolean)true))));
        HashMap<String, ReplicaCount> nodeNameVsShardCount = Assign.getNodeNameVsShardCount(collectionName, clusterState, createNodeList);
        if (createNodeList == null) {
            long availableSlots = 0L;
            for (Map.Entry<String, ReplicaCount> ent : nodeNameVsShardCount.entrySet()) {
                if (maxShardsPerNode <= ent.getValue().thisCollectionNodes) continue;
                availableSlots += (long)(maxShardsPerNode - ent.getValue().thisCollectionNodes);
            }
            if (availableSlots < (long)(nrtReplicas + tlogReplicas + pullReplicas)) {
                throw new AssignmentException(String.format(Locale.ROOT, "Cannot create %d new replicas for collection %s given the current number of eligible live nodes %d and a maxShardsPerNode of %d", nrtReplicas, collectionName, nodeNameVsShardCount.size(), maxShardsPerNode));
            }
        }
        AssignRequest assignRequest = new AssignRequestBuilder().forCollection(collectionName).forShard(Collections.singletonList(shard)).assignNrtReplicas(nrtReplicas).assignTlogReplicas(tlogReplicas).assignPullReplicas(pullReplicas).onNodes(createNodeList).build();
        AssignStrategyFactory assignStrategyFactory = new AssignStrategyFactory(cloudManager);
        AssignStrategy assignStrategy = assignStrategyFactory.create(clusterState, coll);
        return assignStrategy.assign(cloudManager, assignRequest);
    }

    public static List<ReplicaPosition> getPositionsUsingPolicy(String collName, List<String> shardNames, int nrtReplicas, int tlogReplicas, int pullReplicas, String policyName, SolrCloudManager cloudManager, List<String> nodesList) throws IOException, InterruptedException, AssignmentException {
        log.debug("shardnames {} NRT {} TLOG {} PULL {} , policy {}, nodeList {}", new Object[]{shardNames, nrtReplicas, tlogReplicas, pullReplicas, policyName, nodesList});
        List replicaPositions = null;
        AutoScalingConfig autoScalingConfig = cloudManager.getDistribStateManager().getAutoScalingConfig();
        try {
            Map<String, String> kvMap = Collections.singletonMap(collName, policyName);
            List list = replicaPositions = PolicyHelper.getReplicaLocations((String)collName, (AutoScalingConfig)autoScalingConfig, (SolrCloudManager)cloudManager, kvMap, shardNames, (int)nrtReplicas, (int)tlogReplicas, (int)pullReplicas, nodesList);
            return list;
        }
        catch (Exception e) {
            throw new AssignmentException("Error getting replica locations : " + e.getMessage(), e);
        }
        finally {
            if (log.isTraceEnabled()) {
                if (replicaPositions != null && log.isTraceEnabled()) {
                    log.trace("REPLICA_POSITIONS: {}", (Object)Utils.toJSONString((Object)Utils.getDeepCopy((Collection)replicaPositions, (int)7, (boolean)true)));
                }
                if (log.isTraceEnabled()) {
                    log.trace("AUTOSCALING_CONF: {}", (Object)Utils.toJSONString((Object)autoScalingConfig));
                }
            }
        }
    }

    static HashMap<String, ReplicaCount> getNodeNameVsShardCount(String collectionName, ClusterState clusterState, List<String> createNodeList) {
        Set nodes = clusterState.getLiveNodes();
        ArrayList nodeList = new ArrayList(nodes.size());
        nodeList.addAll(nodes);
        if (createNodeList != null) {
            nodeList.retainAll(createNodeList);
        }
        HashMap<String, ReplicaCount> nodeNameVsShardCount = new HashMap<String, ReplicaCount>();
        for (String s : nodeList) {
            nodeNameVsShardCount.put(s, new ReplicaCount(s));
        }
        if (createNodeList != null) {
            if (createNodeList.size() != nodeNameVsShardCount.size()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one of the node(s) specified " + createNodeList + " are not currently active in " + nodeNameVsShardCount.keySet() + ", no action taken.");
            }
            return nodeNameVsShardCount;
        }
        DocCollection coll = clusterState.getCollection(collectionName);
        int maxShardsPerNode = coll.getMaxShardsPerNode() == -1 ? Integer.MAX_VALUE : coll.getMaxShardsPerNode();
        Map collections = clusterState.getCollectionsMap();
        for (Map.Entry entry : collections.entrySet()) {
            DocCollection c = (DocCollection)entry.getValue();
            for (Slice slice : c.getSlices()) {
                Collection replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    ReplicaCount count = nodeNameVsShardCount.get(replica.getNodeName());
                    if (count == null) continue;
                    ++count.totalNodes;
                    if (!((String)entry.getKey()).equals(collectionName)) continue;
                    ++count.thisCollectionNodes;
                    if (count.thisCollectionNodes < maxShardsPerNode) continue;
                    nodeNameVsShardCount.remove(replica.getNodeName());
                }
            }
        }
        return nodeNameVsShardCount;
    }

    private static List<String> checkAnyLiveNodes(List<String> createNodeList, ClusterState clusterState) {
        Set liveNodes = clusterState.getLiveNodes();
        if (createNodeList == null) {
            createNodeList = Collections.emptyList();
        }
        boolean anyLiveNodes = false;
        for (String node : createNodeList) {
            anyLiveNodes |= liveNodes.contains(node);
        }
        if (!anyLiveNodes) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "None of the node(s) specified " + createNodeList + " are currently active in " + liveNodes + ", no action taken.");
        }
        return createNodeList;
    }

    public static class AssignStrategyFactory {
        public SolrCloudManager solrCloudManager;

        public AssignStrategyFactory(SolrCloudManager solrCloudManager) {
            this.solrCloudManager = solrCloudManager;
        }

        public AssignStrategy create(ClusterState clusterState, DocCollection collection) throws IOException, InterruptedException {
            List ruleMaps = (List)collection.get("rule");
            String policyName = collection.getStr("policy");
            List snitches = (List)collection.get("snitch");
            Strategy strategy = null;
            strategy = (ruleMaps == null || ruleMaps.isEmpty()) && !Assign.usePolicyFramework(collection, this.solrCloudManager) ? Strategy.LEGACY : (ruleMaps != null && !ruleMaps.isEmpty() ? Strategy.RULES : Strategy.POLICY);
            switch (strategy) {
                case LEGACY: {
                    return new LegacyAssignStrategy();
                }
                case RULES: {
                    ArrayList<Rule> rules = new ArrayList<Rule>();
                    for (Object map : ruleMaps) {
                        rules.add(new Rule((Map)map));
                    }
                    return new RulesBasedAssignStrategy(rules, snitches, clusterState);
                }
                case POLICY: {
                    return new PolicyBasedAssignStrategy(policyName);
                }
            }
            throw new AssignmentException("Unknown strategy type: " + (Object)((Object)strategy));
        }

        private static enum Strategy {
            LEGACY,
            RULES,
            POLICY;

        }
    }

    public static class PolicyBasedAssignStrategy
    implements AssignStrategy {
        public String policyName;

        public PolicyBasedAssignStrategy(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public List<ReplicaPosition> assign(SolrCloudManager solrCloudManager, AssignRequest assignRequest) throws AssignmentException, IOException, InterruptedException {
            return Assign.getPositionsUsingPolicy(assignRequest.collectionName, assignRequest.shardNames, assignRequest.numNrtReplicas, assignRequest.numTlogReplicas, assignRequest.numPullReplicas, this.policyName, solrCloudManager, assignRequest.nodes);
        }
    }

    public static class RulesBasedAssignStrategy
    implements AssignStrategy {
        public List<Rule> rules;
        public List snitches;
        public ClusterState clusterState;

        public RulesBasedAssignStrategy(List<Rule> rules, List snitches, ClusterState clusterState) {
            this.rules = rules;
            this.snitches = snitches;
            this.clusterState = clusterState;
        }

        @Override
        public List<ReplicaPosition> assign(SolrCloudManager solrCloudManager, AssignRequest assignRequest) throws AssignmentException, IOException, InterruptedException {
            if (assignRequest.numTlogReplicas + assignRequest.numPullReplicas != 0) {
                throw new AssignmentException(Replica.Type.TLOG + " or " + Replica.Type.PULL + " replica types not supported with placement rules or cluster policies");
            }
            HashMap<String, Integer> shardVsReplicaCount = new HashMap<String, Integer>();
            for (String shard : assignRequest.shardNames) {
                shardVsReplicaCount.put(shard, assignRequest.numNrtReplicas);
            }
            LinkedHashMap<String, Map<String, Integer>> shardVsNodes = new LinkedHashMap<String, Map<String, Integer>>();
            DocCollection docCollection = solrCloudManager.getClusterStateProvider().getClusterState().getCollectionOrNull(assignRequest.collectionName);
            if (docCollection != null) {
                for (Slice slice : docCollection.getSlices()) {
                    LinkedHashMap<String, Integer> n = new LinkedHashMap<String, Integer>();
                    shardVsNodes.put(slice.getName(), n);
                    for (Replica replica : slice.getReplicas()) {
                        Integer count = (Integer)n.get(replica.getNodeName());
                        if (count == null) {
                            count = 0;
                        }
                        count = count + 1;
                        n.put(replica.getNodeName(), count);
                    }
                }
            }
            ArrayList<String> nodesList = assignRequest.nodes == null ? new ArrayList(this.clusterState.getLiveNodes()) : assignRequest.nodes;
            ReplicaAssigner replicaAssigner = new ReplicaAssigner(this.rules, shardVsReplicaCount, this.snitches, shardVsNodes, nodesList, solrCloudManager, this.clusterState);
            Map<ReplicaPosition, String> nodeMappings = replicaAssigner.getNodeMappings();
            return nodeMappings.entrySet().stream().map(e -> new ReplicaPosition(((ReplicaPosition)e.getKey()).shard, ((ReplicaPosition)e.getKey()).index, ((ReplicaPosition)e.getKey()).type, (String)e.getValue())).collect(Collectors.toList());
        }
    }

    public static class LegacyAssignStrategy
    implements AssignStrategy {
        @Override
        public List<ReplicaPosition> assign(SolrCloudManager solrCloudManager, AssignRequest assignRequest) throws AssignmentException, IOException, InterruptedException {
            ClusterState clusterState = solrCloudManager.getClusterStateProvider().getClusterState();
            List<String> nodeList = assignRequest.nodes;
            HashMap<String, ReplicaCount> nodeNameVsShardCount = Assign.getNodeNameVsShardCount(assignRequest.collectionName, clusterState, assignRequest.nodes);
            if (nodeList == null || nodeList.isEmpty()) {
                ArrayList<ReplicaCount> sortedNodeList = new ArrayList<ReplicaCount>(nodeNameVsShardCount.values());
                sortedNodeList.sort(Comparator.comparingInt(ReplicaCount::weight));
                nodeList = sortedNodeList.stream().map(replicaCount -> replicaCount.nodeName).collect(Collectors.toList());
            }
            Assign.checkAnyLiveNodes(nodeList, solrCloudManager.getClusterStateProvider().getClusterState());
            int i = 0;
            ArrayList<ReplicaPosition> result = new ArrayList<ReplicaPosition>();
            for (String aShard : assignRequest.shardNames) {
                for (Map.Entry e : ImmutableMap.of((Object)Replica.Type.NRT, (Object)assignRequest.numNrtReplicas, (Object)Replica.Type.TLOG, (Object)assignRequest.numTlogReplicas, (Object)Replica.Type.PULL, (Object)assignRequest.numPullReplicas).entrySet()) {
                    for (int j = 0; j < (Integer)e.getValue(); ++j) {
                        result.add(new ReplicaPosition(aShard, j, (Replica.Type)e.getKey(), nodeList.get(i % nodeList.size())));
                        ++i;
                    }
                }
            }
            return result;
        }
    }

    public static class AssignRequestBuilder {
        private String collectionName;
        private List<String> shardNames;
        private List<String> nodes;
        private int numNrtReplicas;
        private int numTlogReplicas;
        private int numPullReplicas;

        public AssignRequestBuilder forCollection(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public AssignRequestBuilder forShard(List<String> shardNames) {
            this.shardNames = shardNames;
            return this;
        }

        public AssignRequestBuilder onNodes(List<String> nodes) {
            this.nodes = nodes;
            return this;
        }

        public AssignRequestBuilder assignNrtReplicas(int numNrtReplicas) {
            this.numNrtReplicas = numNrtReplicas;
            return this;
        }

        public AssignRequestBuilder assignTlogReplicas(int numTlogReplicas) {
            this.numTlogReplicas = numTlogReplicas;
            return this;
        }

        public AssignRequestBuilder assignPullReplicas(int numPullReplicas) {
            this.numPullReplicas = numPullReplicas;
            return this;
        }

        public AssignRequest build() {
            Objects.requireNonNull(this.collectionName, "The collectionName cannot be null");
            Objects.requireNonNull(this.shardNames, "The shard names cannot be null");
            return new AssignRequest(this.collectionName, this.shardNames, this.nodes, this.numNrtReplicas, this.numTlogReplicas, this.numPullReplicas);
        }
    }

    public static class AssignRequest {
        public String collectionName;
        public List<String> shardNames;
        public List<String> nodes;
        public int numNrtReplicas;
        public int numTlogReplicas;
        public int numPullReplicas;

        public AssignRequest(String collectionName, List<String> shardNames, List<String> nodes, int numNrtReplicas, int numTlogReplicas, int numPullReplicas) {
            this.collectionName = collectionName;
            this.shardNames = shardNames;
            this.nodes = nodes;
            this.numNrtReplicas = numNrtReplicas;
            this.numTlogReplicas = numTlogReplicas;
            this.numPullReplicas = numPullReplicas;
        }
    }

    public static interface AssignStrategy {
        public List<ReplicaPosition> assign(SolrCloudManager var1, AssignRequest var2) throws AssignmentException, IOException, InterruptedException;
    }

    public static class AssignmentException
    extends RuntimeException {
        public AssignmentException() {
        }

        public AssignmentException(String message) {
            super(message);
        }

        public AssignmentException(String message, Throwable cause) {
            super(message, cause);
        }

        public AssignmentException(Throwable cause) {
            super(cause);
        }

        public AssignmentException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }

    static class ReplicaCount {
        public final String nodeName;
        public int thisCollectionNodes = 0;
        public int totalNodes = 0;

        ReplicaCount(String nodeName) {
            this.nodeName = nodeName;
        }

        public int weight() {
            return this.thisCollectionNodes * 100 + this.totalNodes;
        }
    }
}

