﻿/*
# -----------------------------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the ""License""); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an ""AS IS"" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# -----------------------------------------------------------------------------------
*/
//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------
namespace TagSoup 
{
	/// <summary>
	/// This class provides a Schema that has been preinitialized with HTML
	/// elements, attributes, and character entity declarations.  All the declarations
	/// normally provided with HTML 4.01 are given, plus some that are IE-specific
	/// and NS4-specific.  Attribute declarations of type CDATA with no default
	/// value are not included.
	/// </summary>
	public class HTMLSchema : Schema 
	{
		// HTMLModels begin
			public const int M_AREA = 1 << 1;
	public const int M_BLOCK = 1 << 2;
	public const int M_BLOCKINLINE = 1 << 3;
	public const int M_BODY = 1 << 4;
	public const int M_CELL = 1 << 5;
	public const int M_COL = 1 << 6;
	public const int M_DEF = 1 << 7;
	public const int M_FORM = 1 << 8;
	public const int M_FRAME = 1 << 9;
	public const int M_HEAD = 1 << 10;
	public const int M_HTML = 1 << 11;
	public const int M_INLINE = 1 << 12;
	public const int M_LEGEND = 1 << 13;
	public const int M_LI = 1 << 14;
	public const int M_NOLINK = 1 << 15;
	public const int M_OPTION = 1 << 16;
	public const int M_OPTIONS = 1 << 17;
	public const int M_P = 1 << 18;
	public const int M_PARAM = 1 << 19;
	public const int M_TABLE = 1 << 20;
	public const int M_TABULAR = 1 << 21;
	public const int M_TR = 1 << 22;
  // HTMLModels end

		/// <summary>
		/// Returns a newly constructed HTMLSchema object independent of
		/// any existing ones.
		/// </summary>
		public HTMLSchema() 
		{
					Uri = "http://www.w3.org/1999/xhtml";
		Prefix = "html";
		ElementType("<pcdata>", M_EMPTY, M_PCDATA, 0);
		ElementType("<root>", M_ROOT, M_EMPTY, 0);
		ElementType("a", M_PCDATA|M_NOLINK, M_INLINE, 0);
		ElementType("abbr", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("acronym", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("address", M_PCDATA|M_INLINE|M_P, M_BLOCK, 0);
		ElementType("applet", M_PCDATA|M_PARAM|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		ElementType("area", M_EMPTY, M_AREA, 0);
		ElementType("b", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("base", M_EMPTY, M_HEAD, 0);
		ElementType("basefont", M_EMPTY, M_INLINE|M_NOLINK, 0);
		ElementType("bdo", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("bgsound", M_EMPTY, M_HEAD, 0);
		ElementType("big", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("blink", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("blockquote", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		ElementType("body", M_PCDATA|M_INLINE|M_BLOCK, M_HTML|M_BODY, 0);
		ElementType("br", M_EMPTY, M_INLINE|M_NOLINK, 0);
		ElementType("button", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		ElementType("canvas", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("caption", M_PCDATA|M_INLINE, M_TABULAR, 0);
		ElementType("center", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		ElementType("cite", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("code", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("col", M_EMPTY, M_COL|M_TABULAR, 0);
		ElementType("colgroup", M_COL, M_TABULAR, 0);
		ElementType("comment", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("dd", M_PCDATA|M_INLINE|M_BLOCK, M_DEF, 0);
		ElementType("del", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_BLOCKINLINE|M_BLOCK, F_RESTART);
		ElementType("dfn", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("dir", M_LI, M_BLOCK, 0);
		ElementType("div", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		ElementType("dl", M_DEF, M_BLOCK, 0);
		ElementType("dt", M_PCDATA|M_INLINE, M_DEF, 0);
		ElementType("em", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("fieldset", M_PCDATA|M_LEGEND|M_INLINE|M_BLOCK, M_BLOCK, 0);
		ElementType("font", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("form", M_PCDATA|M_INLINE|M_NOLINK|M_BLOCK|M_TR|M_CELL, M_BLOCK|M_FORM, F_NOFORCE);
		ElementType("frame", M_EMPTY, M_FRAME, 0);
		ElementType("frameset", M_FRAME, M_FRAME|M_HTML, 0);
		ElementType("h1", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("h2", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("h3", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("h4", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("h5", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("h6", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("head", M_HEAD, M_HTML, 0);
		ElementType("hr", M_EMPTY, M_BLOCK, 0);
		ElementType("html", M_HTML, M_ROOT, 0);
		ElementType("i", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("iframe", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_NOLINK, 0);
		ElementType("img", M_EMPTY, M_INLINE|M_NOLINK, 0);
		ElementType("input", M_EMPTY, M_INLINE|M_NOLINK, 0);
		ElementType("ins", M_PCDATA|M_INLINE|M_BLOCK, M_INLINE|M_BLOCK, F_RESTART);
		ElementType("isindex", M_EMPTY, M_HEAD, 0);
		ElementType("kbd", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("label", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("legend", M_PCDATA|M_INLINE, M_LEGEND, 0);
		ElementType("li", M_PCDATA|M_INLINE|M_BLOCK, M_LI, 0);
		ElementType("link", M_EMPTY, M_HEAD|M_INLINE, 0);
		ElementType("listing", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("map", M_BLOCK|M_AREA, M_INLINE, 0);
		ElementType("marquee", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("menu", M_LI, M_BLOCK, 0);
		ElementType("meta", M_EMPTY, M_HEAD, 0);
		ElementType("nobr", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("noframes", M_BODY|M_BLOCK|M_INLINE, M_BLOCK|M_HTML|M_FRAME, 0);
		ElementType("noscript", M_PCDATA|M_INLINE|M_BLOCK, M_BLOCK, 0);
		ElementType("object", M_PCDATA|M_PARAM|M_INLINE|M_BLOCK, M_HEAD|M_INLINE|M_NOLINK, 0);
		ElementType("ol", M_LI, M_BLOCK, 0);
		ElementType("optgroup", M_OPTIONS, M_OPTIONS, 0);
		ElementType("option", M_PCDATA, M_OPTION|M_OPTIONS, 0);
		ElementType("p", M_PCDATA|M_INLINE|M_TABLE, M_BLOCK|M_P, 0);
		ElementType("param", M_EMPTY, M_PARAM, 0);
		ElementType("pre", M_PCDATA|M_INLINE, M_BLOCK, 0);
		ElementType("q", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("rb", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("rbc", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("rp", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("rt", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("rtc", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("ruby", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("s", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("samp", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("script", M_PCDATA, (int)(M_ANY & ~M_ROOT), F_CDATA);
		ElementType("select", M_OPTIONS, M_INLINE, 0);
		ElementType("small", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("span", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("strike", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("strong", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("style", M_PCDATA, M_HEAD|M_INLINE, F_CDATA);
		ElementType("sub", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("sup", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("table", M_FORM|M_TABULAR, M_BLOCK|M_TABLE, F_NOFORCE);
		ElementType("tbody", M_TR, M_TABULAR, 0);
		ElementType("td", M_PCDATA|M_INLINE|M_BLOCK, M_CELL, 0);
		ElementType("textarea", M_PCDATA, M_INLINE, 0);
		ElementType("tfoot", M_TR|M_FORM|M_CELL, M_TABULAR, 0);
		ElementType("th", M_PCDATA|M_INLINE|M_BLOCK, M_CELL, 0);
		ElementType("thead", M_TR|M_FORM|M_CELL, M_TABULAR, 0);
		ElementType("title", M_PCDATA, M_HEAD, 0);
		ElementType("tr", M_FORM|M_CELL, M_TR|M_TABULAR, 0);
		ElementType("tt", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("u", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, F_RESTART);
		ElementType("ul", M_LI, M_BLOCK, 0);
		ElementType("var", M_PCDATA|M_INLINE, M_INLINE|M_NOLINK, 0);
		ElementType("wbr", M_EMPTY, M_INLINE|M_NOLINK, 0);
		ElementType("xmp", M_PCDATA|M_INLINE, M_BLOCK, 0);
		Parent("<pcdata>", "body");
		Parent("html", "<root>");
		Parent("a", "body");
		Parent("abbr", "body");
		Parent("acronym", "body");
		Parent("address", "body");
		Parent("applet", "body");
		Parent("area", "map");
		Parent("b", "body");
		Parent("base", "head");
		Parent("basefont", "body");
		Parent("bdo", "body");
		Parent("bgsound", "head");
		Parent("big", "body");
		Parent("blink", "body");
		Parent("blockquote", "body");
		Parent("body", "html");
		Parent("br", "body");
		Parent("button", "form");
		Parent("canvas", "body");
		Parent("caption", "table");
		Parent("center", "body");
		Parent("cite", "body");
		Parent("code", "body");
		Parent("col", "table");
		Parent("colgroup", "table");
		Parent("comment", "body");
		Parent("dd", "dl");
		Parent("del", "body");
		Parent("dfn", "body");
		Parent("dir", "body");
		Parent("div", "body");
		Parent("dl", "body");
		Parent("dt", "dl");
		Parent("em", "body");
		Parent("fieldset", "form");
		Parent("font", "body");
		Parent("form", "body");
		Parent("frame", "frameset");
		Parent("frameset", "html");
		Parent("h1", "body");
		Parent("h2", "body");
		Parent("h3", "body");
		Parent("h4", "body");
		Parent("h5", "body");
		Parent("h6", "body");
		Parent("head", "html");
		Parent("hr", "body");
		Parent("i", "body");
		Parent("iframe", "body");
		Parent("img", "body");
		Parent("input", "form");
		Parent("ins", "body");
		Parent("isindex", "head");
		Parent("kbd", "body");
		Parent("label", "form");
		Parent("legend", "fieldset");
		Parent("li", "ul");
		Parent("link", "head");
		Parent("listing", "body");
		Parent("map", "body");
		Parent("marquee", "body");
		Parent("menu", "body");
		Parent("meta", "head");
		Parent("nobr", "body");
		Parent("noframes", "html");
		Parent("noscript", "body");
		Parent("object", "body");
		Parent("ol", "body");
		Parent("optgroup", "select");
		Parent("option", "select");
		Parent("p", "body");
		Parent("param", "object");
		Parent("pre", "body");
		Parent("q", "body");
		Parent("rb", "body");
		Parent("rbc", "body");
		Parent("rp", "body");
		Parent("rt", "body");
		Parent("rtc", "body");
		Parent("ruby", "body");
		Parent("s", "body");
		Parent("samp", "body");
		Parent("script", "html");
		Parent("select", "form");
		Parent("small", "body");
		Parent("span", "body");
		Parent("strike", "body");
		Parent("strong", "body");
		Parent("style", "head");
		Parent("sub", "body");
		Parent("sup", "body");
		Parent("table", "body");
		Parent("tbody", "table");
		Parent("td", "tr");
		Parent("textarea", "form");
		Parent("tfoot", "table");
		Parent("th", "tr");
		Parent("thead", "table");
		Parent("title", "head");
		Parent("tr", "tbody");
		Parent("tt", "body");
		Parent("u", "body");
		Parent("ul", "body");
		Parent("var", "body");
		Parent("wbr", "body");
		Parent("xmp", "body");
		Attribute("a", "hreflang", "NMTOKEN", null);
		Attribute("a", "shape", "CDATA", "rect");
		Attribute("a", "tabindex", "NMTOKEN", null);
		Attribute("applet", "align", "NMTOKEN", null);
		Attribute("area", "nohref", "BOOLEAN", null);
		Attribute("area", "shape", "CDATA", "rect");
		Attribute("area", "tabindex", "NMTOKEN", null);
		Attribute("br", "clear", "CDATA", "none");
		Attribute("button", "disabled", "BOOLEAN", null);
		Attribute("button", "tabindex", "NMTOKEN", null);
		Attribute("button", "type", "CDATA", "submit");
		Attribute("caption", "align", "NMTOKEN", null);
		Attribute("col", "align", "NMTOKEN", null);
		Attribute("col", "span", "CDATA", "1");
		Attribute("col", "valign", "NMTOKEN", null);
		Attribute("colgroup", "align", "NMTOKEN", null);
		Attribute("colgroup", "span", "CDATA", "1");
		Attribute("colgroup", "valign", "NMTOKEN", null);
		Attribute("dir", "compact", "BOOLEAN", null);
		Attribute("div", "align", "NMTOKEN", null);
		Attribute("dl", "compact", "BOOLEAN", null);
		Attribute("form", "enctype", "CDATA", "application/x-www-form-urlencoded");
		Attribute("form", "method", "CDATA", "get");
		Attribute("frame", "frameborder", "CDATA", "1");
		Attribute("frame", "noresize", "BOOLEAN", null);
		Attribute("frame", "scrolling", "CDATA", "auto");
		Attribute("h1", "align", "NMTOKEN", null);
		Attribute("h2", "align", "NMTOKEN", null);
		Attribute("h3", "align", "NMTOKEN", null);
		Attribute("h4", "align", "NMTOKEN", null);
		Attribute("h5", "align", "NMTOKEN", null);
		Attribute("h6", "align", "NMTOKEN", null);
		Attribute("hr", "align", "NMTOKEN", null);
		Attribute("hr", "noshade", "BOOLEAN", null);
		Attribute("iframe", "align", "NMTOKEN", null);
		Attribute("iframe", "frameborder", "CDATA", "1");
		Attribute("iframe", "scrolling", "CDATA", "auto");
		Attribute("img", "align", "NMTOKEN", null);
		Attribute("img", "ismap", "BOOLEAN", null);
		Attribute("input", "align", "NMTOKEN", null);
		Attribute("input", "checked", "BOOLEAN", null);
		Attribute("input", "disabled", "BOOLEAN", null);
		Attribute("input", "ismap", "BOOLEAN", null);
		Attribute("input", "maxlength", "NMTOKEN", null);
		Attribute("input", "readonly", "BOOLEAN", null);
		Attribute("input", "tabindex", "NMTOKEN", null);
		Attribute("input", "type", "CDATA", "text");
		Attribute("label", "for", "IDREF", null);
		Attribute("legend", "align", "NMTOKEN", null);
		Attribute("li", "value", "NMTOKEN", null);
		Attribute("link", "hreflang", "NMTOKEN", null);
		Attribute("marquee", "width", "NMTOKEN", null);
		Attribute("menu", "compact", "BOOLEAN", null);
		Attribute("meta", "http-equiv", "NMTOKEN", null);
		Attribute("meta", "name", "NMTOKEN", null);
		Attribute("object", "align", "NMTOKEN", null);
		Attribute("object", "declare", "BOOLEAN", null);
		Attribute("object", "tabindex", "NMTOKEN", null);
		Attribute("ol", "compact", "BOOLEAN", null);
		Attribute("ol", "start", "NMTOKEN", null);
		Attribute("optgroup", "disabled", "BOOLEAN", null);
		Attribute("option", "disabled", "BOOLEAN", null);
		Attribute("option", "selected", "BOOLEAN", null);
		Attribute("p", "align", "NMTOKEN", null);
		Attribute("param", "valuetype", "CDATA", "data");
		Attribute("pre", "width", "NMTOKEN", null);
		Attribute("rt", "rbspan", "CDATA", "1");
		Attribute("script", "defer", "BOOLEAN", null);
		Attribute("select", "disabled", "BOOLEAN", null);
		Attribute("select", "multiple", "BOOLEAN", null);
		Attribute("select", "size", "NMTOKEN", null);
		Attribute("select", "tabindex", "NMTOKEN", null);
		Attribute("table", "align", "NMTOKEN", null);
		Attribute("table", "frame", "NMTOKEN", null);
		Attribute("table", "rules", "NMTOKEN", null);
		Attribute("tbody", "align", "NMTOKEN", null);
		Attribute("tbody", "valign", "NMTOKEN", null);
		Attribute("td", "align", "NMTOKEN", null);
		Attribute("td", "colspan", "CDATA", "1");
		Attribute("td", "headers", "IDREFS", null);
		Attribute("td", "nowrap", "BOOLEAN", null);
		Attribute("td", "rowspan", "CDATA", "1");
		Attribute("td", "scope", "NMTOKEN", null);
		Attribute("td", "valign", "NMTOKEN", null);
		Attribute("textarea", "cols", "NMTOKEN", null);
		Attribute("textarea", "disabled", "BOOLEAN", null);
		Attribute("textarea", "readonly", "BOOLEAN", null);
		Attribute("textarea", "rows", "NMTOKEN", null);
		Attribute("textarea", "tabindex", "NMTOKEN", null);
		Attribute("tfoot", "align", "NMTOKEN", null);
		Attribute("tfoot", "valign", "NMTOKEN", null);
		Attribute("th", "align", "NMTOKEN", null);
		Attribute("th", "colspan", "CDATA", "1");
		Attribute("th", "headers", "IDREFS", null);
		Attribute("th", "nowrap", "BOOLEAN", null);
		Attribute("th", "rowspan", "CDATA", "1");
		Attribute("th", "scope", "NMTOKEN", null);
		Attribute("th", "valign", "NMTOKEN", null);
		Attribute("thead", "align", "NMTOKEN", null);
		Attribute("thead", "valign", "NMTOKEN", null);
		Attribute("tr", "align", "NMTOKEN", null);
		Attribute("tr", "valign", "NMTOKEN", null);
		Attribute("ul", "compact", "BOOLEAN", null);
		Attribute("ul", "type", "NMTOKEN", null);
		Attribute("xmp", "width", "NMTOKEN", null);
		Attribute("a", "class", "NMTOKEN", null);
		Attribute("abbr", "class", "NMTOKEN", null);
		Attribute("acronym", "class", "NMTOKEN", null);
		Attribute("address", "class", "NMTOKEN", null);
		Attribute("applet", "class", "NMTOKEN", null);
		Attribute("area", "class", "NMTOKEN", null);
		Attribute("b", "class", "NMTOKEN", null);
		Attribute("base", "class", "NMTOKEN", null);
		Attribute("basefont", "class", "NMTOKEN", null);
		Attribute("bdo", "class", "NMTOKEN", null);
		Attribute("bgsound", "class", "NMTOKEN", null);
		Attribute("big", "class", "NMTOKEN", null);
		Attribute("blink", "class", "NMTOKEN", null);
		Attribute("blockquote", "class", "NMTOKEN", null);
		Attribute("body", "class", "NMTOKEN", null);
		Attribute("br", "class", "NMTOKEN", null);
		Attribute("button", "class", "NMTOKEN", null);
		Attribute("canvas", "class", "NMTOKEN", null);
		Attribute("caption", "class", "NMTOKEN", null);
		Attribute("center", "class", "NMTOKEN", null);
		Attribute("cite", "class", "NMTOKEN", null);
		Attribute("code", "class", "NMTOKEN", null);
		Attribute("col", "class", "NMTOKEN", null);
		Attribute("colgroup", "class", "NMTOKEN", null);
		Attribute("comment", "class", "NMTOKEN", null);
		Attribute("dd", "class", "NMTOKEN", null);
		Attribute("del", "class", "NMTOKEN", null);
		Attribute("dfn", "class", "NMTOKEN", null);
		Attribute("dir", "class", "NMTOKEN", null);
		Attribute("div", "class", "NMTOKEN", null);
		Attribute("dl", "class", "NMTOKEN", null);
		Attribute("dt", "class", "NMTOKEN", null);
		Attribute("em", "class", "NMTOKEN", null);
		Attribute("fieldset", "class", "NMTOKEN", null);
		Attribute("font", "class", "NMTOKEN", null);
		Attribute("form", "class", "NMTOKEN", null);
		Attribute("frame", "class", "NMTOKEN", null);
		Attribute("frameset", "class", "NMTOKEN", null);
		Attribute("h1", "class", "NMTOKEN", null);
		Attribute("h2", "class", "NMTOKEN", null);
		Attribute("h3", "class", "NMTOKEN", null);
		Attribute("h4", "class", "NMTOKEN", null);
		Attribute("h5", "class", "NMTOKEN", null);
		Attribute("h6", "class", "NMTOKEN", null);
		Attribute("head", "class", "NMTOKEN", null);
		Attribute("hr", "class", "NMTOKEN", null);
		Attribute("html", "class", "NMTOKEN", null);
		Attribute("i", "class", "NMTOKEN", null);
		Attribute("iframe", "class", "NMTOKEN", null);
		Attribute("img", "class", "NMTOKEN", null);
		Attribute("input", "class", "NMTOKEN", null);
		Attribute("ins", "class", "NMTOKEN", null);
		Attribute("isindex", "class", "NMTOKEN", null);
		Attribute("kbd", "class", "NMTOKEN", null);
		Attribute("label", "class", "NMTOKEN", null);
		Attribute("legend", "class", "NMTOKEN", null);
		Attribute("li", "class", "NMTOKEN", null);
		Attribute("link", "class", "NMTOKEN", null);
		Attribute("listing", "class", "NMTOKEN", null);
		Attribute("map", "class", "NMTOKEN", null);
		Attribute("marquee", "class", "NMTOKEN", null);
		Attribute("menu", "class", "NMTOKEN", null);
		Attribute("meta", "class", "NMTOKEN", null);
		Attribute("nobr", "class", "NMTOKEN", null);
		Attribute("noframes", "class", "NMTOKEN", null);
		Attribute("noscript", "class", "NMTOKEN", null);
		Attribute("object", "class", "NMTOKEN", null);
		Attribute("ol", "class", "NMTOKEN", null);
		Attribute("optgroup", "class", "NMTOKEN", null);
		Attribute("option", "class", "NMTOKEN", null);
		Attribute("p", "class", "NMTOKEN", null);
		Attribute("param", "class", "NMTOKEN", null);
		Attribute("pre", "class", "NMTOKEN", null);
		Attribute("q", "class", "NMTOKEN", null);
		Attribute("rb", "class", "NMTOKEN", null);
		Attribute("rbc", "class", "NMTOKEN", null);
		Attribute("rp", "class", "NMTOKEN", null);
		Attribute("rt", "class", "NMTOKEN", null);
		Attribute("rtc", "class", "NMTOKEN", null);
		Attribute("ruby", "class", "NMTOKEN", null);
		Attribute("s", "class", "NMTOKEN", null);
		Attribute("samp", "class", "NMTOKEN", null);
		Attribute("script", "class", "NMTOKEN", null);
		Attribute("select", "class", "NMTOKEN", null);
		Attribute("small", "class", "NMTOKEN", null);
		Attribute("span", "class", "NMTOKEN", null);
		Attribute("strike", "class", "NMTOKEN", null);
		Attribute("strong", "class", "NMTOKEN", null);
		Attribute("style", "class", "NMTOKEN", null);
		Attribute("sub", "class", "NMTOKEN", null);
		Attribute("sup", "class", "NMTOKEN", null);
		Attribute("table", "class", "NMTOKEN", null);
		Attribute("tbody", "class", "NMTOKEN", null);
		Attribute("td", "class", "NMTOKEN", null);
		Attribute("textarea", "class", "NMTOKEN", null);
		Attribute("tfoot", "class", "NMTOKEN", null);
		Attribute("th", "class", "NMTOKEN", null);
		Attribute("thead", "class", "NMTOKEN", null);
		Attribute("title", "class", "NMTOKEN", null);
		Attribute("tr", "class", "NMTOKEN", null);
		Attribute("tt", "class", "NMTOKEN", null);
		Attribute("u", "class", "NMTOKEN", null);
		Attribute("ul", "class", "NMTOKEN", null);
		Attribute("var", "class", "NMTOKEN", null);
		Attribute("wbr", "class", "NMTOKEN", null);
		Attribute("xmp", "class", "NMTOKEN", null);
		Attribute("a", "dir", "NMTOKEN", null);
		Attribute("abbr", "dir", "NMTOKEN", null);
		Attribute("acronym", "dir", "NMTOKEN", null);
		Attribute("address", "dir", "NMTOKEN", null);
		Attribute("applet", "dir", "NMTOKEN", null);
		Attribute("area", "dir", "NMTOKEN", null);
		Attribute("b", "dir", "NMTOKEN", null);
		Attribute("base", "dir", "NMTOKEN", null);
		Attribute("basefont", "dir", "NMTOKEN", null);
		Attribute("bdo", "dir", "NMTOKEN", null);
		Attribute("bgsound", "dir", "NMTOKEN", null);
		Attribute("big", "dir", "NMTOKEN", null);
		Attribute("blink", "dir", "NMTOKEN", null);
		Attribute("blockquote", "dir", "NMTOKEN", null);
		Attribute("body", "dir", "NMTOKEN", null);
		Attribute("br", "dir", "NMTOKEN", null);
		Attribute("button", "dir", "NMTOKEN", null);
		Attribute("canvas", "dir", "NMTOKEN", null);
		Attribute("caption", "dir", "NMTOKEN", null);
		Attribute("center", "dir", "NMTOKEN", null);
		Attribute("cite", "dir", "NMTOKEN", null);
		Attribute("code", "dir", "NMTOKEN", null);
		Attribute("col", "dir", "NMTOKEN", null);
		Attribute("colgroup", "dir", "NMTOKEN", null);
		Attribute("comment", "dir", "NMTOKEN", null);
		Attribute("dd", "dir", "NMTOKEN", null);
		Attribute("del", "dir", "NMTOKEN", null);
		Attribute("dfn", "dir", "NMTOKEN", null);
		Attribute("dir", "dir", "NMTOKEN", null);
		Attribute("div", "dir", "NMTOKEN", null);
		Attribute("dl", "dir", "NMTOKEN", null);
		Attribute("dt", "dir", "NMTOKEN", null);
		Attribute("em", "dir", "NMTOKEN", null);
		Attribute("fieldset", "dir", "NMTOKEN", null);
		Attribute("font", "dir", "NMTOKEN", null);
		Attribute("form", "dir", "NMTOKEN", null);
		Attribute("frame", "dir", "NMTOKEN", null);
		Attribute("frameset", "dir", "NMTOKEN", null);
		Attribute("h1", "dir", "NMTOKEN", null);
		Attribute("h2", "dir", "NMTOKEN", null);
		Attribute("h3", "dir", "NMTOKEN", null);
		Attribute("h4", "dir", "NMTOKEN", null);
		Attribute("h5", "dir", "NMTOKEN", null);
		Attribute("h6", "dir", "NMTOKEN", null);
		Attribute("head", "dir", "NMTOKEN", null);
		Attribute("hr", "dir", "NMTOKEN", null);
		Attribute("html", "dir", "NMTOKEN", null);
		Attribute("i", "dir", "NMTOKEN", null);
		Attribute("iframe", "dir", "NMTOKEN", null);
		Attribute("img", "dir", "NMTOKEN", null);
		Attribute("input", "dir", "NMTOKEN", null);
		Attribute("ins", "dir", "NMTOKEN", null);
		Attribute("isindex", "dir", "NMTOKEN", null);
		Attribute("kbd", "dir", "NMTOKEN", null);
		Attribute("label", "dir", "NMTOKEN", null);
		Attribute("legend", "dir", "NMTOKEN", null);
		Attribute("li", "dir", "NMTOKEN", null);
		Attribute("link", "dir", "NMTOKEN", null);
		Attribute("listing", "dir", "NMTOKEN", null);
		Attribute("map", "dir", "NMTOKEN", null);
		Attribute("marquee", "dir", "NMTOKEN", null);
		Attribute("menu", "dir", "NMTOKEN", null);
		Attribute("meta", "dir", "NMTOKEN", null);
		Attribute("nobr", "dir", "NMTOKEN", null);
		Attribute("noframes", "dir", "NMTOKEN", null);
		Attribute("noscript", "dir", "NMTOKEN", null);
		Attribute("object", "dir", "NMTOKEN", null);
		Attribute("ol", "dir", "NMTOKEN", null);
		Attribute("optgroup", "dir", "NMTOKEN", null);
		Attribute("option", "dir", "NMTOKEN", null);
		Attribute("p", "dir", "NMTOKEN", null);
		Attribute("param", "dir", "NMTOKEN", null);
		Attribute("pre", "dir", "NMTOKEN", null);
		Attribute("q", "dir", "NMTOKEN", null);
		Attribute("rb", "dir", "NMTOKEN", null);
		Attribute("rbc", "dir", "NMTOKEN", null);
		Attribute("rp", "dir", "NMTOKEN", null);
		Attribute("rt", "dir", "NMTOKEN", null);
		Attribute("rtc", "dir", "NMTOKEN", null);
		Attribute("ruby", "dir", "NMTOKEN", null);
		Attribute("s", "dir", "NMTOKEN", null);
		Attribute("samp", "dir", "NMTOKEN", null);
		Attribute("script", "dir", "NMTOKEN", null);
		Attribute("select", "dir", "NMTOKEN", null);
		Attribute("small", "dir", "NMTOKEN", null);
		Attribute("span", "dir", "NMTOKEN", null);
		Attribute("strike", "dir", "NMTOKEN", null);
		Attribute("strong", "dir", "NMTOKEN", null);
		Attribute("style", "dir", "NMTOKEN", null);
		Attribute("sub", "dir", "NMTOKEN", null);
		Attribute("sup", "dir", "NMTOKEN", null);
		Attribute("table", "dir", "NMTOKEN", null);
		Attribute("tbody", "dir", "NMTOKEN", null);
		Attribute("td", "dir", "NMTOKEN", null);
		Attribute("textarea", "dir", "NMTOKEN", null);
		Attribute("tfoot", "dir", "NMTOKEN", null);
		Attribute("th", "dir", "NMTOKEN", null);
		Attribute("thead", "dir", "NMTOKEN", null);
		Attribute("title", "dir", "NMTOKEN", null);
		Attribute("tr", "dir", "NMTOKEN", null);
		Attribute("tt", "dir", "NMTOKEN", null);
		Attribute("u", "dir", "NMTOKEN", null);
		Attribute("ul", "dir", "NMTOKEN", null);
		Attribute("var", "dir", "NMTOKEN", null);
		Attribute("wbr", "dir", "NMTOKEN", null);
		Attribute("xmp", "dir", "NMTOKEN", null);
		Attribute("a", "id", "ID", null);
		Attribute("abbr", "id", "ID", null);
		Attribute("acronym", "id", "ID", null);
		Attribute("address", "id", "ID", null);
		Attribute("applet", "id", "ID", null);
		Attribute("area", "id", "ID", null);
		Attribute("b", "id", "ID", null);
		Attribute("base", "id", "ID", null);
		Attribute("basefont", "id", "ID", null);
		Attribute("bdo", "id", "ID", null);
		Attribute("bgsound", "id", "ID", null);
		Attribute("big", "id", "ID", null);
		Attribute("blink", "id", "ID", null);
		Attribute("blockquote", "id", "ID", null);
		Attribute("body", "id", "ID", null);
		Attribute("br", "id", "ID", null);
		Attribute("button", "id", "ID", null);
		Attribute("canvas", "id", "ID", null);
		Attribute("caption", "id", "ID", null);
		Attribute("center", "id", "ID", null);
		Attribute("cite", "id", "ID", null);
		Attribute("code", "id", "ID", null);
		Attribute("col", "id", "ID", null);
		Attribute("colgroup", "id", "ID", null);
		Attribute("comment", "id", "ID", null);
		Attribute("dd", "id", "ID", null);
		Attribute("del", "id", "ID", null);
		Attribute("dfn", "id", "ID", null);
		Attribute("dir", "id", "ID", null);
		Attribute("div", "id", "ID", null);
		Attribute("dl", "id", "ID", null);
		Attribute("dt", "id", "ID", null);
		Attribute("em", "id", "ID", null);
		Attribute("fieldset", "id", "ID", null);
		Attribute("font", "id", "ID", null);
		Attribute("form", "id", "ID", null);
		Attribute("frame", "id", "ID", null);
		Attribute("frameset", "id", "ID", null);
		Attribute("h1", "id", "ID", null);
		Attribute("h2", "id", "ID", null);
		Attribute("h3", "id", "ID", null);
		Attribute("h4", "id", "ID", null);
		Attribute("h5", "id", "ID", null);
		Attribute("h6", "id", "ID", null);
		Attribute("head", "id", "ID", null);
		Attribute("hr", "id", "ID", null);
		Attribute("html", "id", "ID", null);
		Attribute("i", "id", "ID", null);
		Attribute("iframe", "id", "ID", null);
		Attribute("img", "id", "ID", null);
		Attribute("input", "id", "ID", null);
		Attribute("ins", "id", "ID", null);
		Attribute("isindex", "id", "ID", null);
		Attribute("kbd", "id", "ID", null);
		Attribute("label", "id", "ID", null);
		Attribute("legend", "id", "ID", null);
		Attribute("li", "id", "ID", null);
		Attribute("link", "id", "ID", null);
		Attribute("listing", "id", "ID", null);
		Attribute("map", "id", "ID", null);
		Attribute("marquee", "id", "ID", null);
		Attribute("menu", "id", "ID", null);
		Attribute("meta", "id", "ID", null);
		Attribute("nobr", "id", "ID", null);
		Attribute("noframes", "id", "ID", null);
		Attribute("noscript", "id", "ID", null);
		Attribute("object", "id", "ID", null);
		Attribute("ol", "id", "ID", null);
		Attribute("optgroup", "id", "ID", null);
		Attribute("option", "id", "ID", null);
		Attribute("p", "id", "ID", null);
		Attribute("param", "id", "ID", null);
		Attribute("pre", "id", "ID", null);
		Attribute("q", "id", "ID", null);
		Attribute("rb", "id", "ID", null);
		Attribute("rbc", "id", "ID", null);
		Attribute("rp", "id", "ID", null);
		Attribute("rt", "id", "ID", null);
		Attribute("rtc", "id", "ID", null);
		Attribute("ruby", "id", "ID", null);
		Attribute("s", "id", "ID", null);
		Attribute("samp", "id", "ID", null);
		Attribute("script", "id", "ID", null);
		Attribute("select", "id", "ID", null);
		Attribute("small", "id", "ID", null);
		Attribute("span", "id", "ID", null);
		Attribute("strike", "id", "ID", null);
		Attribute("strong", "id", "ID", null);
		Attribute("style", "id", "ID", null);
		Attribute("sub", "id", "ID", null);
		Attribute("sup", "id", "ID", null);
		Attribute("table", "id", "ID", null);
		Attribute("tbody", "id", "ID", null);
		Attribute("td", "id", "ID", null);
		Attribute("textarea", "id", "ID", null);
		Attribute("tfoot", "id", "ID", null);
		Attribute("th", "id", "ID", null);
		Attribute("thead", "id", "ID", null);
		Attribute("title", "id", "ID", null);
		Attribute("tr", "id", "ID", null);
		Attribute("tt", "id", "ID", null);
		Attribute("u", "id", "ID", null);
		Attribute("ul", "id", "ID", null);
		Attribute("var", "id", "ID", null);
		Attribute("wbr", "id", "ID", null);
		Attribute("xmp", "id", "ID", null);
		Attribute("a", "lang", "NMTOKEN", null);
		Attribute("abbr", "lang", "NMTOKEN", null);
		Attribute("acronym", "lang", "NMTOKEN", null);
		Attribute("address", "lang", "NMTOKEN", null);
		Attribute("applet", "lang", "NMTOKEN", null);
		Attribute("area", "lang", "NMTOKEN", null);
		Attribute("b", "lang", "NMTOKEN", null);
		Attribute("base", "lang", "NMTOKEN", null);
		Attribute("basefont", "lang", "NMTOKEN", null);
		Attribute("bdo", "lang", "NMTOKEN", null);
		Attribute("bgsound", "lang", "NMTOKEN", null);
		Attribute("big", "lang", "NMTOKEN", null);
		Attribute("blink", "lang", "NMTOKEN", null);
		Attribute("blockquote", "lang", "NMTOKEN", null);
		Attribute("body", "lang", "NMTOKEN", null);
		Attribute("br", "lang", "NMTOKEN", null);
		Attribute("button", "lang", "NMTOKEN", null);
		Attribute("canvas", "lang", "NMTOKEN", null);
		Attribute("caption", "lang", "NMTOKEN", null);
		Attribute("center", "lang", "NMTOKEN", null);
		Attribute("cite", "lang", "NMTOKEN", null);
		Attribute("code", "lang", "NMTOKEN", null);
		Attribute("col", "lang", "NMTOKEN", null);
		Attribute("colgroup", "lang", "NMTOKEN", null);
		Attribute("comment", "lang", "NMTOKEN", null);
		Attribute("dd", "lang", "NMTOKEN", null);
		Attribute("del", "lang", "NMTOKEN", null);
		Attribute("dfn", "lang", "NMTOKEN", null);
		Attribute("dir", "lang", "NMTOKEN", null);
		Attribute("div", "lang", "NMTOKEN", null);
		Attribute("dl", "lang", "NMTOKEN", null);
		Attribute("dt", "lang", "NMTOKEN", null);
		Attribute("em", "lang", "NMTOKEN", null);
		Attribute("fieldset", "lang", "NMTOKEN", null);
		Attribute("font", "lang", "NMTOKEN", null);
		Attribute("form", "lang", "NMTOKEN", null);
		Attribute("frame", "lang", "NMTOKEN", null);
		Attribute("frameset", "lang", "NMTOKEN", null);
		Attribute("h1", "lang", "NMTOKEN", null);
		Attribute("h2", "lang", "NMTOKEN", null);
		Attribute("h3", "lang", "NMTOKEN", null);
		Attribute("h4", "lang", "NMTOKEN", null);
		Attribute("h5", "lang", "NMTOKEN", null);
		Attribute("h6", "lang", "NMTOKEN", null);
		Attribute("head", "lang", "NMTOKEN", null);
		Attribute("hr", "lang", "NMTOKEN", null);
		Attribute("html", "lang", "NMTOKEN", null);
		Attribute("i", "lang", "NMTOKEN", null);
		Attribute("iframe", "lang", "NMTOKEN", null);
		Attribute("img", "lang", "NMTOKEN", null);
		Attribute("input", "lang", "NMTOKEN", null);
		Attribute("ins", "lang", "NMTOKEN", null);
		Attribute("isindex", "lang", "NMTOKEN", null);
		Attribute("kbd", "lang", "NMTOKEN", null);
		Attribute("label", "lang", "NMTOKEN", null);
		Attribute("legend", "lang", "NMTOKEN", null);
		Attribute("li", "lang", "NMTOKEN", null);
		Attribute("link", "lang", "NMTOKEN", null);
		Attribute("listing", "lang", "NMTOKEN", null);
		Attribute("map", "lang", "NMTOKEN", null);
		Attribute("marquee", "lang", "NMTOKEN", null);
		Attribute("menu", "lang", "NMTOKEN", null);
		Attribute("meta", "lang", "NMTOKEN", null);
		Attribute("nobr", "lang", "NMTOKEN", null);
		Attribute("noframes", "lang", "NMTOKEN", null);
		Attribute("noscript", "lang", "NMTOKEN", null);
		Attribute("object", "lang", "NMTOKEN", null);
		Attribute("ol", "lang", "NMTOKEN", null);
		Attribute("optgroup", "lang", "NMTOKEN", null);
		Attribute("option", "lang", "NMTOKEN", null);
		Attribute("p", "lang", "NMTOKEN", null);
		Attribute("param", "lang", "NMTOKEN", null);
		Attribute("pre", "lang", "NMTOKEN", null);
		Attribute("q", "lang", "NMTOKEN", null);
		Attribute("rb", "lang", "NMTOKEN", null);
		Attribute("rbc", "lang", "NMTOKEN", null);
		Attribute("rp", "lang", "NMTOKEN", null);
		Attribute("rt", "lang", "NMTOKEN", null);
		Attribute("rtc", "lang", "NMTOKEN", null);
		Attribute("ruby", "lang", "NMTOKEN", null);
		Attribute("s", "lang", "NMTOKEN", null);
		Attribute("samp", "lang", "NMTOKEN", null);
		Attribute("script", "lang", "NMTOKEN", null);
		Attribute("select", "lang", "NMTOKEN", null);
		Attribute("small", "lang", "NMTOKEN", null);
		Attribute("span", "lang", "NMTOKEN", null);
		Attribute("strike", "lang", "NMTOKEN", null);
		Attribute("strong", "lang", "NMTOKEN", null);
		Attribute("style", "lang", "NMTOKEN", null);
		Attribute("sub", "lang", "NMTOKEN", null);
		Attribute("sup", "lang", "NMTOKEN", null);
		Attribute("table", "lang", "NMTOKEN", null);
		Attribute("tbody", "lang", "NMTOKEN", null);
		Attribute("td", "lang", "NMTOKEN", null);
		Attribute("textarea", "lang", "NMTOKEN", null);
		Attribute("tfoot", "lang", "NMTOKEN", null);
		Attribute("th", "lang", "NMTOKEN", null);
		Attribute("thead", "lang", "NMTOKEN", null);
		Attribute("title", "lang", "NMTOKEN", null);
		Attribute("tr", "lang", "NMTOKEN", null);
		Attribute("tt", "lang", "NMTOKEN", null);
		Attribute("u", "lang", "NMTOKEN", null);
		Attribute("ul", "lang", "NMTOKEN", null);
		Attribute("var", "lang", "NMTOKEN", null);
		Attribute("wbr", "lang", "NMTOKEN", null);
		Attribute("xmp", "lang", "NMTOKEN", null);
		Entity("aacgr", 0x03AC);
		Entity("Aacgr", 0x0386);
		Entity("aacute", 0x00E1);
		Entity("Aacute", 0x00C1);
		Entity("abreve", 0x0103);
		Entity("Abreve", 0x0102);
		Entity("ac", 0x223E);
		Entity("acd", 0x223F);
		Entity("acirc", 0x00E2);
		Entity("Acirc", 0x00C2);
		Entity("acute", 0x00B4);
		Entity("acy", 0x0430);
		Entity("Acy", 0x0410);
		Entity("aelig", 0x00E6);
		Entity("AElig", 0x00C6);
		Entity("af", 0x2061);
		Entity("afr", 0x1D51E);
		Entity("Afr", 0x1D504);
		Entity("agr", 0x03B1);
		Entity("Agr", 0x0391);
		Entity("agrave", 0x00E0);
		Entity("Agrave", 0x00C0);
		Entity("alefsym", 0x2135);
		Entity("aleph", 0x2135);
		Entity("alpha", 0x03B1);
		Entity("Alpha", 0x0391);
		Entity("amacr", 0x0101);
		Entity("Amacr", 0x0100);
		Entity("amalg", 0x2A3F);
		Entity("amp", 0x0026);
		Entity("and", 0x2227);
		Entity("And", 0x2A53);
		Entity("andand", 0x2A55);
		Entity("andd", 0x2A5C);
		Entity("andslope", 0x2A58);
		Entity("andv", 0x2A5A);
		Entity("ang", 0x2220);
		Entity("ange", 0x29A4);
		Entity("angle", 0x2220);
		Entity("angmsd", 0x2221);
		Entity("angmsdaa", 0x29A8);
		Entity("angmsdab", 0x29A9);
		Entity("angmsdac", 0x29AA);
		Entity("angmsdad", 0x29AB);
		Entity("angmsdae", 0x29AC);
		Entity("angmsdaf", 0x29AD);
		Entity("angmsdag", 0x29AE);
		Entity("angmsdah", 0x29AF);
		Entity("angrt", 0x221F);
		Entity("angrtvb", 0x22BE);
		Entity("angrtvbd", 0x299D);
		Entity("angsph", 0x2222);
		Entity("angst", 0x212B);
		Entity("angzarr", 0x237C);
		Entity("aogon", 0x0105);
		Entity("Aogon", 0x0104);
		Entity("aopf", 0x1D552);
		Entity("Aopf", 0x1D538);
		Entity("ap", 0x2248);
		Entity("apacir", 0x2A6F);
		Entity("ape", 0x224A);
		Entity("apE", 0x2A70);
		Entity("apid", 0x224B);
		Entity("apos", 0x0027);
		Entity("ApplyFunction", 0x2061);
		Entity("approx", 0x2248);
		Entity("approxeq", 0x224A);
		Entity("aring", 0x00E5);
		Entity("Aring", 0x00C5);
		Entity("ascr", 0x1D4B6);
		Entity("Ascr", 0x1D49C);
		Entity("Assign", 0x2254);
		Entity("ast", 0x002A);
		Entity("asymp", 0x2248);
		Entity("asympeq", 0x224D);
		Entity("atilde", 0x00E3);
		Entity("Atilde", 0x00C3);
		Entity("auml", 0x00E4);
		Entity("Auml", 0x00C4);
		Entity("awconint", 0x2233);
		Entity("awint", 0x2A11);
		Entity("b.alpha", 0x1D6C2);
		Entity("b.beta", 0x1D6C3);
		Entity("b.chi", 0x1D6D8);
		Entity("b.delta", 0x1D6C5);
		Entity("b.Delta", 0x1D6AB);
		Entity("b.epsi", 0x1D6C6);
		Entity("b.epsiv", 0x1D6DC);
		Entity("b.eta", 0x1D6C8);
		Entity("b.gamma", 0x1D6C4);
		Entity("b.Gamma", 0x1D6AA);
		Entity("b.gammad", 0x1D7CB);
		Entity("b.Gammad", 0x1D7CA);
		Entity("b.iota", 0x1D6CA);
		Entity("b.kappa", 0x1D6CB);
		Entity("b.kappav", 0x1D6DE);
		Entity("b.lambda", 0x1D6CC);
		Entity("b.Lambda", 0x1D6B2);
		Entity("b.mu", 0x1D6CD);
		Entity("b.nu", 0x1D6CE);
		Entity("b.omega", 0x1D6DA);
		Entity("b.Omega", 0x1D6C0);
		Entity("b.phi", 0x1D6D7);
		Entity("b.Phi", 0x1D6BD);
		Entity("b.phiv", 0x1D6DF);
		Entity("b.pi", 0x1D6D1);
		Entity("b.Pi", 0x1D6B7);
		Entity("b.piv", 0x1D6E1);
		Entity("b.psi", 0x1D6D9);
		Entity("b.Psi", 0x1D6BF);
		Entity("b.rho", 0x1D6D2);
		Entity("b.rhov", 0x1D6E0);
		Entity("b.sigma", 0x1D6D4);
		Entity("b.Sigma", 0x1D6BA);
		Entity("b.sigmav", 0x1D6D3);
		Entity("b.tau", 0x1D6D5);
		Entity("b.Theta", 0x1D6AF);
		Entity("b.thetas", 0x1D6C9);
		Entity("b.thetav", 0x1D6DD);
		Entity("b.upsi", 0x1D6D6);
		Entity("b.Upsi", 0x1D6BC);
		Entity("b.xi", 0x1D6CF);
		Entity("b.Xi", 0x1D6B5);
		Entity("b.zeta", 0x1D6C7);
		Entity("backcong", 0x224C);
		Entity("backepsilon", 0x03F6);
		Entity("backprime", 0x2035);
		Entity("backsim", 0x223D);
		Entity("backsimeq", 0x22CD);
		Entity("Backslash", 0x2216);
		Entity("Barv", 0x2AE7);
		Entity("barvee", 0x22BD);
		Entity("barwed", 0x2305);
		Entity("Barwed", 0x2306);
		Entity("barwedge", 0x2305);
		Entity("bbrk", 0x23B5);
		Entity("bbrktbrk", 0x23B6);
		Entity("bcong", 0x224C);
		Entity("bcy", 0x0431);
		Entity("Bcy", 0x0411);
		Entity("bdquo", 0x201E);
		Entity("becaus", 0x2235);
		Entity("because", 0x2235);
		Entity("bemptyv", 0x29B0);
		Entity("bepsi", 0x03F6);
		Entity("bernou", 0x212C);
		Entity("Bernoullis", 0x212C);
		Entity("beta", 0x03B2);
		Entity("Beta", 0x0392);
		Entity("beth", 0x2136);
		Entity("between", 0x226C);
		Entity("bfr", 0x1D51F);
		Entity("Bfr", 0x1D505);
		Entity("bgr", 0x03B2);
		Entity("Bgr", 0x0392);
		Entity("bigcap", 0x22C2);
		Entity("bigcirc", 0x25EF);
		Entity("bigcup", 0x22C3);
		Entity("bigodot", 0x2A00);
		Entity("bigoplus", 0x2A01);
		Entity("bigotimes", 0x2A02);
		Entity("bigsqcup", 0x2A06);
		Entity("bigstar", 0x2605);
		Entity("bigtriangledown", 0x25BD);
		Entity("bigtriangleup", 0x25B3);
		Entity("biguplus", 0x2A04);
		Entity("bigvee", 0x22C1);
		Entity("bigwedge", 0x22C0);
		Entity("bkarow", 0x290D);
		Entity("blacklozenge", 0x29EB);
		Entity("blacksquare", 0x25AA);
		Entity("blacktriangle", 0x25B4);
		Entity("blacktriangledown", 0x25BE);
		Entity("blacktriangleleft", 0x25C2);
		Entity("blacktriangleright", 0x25B8);
		Entity("blank", 0x2423);
		Entity("blk12", 0x2592);
		Entity("blk14", 0x2591);
		Entity("blk34", 0x2593);
		Entity("block", 0x2588);
		Entity("bnot", 0x2310);
		Entity("bNot", 0x2AED);
		Entity("bopf", 0x1D553);
		Entity("Bopf", 0x1D539);
		Entity("bot", 0x22A5);
		Entity("bottom", 0x22A5);
		Entity("bowtie", 0x22C8);
		Entity("boxbox", 0x29C9);
		Entity("boxdl", 0x2510);
		Entity("boxdL", 0x2555);
		Entity("boxDl", 0x2556);
		Entity("boxDL", 0x2557);
		Entity("boxdr", 0x250C);
		Entity("boxdR", 0x2552);
		Entity("boxDr", 0x2553);
		Entity("boxDR", 0x2554);
		Entity("boxh", 0x2500);
		Entity("boxH", 0x2550);
		Entity("boxhd", 0x252C);
		Entity("boxhD", 0x2565);
		Entity("boxHd", 0x2564);
		Entity("boxHD", 0x2566);
		Entity("boxhu", 0x2534);
		Entity("boxhU", 0x2568);
		Entity("boxHu", 0x2567);
		Entity("boxHU", 0x2569);
		Entity("boxminus", 0x229F);
		Entity("boxplus", 0x229E);
		Entity("boxtimes", 0x22A0);
		Entity("boxul", 0x2518);
		Entity("boxuL", 0x255B);
		Entity("boxUl", 0x255C);
		Entity("boxUL", 0x255D);
		Entity("boxur", 0x2514);
		Entity("boxuR", 0x2558);
		Entity("boxUr", 0x2559);
		Entity("boxUR", 0x255A);
		Entity("boxv", 0x2502);
		Entity("boxV", 0x2551);
		Entity("boxvh", 0x253C);
		Entity("boxvH", 0x256A);
		Entity("boxVh", 0x256B);
		Entity("boxVH", 0x256C);
		Entity("boxvl", 0x2524);
		Entity("boxvL", 0x2561);
		Entity("boxVl", 0x2562);
		Entity("boxVL", 0x2563);
		Entity("boxvr", 0x251C);
		Entity("boxvR", 0x255E);
		Entity("boxVr", 0x255F);
		Entity("boxVR", 0x2560);
		Entity("bprime", 0x2035);
		Entity("breve", 0x02D8);
		Entity("brvbar", 0x00A6);
		Entity("bscr", 0x1D4B7);
		Entity("Bscr", 0x212C);
		Entity("bsemi", 0x204F);
		Entity("bsim", 0x223D);
		Entity("bsime", 0x22CD);
		Entity("bsol", 0x005C);
		Entity("bsolb", 0x29C5);
		Entity("bull", 0x2022);
		Entity("bullet", 0x2022);
		Entity("bump", 0x224E);
		Entity("bumpe", 0x224F);
		Entity("bumpE", 0x2AAE);
		Entity("bumpeq", 0x224F);
		Entity("Bumpeq", 0x224E);
		Entity("cacute", 0x0107);
		Entity("Cacute", 0x0106);
		Entity("cap", 0x2229);
		Entity("Cap", 0x22D2);
		Entity("capand", 0x2A44);
		Entity("capbrcup", 0x2A49);
		Entity("capcap", 0x2A4B);
		Entity("capcup", 0x2A47);
		Entity("capdot", 0x2A40);
		Entity("CapitalDifferentialD", 0x2145);
		Entity("caret", 0x2041);
		Entity("caron", 0x02C7);
		Entity("Cayleys", 0x212D);
		Entity("ccaps", 0x2A4D);
		Entity("ccaron", 0x010D);
		Entity("Ccaron", 0x010C);
		Entity("ccedil", 0x00E7);
		Entity("Ccedil", 0x00C7);
		Entity("ccirc", 0x0109);
		Entity("Ccirc", 0x0108);
		Entity("Cconint", 0x2230);
		Entity("ccups", 0x2A4C);
		Entity("ccupssm", 0x2A50);
		Entity("cdot", 0x010B);
		Entity("Cdot", 0x010A);
		Entity("cedil", 0x00B8);
		Entity("Cedilla", 0x00B8);
		Entity("cemptyv", 0x29B2);
		Entity("cent", 0x00A2);
		Entity("centerdot", 0x00B7);
		Entity("cfr", 0x1D520);
		Entity("Cfr", 0x212D);
		Entity("chcy", 0x0447);
		Entity("CHcy", 0x0427);
		Entity("check", 0x2713);
		Entity("checkmark", 0x2713);
		Entity("chi", 0x03C7);
		Entity("Chi", 0x03A7);
		Entity("cir", 0x25CB);
		Entity("circ", 0x02C6);
		Entity("circeq", 0x2257);
		Entity("circlearrowleft", 0x21BA);
		Entity("circlearrowright", 0x21BB);
		Entity("circledast", 0x229B);
		Entity("circledcirc", 0x229A);
		Entity("circleddash", 0x229D);
		Entity("CircleDot", 0x2299);
		Entity("circledR", 0x00AE);
		Entity("circledS", 0x24C8);
		Entity("CircleMinus", 0x2296);
		Entity("CirclePlus", 0x2295);
		Entity("CircleTimes", 0x2297);
		Entity("cire", 0x2257);
		Entity("cirE", 0x29C3);
		Entity("cirfnint", 0x2A10);
		Entity("cirmid", 0x2AEF);
		Entity("cirscir", 0x29C2);
		Entity("ClockwiseContourIntegral", 0x2232);
		Entity("CloseCurlyDoubleQuote", 0x201D);
		Entity("CloseCurlyQuote", 0x2019);
		Entity("clubs", 0x2663);
		Entity("clubsuit", 0x2663);
		Entity("colon", 0x003A);
		Entity("Colon", 0x2237);
		Entity("colone", 0x2254);
		Entity("Colone", 0x2A74);
		Entity("coloneq", 0x2254);
		Entity("comma", 0x002C);
		Entity("commat", 0x0040);
		Entity("comp", 0x2201);
		Entity("compfn", 0x2218);
		Entity("complement", 0x2201);
		Entity("complexes", 0x2102);
		Entity("cong", 0x2245);
		Entity("congdot", 0x2A6D);
		Entity("Congruent", 0x2261);
		Entity("conint", 0x222E);
		Entity("Conint", 0x222F);
		Entity("ContourIntegral", 0x222E);
		Entity("copf", 0x1D554);
		Entity("Copf", 0x2102);
		Entity("coprod", 0x2210);
		Entity("Coproduct", 0x2210);
		Entity("copy", 0x00A9);
		Entity("copysr", 0x2117);
		Entity("CounterClockwiseContourIntegral", 0x2233);
		Entity("crarr", 0x21B5);
		Entity("cross", 0x2717);
		Entity("Cross", 0x2A2F);
		Entity("cscr", 0x1D4B8);
		Entity("Cscr", 0x1D49E);
		Entity("csub", 0x2ACF);
		Entity("csube", 0x2AD1);
		Entity("csup", 0x2AD0);
		Entity("csupe", 0x2AD2);
		Entity("ctdot", 0x22EF);
		Entity("cudarrl", 0x2938);
		Entity("cudarrr", 0x2935);
		Entity("cuepr", 0x22DE);
		Entity("cuesc", 0x22DF);
		Entity("cularr", 0x21B6);
		Entity("cularrp", 0x293D);
		Entity("cup", 0x222A);
		Entity("Cup", 0x22D3);
		Entity("cupbrcap", 0x2A48);
		Entity("cupcap", 0x2A46);
		Entity("CupCap", 0x224D);
		Entity("cupcup", 0x2A4A);
		Entity("cupdot", 0x228D);
		Entity("cupor", 0x2A45);
		Entity("curarr", 0x21B7);
		Entity("curarrm", 0x293C);
		Entity("curlyeqprec", 0x22DE);
		Entity("curlyeqsucc", 0x22DF);
		Entity("curlyvee", 0x22CE);
		Entity("curlywedge", 0x22CF);
		Entity("curren", 0x00A4);
		Entity("curvearrowleft", 0x21B6);
		Entity("curvearrowright", 0x21B7);
		Entity("cuvee", 0x22CE);
		Entity("cuwed", 0x22CF);
		Entity("cwconint", 0x2232);
		Entity("cwint", 0x2231);
		Entity("cylcty", 0x232D);
		Entity("dagger", 0x2020);
		Entity("Dagger", 0x2021);
		Entity("daleth", 0x2138);
		Entity("darr", 0x2193);
		Entity("dArr", 0x21D3);
		Entity("Darr", 0x21A1);
		Entity("dash", 0x2010);
		Entity("dashv", 0x22A3);
		Entity("Dashv", 0x2AE4);
		Entity("dbkarow", 0x290F);
		Entity("dblac", 0x02DD);
		Entity("dcaron", 0x010F);
		Entity("Dcaron", 0x010E);
		Entity("dcy", 0x0434);
		Entity("Dcy", 0x0414);
		Entity("dd", 0x2146);
		Entity("DD", 0x2145);
		Entity("ddagger", 0x2021);
		Entity("ddarr", 0x21CA);
		Entity("DDotrahd", 0x2911);
		Entity("ddotseq", 0x2A77);
		Entity("deg", 0x00B0);
		Entity("Del", 0x2207);
		Entity("delta", 0x03B4);
		Entity("Delta", 0x0394);
		Entity("demptyv", 0x29B1);
		Entity("dfisht", 0x297F);
		Entity("dfr", 0x1D521);
		Entity("Dfr", 0x1D507);
		Entity("dgr", 0x03B4);
		Entity("Dgr", 0x0394);
		Entity("dHar", 0x2965);
		Entity("dharl", 0x21C3);
		Entity("dharr", 0x21C2);
		Entity("DiacriticalAcute", 0x00B4);
		Entity("DiacriticalDot", 0x02D9);
		Entity("DiacriticalDoubleAcute", 0x02DD);
		Entity("DiacriticalGrave", 0x0060);
		Entity("DiacriticalTilde", 0x02DC);
		Entity("diam", 0x22C4);
		Entity("diamond", 0x22C4);
		Entity("diamondsuit", 0x2666);
		Entity("diams", 0x2666);
		Entity("die", 0x00A8);
		Entity("DifferentialD", 0x2146);
		Entity("digamma", 0x03DD);
		Entity("disin", 0x22F2);
		Entity("div", 0x00F7);
		Entity("divide", 0x00F7);
		Entity("divideontimes", 0x22C7);
		Entity("divonx", 0x22C7);
		Entity("djcy", 0x0452);
		Entity("DJcy", 0x0402);
		Entity("dlcorn", 0x231E);
		Entity("dlcrop", 0x230D);
		Entity("dollar", 0x0024);
		Entity("dopf", 0x1D555);
		Entity("Dopf", 0x1D53B);
		Entity("dot", 0x02D9);
		Entity("Dot", 0x00A8);
		Entity("doteq", 0x2250);
		Entity("doteqdot", 0x2251);
		Entity("DotEqual", 0x2250);
		Entity("dotminus", 0x2238);
		Entity("dotplus", 0x2214);
		Entity("dotsquare", 0x22A1);
		Entity("doublebarwedge", 0x2306);
		Entity("DoubleContourIntegral", 0x222F);
		Entity("DoubleDot", 0x00A8);
		Entity("DoubleDownArrow", 0x21D3);
		Entity("DoubleLeftArrow", 0x21D0);
		Entity("DoubleLeftRightArrow", 0x21D4);
		Entity("DoubleLeftTee", 0x2AE4);
		Entity("DoubleLongLeftArrow", 0x27F8);
		Entity("DoubleLongLeftRightArrow", 0x27FA);
		Entity("DoubleLongRightArrow", 0x27F9);
		Entity("DoubleRightArrow", 0x21D2);
		Entity("DoubleRightTee", 0x22A8);
		Entity("DoubleUpArrow", 0x21D1);
		Entity("DoubleUpDownArrow", 0x21D5);
		Entity("DoubleVerticalBar", 0x2225);
		Entity("downarrow", 0x2193);
		Entity("Downarrow", 0x21D3);
		Entity("DownArrowBar", 0x2913);
		Entity("DownArrowUpArrow", 0x21F5);
		Entity("downdownarrows", 0x21CA);
		Entity("downharpoonleft", 0x21C3);
		Entity("downharpoonright", 0x21C2);
		Entity("DownLeftRightVector", 0x2950);
		Entity("DownLeftTeeVector", 0x295E);
		Entity("DownLeftVector", 0x21BD);
		Entity("DownLeftVectorBar", 0x2956);
		Entity("DownRightTeeVector", 0x295F);
		Entity("DownRightVector", 0x21C1);
		Entity("DownRightVectorBar", 0x2957);
		Entity("DownTee", 0x22A4);
		Entity("DownTeeArrow", 0x21A7);
		Entity("drbkarow", 0x2910);
		Entity("drcorn", 0x231F);
		Entity("drcrop", 0x230C);
		Entity("dscr", 0x1D4B9);
		Entity("Dscr", 0x1D49F);
		Entity("dscy", 0x0455);
		Entity("DScy", 0x0405);
		Entity("dsol", 0x29F6);
		Entity("dstrok", 0x0111);
		Entity("Dstrok", 0x0110);
		Entity("dtdot", 0x22F1);
		Entity("dtri", 0x25BF);
		Entity("dtrif", 0x25BE);
		Entity("duarr", 0x21F5);
		Entity("duhar", 0x296F);
		Entity("dwangle", 0x29A6);
		Entity("dzcy", 0x045F);
		Entity("DZcy", 0x040F);
		Entity("dzigrarr", 0x27FF);
		Entity("eacgr", 0x03AD);
		Entity("Eacgr", 0x0388);
		Entity("eacute", 0x00E9);
		Entity("Eacute", 0x00C9);
		Entity("easter", 0x2A6E);
		Entity("ecaron", 0x011B);
		Entity("Ecaron", 0x011A);
		Entity("ecir", 0x2256);
		Entity("ecirc", 0x00EA);
		Entity("Ecirc", 0x00CA);
		Entity("ecolon", 0x2255);
		Entity("ecy", 0x044D);
		Entity("Ecy", 0x042D);
		Entity("eDDot", 0x2A77);
		Entity("edot", 0x0117);
		Entity("eDot", 0x2251);
		Entity("Edot", 0x0116);
		Entity("ee", 0x2147);
		Entity("eeacgr", 0x03AE);
		Entity("EEacgr", 0x0389);
		Entity("eegr", 0x03B7);
		Entity("EEgr", 0x0397);
		Entity("efDot", 0x2252);
		Entity("efr", 0x1D522);
		Entity("Efr", 0x1D508);
		Entity("eg", 0x2A9A);
		Entity("egr", 0x03B5);
		Entity("Egr", 0x0395);
		Entity("egrave", 0x00E8);
		Entity("Egrave", 0x00C8);
		Entity("egs", 0x2A96);
		Entity("egsdot", 0x2A98);
		Entity("el", 0x2A99);
		Entity("Element", 0x2208);
		Entity("elinters", 0x23E7);
		Entity("ell", 0x2113);
		Entity("els", 0x2A95);
		Entity("elsdot", 0x2A97);
		Entity("emacr", 0x0113);
		Entity("Emacr", 0x0112);
		Entity("empty", 0x2205);
		Entity("emptyset", 0x2205);
		Entity("EmptySmallSquare", 0x25FB);
		Entity("emptyv", 0x2205);
		Entity("EmptyVerySmallSquare", 0x25AB);
		Entity("emsp", 0x2003);
		Entity("emsp13", 0x2004);
		Entity("emsp14", 0x2005);
		Entity("eng", 0x014B);
		Entity("ENG", 0x014A);
		Entity("ensp", 0x2002);
		Entity("eogon", 0x0119);
		Entity("Eogon", 0x0118);
		Entity("eopf", 0x1D556);
		Entity("Eopf", 0x1D53C);
		Entity("epar", 0x22D5);
		Entity("eparsl", 0x29E3);
		Entity("eplus", 0x2A71);
		Entity("epsi", 0x03F5);
		Entity("epsilon", 0x03B5);
		Entity("Epsilon", 0x0395);
		Entity("epsiv", 0x03B5);
		Entity("eqcirc", 0x2256);
		Entity("eqcolon", 0x2255);
		Entity("eqsim", 0x2242);
		Entity("eqslantgtr", 0x2A96);
		Entity("eqslantless", 0x2A95);
		Entity("Equal", 0x2A75);
		Entity("equals", 0x003D);
		Entity("EqualTilde", 0x2242);
		Entity("equest", 0x225F);
		Entity("Equilibrium", 0x21CC);
		Entity("equiv", 0x2261);
		Entity("equivDD", 0x2A78);
		Entity("eqvparsl", 0x29E5);
		Entity("erarr", 0x2971);
		Entity("erDot", 0x2253);
		Entity("escr", 0x212F);
		Entity("Escr", 0x2130);
		Entity("esdot", 0x2250);
		Entity("esim", 0x2242);
		Entity("Esim", 0x2A73);
		Entity("eta", 0x03B7);
		Entity("Eta", 0x0397);
		Entity("eth", 0x00F0);
		Entity("ETH", 0x00D0);
		Entity("euml", 0x00EB);
		Entity("Euml", 0x00CB);
		Entity("euro", 0x20AC);
		Entity("excl", 0x0021);
		Entity("exist", 0x2203);
		Entity("Exists", 0x2203);
		Entity("expectation", 0x2130);
		Entity("exponentiale", 0x2147);
		Entity("fallingdotseq", 0x2252);
		Entity("fcy", 0x0444);
		Entity("Fcy", 0x0424);
		Entity("female", 0x2640);
		Entity("ffilig", 0xFB03);
		Entity("fflig", 0xFB00);
		Entity("ffllig", 0xFB04);
		Entity("ffr", 0x1D523);
		Entity("Ffr", 0x1D509);
		Entity("filig", 0xFB01);
		Entity("FilledSmallSquare", 0x25FC);
		Entity("FilledVerySmallSquare", 0x25AA);
		Entity("flat", 0x266D);
		Entity("fllig", 0xFB02);
		Entity("fltns", 0x25B1);
		Entity("fnof", 0x0192);
		Entity("fopf", 0x1D557);
		Entity("Fopf", 0x1D53D);
		Entity("forall", 0x2200);
		Entity("fork", 0x22D4);
		Entity("forkv", 0x2AD9);
		Entity("Fouriertrf", 0x2131);
		Entity("fpartint", 0x2A0D);
		Entity("frac12", 0x00BD);
		Entity("frac13", 0x2153);
		Entity("frac14", 0x00BC);
		Entity("frac15", 0x2155);
		Entity("frac16", 0x2159);
		Entity("frac18", 0x215B);
		Entity("frac23", 0x2154);
		Entity("frac25", 0x2156);
		Entity("frac34", 0x00BE);
		Entity("frac35", 0x2157);
		Entity("frac38", 0x215C);
		Entity("frac45", 0x2158);
		Entity("frac56", 0x215A);
		Entity("frac58", 0x215D);
		Entity("frac78", 0x215E);
		Entity("frasl", 0x2044);
		Entity("frown", 0x2322);
		Entity("fscr", 0x1D4BB);
		Entity("Fscr", 0x2131);
		Entity("gacute", 0x01F5);
		Entity("gamma", 0x03B3);
		Entity("Gamma", 0x0393);
		Entity("gammad", 0x03DD);
		Entity("Gammad", 0x03DC);
		Entity("gap", 0x2A86);
		Entity("gbreve", 0x011F);
		Entity("Gbreve", 0x011E);
		Entity("Gcedil", 0x0122);
		Entity("gcirc", 0x011D);
		Entity("Gcirc", 0x011C);
		Entity("gcy", 0x0433);
		Entity("Gcy", 0x0413);
		Entity("gdot", 0x0121);
		Entity("Gdot", 0x0120);
		Entity("ge", 0x2265);
		Entity("gE", 0x2267);
		Entity("gel", 0x22DB);
		Entity("gEl", 0x2A8C);
		Entity("geq", 0x2265);
		Entity("geqq", 0x2267);
		Entity("geqslant", 0x2A7E);
		Entity("ges", 0x2A7E);
		Entity("gescc", 0x2AA9);
		Entity("gesdot", 0x2A80);
		Entity("gesdoto", 0x2A82);
		Entity("gesdotol", 0x2A84);
		Entity("gesles", 0x2A94);
		Entity("gfr", 0x1D524);
		Entity("Gfr", 0x1D50A);
		Entity("gg", 0x226B);
		Entity("Gg", 0x22D9);
		Entity("ggg", 0x22D9);
		Entity("ggr", 0x03B3);
		Entity("Ggr", 0x0393);
		Entity("gimel", 0x2137);
		Entity("gjcy", 0x0453);
		Entity("GJcy", 0x0403);
		Entity("gl", 0x2277);
		Entity("gla", 0x2AA5);
		Entity("glE", 0x2A92);
		Entity("glj", 0x2AA4);
		Entity("gnap", 0x2A8A);
		Entity("gnapprox", 0x2A8A);
		Entity("gne", 0x2A88);
		Entity("gnE", 0x2269);
		Entity("gneq", 0x2A88);
		Entity("gneqq", 0x2269);
		Entity("gnsim", 0x22E7);
		Entity("gopf", 0x1D558);
		Entity("Gopf", 0x1D53E);
		Entity("grave", 0x0060);
		Entity("GreaterEqual", 0x2265);
		Entity("GreaterEqualLess", 0x22DB);
		Entity("GreaterFullEqual", 0x2267);
		Entity("GreaterGreater", 0x2AA2);
		Entity("GreaterLess", 0x2277);
		Entity("GreaterSlantEqual", 0x2A7E);
		Entity("GreaterTilde", 0x2273);
		Entity("gscr", 0x210A);
		Entity("Gscr", 0x1D4A2);
		Entity("gsim", 0x2273);
		Entity("gsime", 0x2A8E);
		Entity("gsiml", 0x2A90);
		Entity("gt", 0x003E);
		Entity("Gt", 0x226B);
		Entity("gtcc", 0x2AA7);
		Entity("gtcir", 0x2A7A);
		Entity("gtdot", 0x22D7);
		Entity("gtlPar", 0x2995);
		Entity("gtquest", 0x2A7C);
		Entity("gtrapprox", 0x2A86);
		Entity("gtrarr", 0x2978);
		Entity("gtrdot", 0x22D7);
		Entity("gtreqless", 0x22DB);
		Entity("gtreqqless", 0x2A8C);
		Entity("gtrless", 0x2277);
		Entity("gtrsim", 0x2273);
		Entity("Hacek", 0x02C7);
		Entity("hairsp", 0x200A);
		Entity("half", 0x00BD);
		Entity("hamilt", 0x210B);
		Entity("hardcy", 0x044A);
		Entity("HARDcy", 0x042A);
		Entity("harr", 0x2194);
		Entity("hArr", 0x21D4);
		Entity("harrcir", 0x2948);
		Entity("harrw", 0x21AD);
		Entity("Hat", 0x005E);
		Entity("hbar", 0x210F);
		Entity("hcirc", 0x0125);
		Entity("Hcirc", 0x0124);
		Entity("hearts", 0x2665);
		Entity("heartsuit", 0x2665);
		Entity("hellip", 0x2026);
		Entity("hercon", 0x22B9);
		Entity("hfr", 0x1D525);
		Entity("Hfr", 0x210C);
		Entity("HilbertSpace", 0x210B);
		Entity("hksearow", 0x2925);
		Entity("hkswarow", 0x2926);
		Entity("hoarr", 0x21FF);
		Entity("homtht", 0x223B);
		Entity("hookleftarrow", 0x21A9);
		Entity("hookrightarrow", 0x21AA);
		Entity("hopf", 0x1D559);
		Entity("Hopf", 0x210D);
		Entity("horbar", 0x2015);
		Entity("HorizontalLine", 0x2500);
		Entity("hscr", 0x1D4BD);
		Entity("Hscr", 0x210B);
		Entity("hslash", 0x210F);
		Entity("hstrok", 0x0127);
		Entity("Hstrok", 0x0126);
		Entity("HumpDownHump", 0x224E);
		Entity("HumpEqual", 0x224F);
		Entity("hybull", 0x2043);
		Entity("hyphen", 0x2010);
		Entity("iacgr", 0x03AF);
		Entity("Iacgr", 0x038A);
		Entity("iacute", 0x00ED);
		Entity("Iacute", 0x00CD);
		Entity("ic", 0x2063);
		Entity("icirc", 0x00EE);
		Entity("Icirc", 0x00CE);
		Entity("icy", 0x0438);
		Entity("Icy", 0x0418);
		Entity("idiagr", 0x0390);
		Entity("idigr", 0x03CA);
		Entity("Idigr", 0x03AA);
		Entity("Idot", 0x0130);
		Entity("iecy", 0x0435);
		Entity("IEcy", 0x0415);
		Entity("iexcl", 0x00A1);
		Entity("iff", 0x21D4);
		Entity("ifr", 0x1D526);
		Entity("Ifr", 0x2111);
		Entity("igr", 0x03B9);
		Entity("Igr", 0x0399);
		Entity("igrave", 0x00EC);
		Entity("Igrave", 0x00CC);
		Entity("ii", 0x2148);
		Entity("iiiint", 0x2A0C);
		Entity("iiint", 0x222D);
		Entity("iinfin", 0x29DC);
		Entity("iiota", 0x2129);
		Entity("ijlig", 0x0133);
		Entity("IJlig", 0x0132);
		Entity("Im", 0x2111);
		Entity("imacr", 0x012B);
		Entity("Imacr", 0x012A);
		Entity("image", 0x2111);
		Entity("ImaginaryI", 0x2148);
		Entity("imagline", 0x2110);
		Entity("imagpart", 0x2111);
		Entity("imath", 0x0131);
		Entity("imof", 0x22B7);
		Entity("imped", 0x01B5);
		Entity("Implies", 0x21D2);
		Entity("in", 0x2208);
		Entity("incare", 0x2105);
		Entity("infin", 0x221E);
		Entity("infintie", 0x29DD);
		Entity("inodot", 0x0131);
		Entity("int", 0x222B);
		Entity("Int", 0x222C);
		Entity("intcal", 0x22BA);
		Entity("integers", 0x2124);
		Entity("Integral", 0x222B);
		Entity("intercal", 0x22BA);
		Entity("Intersection", 0x22C2);
		Entity("intlarhk", 0x2A17);
		Entity("intprod", 0x2A3C);
		Entity("InvisibleComma", 0x2063);
		Entity("InvisibleTimes", 0x2062);
		Entity("iocy", 0x0451);
		Entity("IOcy", 0x0401);
		Entity("iogon", 0x012F);
		Entity("Iogon", 0x012E);
		Entity("iopf", 0x1D55A);
		Entity("Iopf", 0x1D540);
		Entity("iota", 0x03B9);
		Entity("Iota", 0x0399);
		Entity("iprod", 0x2A3C);
		Entity("iquest", 0x00BF);
		Entity("iscr", 0x1D4BE);
		Entity("Iscr", 0x2110);
		Entity("isin", 0x2208);
		Entity("isindot", 0x22F5);
		Entity("isinE", 0x22F9);
		Entity("isins", 0x22F4);
		Entity("isinsv", 0x22F3);
		Entity("isinv", 0x2208);
		Entity("it", 0x2062);
		Entity("itilde", 0x0129);
		Entity("Itilde", 0x0128);
		Entity("iukcy", 0x0456);
		Entity("Iukcy", 0x0406);
		Entity("iuml", 0x00EF);
		Entity("Iuml", 0x00CF);
		Entity("jcirc", 0x0135);
		Entity("Jcirc", 0x0134);
		Entity("jcy", 0x0439);
		Entity("Jcy", 0x0419);
		Entity("jfr", 0x1D527);
		Entity("Jfr", 0x1D50D);
		Entity("jmath", 0x0237);
		Entity("jopf", 0x1D55B);
		Entity("Jopf", 0x1D541);
		Entity("jscr", 0x1D4BF);
		Entity("Jscr", 0x1D4A5);
		Entity("jsercy", 0x0458);
		Entity("Jsercy", 0x0408);
		Entity("jukcy", 0x0454);
		Entity("Jukcy", 0x0404);
		Entity("kappa", 0x03BA);
		Entity("Kappa", 0x039A);
		Entity("kappav", 0x03F0);
		Entity("kcedil", 0x0137);
		Entity("Kcedil", 0x0136);
		Entity("kcy", 0x043A);
		Entity("Kcy", 0x041A);
		Entity("kfr", 0x1D528);
		Entity("Kfr", 0x1D50E);
		Entity("kgr", 0x03BA);
		Entity("Kgr", 0x039A);
		Entity("kgreen", 0x0138);
		Entity("khcy", 0x0445);
		Entity("KHcy", 0x0425);
		Entity("khgr", 0x03C7);
		Entity("KHgr", 0x03A7);
		Entity("kjcy", 0x045C);
		Entity("KJcy", 0x040C);
		Entity("kopf", 0x1D55C);
		Entity("Kopf", 0x1D542);
		Entity("kscr", 0x1D4C0);
		Entity("Kscr", 0x1D4A6);
		Entity("lAarr", 0x21DA);
		Entity("lacute", 0x013A);
		Entity("Lacute", 0x0139);
		Entity("laemptyv", 0x29B4);
		Entity("lagran", 0x2112);
		Entity("lambda", 0x03BB);
		Entity("Lambda", 0x039B);
		Entity("lang", 0x2329);
		Entity("Lang", 0x27EA);
		Entity("langd", 0x2991);
		Entity("langle", 0x2329);
		Entity("lap", 0x2A85);
		Entity("Laplacetrf", 0x2112);
		Entity("laquo", 0x00AB);
		Entity("larr", 0x2190);
		Entity("lArr", 0x21D0);
		Entity("Larr", 0x219E);
		Entity("larrb", 0x21E4);
		Entity("larrbfs", 0x291F);
		Entity("larrfs", 0x291D);
		Entity("larrhk", 0x21A9);
		Entity("larrlp", 0x21AB);
		Entity("larrpl", 0x2939);
		Entity("larrsim", 0x2973);
		Entity("larrtl", 0x21A2);
		Entity("lat", 0x2AAB);
		Entity("latail", 0x2919);
		Entity("lAtail", 0x291B);
		Entity("late", 0x2AAD);
		Entity("lbarr", 0x290C);
		Entity("lBarr", 0x290E);
		Entity("lbbrk", 0x2997);
		Entity("lbrace", 0x007B);
		Entity("lbrack", 0x005B);
		Entity("lbrke", 0x298B);
		Entity("lbrksld", 0x298F);
		Entity("lbrkslu", 0x298D);
		Entity("lcaron", 0x013E);
		Entity("Lcaron", 0x013D);
		Entity("lcedil", 0x013C);
		Entity("Lcedil", 0x013B);
		Entity("lceil", 0x2308);
		Entity("lcub", 0x007B);
		Entity("lcy", 0x043B);
		Entity("Lcy", 0x041B);
		Entity("ldca", 0x2936);
		Entity("ldquo", 0x201C);
		Entity("ldquor", 0x201E);
		Entity("ldrdhar", 0x2967);
		Entity("ldrushar", 0x294B);
		Entity("ldsh", 0x21B2);
		Entity("le", 0x2264);
		Entity("lE", 0x2266);
		Entity("LeftAngleBracket", 0x2329);
		Entity("leftarrow", 0x2190);
		Entity("Leftarrow", 0x21D0);
		Entity("LeftArrowBar", 0x21E4);
		Entity("LeftArrowRightArrow", 0x21C6);
		Entity("leftarrowtail", 0x21A2);
		Entity("LeftCeiling", 0x2308);
		Entity("LeftDoubleBracket", 0x27E6);
		Entity("LeftDownTeeVector", 0x2961);
		Entity("LeftDownVector", 0x21C3);
		Entity("LeftDownVectorBar", 0x2959);
		Entity("LeftFloor", 0x230A);
		Entity("leftharpoondown", 0x21BD);
		Entity("leftharpoonup", 0x21BC);
		Entity("leftleftarrows", 0x21C7);
		Entity("leftrightarrow", 0x2194);
		Entity("Leftrightarrow", 0x21D4);
		Entity("leftrightarrows", 0x21C6);
		Entity("leftrightharpoons", 0x21CB);
		Entity("leftrightsquigarrow", 0x21AD);
		Entity("LeftRightVector", 0x294E);
		Entity("LeftTee", 0x22A3);
		Entity("LeftTeeArrow", 0x21A4);
		Entity("LeftTeeVector", 0x295A);
		Entity("leftthreetimes", 0x22CB);
		Entity("LeftTriangle", 0x22B2);
		Entity("LeftTriangleBar", 0x29CF);
		Entity("LeftTriangleEqual", 0x22B4);
		Entity("LeftUpDownVector", 0x2951);
		Entity("LeftUpTeeVector", 0x2960);
		Entity("LeftUpVector", 0x21BF);
		Entity("LeftUpVectorBar", 0x2958);
		Entity("LeftVector", 0x21BC);
		Entity("LeftVectorBar", 0x2952);
		Entity("leg", 0x22DA);
		Entity("lEg", 0x2A8B);
		Entity("leq", 0x2264);
		Entity("leqq", 0x2266);
		Entity("leqslant", 0x2A7D);
		Entity("les", 0x2A7D);
		Entity("lescc", 0x2AA8);
		Entity("lesdot", 0x2A7F);
		Entity("lesdoto", 0x2A81);
		Entity("lesdotor", 0x2A83);
		Entity("lesges", 0x2A93);
		Entity("lessapprox", 0x2A85);
		Entity("lessdot", 0x22D6);
		Entity("lesseqgtr", 0x22DA);
		Entity("lesseqqgtr", 0x2A8B);
		Entity("LessEqualGreater", 0x22DA);
		Entity("LessFullEqual", 0x2266);
		Entity("LessGreater", 0x2276);
		Entity("lessgtr", 0x2276);
		Entity("LessLess", 0x2AA1);
		Entity("lesssim", 0x2272);
		Entity("LessSlantEqual", 0x2A7D);
		Entity("LessTilde", 0x2272);
		Entity("lfisht", 0x297C);
		Entity("lfloor", 0x230A);
		Entity("lfr", 0x1D529);
		Entity("Lfr", 0x1D50F);
		Entity("lg", 0x2276);
		Entity("lgE", 0x2A91);
		Entity("lgr", 0x03BB);
		Entity("Lgr", 0x039B);
		Entity("lHar", 0x2962);
		Entity("lhard", 0x21BD);
		Entity("lharu", 0x21BC);
		Entity("lharul", 0x296A);
		Entity("lhblk", 0x2584);
		Entity("ljcy", 0x0459);
		Entity("LJcy", 0x0409);
		Entity("ll", 0x226A);
		Entity("Ll", 0x22D8);
		Entity("llarr", 0x21C7);
		Entity("llcorner", 0x231E);
		Entity("Lleftarrow", 0x21DA);
		Entity("llhard", 0x296B);
		Entity("lltri", 0x25FA);
		Entity("lmidot", 0x0140);
		Entity("Lmidot", 0x013F);
		Entity("lmoust", 0x23B0);
		Entity("lmoustache", 0x23B0);
		Entity("lnap", 0x2A89);
		Entity("lnapprox", 0x2A89);
		Entity("lne", 0x2A87);
		Entity("lnE", 0x2268);
		Entity("lneq", 0x2A87);
		Entity("lneqq", 0x2268);
		Entity("lnsim", 0x22E6);
		Entity("loang", 0x27EC);
		Entity("loarr", 0x21FD);
		Entity("lobrk", 0x27E6);
		Entity("longleftarrow", 0x27F5);
		Entity("Longleftarrow", 0x27F8);
		Entity("longleftrightarrow", 0x27F7);
		Entity("Longleftrightarrow", 0x27FA);
		Entity("longmapsto", 0x27FC);
		Entity("longrightarrow", 0x27F6);
		Entity("Longrightarrow", 0x27F9);
		Entity("looparrowleft", 0x21AB);
		Entity("looparrowright", 0x21AC);
		Entity("lopar", 0x2985);
		Entity("lopf", 0x1D55D);
		Entity("Lopf", 0x1D543);
		Entity("loplus", 0x2A2D);
		Entity("lotimes", 0x2A34);
		Entity("lowast", 0x2217);
		Entity("lowbar", 0x005F);
		Entity("LowerLeftArrow", 0x2199);
		Entity("LowerRightArrow", 0x2198);
		Entity("loz", 0x25CA);
		Entity("lozenge", 0x25CA);
		Entity("lozf", 0x29EB);
		Entity("lpar", 0x0028);
		Entity("lparlt", 0x2993);
		Entity("lrarr", 0x21C6);
		Entity("lrcorner", 0x231F);
		Entity("lrhar", 0x21CB);
		Entity("lrhard", 0x296D);
		Entity("lrm", 0x200E);
		Entity("lrtri", 0x22BF);
		Entity("lsaquo", 0x2039);
		Entity("lscr", 0x1D4C1);
		Entity("Lscr", 0x2112);
		Entity("lsh", 0x21B0);
		Entity("lsim", 0x2272);
		Entity("lsime", 0x2A8D);
		Entity("lsimg", 0x2A8F);
		Entity("lsqb", 0x005B);
		Entity("lsquo", 0x2018);
		Entity("lsquor", 0x201A);
		Entity("lstrok", 0x0142);
		Entity("Lstrok", 0x0141);
		Entity("lt", 0x003C);
		Entity("Lt", 0x226A);
		Entity("ltcc", 0x2AA6);
		Entity("ltcir", 0x2A79);
		Entity("ltdot", 0x22D6);
		Entity("lthree", 0x22CB);
		Entity("ltimes", 0x22C9);
		Entity("ltlarr", 0x2976);
		Entity("ltquest", 0x2A7B);
		Entity("ltri", 0x25C3);
		Entity("ltrie", 0x22B4);
		Entity("ltrif", 0x25C2);
		Entity("ltrPar", 0x2996);
		Entity("lurdshar", 0x294A);
		Entity("luruhar", 0x2966);
		Entity("macr", 0x00AF);
		Entity("male", 0x2642);
		Entity("malt", 0x2720);
		Entity("maltese", 0x2720);
		Entity("map", 0x21A6);
		Entity("Map", 0x2905);
		Entity("mapsto", 0x21A6);
		Entity("mapstodown", 0x21A7);
		Entity("mapstoleft", 0x21A4);
		Entity("mapstoup", 0x21A5);
		Entity("marker", 0x25AE);
		Entity("mcomma", 0x2A29);
		Entity("mcy", 0x043C);
		Entity("Mcy", 0x041C);
		Entity("mdash", 0x2014);
		Entity("mDDot", 0x223A);
		Entity("measuredangle", 0x2221);
		Entity("MediumSpace", 0x205F);
		Entity("Mellintrf", 0x2133);
		Entity("mfr", 0x1D52A);
		Entity("Mfr", 0x1D510);
		Entity("mgr", 0x03BC);
		Entity("Mgr", 0x039C);
		Entity("mho", 0x2127);
		Entity("micro", 0x00B5);
		Entity("mid", 0x2223);
		Entity("midast", 0x002A);
		Entity("midcir", 0x2AF0);
		Entity("middot", 0x00B7);
		Entity("minus", 0x2212);
		Entity("minusb", 0x229F);
		Entity("minusd", 0x2238);
		Entity("minusdu", 0x2A2A);
		Entity("MinusPlus", 0x2213);
		Entity("mlcp", 0x2ADB);
		Entity("mldr", 0x2026);
		Entity("mnplus", 0x2213);
		Entity("models", 0x22A7);
		Entity("mopf", 0x1D55E);
		Entity("Mopf", 0x1D544);
		Entity("mp", 0x2213);
		Entity("mscr", 0x1D4C2);
		Entity("Mscr", 0x2133);
		Entity("mstpos", 0x223E);
		Entity("mu", 0x03BC);
		Entity("Mu", 0x039C);
		Entity("multimap", 0x22B8);
		Entity("mumap", 0x22B8);
		Entity("nabla", 0x2207);
		Entity("nacute", 0x0144);
		Entity("Nacute", 0x0143);
		Entity("nap", 0x2249);
		Entity("napos", 0x0149);
		Entity("napprox", 0x2249);
		Entity("natur", 0x266E);
		Entity("natural", 0x266E);
		Entity("naturals", 0x2115);
		Entity("nbsp", 0x00A0);
		Entity("ncap", 0x2A43);
		Entity("ncaron", 0x0148);
		Entity("Ncaron", 0x0147);
		Entity("ncedil", 0x0146);
		Entity("Ncedil", 0x0145);
		Entity("ncong", 0x2247);
		Entity("ncup", 0x2A42);
		Entity("ncy", 0x043D);
		Entity("Ncy", 0x041D);
		Entity("ndash", 0x2013);
		Entity("ne", 0x2260);
		Entity("nearhk", 0x2924);
		Entity("nearr", 0x2197);
		Entity("neArr", 0x21D7);
		Entity("nearrow", 0x2197);
		Entity("NegativeMediumSpace", 0x200B);
		Entity("NegativeThickSpace", 0x200B);
		Entity("NegativeThinSpace", 0x200B);
		Entity("NegativeVeryThinSpace", 0x200B);
		Entity("nequiv", 0x2262);
		Entity("nesear", 0x2928);
		Entity("NestedGreaterGreater", 0x226B);
		Entity("NestedLessLess", 0x226A);
		Entity("NewLine", 0x000A);
		Entity("nexist", 0x2204);
		Entity("nexists", 0x2204);
		Entity("nfr", 0x1D52B);
		Entity("Nfr", 0x1D511);
		Entity("nge", 0x2271);
		Entity("ngeq", 0x2271);
		Entity("ngr", 0x03BD);
		Entity("Ngr", 0x039D);
		Entity("ngsim", 0x2275);
		Entity("ngt", 0x226F);
		Entity("ngtr", 0x226F);
		Entity("nharr", 0x21AE);
		Entity("nhArr", 0x21CE);
		Entity("nhpar", 0x2AF2);
		Entity("ni", 0x220B);
		Entity("nis", 0x22FC);
		Entity("nisd", 0x22FA);
		Entity("niv", 0x220B);
		Entity("njcy", 0x045A);
		Entity("NJcy", 0x040A);
		Entity("nlarr", 0x219A);
		Entity("nlArr", 0x21CD);
		Entity("nldr", 0x2025);
		Entity("nle", 0x2270);
		Entity("nleftarrow", 0x219A);
		Entity("nLeftarrow", 0x21CD);
		Entity("nleftrightarrow", 0x21AE);
		Entity("nLeftrightarrow", 0x21CE);
		Entity("nleq", 0x2270);
		Entity("nless", 0x226E);
		Entity("nlsim", 0x2274);
		Entity("nlt", 0x226E);
		Entity("nltri", 0x22EA);
		Entity("nltrie", 0x22EC);
		Entity("nmid", 0x2224);
		Entity("NoBreak", 0x2060);
		Entity("NonBreakingSpace", 0x00A0);
		Entity("nopf", 0x1D55F);
		Entity("Nopf", 0x2115);
		Entity("not", 0x00AC);
		Entity("Not", 0x2AEC);
		Entity("NotCongruent", 0x2262);
		Entity("NotCupCap", 0x226D);
		Entity("NotDoubleVerticalBar", 0x2226);
		Entity("NotElement", 0x2209);
		Entity("NotEqual", 0x2260);
		Entity("NotExists", 0x2204);
		Entity("NotGreater", 0x226F);
		Entity("NotGreaterEqual", 0x2271);
		Entity("NotGreaterLess", 0x2279);
		Entity("NotGreaterTilde", 0x2275);
		Entity("notin", 0x2209);
		Entity("notinva", 0x2209);
		Entity("notinvb", 0x22F7);
		Entity("notinvc", 0x22F6);
		Entity("NotLeftTriangle", 0x22EA);
		Entity("NotLeftTriangleEqual", 0x22EC);
		Entity("NotLess", 0x226E);
		Entity("NotLessEqual", 0x2270);
		Entity("NotLessGreater", 0x2278);
		Entity("NotLessTilde", 0x2274);
		Entity("notni", 0x220C);
		Entity("notniva", 0x220C);
		Entity("notnivb", 0x22FE);
		Entity("notnivc", 0x22FD);
		Entity("NotPrecedes", 0x2280);
		Entity("NotPrecedesSlantEqual", 0x22E0);
		Entity("NotReverseElement", 0x220C);
		Entity("NotRightTriangle", 0x22EB);
		Entity("NotRightTriangleEqual", 0x22ED);
		Entity("NotSquareSubsetEqual", 0x22E2);
		Entity("NotSquareSupersetEqual", 0x22E3);
		Entity("NotSubsetEqual", 0x2288);
		Entity("NotSucceeds", 0x2281);
		Entity("NotSucceedsSlantEqual", 0x22E1);
		Entity("NotSupersetEqual", 0x2289);
		Entity("NotTilde", 0x2241);
		Entity("NotTildeEqual", 0x2244);
		Entity("NotTildeFullEqual", 0x2247);
		Entity("NotTildeTilde", 0x2249);
		Entity("NotVerticalBar", 0x2224);
		Entity("npar", 0x2226);
		Entity("nparallel", 0x2226);
		Entity("npolint", 0x2A14);
		Entity("npr", 0x2280);
		Entity("nprcue", 0x22E0);
		Entity("nprec", 0x2280);
		Entity("nrarr", 0x219B);
		Entity("nrArr", 0x21CF);
		Entity("nrightarrow", 0x219B);
		Entity("nRightarrow", 0x21CF);
		Entity("nrtri", 0x22EB);
		Entity("nrtrie", 0x22ED);
		Entity("nsc", 0x2281);
		Entity("nsccue", 0x22E1);
		Entity("nscr", 0x1D4C3);
		Entity("Nscr", 0x1D4A9);
		Entity("nshortmid", 0x2224);
		Entity("nshortparallel", 0x2226);
		Entity("nsim", 0x2241);
		Entity("nsime", 0x2244);
		Entity("nsimeq", 0x2244);
		Entity("nsmid", 0x2224);
		Entity("nspar", 0x2226);
		Entity("nsqsube", 0x22E2);
		Entity("nsqsupe", 0x22E3);
		Entity("nsub", 0x2284);
		Entity("nsube", 0x2288);
		Entity("nsubseteq", 0x2288);
		Entity("nsucc", 0x2281);
		Entity("nsup", 0x2285);
		Entity("nsupe", 0x2289);
		Entity("nsupseteq", 0x2289);
		Entity("ntgl", 0x2279);
		Entity("ntilde", 0x00F1);
		Entity("Ntilde", 0x00D1);
		Entity("ntlg", 0x2278);
		Entity("ntriangleleft", 0x22EA);
		Entity("ntrianglelefteq", 0x22EC);
		Entity("ntriangleright", 0x22EB);
		Entity("ntrianglerighteq", 0x22ED);
		Entity("nu", 0x03BD);
		Entity("Nu", 0x039D);
		Entity("num", 0x0023);
		Entity("numero", 0x2116);
		Entity("numsp", 0x2007);
		Entity("nvdash", 0x22AC);
		Entity("nvDash", 0x22AD);
		Entity("nVdash", 0x22AE);
		Entity("nVDash", 0x22AF);
		Entity("nvHarr", 0x2904);
		Entity("nvinfin", 0x29DE);
		Entity("nvlArr", 0x2902);
		Entity("nvrArr", 0x2903);
		Entity("nwarhk", 0x2923);
		Entity("nwarr", 0x2196);
		Entity("nwArr", 0x21D6);
		Entity("nwarrow", 0x2196);
		Entity("nwnear", 0x2927);
		Entity("oacgr", 0x03CC);
		Entity("Oacgr", 0x038C);
		Entity("oacute", 0x00F3);
		Entity("Oacute", 0x00D3);
		Entity("oast", 0x229B);
		Entity("ocir", 0x229A);
		Entity("ocirc", 0x00F4);
		Entity("Ocirc", 0x00D4);
		Entity("ocy", 0x043E);
		Entity("Ocy", 0x041E);
		Entity("odash", 0x229D);
		Entity("odblac", 0x0151);
		Entity("Odblac", 0x0150);
		Entity("odiv", 0x2A38);
		Entity("odot", 0x2299);
		Entity("odsold", 0x29BC);
		Entity("oelig", 0x0153);
		Entity("OElig", 0x0152);
		Entity("ofcir", 0x29BF);
		Entity("ofr", 0x1D52C);
		Entity("Ofr", 0x1D512);
		Entity("ogon", 0x02DB);
		Entity("ogr", 0x03BF);
		Entity("Ogr", 0x039F);
		Entity("ograve", 0x00F2);
		Entity("Ograve", 0x00D2);
		Entity("ogt", 0x29C1);
		Entity("ohacgr", 0x03CE);
		Entity("OHacgr", 0x038F);
		Entity("ohbar", 0x29B5);
		Entity("ohgr", 0x03C9);
		Entity("OHgr", 0x03A9);
		Entity("ohm", 0x2126);
		Entity("oint", 0x222E);
		Entity("olarr", 0x21BA);
		Entity("olcir", 0x29BE);
		Entity("olcross", 0x29BB);
		Entity("oline", 0x203E);
		Entity("olt", 0x29C0);
		Entity("omacr", 0x014D);
		Entity("Omacr", 0x014C);
		Entity("omega", 0x03C9);
		Entity("Omega", 0x03A9);
		Entity("omicron", 0x03BF);
		Entity("Omicron", 0x039F);
		Entity("omid", 0x29B6);
		Entity("ominus", 0x2296);
		Entity("oopf", 0x1D560);
		Entity("Oopf", 0x1D546);
		Entity("opar", 0x29B7);
		Entity("OpenCurlyDoubleQuote", 0x201C);
		Entity("OpenCurlyQuote", 0x2018);
		Entity("operp", 0x29B9);
		Entity("oplus", 0x2295);
		Entity("or", 0x2228);
		Entity("Or", 0x2A54);
		Entity("orarr", 0x21BB);
		Entity("ord", 0x2A5D);
		Entity("order", 0x2134);
		Entity("orderof", 0x2134);
		Entity("ordf", 0x00AA);
		Entity("ordm", 0x00BA);
		Entity("origof", 0x22B6);
		Entity("oror", 0x2A56);
		Entity("orslope", 0x2A57);
		Entity("orv", 0x2A5B);
		Entity("oS", 0x24C8);
		Entity("oscr", 0x2134);
		Entity("Oscr", 0x1D4AA);
		Entity("oslash", 0x00F8);
		Entity("Oslash", 0x00D8);
		Entity("osol", 0x2298);
		Entity("otilde", 0x00F5);
		Entity("Otilde", 0x00D5);
		Entity("otimes", 0x2297);
		Entity("Otimes", 0x2A37);
		Entity("otimesas", 0x2A36);
		Entity("ouml", 0x00F6);
		Entity("Ouml", 0x00D6);
		Entity("ovbar", 0x233D);
		Entity("OverBar", 0x00AF);
		Entity("OverBrace", 0xFE37);
		Entity("OverBracket", 0x23B4);
		Entity("OverParenthesis", 0xFE35);
		Entity("par", 0x2225);
		Entity("para", 0x00B6);
		Entity("parallel", 0x2225);
		Entity("parsim", 0x2AF3);
		Entity("parsl", 0x2AFD);
		Entity("part", 0x2202);
		Entity("PartialD", 0x2202);
		Entity("pcy", 0x043F);
		Entity("Pcy", 0x041F);
		Entity("percnt", 0x0025);
		Entity("period", 0x002E);
		Entity("permil", 0x2030);
		Entity("perp", 0x22A5);
		Entity("pertenk", 0x2031);
		Entity("pfr", 0x1D52D);
		Entity("Pfr", 0x1D513);
		Entity("pgr", 0x03C0);
		Entity("Pgr", 0x03A0);
		Entity("phgr", 0x03C6);
		Entity("PHgr", 0x03A6);
		Entity("phi", 0x03D5);
		Entity("Phi", 0x03A6);
		Entity("phiv", 0x03C6);
		Entity("phmmat", 0x2133);
		Entity("phone", 0x260E);
		Entity("pi", 0x03C0);
		Entity("Pi", 0x03A0);
		Entity("pitchfork", 0x22D4);
		Entity("piv", 0x03D6);
		Entity("planck", 0x210F);
		Entity("planckh", 0x210E);
		Entity("plankv", 0x210F);
		Entity("plus", 0x002B);
		Entity("plusacir", 0x2A23);
		Entity("plusb", 0x229E);
		Entity("pluscir", 0x2A22);
		Entity("plusdo", 0x2214);
		Entity("plusdu", 0x2A25);
		Entity("pluse", 0x2A72);
		Entity("PlusMinus", 0x00B1);
		Entity("plusmn", 0x00B1);
		Entity("plussim", 0x2A26);
		Entity("plustwo", 0x2A27);
		Entity("pm", 0x00B1);
		Entity("Poincareplane", 0x210C);
		Entity("pointint", 0x2A15);
		Entity("popf", 0x1D561);
		Entity("Popf", 0x2119);
		Entity("pound", 0x00A3);
		Entity("pr", 0x227A);
		Entity("Pr", 0x2ABB);
		Entity("prap", 0x2AB7);
		Entity("prcue", 0x227C);
		Entity("pre", 0x2AAF);
		Entity("prE", 0x2AB3);
		Entity("prec", 0x227A);
		Entity("precapprox", 0x2AB7);
		Entity("preccurlyeq", 0x227C);
		Entity("Precedes", 0x227A);
		Entity("PrecedesEqual", 0x2AAF);
		Entity("PrecedesSlantEqual", 0x227C);
		Entity("PrecedesTilde", 0x227E);
		Entity("preceq", 0x2AAF);
		Entity("precnapprox", 0x2AB9);
		Entity("precneqq", 0x2AB5);
		Entity("precnsim", 0x22E8);
		Entity("precsim", 0x227E);
		Entity("prime", 0x2032);
		Entity("Prime", 0x2033);
		Entity("primes", 0x2119);
		Entity("prnap", 0x2AB9);
		Entity("prnE", 0x2AB5);
		Entity("prnsim", 0x22E8);
		Entity("prod", 0x220F);
		Entity("Product", 0x220F);
		Entity("profalar", 0x232E);
		Entity("profline", 0x2312);
		Entity("profsurf", 0x2313);
		Entity("prop", 0x221D);
		Entity("Proportion", 0x2237);
		Entity("Proportional", 0x221D);
		Entity("propto", 0x221D);
		Entity("prsim", 0x227E);
		Entity("prurel", 0x22B0);
		Entity("pscr", 0x1D4C5);
		Entity("Pscr", 0x1D4AB);
		Entity("psgr", 0x03C8);
		Entity("PSgr", 0x03A8);
		Entity("psi", 0x03C8);
		Entity("Psi", 0x03A8);
		Entity("puncsp", 0x2008);
		Entity("qfr", 0x1D52E);
		Entity("Qfr", 0x1D514);
		Entity("qint", 0x2A0C);
		Entity("qopf", 0x1D562);
		Entity("Qopf", 0x211A);
		Entity("qprime", 0x2057);
		Entity("qscr", 0x1D4C6);
		Entity("Qscr", 0x1D4AC);
		Entity("quaternions", 0x210D);
		Entity("quatint", 0x2A16);
		Entity("quest", 0x003F);
		Entity("questeq", 0x225F);
		Entity("quot", 0x0022);
		Entity("rAarr", 0x21DB);
		Entity("race", 0x29DA);
		Entity("racute", 0x0155);
		Entity("Racute", 0x0154);
		Entity("radic", 0x221A);
		Entity("raemptyv", 0x29B3);
		Entity("rang", 0x232A);
		Entity("Rang", 0x27EB);
		Entity("rangd", 0x2992);
		Entity("range", 0x29A5);
		Entity("rangle", 0x232A);
		Entity("raquo", 0x00BB);
		Entity("rarr", 0x2192);
		Entity("rArr", 0x21D2);
		Entity("Rarr", 0x21A0);
		Entity("rarrap", 0x2975);
		Entity("rarrb", 0x21E5);
		Entity("rarrbfs", 0x2920);
		Entity("rarrc", 0x2933);
		Entity("rarrfs", 0x291E);
		Entity("rarrhk", 0x21AA);
		Entity("rarrlp", 0x21AC);
		Entity("rarrpl", 0x2945);
		Entity("rarrsim", 0x2974);
		Entity("rarrtl", 0x21A3);
		Entity("Rarrtl", 0x2916);
		Entity("rarrw", 0x219D);
		Entity("ratail", 0x291A);
		Entity("rAtail", 0x291C);
		Entity("ratio", 0x2236);
		Entity("rationals", 0x211A);
		Entity("rbarr", 0x290D);
		Entity("rBarr", 0x290F);
		Entity("RBarr", 0x2910);
		Entity("rbbrk", 0x2998);
		Entity("rbrace", 0x007D);
		Entity("rbrack", 0x005D);
		Entity("rbrke", 0x298C);
		Entity("rbrksld", 0x298E);
		Entity("rbrkslu", 0x2990);
		Entity("rcaron", 0x0159);
		Entity("Rcaron", 0x0158);
		Entity("rcedil", 0x0157);
		Entity("Rcedil", 0x0156);
		Entity("rceil", 0x2309);
		Entity("rcub", 0x007D);
		Entity("rcy", 0x0440);
		Entity("Rcy", 0x0420);
		Entity("rdca", 0x2937);
		Entity("rdldhar", 0x2969);
		Entity("rdquo", 0x201D);
		Entity("rdquor", 0x201D);
		Entity("rdsh", 0x21B3);
		Entity("Re", 0x211C);
		Entity("real", 0x211C);
		Entity("realine", 0x211B);
		Entity("realpart", 0x211C);
		Entity("reals", 0x211D);
		Entity("rect", 0x25AD);
		Entity("reg", 0x00AE);
		Entity("ReverseElement", 0x220B);
		Entity("ReverseEquilibrium", 0x21CB);
		Entity("ReverseUpEquilibrium", 0x296F);
		Entity("rfisht", 0x297D);
		Entity("rfloor", 0x230B);
		Entity("rfr", 0x1D52F);
		Entity("Rfr", 0x211C);
		Entity("rgr", 0x03C1);
		Entity("Rgr", 0x03A1);
		Entity("rHar", 0x2964);
		Entity("rhard", 0x21C1);
		Entity("rharu", 0x21C0);
		Entity("rharul", 0x296C);
		Entity("rho", 0x03C1);
		Entity("Rho", 0x03A1);
		Entity("rhov", 0x03F1);
		Entity("RightAngleBracket", 0x232A);
		Entity("rightarrow", 0x2192);
		Entity("Rightarrow", 0x21D2);
		Entity("RightArrowBar", 0x21E5);
		Entity("RightArrowLeftArrow", 0x21C4);
		Entity("rightarrowtail", 0x21A3);
		Entity("RightCeiling", 0x2309);
		Entity("RightDoubleBracket", 0x27E7);
		Entity("RightDownTeeVector", 0x295D);
		Entity("RightDownVector", 0x21C2);
		Entity("RightDownVectorBar", 0x2955);
		Entity("RightFloor", 0x230B);
		Entity("rightharpoondown", 0x21C1);
		Entity("rightharpoonup", 0x21C0);
		Entity("rightleftarrows", 0x21C4);
		Entity("rightleftharpoons", 0x21CC);
		Entity("rightrightarrows", 0x21C9);
		Entity("rightsquigarrow", 0x219D);
		Entity("RightTee", 0x22A2);
		Entity("RightTeeArrow", 0x21A6);
		Entity("RightTeeVector", 0x295B);
		Entity("rightthreetimes", 0x22CC);
		Entity("RightTriangle", 0x22B3);
		Entity("RightTriangleBar", 0x29D0);
		Entity("RightTriangleEqual", 0x22B5);
		Entity("RightUpDownVector", 0x294F);
		Entity("RightUpTeeVector", 0x295C);
		Entity("RightUpVector", 0x21BE);
		Entity("RightUpVectorBar", 0x2954);
		Entity("RightVector", 0x21C0);
		Entity("RightVectorBar", 0x2953);
		Entity("ring", 0x02DA);
		Entity("risingdotseq", 0x2253);
		Entity("rlarr", 0x21C4);
		Entity("rlhar", 0x21CC);
		Entity("rlm", 0x200F);
		Entity("rmoust", 0x23B1);
		Entity("rmoustache", 0x23B1);
		Entity("rnmid", 0x2AEE);
		Entity("roang", 0x27ED);
		Entity("roarr", 0x21FE);
		Entity("robrk", 0x27E7);
		Entity("ropar", 0x2986);
		Entity("ropf", 0x1D563);
		Entity("Ropf", 0x211D);
		Entity("roplus", 0x2A2E);
		Entity("rotimes", 0x2A35);
		Entity("RoundImplies", 0x2970);
		Entity("rpar", 0x0029);
		Entity("rpargt", 0x2994);
		Entity("rppolint", 0x2A12);
		Entity("rrarr", 0x21C9);
		Entity("Rrightarrow", 0x21DB);
		Entity("rsaquo", 0x203A);
		Entity("rscr", 0x1D4C7);
		Entity("Rscr", 0x211B);
		Entity("rsh", 0x21B1);
		Entity("rsqb", 0x005D);
		Entity("rsquo", 0x2019);
		Entity("rsquor", 0x2019);
		Entity("rthree", 0x22CC);
		Entity("rtimes", 0x22CA);
		Entity("rtri", 0x25B9);
		Entity("rtrie", 0x22B5);
		Entity("rtrif", 0x25B8);
		Entity("rtriltri", 0x29CE);
		Entity("RuleDelayed", 0x29F4);
		Entity("ruluhar", 0x2968);
		Entity("rx", 0x211E);
		Entity("sacute", 0x015B);
		Entity("Sacute", 0x015A);
		Entity("sbquo", 0x201A);
		Entity("sc", 0x227B);
		Entity("Sc", 0x2ABC);
		Entity("scap", 0x2AB8);
		Entity("scaron", 0x0161);
		Entity("Scaron", 0x0160);
		Entity("sccue", 0x227D);
		Entity("sce", 0x2AB0);
		Entity("scE", 0x2AB4);
		Entity("scedil", 0x015F);
		Entity("Scedil", 0x015E);
		Entity("scirc", 0x015D);
		Entity("Scirc", 0x015C);
		Entity("scnap", 0x2ABA);
		Entity("scnE", 0x2AB6);
		Entity("scnsim", 0x22E9);
		Entity("scpolint", 0x2A13);
		Entity("scsim", 0x227F);
		Entity("scy", 0x0441);
		Entity("Scy", 0x0421);
		Entity("sdot", 0x22C5);
		Entity("sdotb", 0x22A1);
		Entity("sdote", 0x2A66);
		Entity("searhk", 0x2925);
		Entity("searr", 0x2198);
		Entity("seArr", 0x21D8);
		Entity("searrow", 0x2198);
		Entity("sect", 0x00A7);
		Entity("semi", 0x003B);
		Entity("seswar", 0x2929);
		Entity("setminus", 0x2216);
		Entity("setmn", 0x2216);
		Entity("sext", 0x2736);
		Entity("sfgr", 0x03C2);
		Entity("sfr", 0x1D530);
		Entity("Sfr", 0x1D516);
		Entity("sfrown", 0x2322);
		Entity("sgr", 0x03C3);
		Entity("Sgr", 0x03A3);
		Entity("sharp", 0x266F);
		Entity("shchcy", 0x0449);
		Entity("SHCHcy", 0x0429);
		Entity("shcy", 0x0448);
		Entity("SHcy", 0x0428);
		Entity("ShortDownArrow", 0x2193);
		Entity("ShortLeftArrow", 0x2190);
		Entity("shortmid", 0x2223);
		Entity("shortparallel", 0x2225);
		Entity("ShortRightArrow", 0x2192);
		Entity("ShortUpArrow", 0x2191);
		Entity("shy", 0x00AD);
		Entity("sigma", 0x03C3);
		Entity("Sigma", 0x03A3);
		Entity("sigmaf", 0x03C2);
		Entity("sigmav", 0x03C2);
		Entity("sim", 0x223C);
		Entity("simdot", 0x2A6A);
		Entity("sime", 0x2243);
		Entity("simeq", 0x2243);
		Entity("simg", 0x2A9E);
		Entity("simgE", 0x2AA0);
		Entity("siml", 0x2A9D);
		Entity("simlE", 0x2A9F);
		Entity("simne", 0x2246);
		Entity("simplus", 0x2A24);
		Entity("simrarr", 0x2972);
		Entity("slarr", 0x2190);
		Entity("SmallCircle", 0x2218);
		Entity("smallsetminus", 0x2216);
		Entity("smashp", 0x2A33);
		Entity("smeparsl", 0x29E4);
		Entity("smid", 0x2223);
		Entity("smile", 0x2323);
		Entity("smt", 0x2AAA);
		Entity("smte", 0x2AAC);
		Entity("softcy", 0x044C);
		Entity("SOFTcy", 0x042C);
		Entity("sol", 0x002F);
		Entity("solb", 0x29C4);
		Entity("solbar", 0x233F);
		Entity("sopf", 0x1D564);
		Entity("Sopf", 0x1D54A);
		Entity("spades", 0x2660);
		Entity("spadesuit", 0x2660);
		Entity("spar", 0x2225);
		Entity("sqcap", 0x2293);
		Entity("sqcup", 0x2294);
		Entity("Sqrt", 0x221A);
		Entity("sqsub", 0x228F);
		Entity("sqsube", 0x2291);
		Entity("sqsubset", 0x228F);
		Entity("sqsubseteq", 0x2291);
		Entity("sqsup", 0x2290);
		Entity("sqsupe", 0x2292);
		Entity("sqsupset", 0x2290);
		Entity("sqsupseteq", 0x2292);
		Entity("squ", 0x25A1);
		Entity("square", 0x25A1);
		Entity("SquareIntersection", 0x2293);
		Entity("SquareSubset", 0x228F);
		Entity("SquareSubsetEqual", 0x2291);
		Entity("SquareSuperset", 0x2290);
		Entity("SquareSupersetEqual", 0x2292);
		Entity("SquareUnion", 0x2294);
		Entity("squarf", 0x25AA);
		Entity("squf", 0x25AA);
		Entity("srarr", 0x2192);
		Entity("sscr", 0x1D4C8);
		Entity("Sscr", 0x1D4AE);
		Entity("ssetmn", 0x2216);
		Entity("ssmile", 0x2323);
		Entity("sstarf", 0x22C6);
		Entity("star", 0x2606);
		Entity("Star", 0x22C6);
		Entity("starf", 0x2605);
		Entity("straightepsilon", 0x03F5);
		Entity("straightphi", 0x03D5);
		Entity("strns", 0x00AF);
		Entity("sub", 0x2282);
		Entity("Sub", 0x22D0);
		Entity("subdot", 0x2ABD);
		Entity("sube", 0x2286);
		Entity("subE", 0x2AC5);
		Entity("subedot", 0x2AC3);
		Entity("submult", 0x2AC1);
		Entity("subne", 0x228A);
		Entity("subnE", 0x2ACB);
		Entity("subplus", 0x2ABF);
		Entity("subrarr", 0x2979);
		Entity("subset", 0x2282);
		Entity("Subset", 0x22D0);
		Entity("subseteq", 0x2286);
		Entity("subseteqq", 0x2AC5);
		Entity("SubsetEqual", 0x2286);
		Entity("subsetneq", 0x228A);
		Entity("subsetneqq", 0x2ACB);
		Entity("subsim", 0x2AC7);
		Entity("subsub", 0x2AD5);
		Entity("subsup", 0x2AD3);
		Entity("succ", 0x227B);
		Entity("succapprox", 0x2AB8);
		Entity("succcurlyeq", 0x227D);
		Entity("Succeeds", 0x227B);
		Entity("SucceedsEqual", 0x2AB0);
		Entity("SucceedsSlantEqual", 0x227D);
		Entity("SucceedsTilde", 0x227F);
		Entity("succeq", 0x2AB0);
		Entity("succnapprox", 0x2ABA);
		Entity("succneqq", 0x2AB6);
		Entity("succnsim", 0x22E9);
		Entity("succsim", 0x227F);
		Entity("SuchThat", 0x220B);
		Entity("sum", 0x2211);
		Entity("sung", 0x266A);
		Entity("sup", 0x2283);
		Entity("Sup", 0x22D1);
		Entity("sup1", 0x00B9);
		Entity("sup2", 0x00B2);
		Entity("sup3", 0x00B3);
		Entity("supdot", 0x2ABE);
		Entity("supdsub", 0x2AD8);
		Entity("supe", 0x2287);
		Entity("supE", 0x2AC6);
		Entity("supedot", 0x2AC4);
		Entity("Superset", 0x2283);
		Entity("SupersetEqual", 0x2287);
		Entity("suphsub", 0x2AD7);
		Entity("suplarr", 0x297B);
		Entity("supmult", 0x2AC2);
		Entity("supne", 0x228B);
		Entity("supnE", 0x2ACC);
		Entity("supplus", 0x2AC0);
		Entity("supset", 0x2283);
		Entity("Supset", 0x22D1);
		Entity("supseteq", 0x2287);
		Entity("supseteqq", 0x2AC6);
		Entity("supsetneq", 0x228B);
		Entity("supsetneqq", 0x2ACC);
		Entity("supsim", 0x2AC8);
		Entity("supsub", 0x2AD4);
		Entity("supsup", 0x2AD6);
		Entity("swarhk", 0x2926);
		Entity("swarr", 0x2199);
		Entity("swArr", 0x21D9);
		Entity("swarrow", 0x2199);
		Entity("swnwar", 0x292A);
		Entity("szlig", 0x00DF);
		Entity("Tab", 0x0009);
		Entity("target", 0x2316);
		Entity("tau", 0x03C4);
		Entity("Tau", 0x03A4);
		Entity("tbrk", 0x23B4);
		Entity("tcaron", 0x0165);
		Entity("Tcaron", 0x0164);
		Entity("tcedil", 0x0163);
		Entity("Tcedil", 0x0162);
		Entity("tcy", 0x0442);
		Entity("Tcy", 0x0422);
		Entity("telrec", 0x2315);
		Entity("tfr", 0x1D531);
		Entity("Tfr", 0x1D517);
		Entity("tgr", 0x03C4);
		Entity("Tgr", 0x03A4);
		Entity("there4", 0x2234);
		Entity("therefore", 0x2234);
		Entity("theta", 0x03B8);
		Entity("Theta", 0x0398);
		Entity("thetasym", 0x03D1);
		Entity("thetav", 0x03D1);
		Entity("thgr", 0x03B8);
		Entity("THgr", 0x0398);
		Entity("thickapprox", 0x2248);
		Entity("thicksim", 0x223C);
		Entity("thinsp", 0x2009);
		Entity("ThinSpace", 0x2009);
		Entity("thkap", 0x2248);
		Entity("thksim", 0x223C);
		Entity("thorn", 0x00FE);
		Entity("THORN", 0x00DE);
		Entity("tilde", 0x02DC);
		Entity("Tilde", 0x223C);
		Entity("TildeEqual", 0x2243);
		Entity("TildeFullEqual", 0x2245);
		Entity("TildeTilde", 0x2248);
		Entity("times", 0x00D7);
		Entity("timesb", 0x22A0);
		Entity("timesbar", 0x2A31);
		Entity("timesd", 0x2A30);
		Entity("tint", 0x222D);
		Entity("toea", 0x2928);
		Entity("top", 0x22A4);
		Entity("topbot", 0x2336);
		Entity("topcir", 0x2AF1);
		Entity("topf", 0x1D565);
		Entity("Topf", 0x1D54B);
		Entity("topfork", 0x2ADA);
		Entity("tosa", 0x2929);
		Entity("tprime", 0x2034);
		Entity("trade", 0x2122);
		Entity("triangle", 0x25B5);
		Entity("triangledown", 0x25BF);
		Entity("triangleleft", 0x25C3);
		Entity("trianglelefteq", 0x22B4);
		Entity("triangleq", 0x225C);
		Entity("triangleright", 0x25B9);
		Entity("trianglerighteq", 0x22B5);
		Entity("tridot", 0x25EC);
		Entity("trie", 0x225C);
		Entity("triminus", 0x2A3A);
		Entity("triplus", 0x2A39);
		Entity("trisb", 0x29CD);
		Entity("tritime", 0x2A3B);
		Entity("trpezium", 0x23E2);
		Entity("tscr", 0x1D4C9);
		Entity("Tscr", 0x1D4AF);
		Entity("tscy", 0x0446);
		Entity("TScy", 0x0426);
		Entity("tshcy", 0x045B);
		Entity("TSHcy", 0x040B);
		Entity("tstrok", 0x0167);
		Entity("Tstrok", 0x0166);
		Entity("twixt", 0x226C);
		Entity("twoheadleftarrow", 0x219E);
		Entity("twoheadrightarrow", 0x21A0);
		Entity("uacgr", 0x03CD);
		Entity("Uacgr", 0x038E);
		Entity("uacute", 0x00FA);
		Entity("Uacute", 0x00DA);
		Entity("uarr", 0x2191);
		Entity("uArr", 0x21D1);
		Entity("Uarr", 0x219F);
		Entity("Uarrocir", 0x2949);
		Entity("ubrcy", 0x045E);
		Entity("Ubrcy", 0x040E);
		Entity("ubreve", 0x016D);
		Entity("Ubreve", 0x016C);
		Entity("ucirc", 0x00FB);
		Entity("Ucirc", 0x00DB);
		Entity("ucy", 0x0443);
		Entity("Ucy", 0x0423);
		Entity("udarr", 0x21C5);
		Entity("udblac", 0x0171);
		Entity("Udblac", 0x0170);
		Entity("udhar", 0x296E);
		Entity("udiagr", 0x03B0);
		Entity("udigr", 0x03CB);
		Entity("Udigr", 0x03AB);
		Entity("ufisht", 0x297E);
		Entity("ufr", 0x1D532);
		Entity("Ufr", 0x1D518);
		Entity("ugr", 0x03C5);
		Entity("Ugr", 0x03A5);
		Entity("ugrave", 0x00F9);
		Entity("Ugrave", 0x00D9);
		Entity("uHar", 0x2963);
		Entity("uharl", 0x21BF);
		Entity("uharr", 0x21BE);
		Entity("uhblk", 0x2580);
		Entity("ulcorn", 0x231C);
		Entity("ulcorner", 0x231C);
		Entity("ulcrop", 0x230F);
		Entity("ultri", 0x25F8);
		Entity("umacr", 0x016B);
		Entity("Umacr", 0x016A);
		Entity("uml", 0x00A8);
		Entity("UnderBrace", 0xFE38);
		Entity("UnderBracket", 0x23B5);
		Entity("UnderParenthesis", 0xFE36);
		Entity("Union", 0x22C3);
		Entity("UnionPlus", 0x228E);
		Entity("uogon", 0x0173);
		Entity("Uogon", 0x0172);
		Entity("uopf", 0x1D566);
		Entity("Uopf", 0x1D54C);
		Entity("uparrow", 0x2191);
		Entity("Uparrow", 0x21D1);
		Entity("UpArrowBar", 0x2912);
		Entity("UpArrowDownArrow", 0x21C5);
		Entity("updownarrow", 0x2195);
		Entity("Updownarrow", 0x21D5);
		Entity("UpEquilibrium", 0x296E);
		Entity("upharpoonleft", 0x21BF);
		Entity("upharpoonright", 0x21BE);
		Entity("uplus", 0x228E);
		Entity("UpperLeftArrow", 0x2196);
		Entity("UpperRightArrow", 0x2197);
		Entity("upsi", 0x03C5);
		Entity("Upsi", 0x03D2);
		Entity("upsih", 0x03D2);
		Entity("upsilon", 0x03C5);
		Entity("Upsilon", 0x03A5);
		Entity("UpTee", 0x22A5);
		Entity("UpTeeArrow", 0x21A5);
		Entity("upuparrows", 0x21C8);
		Entity("urcorn", 0x231D);
		Entity("urcorner", 0x231D);
		Entity("urcrop", 0x230E);
		Entity("uring", 0x016F);
		Entity("Uring", 0x016E);
		Entity("urtri", 0x25F9);
		Entity("uscr", 0x1D4CA);
		Entity("Uscr", 0x1D4B0);
		Entity("utdot", 0x22F0);
		Entity("utilde", 0x0169);
		Entity("Utilde", 0x0168);
		Entity("utri", 0x25B5);
		Entity("utrif", 0x25B4);
		Entity("uuarr", 0x21C8);
		Entity("uuml", 0x00FC);
		Entity("Uuml", 0x00DC);
		Entity("uwangle", 0x29A7);
		Entity("vangrt", 0x299C);
		Entity("varepsilon", 0x03B5);
		Entity("varkappa", 0x03F0);
		Entity("varnothing", 0x2205);
		Entity("varphi", 0x03C6);
		Entity("varpi", 0x03D6);
		Entity("varpropto", 0x221D);
		Entity("varr", 0x2195);
		Entity("vArr", 0x21D5);
		Entity("varrho", 0x03F1);
		Entity("varsigma", 0x03C2);
		Entity("vartheta", 0x03D1);
		Entity("vartriangleleft", 0x22B2);
		Entity("vartriangleright", 0x22B3);
		Entity("vBar", 0x2AE8);
		Entity("Vbar", 0x2AEB);
		Entity("vBarv", 0x2AE9);
		Entity("vcy", 0x0432);
		Entity("Vcy", 0x0412);
		Entity("vdash", 0x22A2);
		Entity("vDash", 0x22A8);
		Entity("Vdash", 0x22A9);
		Entity("VDash", 0x22AB);
		Entity("Vdashl", 0x2AE6);
		Entity("vee", 0x2228);
		Entity("Vee", 0x22C1);
		Entity("veebar", 0x22BB);
		Entity("veeeq", 0x225A);
		Entity("vellip", 0x22EE);
		Entity("verbar", 0x007C);
		Entity("Verbar", 0x2016);
		Entity("vert", 0x007C);
		Entity("Vert", 0x2016);
		Entity("VerticalBar", 0x2223);
		Entity("VerticalLine", 0x007C);
		Entity("VerticalSeparator", 0x2758);
		Entity("VerticalTilde", 0x2240);
		Entity("VeryThinSpace", 0x200A);
		Entity("vfr", 0x1D533);
		Entity("Vfr", 0x1D519);
		Entity("vltri", 0x22B2);
		Entity("vopf", 0x1D567);
		Entity("Vopf", 0x1D54D);
		Entity("vprop", 0x221D);
		Entity("vrtri", 0x22B3);
		Entity("vscr", 0x1D4CB);
		Entity("Vscr", 0x1D4B1);
		Entity("Vvdash", 0x22AA);
		Entity("vzigzag", 0x299A);
		Entity("wcirc", 0x0175);
		Entity("Wcirc", 0x0174);
		Entity("wedbar", 0x2A5F);
		Entity("wedge", 0x2227);
		Entity("Wedge", 0x22C0);
		Entity("wedgeq", 0x2259);
		Entity("weierp", 0x2118);
		Entity("wfr", 0x1D534);
		Entity("Wfr", 0x1D51A);
		Entity("wopf", 0x1D568);
		Entity("Wopf", 0x1D54E);
		Entity("wp", 0x2118);
		Entity("wr", 0x2240);
		Entity("wreath", 0x2240);
		Entity("wscr", 0x1D4CC);
		Entity("Wscr", 0x1D4B2);
		Entity("xcap", 0x22C2);
		Entity("xcirc", 0x25EF);
		Entity("xcup", 0x22C3);
		Entity("xdtri", 0x25BD);
		Entity("xfr", 0x1D535);
		Entity("Xfr", 0x1D51B);
		Entity("xgr", 0x03BE);
		Entity("Xgr", 0x039E);
		Entity("xharr", 0x27F7);
		Entity("xhArr", 0x27FA);
		Entity("xi", 0x03BE);
		Entity("Xi", 0x039E);
		Entity("xlarr", 0x27F5);
		Entity("xlArr", 0x27F8);
		Entity("xmap", 0x27FC);
		Entity("xnis", 0x22FB);
		Entity("xodot", 0x2A00);
		Entity("xopf", 0x1D569);
		Entity("Xopf", 0x1D54F);
		Entity("xoplus", 0x2A01);
		Entity("xotime", 0x2A02);
		Entity("xrarr", 0x27F6);
		Entity("xrArr", 0x27F9);
		Entity("xscr", 0x1D4CD);
		Entity("Xscr", 0x1D4B3);
		Entity("xsqcup", 0x2A06);
		Entity("xuplus", 0x2A04);
		Entity("xutri", 0x25B3);
		Entity("xvee", 0x22C1);
		Entity("xwedge", 0x22C0);
		Entity("yacute", 0x00FD);
		Entity("Yacute", 0x00DD);
		Entity("yacy", 0x044F);
		Entity("YAcy", 0x042F);
		Entity("ycirc", 0x0177);
		Entity("Ycirc", 0x0176);
		Entity("ycy", 0x044B);
		Entity("Ycy", 0x042B);
		Entity("yen", 0x00A5);
		Entity("yfr", 0x1D536);
		Entity("Yfr", 0x1D51C);
		Entity("yicy", 0x0457);
		Entity("YIcy", 0x0407);
		Entity("yopf", 0x1D56A);
		Entity("Yopf", 0x1D550);
		Entity("yscr", 0x1D4CE);
		Entity("Yscr", 0x1D4B4);
		Entity("yucy", 0x044E);
		Entity("YUcy", 0x042E);
		Entity("yuml", 0x00FF);
		Entity("Yuml", 0x0178);
		Entity("zacute", 0x017A);
		Entity("Zacute", 0x0179);
		Entity("zcaron", 0x017E);
		Entity("Zcaron", 0x017D);
		Entity("zcy", 0x0437);
		Entity("Zcy", 0x0417);
		Entity("zdot", 0x017C);
		Entity("Zdot", 0x017B);
		Entity("zeetrf", 0x2128);
		Entity("ZeroWidthSpace", 0x200B);
		Entity("zeta", 0x03B6);
		Entity("Zeta", 0x0396);
		Entity("zfr", 0x1D537);
		Entity("Zfr", 0x2128);
		Entity("zgr", 0x03B6);
		Entity("Zgr", 0x0396);
		Entity("zhcy", 0x0436);
		Entity("ZHcy", 0x0416);
		Entity("zigrarr", 0x21DD);
		Entity("zopf", 0x1D56B);
		Entity("Zopf", 0x2124);
		Entity("zscr", 0x1D4CF);
		Entity("Zscr", 0x1D4B5);
		Entity("zwj", 0x200D);
		Entity("zwnj", 0x200C);
		}
	}
}
