/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$resolver$ResourceResolver == null ? (class$org$apache$xml$security$utils$resolver$ResourceResolver = ResourceResolver.class$("org.apache.xml.security.utils.resolver.ResourceResolver")) : class$org$apache$xml$security$utils$resolver$ResourceResolver).getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    static boolean allThreadSafeInList = true;
    protected ResourceResolverSpi _resolverSpi = null;
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$ResourceResolver;

    private ResourceResolver(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(string).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this._resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string) throws ResourceResolverException {
        int n = _resolverVector.size();
        for (int i = 0; i < n; ++i) {
            ResourceResolver resourceResolver = (ResourceResolver)_resolverVector.get(i);
            ResourceResolver resourceResolver2 = null;
            try {
                resourceResolver2 = allThreadSafeInList || resourceResolver._resolverSpi.engineIsThreadSafe() ? resourceResolver : new ResourceResolver((ResourceResolverSpi)resourceResolver._resolverSpi.getClass().newInstance());
            }
            catch (InstantiationException instantiationException) {
                throw new ResourceResolverException("", instantiationException, attr, string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ResourceResolverException("", illegalAccessException, attr, string);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("check resolvability by class " + resourceResolver._resolverSpi.getClass().getName()));
            }
            if (resourceResolver == null || !resourceResolver2.canResolve(attr, string)) continue;
            if (i != 0) {
                List list = (List)((ArrayList)_resolverVector).clone();
                list.remove(i);
                list.add(0, resourceResolver);
                _resolverVector = list;
            }
            return resourceResolver2;
        }
        Object[] objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string};
        throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string);
    }

    public static final ResourceResolver getInstance(Attr attr, String string, List list) throws ResourceResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("I was asked to create a ResourceResolver and got " + (list == null ? 0 : list.size())));
            log.debug((Object)(" extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers"));
        }
        int n = 0;
        if (list != null && (n = list.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                ResourceResolver resourceResolver = (ResourceResolver)list.get(i);
                if (resourceResolver == null) continue;
                String string2 = resourceResolver._resolverSpi.getClass().getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("check resolvability by class " + string2));
                }
                if (!resourceResolver.canResolve(attr, string)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String string) {
        ResourceResolver.register(string, false);
    }

    public static void registerAtStart(String string) {
        ResourceResolver.register(string, true);
    }

    private static void register(String string, boolean bl) {
        try {
            ResourceResolver resourceResolver = new ResourceResolver(string);
            if (bl) {
                _resolverVector.add(0, resourceResolver);
                log.debug((Object)"registered resolver");
            } else {
                _resolverVector.add(resourceResolver);
            }
            if (!resourceResolver._resolverSpi.engineIsThreadSafe()) {
                allThreadSafeInList = false;
            }
        }
        catch (Exception exception) {
            log.warn((Object)("Error loading resolver " + string + " disabling it"));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            log.warn((Object)("Error loading resolver " + string + " disabling it"));
        }
    }

    public static XMLSignatureInput resolveStatic(Attr attr, String string) throws ResourceResolverException {
        ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
        return resourceResolver.resolve(attr, string);
    }

    public XMLSignatureInput resolve(Attr attr, String string) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(attr, string);
    }

    public void setProperty(String string, String string2) {
        this._resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this._resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map map) {
        this._resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this._resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(Attr attr, String string) {
        return this._resolverSpi.engineCanResolve(attr, string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

