/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.jdbcpool.ConnectionPool;
import org.apache.manifoldcf.core.jdbcpool.ConnectionPoolManager;
import org.apache.manifoldcf.core.jdbcpool.WrappedConnection;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class JDBCConnectionFactory {
    public static final String _rcsid = "@(#)$Id: JDBCConnectionFactory.java 1540867 2013-11-11 22:17:04Z kwright $";
    private static Map<String, String> driverMap;
    private static ConnectionPoolManager _pool;

    private JDBCConnectionFactory() {
    }

    public static String getJDBCDriverString(String providerName, String host, String database, String rawDriverString) {
        int slashIndex;
        if (rawDriverString != null && rawDriverString.length() > 0) {
            return rawDriverString;
        }
        if (database.length() == 0) {
            database = "_root_";
        }
        String instanceName = null;
        if (providerName.startsWith("jtds:") && (slashIndex = database.indexOf("/")) != -1) {
            instanceName = database.substring(0, slashIndex);
            database = database.substring(slashIndex + 1);
        }
        return host + "/" + database + (instanceName == null ? "" : ";instance=" + instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrappedConnection getConnection(String providerName, String jdbcDriverString, String userName, String password) throws ManifoldCFException, ServiceInterruption {
        String driverClassName = driverMap.get(providerName);
        if (driverClassName == null) {
            throw new ManifoldCFException("Unrecognized jdbc provider: '" + providerName + "'");
        }
        String dburl = "jdbc:" + providerName + "//" + jdbcDriverString;
        if (Logging.connectors != null && Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("JDBC: The connect string is '" + dburl + "'"));
        }
        try {
            if (_pool != null) {
                ConnectionPool cp;
                String poolKey = providerName + "/" + jdbcDriverString;
                poolKey = poolKey + "/" + userName + "/" + ManifoldCF.hash((String)password);
                ConnectionPoolManager connectionPoolManager = _pool;
                synchronized (connectionPoolManager) {
                    cp = _pool.getPool(poolKey);
                    if (cp == null) {
                        Class.forName(driverClassName);
                        cp = _pool.addAlias(poolKey, driverClassName, dburl, userName, password, 30, 300000L);
                    }
                }
                return cp.getConnection();
            }
            throw new ManifoldCFException("Can't get connection since pool driver did not initialize properly");
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                if (userName != null && userName.length() > 0) {
                    DriverManager.getConnection(dburl, userName, password).close();
                } else {
                    DriverManager.getConnection(dburl).close();
                }
            }
            catch (SQLException e2) {
                throw new ManifoldCFException("Error getting connection: " + e2.getMessage(), (Throwable)e2, 3);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Error getting connection: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 21600000L, -1, true);
        }
        catch (ClassNotFoundException e) {
            throw new ManifoldCFException("Driver class not found: " + e.getMessage(), (Throwable)e, 3);
        }
        catch (InstantiationException e) {
            throw new ManifoldCFException("Driver class not instantiable: " + e.getMessage(), (Throwable)e, 3);
        }
        catch (IllegalAccessException e) {
            throw new ManifoldCFException("Driver class not accessible: " + e.getMessage(), (Throwable)e, 3);
        }
    }

    public static void releaseConnection(WrappedConnection c) {
        c.release();
    }

    static {
        _pool = null;
        driverMap = new HashMap<String, String>();
        driverMap.put("oracle:thin:@", "oracle.jdbc.OracleDriver");
        driverMap.put("postgresql:", "org.postgresql.Driver");
        driverMap.put("jtds:sqlserver:", "net.sourceforge.jtds.jdbc.Driver");
        driverMap.put("jtds:sybase:", "net.sourceforge.jtds.jdbc.Driver");
        driverMap.put("mysql:", "com.mysql.jdbc.Driver");
        try {
            _pool = new ConnectionPoolManager(120, false);
        }
        catch (Exception e) {
            System.err.println("Can't set up pool");
            e.printStackTrace(System.err);
        }
    }
}

