/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.searchblox;

import java.io.IOException;
import java.io.StringReader;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxDocument;
import org.apache.manifoldcf.agents.output.searchblox.SearchBloxException;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.xerces.parsers.DOMParser;
import org.jboss.resteasy.plugins.providers.StringTextStar;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchBloxClient {
    public static final String DEFAULT_ENDPOINT = "http://localhost:8080/searchblox/rest/v1/api";
    private static final String ADD_PATH = "add";
    private static final String DELETE_PATH = "delete";
    private static final String STATUS_PATH = "status";
    private static final String CREATE_PATH = "coladd";
    private static final String CLEAR_PATH = "clear";
    private static final String STATUS_NODE = "statuscode";
    private static final Pattern status_pattern = Pattern.compile("^status code\\s?:\\s([0-9]+)$");
    private String apikey;
    private Client client;
    private UriBuilder uriBuilder;

    public SearchBloxClient(String apikey, ClientBuilder builder, String endpoint) {
        this.apikey = apikey;
        builder.register(StringTextStar.class);
        this.client = builder.build();
        this.uriBuilder = endpoint != null && !endpoint.isEmpty() ? UriBuilder.fromUri((String)endpoint) : UriBuilder.fromUri((String)DEFAULT_ENDPOINT);
    }

    public ResponseCode addUpdateDocument(SearchBloxDocument document, String format) throws SearchBloxException {
        return this.post(document, format, SearchBloxDocument.DocumentAction.ADD_UPDATE);
    }

    public ResponseCode deleteDocument(SearchBloxDocument document, String format) throws SearchBloxException {
        return this.post(document, format, SearchBloxDocument.DocumentAction.DELETE);
    }

    public ResponseCode createCollection(String colname, String format) throws SearchBloxException {
        SearchBloxDocument document = new SearchBloxDocument(this.apikey);
        document.colName = colname;
        return this.post(document, format, SearchBloxDocument.DocumentAction.CREATE);
    }

    public ResponseCode clearCollection(String colname, String format) throws SearchBloxException {
        SearchBloxDocument document = new SearchBloxDocument(this.apikey);
        document.colName = colname;
        return this.post(document, format, SearchBloxDocument.DocumentAction.CLEAR);
    }

    public boolean ping(String format) throws SearchBloxException {
        SearchBloxDocument document = new SearchBloxDocument(this.apikey);
        document.colName = UUID.randomUUID().toString();
        document.uid = UUID.randomUUID().toString();
        ResponseCode result = this.post(document, format, SearchBloxDocument.DocumentAction.STATUS);
        return result == ResponseCode.INVALID_COLLECTION_NAME;
    }

    private ResponseCode post(SearchBloxDocument document, String format, SearchBloxDocument.DocumentAction action) throws SearchBloxException {
        SearchBloxDocument.IndexingFormat iFormat = SearchBloxDocument.IndexingFormat.valueOf(format.toUpperCase());
        if (iFormat == null) {
            Logging.connectors.error((Object)("[Post request] Format not recognized " + format));
            throw new SearchBloxException("Unknown Serialization Format " + format);
        }
        boolean isJson = iFormat.equals((Object)SearchBloxDocument.IndexingFormat.JSON);
        UriBuilder uri = this.uriBuilder.clone();
        if (action == SearchBloxDocument.DocumentAction.ADD_UPDATE) {
            uri = uri.path(ADD_PATH);
        } else if (action == SearchBloxDocument.DocumentAction.DELETE) {
            uri = uri.path(DELETE_PATH);
        } else if (action == SearchBloxDocument.DocumentAction.STATUS) {
            uri = uri.path(STATUS_PATH);
        } else if (action == SearchBloxDocument.DocumentAction.CREATE) {
            uri = uri.path(CREATE_PATH);
        } else if (action == SearchBloxDocument.DocumentAction.CLEAR) {
            uri = uri.path(CLEAR_PATH);
        }
        WebTarget target = this.client.target(uri.build(new Object[0]));
        Invocation.Builder httpRequest = target.request();
        if (iFormat == SearchBloxDocument.IndexingFormat.JSON) {
            httpRequest.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        } else {
            httpRequest.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        }
        document.apiKey = this.apikey;
        String body = document.toString(iFormat, action);
        Logging.connectors.debug((Object)("Document for document: " + document.uid + ":" + body));
        MediaType type = MediaType.TEXT_PLAIN_TYPE;
        if (iFormat == SearchBloxDocument.IndexingFormat.JSON) {
            type = MediaType.APPLICATION_JSON_TYPE;
        }
        Entity entity = Entity.entity((Object)body, (MediaType)type);
        Response response = null;
        try {
            response = httpRequest.post(entity);
        }
        catch (Exception e) {
            Logging.connectors.error((Object)"[No Connection] Error trying to connect ", (Throwable)e);
            return ResponseCode.SERVER_UNREACHABLE;
        }
        String rawResponse = (String)response.readEntity(String.class);
        if (iFormat == SearchBloxDocument.IndexingFormat.XML) {
            DOMParser parser = new DOMParser();
            try {
                parser.parse(new InputSource(new StringReader(rawResponse)));
            }
            catch (IOException | SAXException e) {
                Logging.connectors.error((Object)"[Response parsing] Dom parsing error", (Throwable)e);
                throw new SearchBloxException(e);
            }
            Document doc = parser.getDocument();
            NodeList nodeList = doc.getElementsByTagName(STATUS_NODE);
            if (nodeList == null || nodeList.getLength() == 0) {
                String message = "[Response Parsing] Status code not found";
                Logging.connectors.error((Object)message);
                throw new SearchBloxException(message);
            }
            String codeStr = nodeList.item(0).getTextContent();
            int statusCode = Integer.parseInt(codeStr);
            return ResponseCode.getCodeFromValue(statusCode, isJson);
        }
        Matcher matcher = status_pattern.matcher(rawResponse);
        String codeStr = null;
        if (matcher.find()) {
            codeStr = matcher.group(1);
        }
        if (codeStr == null) {
            String message = "[Response parsing] Response code parsing error";
            Logging.connectors.error((Object)message);
            throw new SearchBloxException(message);
        }
        int statusCode = Integer.parseInt(codeStr);
        return ResponseCode.getCodeFromValue(statusCode, isJson);
    }

    public static enum ResponseCode {
        DOCUMENT_INDEXED(100),
        DOCUMENT_REJECTED(101),
        DOCUMENT_DELETED(200, 2001),
        DOCUMENT_NOT_EXIST(201, 2002),
        DOCUMENT_NOT_FOUND(301),
        COLLECTION_CLEARED(400),
        ERROR_CLEARING_COLLECTION(401),
        COLLECTION_CREATED(900),
        INVALID_COLLECTION_NAME(500, 501),
        INVALID_REQUEST(501),
        INVALID_DOCUMENT_LOCATION(502),
        NOT_CUSTOM_COLLECTION(503),
        LIMIT_EXCEEDED(504),
        INVALID_LICENSE_ID(601),
        SERVER_UNREACHABLE(700);

        private int code;
        private int jsonCode;

        private ResponseCode(int code) {
            this.code = code;
        }

        private ResponseCode(int code, int jsonCode) {
            this.code = code;
            this.jsonCode = jsonCode;
        }

        static ResponseCode getCodeFromValue(int value) {
            for (ResponseCode e : ResponseCode.values()) {
                if (value != e.code) continue;
                return e;
            }
            return null;
        }

        static ResponseCode getCodeFromValue(int value, boolean json) {
            for (ResponseCode e : ResponseCode.values()) {
                if ((!json || value != e.jsonCode) && value != e.code) continue;
                return e;
            }
            return null;
        }

        int getCode() {
            return this.code;
        }

        int getJsonCode() {
            return this.jsonCode;
        }
    }
}

