/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.incrementalingest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.incrementalingest.RepositoryDocumentFactory;
import org.apache.manifoldcf.agents.interfaces.DocumentIngestStatus;
import org.apache.manifoldcf.agents.interfaces.IIncrementalIngester;
import org.apache.manifoldcf.agents.interfaces.IOutputActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnector;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorPool;
import org.apache.manifoldcf.agents.interfaces.IOutputHistoryActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputQualifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnections;
import org.apache.manifoldcf.agents.interfaces.IPipelineConnector;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecification;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationBasic;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationWithVersions;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnection;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnector;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorPool;
import org.apache.manifoldcf.agents.interfaces.IngestStatuses;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorPoolFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class IncrementalIngester
extends BaseTable
implements IIncrementalIngester {
    public static final String _rcsid = "@(#)$Id: IncrementalIngester.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String idField = "id";
    protected static final String outputConnNameField = "connectionname";
    protected static final String docKeyField = "dockey";
    protected static final String componentHashField = "componenthash";
    protected static final String docURIField = "docuri";
    protected static final String uriHashField = "urihash";
    protected static final String lastVersionField = "lastversion";
    protected static final String lastOutputVersionField = "lastoutputversion";
    protected static final String lastTransformationVersionField = "lasttransformationversion";
    protected static final String forcedParamsField = "forcedparams";
    protected static final String changeCountField = "changecount";
    protected static final String firstIngestField = "firstingest";
    protected static final String lastIngestField = "lastingest";
    protected static final String authorityNameField = "authorityname";
    protected final IThreadContext threadContext;
    protected final ILockManager lockManager;
    protected final IOutputConnectionManager connectionManager;
    protected final IOutputConnectorPool outputConnectorPool;
    protected final ITransformationConnectorPool transformationConnectorPool;

    public IncrementalIngester(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "ingeststatus");
        this.threadContext = threadContext;
        this.lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        this.connectionManager = OutputConnectionManagerFactory.make(threadContext);
        this.outputConnectorPool = OutputConnectorPoolFactory.make(threadContext);
        this.transformationConnectorPool = TransformationConnectorPoolFactory.make(threadContext);
    }

    @Override
    public void install() throws ManifoldCFException {
        block11: {
            String outputConnectionTableName = this.connectionManager.getTableName();
            String outputConnectionNameField = this.connectionManager.getConnectionNameColumn();
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(outputConnNameField, new ColumnDescription("VARCHAR(32)", false, false, outputConnectionTableName, outputConnectionNameField, false));
                map.put(docKeyField, new ColumnDescription("VARCHAR(73)", false, false, null, null, false));
                map.put(componentHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(docURIField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(uriHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(lastVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(lastOutputVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(lastTransformationVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(forcedParamsField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(changeCountField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(firstIngestField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(lastIngestField, new ColumnDescription("BIGINT", false, false, null, null, false));
                map.put(authorityNameField, new ColumnDescription("VARCHAR(32)", false, true, null, null, false));
                this.performCreate(map, null);
            } else {
                HashMap<String, ColumnDescription> addMap;
                ColumnDescription cd = (ColumnDescription)existing.get(forcedParamsField);
                if (cd == null) {
                    addMap = new HashMap<String, ColumnDescription>();
                    addMap.put(forcedParamsField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                    this.performAlter(addMap, null, null, null);
                }
                if ((cd = (ColumnDescription)existing.get(lastTransformationVersionField)) == null) {
                    addMap = new HashMap();
                    addMap.put(lastTransformationVersionField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                    this.performAlter(addMap, null, null, null);
                }
                if ((cd = (ColumnDescription)existing.get(componentHashField)) == null) {
                    addMap = new HashMap();
                    addMap.put(componentHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                    this.performAlter(addMap, null, null, null);
                }
            }
            IndexDescription keyIndex = new IndexDescription(true, new String[]{docKeyField, outputConnNameField, componentHashField});
            IndexDescription uriHashIndex = new IndexDescription(false, new String[]{uriHashField, outputConnNameField});
            IndexDescription outputConnIndex = new IndexDescription(false, new String[]{outputConnNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (keyIndex != null && id.equals((Object)keyIndex)) {
                    keyIndex = null;
                    continue;
                }
                if (uriHashIndex != null && id.equals((Object)uriHashIndex)) {
                    uriHashIndex = null;
                    continue;
                }
                if (outputConnIndex != null && id.equals((Object)outputConnIndex)) {
                    outputConnIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (uriHashIndex != null) {
                this.performAddIndex(null, uriHashIndex);
            }
            if (keyIndex != null) {
                this.performAddIndex(null, keyIndex);
            }
            if (outputConnIndex == null) break block11;
            this.performAddIndex(null, outputConnIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    @Override
    public void clearAll() throws ManifoldCFException {
        this.performDelete("", null, null);
    }

    @Override
    public String getLastIndexedOutputConnectionName(IPipelineSpecificationBasic pipelineSpecificationBasic) {
        int count = pipelineSpecificationBasic.getOutputCount();
        if (count == 0) {
            return null;
        }
        return pipelineSpecificationBasic.getStageConnectionName(pipelineSpecificationBasic.getOutputStage(count - 1));
    }

    @Override
    public String getFirstIndexedOutputConnectionName(IPipelineSpecificationBasic pipelineSpecificationBasic) {
        if (pipelineSpecificationBasic.getOutputCount() == 0) {
            return null;
        }
        return pipelineSpecificationBasic.getStageConnectionName(pipelineSpecificationBasic.getOutputStage(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDateIndexable(IPipelineSpecification pipelineSpecification, Date date, IOutputCheckActivity activity) throws ManifoldCFException, ServiceInterruption {
        PipelineObject pipeline = this.pipelineGrab(pipelineSpecification);
        if (pipeline == null) {
            throw new ServiceInterruption("One or more connectors are not installed", 0L);
        }
        try {
            boolean bl = pipeline.checkDateIndexable(date, activity);
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkMimeTypeIndexable(IPipelineSpecification pipelineSpecification, String mimeType, IOutputCheckActivity activity) throws ManifoldCFException, ServiceInterruption {
        PipelineObject pipeline = this.pipelineGrab(pipelineSpecification);
        if (pipeline == null) {
            throw new ServiceInterruption("One or more connectors are not installed", 0L);
        }
        try {
            boolean bl = pipeline.checkMimeTypeIndexable(mimeType, activity);
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDocumentIndexable(IPipelineSpecification pipelineSpecification, File localFile, IOutputCheckActivity activity) throws ManifoldCFException, ServiceInterruption {
        PipelineObject pipeline = this.pipelineGrab(pipelineSpecification);
        if (pipeline == null) {
            throw new ServiceInterruption("One or more connectors are not installed", 0L);
        }
        try {
            boolean bl = pipeline.checkDocumentIndexable(localFile, activity);
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkLengthIndexable(IPipelineSpecification pipelineSpecification, long length, IOutputCheckActivity activity) throws ManifoldCFException, ServiceInterruption {
        PipelineObject pipeline = this.pipelineGrab(pipelineSpecification);
        if (pipeline == null) {
            throw new ServiceInterruption("One or more connectors are not installed", 0L);
        }
        try {
            boolean bl = pipeline.checkLengthIndexable(length, activity);
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkURLIndexable(IPipelineSpecification pipelineSpecification, String url, IOutputCheckActivity activity) throws ManifoldCFException, ServiceInterruption {
        PipelineObject pipeline = this.pipelineGrab(pipelineSpecification);
        if (pipeline == null) {
            throw new ServiceInterruption("One or more connectors are not installed", 0L);
        }
        try {
            boolean bl = pipeline.checkURLIndexable(url, activity);
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    protected PipelineObjectWithVersions pipelineGrabWithVersions(IPipelineSpecificationWithVersions pipelineConnections) throws ManifoldCFException {
        ITransformationConnector[] transformationConnectors;
        for (ITransformationConnector c : transformationConnectors = this.transformationConnectorPool.grabMultiple(pipelineConnections.getTransformationConnectionNames(), pipelineConnections.getTransformationConnections())) {
            if (c != null) continue;
            this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
            return null;
        }
        try {
            IOutputConnector[] outputConnectors;
            for (IOutputConnector c : outputConnectors = this.outputConnectorPool.grabMultiple(pipelineConnections.getOutputConnectionNames(), pipelineConnections.getOutputConnections())) {
                if (c != null) continue;
                this.outputConnectorPool.releaseMultiple(pipelineConnections.getOutputConnections(), outputConnectors);
                this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
                return null;
            }
            return new PipelineObjectWithVersions(pipelineConnections, transformationConnectors, outputConnectors);
        }
        catch (Throwable e) {
            this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
            if (e instanceof ManifoldCFException) {
                throw (ManifoldCFException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException("Unexpected exception type: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    protected PipelineObject pipelineGrab(IPipelineSpecification pipelineConnections) throws ManifoldCFException {
        ITransformationConnector[] transformationConnectors;
        for (ITransformationConnector c : transformationConnectors = this.transformationConnectorPool.grabMultiple(pipelineConnections.getTransformationConnectionNames(), pipelineConnections.getTransformationConnections())) {
            if (c != null) continue;
            this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
            return null;
        }
        try {
            IOutputConnector[] outputConnectors;
            for (IOutputConnector c : outputConnectors = this.outputConnectorPool.grabMultiple(pipelineConnections.getOutputConnectionNames(), pipelineConnections.getOutputConnections())) {
                if (c != null) continue;
                this.outputConnectorPool.releaseMultiple(pipelineConnections.getOutputConnections(), outputConnectors);
                this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
                return null;
            }
            return new PipelineObject(pipelineConnections, transformationConnectors, outputConnectors);
        }
        catch (Throwable e) {
            this.transformationConnectorPool.releaseMultiple(pipelineConnections.getTransformationConnections(), transformationConnectors);
            if (e instanceof ManifoldCFException) {
                throw (ManifoldCFException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException("Unexpected exception type: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionContext getOutputDescription(IOutputConnection outputConnection, Specification spec) throws ManifoldCFException, ServiceInterruption {
        IOutputConnector connector = this.outputConnectorPool.grab(outputConnection);
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 0L);
        }
        try {
            VersionContext versionContext = connector.getPipelineDescription(spec);
            return versionContext;
        }
        finally {
            this.outputConnectorPool.release(outputConnection, connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VersionContext getTransformationDescription(ITransformationConnection transformationConnection, Specification spec) throws ManifoldCFException, ServiceInterruption {
        ITransformationConnector connector = this.transformationConnectorPool.grab(transformationConnection);
        if (connector == null) {
            throw new ServiceInterruption("Transformation connector not installed", 0L);
        }
        try {
            VersionContext versionContext = connector.getPipelineDescription(spec);
            return versionContext;
        }
        finally {
            this.transformationConnectorPool.release(transformationConnection, connector);
        }
    }

    @Override
    public boolean checkFetchDocument(IPipelineSpecificationWithVersions pipelineSpecificationWithVersions, String newDocumentVersion, String newParameterVersion, String newAuthorityNameString) {
        if (newAuthorityNameString == null) {
            newAuthorityNameString = "";
        }
        for (int i = 0; i < pipelineSpecificationWithVersions.getOutputCount(); ++i) {
            int stage = pipelineSpecificationWithVersions.getOutputStage(i);
            String oldDocumentVersion = pipelineSpecificationWithVersions.getOutputDocumentVersionString(i);
            String oldParameterVersion = pipelineSpecificationWithVersions.getOutputParameterVersionString(i);
            String oldOutputVersion = pipelineSpecificationWithVersions.getOutputVersionString(i);
            String oldAuthorityName = pipelineSpecificationWithVersions.getAuthorityNameString(i);
            if (oldDocumentVersion == null) {
                return true;
            }
            if (!(oldDocumentVersion.equals(newDocumentVersion) && oldParameterVersion.equals(newParameterVersion) && oldAuthorityName.equals(newAuthorityNameString) && oldOutputVersion.equals(pipelineSpecificationWithVersions.getStageDescriptionString(stage).getVersionString()))) {
                return true;
            }
            String newTransformationVersion = IncrementalIngester.computePackedTransformationVersion(pipelineSpecificationWithVersions, stage);
            String oldTransformationVersion = pipelineSpecificationWithVersions.getOutputTransformationVersionString(i);
            if (oldTransformationVersion.length() == 0) {
                oldTransformationVersion = "0+0!";
            }
            if (oldTransformationVersion.equals(newTransformationVersion)) continue;
            return true;
        }
        return false;
    }

    protected static String computePackedTransformationVersion(IPipelineSpecification pipelineSpecification, int stage) {
        int newStage;
        int newStage2;
        int stageCount = 0;
        int currentStage = stage;
        while ((newStage2 = pipelineSpecification.getStageParent(currentStage)) != -1) {
            ++stageCount;
            currentStage = newStage2;
        }
        String[] stageNames = new String[stageCount];
        String[] stageDescriptions = new String[stageCount];
        stageCount = 0;
        currentStage = stage;
        while ((newStage = pipelineSpecification.getStageParent(currentStage)) != -1) {
            stageNames[stageCount] = pipelineSpecification.getStageConnectionName(newStage);
            stageDescriptions[stageCount] = pipelineSpecification.getStageDescriptionString(newStage).getVersionString();
            ++stageCount;
            currentStage = newStage;
        }
        StringBuilder sb = new StringBuilder();
        IncrementalIngester.packList(sb, stageNames, '+');
        IncrementalIngester.packList(sb, stageDescriptions, '!');
        return sb.toString();
    }

    protected static void packList(StringBuilder output, String[] values, char delimiter) {
        IncrementalIngester.pack(output, Integer.toString(values.length), delimiter);
        int i = 0;
        while (i < values.length) {
            IncrementalIngester.pack(output, values[i++], delimiter);
        }
    }

    protected static void pack(StringBuilder sb, String value, char delim) {
        for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            if (x == delim || x == '\\') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append(delim);
    }

    @Override
    public void documentRecord(IPipelineSpecificationBasic pipelineSpecificationBasic, String identifierClass, String identifierHash, String componentHash, String documentVersion, long recordTime) throws ManifoldCFException {
        String docKey = IncrementalIngester.makeKey(identifierClass, identifierHash);
        String[] outputConnectionNames = IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationBasic);
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("Recording document '" + docKey + "' component hash " + (componentHash == null ? "(None)" : "'" + componentHash + "'") + " for output connections '" + outputConnectionNames + "'"));
        }
        for (int k = 0; k < outputConnectionNames.length; ++k) {
            String outputConnectionName = outputConnectionNames[k];
            this.noteDocumentIngest(outputConnectionName, docKey, componentHash, documentVersion, null, null, null, null, recordTime, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentNoData(IPipelineSpecificationWithVersions pipelineSpecificationWithVersions, String identifierClass, String identifierHash, String componentHash, String documentVersion, String parameterVersion, String authorityName, long recordTime, IOutputActivity activities) throws ManifoldCFException, ServiceInterruption {
        PipelineObjectWithVersions pipeline;
        String docKey = IncrementalIngester.makeKey(identifierClass, identifierHash);
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("Logging empty document '" + docKey + "' component hash " + (componentHash == null ? "(None)" : "'" + componentHash + "'") + " into output connections '" + IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationWithVersions) + "'"));
        }
        if ((pipeline = this.pipelineGrabWithVersions(pipelineSpecificationWithVersions)) == null) {
            throw new ServiceInterruption("Pipeline connector not installed", 0L);
        }
        try {
            pipeline.noDocument(docKey, componentHash, documentVersion, parameterVersion, authorityName, activities, recordTime);
        }
        finally {
            pipeline.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean documentIngest(IPipelineSpecificationWithVersions pipelineSpecificationWithVersions, String identifierClass, String identifierHash, String componentHash, String documentVersion, String parameterVersion, String authorityName, RepositoryDocument data, long ingestTime, String documentURI, IOutputActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        String docKey = IncrementalIngester.makeKey(identifierClass, identifierHash);
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("Ingesting document '" + docKey + "' component hash " + (componentHash == null ? "(None)" : "'" + componentHash + "'") + " into output connections '" + IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationWithVersions) + "'"));
        }
        data.setIndexingDate(new Date());
        PipelineObjectWithVersions pipeline = this.pipelineGrabWithVersions(pipelineSpecificationWithVersions);
        if (pipeline == null) {
            throw new ServiceInterruption("Pipeline connector not installed", 0L);
        }
        try {
            boolean bl = pipeline.addOrReplaceDocumentWithException(docKey, componentHash, documentURI, data, documentVersion, parameterVersion, authorityName, activities, ingestTime) == 0;
            return bl;
        }
        finally {
            pipeline.release();
        }
    }

    @Override
    public void documentRemove(IPipelineConnections pipelineConnections, String identifierClass, String identifierHash, String componentHash, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.documentRemoveMultiple(pipelineConnections, new String[]{identifierClass}, new String[]{identifierHash}, componentHash, activities);
    }

    protected static String[] extractOutputConnectionNames(IPipelineSpecificationBasic pipelineSpecificationBasic) {
        String[] rval = new String[pipelineSpecificationBasic.getOutputCount()];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = pipelineSpecificationBasic.getStageConnectionName(pipelineSpecificationBasic.getOutputStage(i));
        }
        return rval;
    }

    @Override
    public void documentCheckMultiple(IPipelineSpecificationBasic pipelineSpecificationBasic, String[] identifierClasses, String[] identifierHashes, long checkTime) throws ManifoldCFException {
        String[] outputConnectionNames = IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationBasic);
        this.beginTransaction();
        try {
            HashSet<String> docIDValues = new HashSet<String>();
            for (int j = 0; j < identifierHashes.length; ++j) {
                String docDBString = IncrementalIngester.makeKey(identifierClasses[j], identifierHashes[j]);
                docIDValues.add(docDBString);
            }
            HashSet<Long> rowIDSet = new HashSet<Long>();
            Iterator iter = docIDValues.iterator();
            int j = 0;
            ArrayList<String> list = new ArrayList<String>();
            int maxClauses = this.maxClausesRowIdsForDocIds(outputConnectionNames);
            while (iter.hasNext()) {
                if (j == maxClauses) {
                    this.findRowIdsForDocIds(outputConnectionNames, rowIDSet, list);
                    list.clear();
                    j = 0;
                }
                list.add((String)iter.next());
                ++j;
            }
            if (j > 0) {
                this.findRowIdsForDocIds(outputConnectionNames, rowIDSet, list);
            }
            j = 0;
            ArrayList<Long> list2 = new ArrayList<Long>();
            Iterator iter2 = rowIDSet.iterator();
            maxClauses = this.maxClausesUpdateRowIds();
            while (iter2.hasNext()) {
                if (j == maxClauses) {
                    this.updateRowIds(list2, checkTime);
                    list2.clear();
                    j = 0;
                }
                list2.add((Long)iter2.next());
                ++j;
            }
            if (j > 0) {
                this.updateRowIds(list2, checkTime);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void documentCheck(IPipelineSpecificationBasic pipelineSpecificationBasic, String identifierClass, String identifierHash, long checkTime) throws ManifoldCFException {
        this.documentCheckMultiple(pipelineSpecificationBasic, new String[]{identifierClass}, new String[]{identifierHash}, checkTime);
    }

    protected int maxClausesUpdateRowIds() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void updateRowIds(List<Long> list, long checkTime) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(idField, list)});
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(lastIngestField, new Long(checkTime));
        this.performUpdate(map, "WHERE " + query, newList, null);
    }

    @Override
    public void documentDeleteMultiple(IPipelineConnections[] pipelineConnections, String[] identifierClasses, String[] identifierHashes, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        List list;
        HashMap keyMap = new HashMap();
        for (int i = 0; i < pipelineConnections.length; ++i) {
            IPipelineConnections spec = pipelineConnections[i];
            list = (ArrayList<Integer>)keyMap.get(spec);
            if (list == null) {
                list = new ArrayList<Integer>();
                keyMap.put(spec, list);
            }
            list.add(new Integer(i));
        }
        for (IPipelineConnections spec : keyMap.keySet()) {
            list = (List)keyMap.get(spec);
            String[] localIdentifierClasses = new String[list.size()];
            String[] localIdentifierHashes = new String[list.size()];
            for (int i = 0; i < localIdentifierClasses.length; ++i) {
                int index = (Integer)list.get(i);
                localIdentifierClasses[i] = identifierClasses[index];
                localIdentifierHashes[i] = identifierHashes[index];
            }
            this.documentDeleteMultiple(spec, localIdentifierClasses, localIdentifierHashes, activities);
        }
    }

    protected static String createURILockName(String outputConnectionName, String uriHash) {
        int hashCode = outputConnectionName.hashCode() + uriHash.hashCode();
        return "URILOCK-" + (hashCode &= 0xFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentDeleteMultiple(IPipelineConnections pipelineConnections, String[] identifierClasses, String[] identifierHashes, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        String[] outputConnectionNames = pipelineConnections.getOutputConnectionNames();
        IOutputConnection[] outputConnections = pipelineConnections.getOutputConnections();
        for (int z = 0; z < outputConnectionNames.length; ++z) {
            String outputConnectionName = outputConnectionNames[z];
            IOutputConnection connection = outputConnections[z];
            activities = new OutputRemoveActivitiesWrapper(activities, outputConnectionName);
            if (Logging.ingest.isDebugEnabled()) {
                for (int i = 0; i < identifierHashes.length; ++i) {
                    Logging.ingest.debug((Object)("Request to delete document '" + IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]) + "' from output connection '" + outputConnectionName + "'"));
                }
            }
            List<DeleteInfo> uris = this.getDocumentURIMultiple(outputConnectionName, identifierClasses, identifierHashes);
            int validURIcount = 0;
            for (DeleteInfo uri : uris) {
                if (uri.getURI() == null) continue;
                ++validURIcount;
            }
            String[] lockArray = new String[validURIcount];
            String[] validURIArray = new String[validURIcount];
            String[] validURIHashArray = new String[validURIcount];
            validURIcount = 0;
            for (DeleteInfo uri : uris) {
                if (uri.getURI() == null) continue;
                validURIArray[validURIcount] = uri.getURI();
                validURIHashArray[validURIcount] = uri.getURIHash();
                lockArray[validURIcount] = IncrementalIngester.createURILockName(outputConnectionName, validURIHashArray[validURIcount]);
                ++validURIcount;
            }
            this.lockManager.enterLocks(null, null, lockArray);
            try {
                for (DeleteInfo uri : uris) {
                    if (uri.getURI() == null) continue;
                    this.removeDocument(connection, uri.getURI(), uri.getOutputVersion(), activities);
                }
                this.beginTransaction();
                try {
                    HashSet<String> docURIHashValues = new HashSet<String>();
                    HashSet<String> docURIValues = new HashSet<String>();
                    for (String docDBString : validURIArray) {
                        docURIValues.add(docDBString);
                    }
                    for (String docDBString : validURIHashArray) {
                        docURIHashValues.add(docDBString);
                    }
                    HashSet<Long> rowIDSet = new HashSet<Long>();
                    Iterator iter = docURIHashValues.iterator();
                    int j = 0;
                    ArrayList<String> hashList = new ArrayList<String>();
                    int maxClauses = this.maxClausesRowIdsForURIs(outputConnectionName);
                    while (iter.hasNext()) {
                        if (j == maxClauses) {
                            this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList);
                            hashList.clear();
                            j = 0;
                        }
                        hashList.add((String)iter.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList);
                    }
                    j = 0;
                    ArrayList<Long> list = new ArrayList<Long>();
                    Iterator iter2 = rowIDSet.iterator();
                    maxClauses = this.maxClausesDeleteRowIds();
                    while (iter2.hasNext()) {
                        if (j == maxClauses) {
                            this.deleteRowIds(list);
                            list.clear();
                            j = 0;
                        }
                        list.add((Long)iter2.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.deleteRowIds(list);
                    }
                    HashSet<String> docIdValues = new HashSet<String>();
                    for (int i = 0; i < identifierHashes.length; ++i) {
                        String docDBString = IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]);
                        docIdValues.add(docDBString);
                    }
                    rowIDSet.clear();
                    iter = docIdValues.iterator();
                    j = 0;
                    ArrayList<String> list2 = new ArrayList<String>();
                    maxClauses = this.maxClausesRowIdsForDocIds(outputConnectionName);
                    while (iter.hasNext()) {
                        if (j == maxClauses) {
                            this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list2);
                            list2.clear();
                            j = 0;
                        }
                        list2.add((String)iter.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list2);
                    }
                    j = 0;
                    list.clear();
                    iter2 = rowIDSet.iterator();
                    maxClauses = this.maxClausesDeleteRowIds();
                    while (iter2.hasNext()) {
                        if (j == maxClauses) {
                            this.deleteRowIds(list);
                            list.clear();
                            j = 0;
                        }
                        list.add((Long)iter2.next());
                        ++j;
                    }
                    if (j <= 0) continue;
                    this.deleteRowIds(list);
                    continue;
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.lockManager.leaveLocks(null, null, lockArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentRemoveMultiple(IPipelineConnections pipelineConnections, String[] identifierClasses, String[] identifierHashes, String componentHash, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        String[] outputConnectionNames = pipelineConnections.getOutputConnectionNames();
        IOutputConnection[] outputConnections = pipelineConnections.getOutputConnections();
        for (int z = 0; z < outputConnectionNames.length; ++z) {
            String outputConnectionName = outputConnectionNames[z];
            IOutputConnection connection = outputConnections[z];
            activities = new OutputRemoveActivitiesWrapper(activities, outputConnectionName);
            if (Logging.ingest.isDebugEnabled()) {
                for (int i = 0; i < identifierHashes.length; ++i) {
                    Logging.ingest.debug((Object)("Request to remove document '" + IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]) + "' component hash " + (componentHash == null ? "(None)" : "'" + componentHash + "'") + " from output connection '" + outputConnectionName + "'"));
                }
            }
            List<DeleteInfo> uris = this.getDocumentURIMultiple(outputConnectionName, identifierClasses, identifierHashes, componentHash);
            int validURIcount = 0;
            for (DeleteInfo uri : uris) {
                if (uri.getURI() == null) continue;
                ++validURIcount;
            }
            String[] lockArray = new String[validURIcount];
            String[] validURIArray = new String[validURIcount];
            String[] validURIHashArray = new String[validURIcount];
            validURIcount = 0;
            for (DeleteInfo uri : uris) {
                if (uri.getURI() == null) continue;
                validURIArray[validURIcount] = uri.getURI();
                validURIHashArray[validURIcount] = uri.getURIHash();
                lockArray[validURIcount] = IncrementalIngester.createURILockName(outputConnectionName, validURIHashArray[validURIcount]);
                ++validURIcount;
            }
            this.lockManager.enterLocks(null, null, lockArray);
            try {
                for (DeleteInfo uri : uris) {
                    if (uri.getURI() == null) continue;
                    this.removeDocument(connection, uri.getURI(), uri.getOutputVersion(), activities);
                }
                this.beginTransaction();
                try {
                    HashSet<String> docURIHashValues = new HashSet<String>();
                    HashSet<String> docURIValues = new HashSet<String>();
                    for (String docDBString : validURIArray) {
                        docURIValues.add(docDBString);
                    }
                    for (String docDBString : validURIHashArray) {
                        docURIHashValues.add(docDBString);
                    }
                    HashSet<Long> rowIDSet = new HashSet<Long>();
                    Iterator iter = docURIHashValues.iterator();
                    int j = 0;
                    ArrayList<String> hashList = new ArrayList<String>();
                    int maxClauses = this.maxClausesRowIdsForURIs(outputConnectionName);
                    while (iter.hasNext()) {
                        if (j == maxClauses) {
                            this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList);
                            hashList.clear();
                            j = 0;
                        }
                        hashList.add((String)iter.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.findRowIdsForURIs(outputConnectionName, rowIDSet, docURIValues, hashList);
                    }
                    j = 0;
                    ArrayList<Long> list = new ArrayList<Long>();
                    Iterator iter2 = rowIDSet.iterator();
                    maxClauses = this.maxClausesDeleteRowIds();
                    while (iter2.hasNext()) {
                        if (j == maxClauses) {
                            this.deleteRowIds(list);
                            list.clear();
                            j = 0;
                        }
                        list.add((Long)iter2.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.deleteRowIds(list);
                    }
                    HashSet<String> docIdValues = new HashSet<String>();
                    for (int i = 0; i < identifierHashes.length; ++i) {
                        String docDBString = IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]);
                        docIdValues.add(docDBString);
                    }
                    rowIDSet.clear();
                    iter = docIdValues.iterator();
                    j = 0;
                    ArrayList<String> list2 = new ArrayList<String>();
                    maxClauses = this.maxClausesRowIdsForDocIds(outputConnectionName, componentHash);
                    while (iter.hasNext()) {
                        if (j == maxClauses) {
                            this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list2, componentHash);
                            list2.clear();
                            j = 0;
                        }
                        list2.add((String)iter.next());
                        ++j;
                    }
                    if (j > 0) {
                        this.findRowIdsForDocIds(outputConnectionName, rowIDSet, list2, componentHash);
                    }
                    j = 0;
                    list.clear();
                    iter2 = rowIDSet.iterator();
                    maxClauses = this.maxClausesDeleteRowIds();
                    while (iter2.hasNext()) {
                        if (j == maxClauses) {
                            this.deleteRowIds(list);
                            list.clear();
                            j = 0;
                        }
                        list.add((Long)iter2.next());
                        ++j;
                    }
                    if (j <= 0) continue;
                    this.deleteRowIds(list);
                    continue;
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                }
            }
            finally {
                this.lockManager.leaveLocks(null, null, lockArray);
            }
        }
    }

    protected int maxClausesRowIdsForURIs(String outputConnectionName) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
    }

    protected void findRowIdsForURIs(String outputConnectionName, Set<Long> rowIDSet, Set<String> uris, List<String> hashParamValues) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(uriHashField, hashParamValues), new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
        IResultSet set = this.performQuery("SELECT id,docuri FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            String docURI = (String)row.getValue(docURIField);
            if (docURI == null || docURI.length() <= 0 || !uris.contains(docURI)) continue;
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.add(rowID);
        }
    }

    protected int maxClausesRowIdsForDocIds(String outputConnectionName) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
    }

    protected int maxClausesRowIdsForDocIds(String outputConnectionName, String componentHash) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName), componentHash == null || componentHash.length() == 0 ? new NullCheckClause(componentHashField, true) : new UnitaryClause(componentHashField, (Object)componentHash)});
    }

    protected int maxClausesRowIdsForDocIds(String[] outputConnectionNames) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
    }

    protected void findRowIdsForDocIds(String outputConnectionName, Set<Long> rowIDSet, List<String> paramValues) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(docKeyField, paramValues), new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.add(rowID);
        }
    }

    protected void findRowIdsForDocIds(String outputConnectionName, Set<Long> rowIDSet, List<String> paramValues, String componentHash) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(docKeyField, paramValues), new UnitaryClause(outputConnNameField, (Object)outputConnectionName), componentHash == null || componentHash.length() == 0 ? new NullCheckClause(componentHashField, true) : new UnitaryClause(componentHashField, (Object)componentHash)});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.add(rowID);
        }
    }

    protected void findRowIdsForDocIds(String[] outputConnectionNames, Set<Long> rowIDSet, List<String> paramValues) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(docKeyField, paramValues), new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
        IResultSet set = this.performQuery("SELECT id FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            Long rowID = (Long)row.getValue(idField);
            rowIDSet.add(rowID);
        }
    }

    protected int maxClausesDeleteRowIds() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void deleteRowIds(List<Long> list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(idField, list)});
        this.performDelete("WHERE " + query, newList, null);
    }

    @Override
    public void documentDelete(IPipelineConnections pipelineConnections, String identifierClass, String identifierHash, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.documentDeleteMultiple(pipelineConnections, new String[]{identifierClass}, new String[]{identifierHash}, activities);
    }

    protected List<DeleteInfo> getDocumentURIMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        ArrayList<DeleteInfo> rval = new ArrayList<DeleteInfo>();
        this.beginTransaction();
        try {
            ArrayList<String> list = new ArrayList<String>();
            int maxCount = this.maxClauseDocumentURIChunk(outputConnectionName);
            int j = 0;
            for (int i = 0; i < identifierHashes.length; ++i) {
                if (j == maxCount) {
                    this.getDocumentURIChunk(rval, outputConnectionName, list);
                    j = 0;
                    list.clear();
                }
                list.add(IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]));
                ++j;
            }
            if (j > 0) {
                this.getDocumentURIChunk(rval, outputConnectionName, list);
            }
            ArrayList<DeleteInfo> arrayList = rval;
            return arrayList;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected List<DeleteInfo> getDocumentURIMultiple(String outputConnectionName, String[] identifierClasses, String[] identifierHashes, String componentHash) throws ManifoldCFException {
        ArrayList<DeleteInfo> rval = new ArrayList<DeleteInfo>();
        this.beginTransaction();
        try {
            ArrayList<String> list = new ArrayList<String>();
            int maxCount = this.maxClauseDocumentURIChunk(outputConnectionName, componentHash);
            int j = 0;
            for (int i = 0; i < identifierHashes.length; ++i) {
                if (j == maxCount) {
                    this.getDocumentURIChunk(rval, outputConnectionName, list, componentHash);
                    j = 0;
                    list.clear();
                }
                list.add(IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]));
                ++j;
            }
            if (j > 0) {
                this.getDocumentURIChunk(rval, outputConnectionName, list, componentHash);
            }
            ArrayList<DeleteInfo> arrayList = rval;
            return arrayList;
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void getPipelineDocumentIngestDataMultiple(IngestStatuses rval, IPipelineSpecificationBasic[] pipelineSpecificationBasics, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        List list;
        HashMap keyMap = new HashMap();
        for (int i = 0; i < pipelineSpecificationBasics.length; ++i) {
            IPipelineSpecificationBasic spec = pipelineSpecificationBasics[i];
            list = (ArrayList<Integer>)keyMap.get(spec);
            if (list == null) {
                list = new ArrayList<Integer>();
                keyMap.put(spec, list);
            }
            list.add(new Integer(i));
        }
        for (IPipelineSpecificationBasic spec : keyMap.keySet()) {
            list = (List)keyMap.get(spec);
            String[] localIdentifierClasses = new String[list.size()];
            String[] localIdentifierHashes = new String[list.size()];
            for (int i = 0; i < localIdentifierClasses.length; ++i) {
                int index = (Integer)list.get(i);
                localIdentifierClasses[i] = identifierClasses[index];
                localIdentifierHashes[i] = identifierHashes[index];
            }
            this.getPipelineDocumentIngestDataMultiple(rval, spec, localIdentifierClasses, localIdentifierHashes);
        }
    }

    @Override
    public void getPipelineDocumentIngestDataMultiple(IngestStatuses rval, IPipelineSpecificationBasic pipelineSpecificationBasic, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        String[] outputConnectionNames = IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationBasic);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (int i = 0; i < identifierHashes.length; ++i) {
            indexMap.put(IncrementalIngester.makeKey(identifierClasses[i], identifierHashes[i]), new Integer(i));
        }
        this.beginTransaction();
        try {
            ArrayList<String> list = new ArrayList<String>();
            int maxCount = this.maxClausePipelineDocumentIngestDataChunk(outputConnectionNames);
            int j = 0;
            Iterator iter = indexMap.keySet().iterator();
            while (iter.hasNext()) {
                if (j == maxCount) {
                    this.getPipelineDocumentIngestDataChunk(rval, indexMap, outputConnectionNames, list, identifierClasses, identifierHashes);
                    j = 0;
                    list.clear();
                }
                list.add((String)iter.next());
                ++j;
            }
            if (j > 0) {
                this.getPipelineDocumentIngestDataChunk(rval, indexMap, outputConnectionNames, list, identifierClasses, identifierHashes);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void getPipelineDocumentIngestDataChunk(IngestStatuses rval, Map<String, Integer> map, String[] outputConnectionNames, List<String> list, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(docKeyField, list), new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
        IResultSet set = this.performQuery("SELECT id,connectionname,dockey,componenthash,lastversion,lastoutputversion,authorityname,forcedparams,lasttransformationversion FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            String authorityName;
            String paramVersion;
            String lastOutputVersion;
            String lastTransformationVersion;
            IResultRow row = set.getRow(i);
            String docHash = row.getValue(docKeyField).toString();
            Integer position = map.get(docHash);
            if (position == null) continue;
            Long id = (Long)row.getValue(idField);
            String outputConnectionName = (String)row.getValue(outputConnNameField);
            String componentHash = (String)row.getValue(componentHashField);
            String lastVersion = (String)row.getValue(lastVersionField);
            if (lastVersion == null) {
                lastVersion = "";
            }
            if ((lastTransformationVersion = (String)row.getValue(lastTransformationVersionField)) == null) {
                lastTransformationVersion = "";
            }
            if ((lastOutputVersion = (String)row.getValue(lastOutputVersionField)) == null) {
                lastOutputVersion = "";
            }
            if ((paramVersion = (String)row.getValue(forcedParamsField)) == null) {
                paramVersion = "";
            }
            if ((authorityName = (String)row.getValue(authorityNameField)) == null) {
                authorityName = "";
            }
            int indexValue = position;
            rval.addStatus(identifierClasses[indexValue], identifierHashes[indexValue], outputConnectionName, componentHash, new DocumentIngestStatus(lastVersion, lastTransformationVersion, lastOutputVersion, paramVersion, authorityName));
        }
    }

    @Override
    public void getPipelineDocumentIngestData(IngestStatuses rval, IPipelineSpecificationBasic pipelineSpecificationBasic, String identifierClass, String identifierHash) throws ManifoldCFException {
        this.getPipelineDocumentIngestDataMultiple(rval, pipelineSpecificationBasic, new String[]{identifierClass}, new String[]{identifierHash});
    }

    @Override
    public long[] getDocumentUpdateIntervalMultiple(IPipelineSpecificationBasic pipelineSpecificationBasic, String[] identifierClasses, String[] identifierHashes) throws ManifoldCFException {
        String[] outputConnectionNames = IncrementalIngester.extractOutputConnectionNames(pipelineSpecificationBasic);
        long[] rval = new long[identifierHashes.length];
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        HashSet<String> idCodes = new HashSet<String>();
        for (int j = 0; j < identifierHashes.length; ++j) {
            String key = IncrementalIngester.makeKey(identifierClasses[j], identifierHashes[j]);
            rval[j] = Long.MAX_VALUE;
            returnMap.put(key, new Integer(j));
            idCodes.add(key);
        }
        int maxClause = this.maxClauseGetIntervals(outputConnectionNames);
        Iterator iter = idCodes.iterator();
        ArrayList<String> list = new ArrayList<String>();
        int j = 0;
        while (iter.hasNext()) {
            if (j == maxClause) {
                this.getIntervals(rval, outputConnectionNames, list, returnMap);
                list.clear();
                j = 0;
            }
            list.add((String)iter.next());
            ++j;
        }
        if (j > 0) {
            this.getIntervals(rval, outputConnectionNames, list, returnMap);
        }
        for (int i = 0; i < rval.length; ++i) {
            if (rval[i] != Long.MAX_VALUE) continue;
            rval[i] = 0L;
        }
        return rval;
    }

    @Override
    public long getDocumentUpdateInterval(IPipelineSpecificationBasic pipelineSpecificationBasic, String identifierClass, String identifierHash) throws ManifoldCFException {
        return this.getDocumentUpdateIntervalMultiple(pipelineSpecificationBasic, new String[]{identifierClass}, new String[]{identifierHash})[0];
    }

    protected int maxClauseGetIntervals(String[] outputConnectionNames) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
    }

    protected void getIntervals(long[] rval, String[] outputConnectionNames, List<String> list, Map<String, Integer> returnMap) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(docKeyField, list), new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
        IResultSet set = this.performQuery("SELECT dockey,changecount,firstingest,lastingest FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            int indexValue;
            IResultRow row = set.getRow(i);
            String docHash = (String)row.getValue(docKeyField);
            Integer index = returnMap.get(docHash);
            if (index == null) continue;
            long changeCount = (Long)row.getValue(changeCountField);
            long firstIngest = (Long)row.getValue(firstIngestField);
            long lastIngest = (Long)row.getValue(lastIngestField);
            long newValue = (long)((double)(lastIngest - firstIngest) / (double)changeCount);
            if (newValue >= rval[indexValue = index.intValue()]) continue;
            rval[indexValue] = newValue;
        }
    }

    @Override
    public void resetOutputConnection(IOutputConnection outputConnection) throws ManifoldCFException {
        if (outputConnection == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(lastVersionField, null);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnection.getName())});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutputConnection(IOutputConnection outputConnection) throws ManifoldCFException {
        if (outputConnection == null) {
            return;
        }
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnection.getName())});
        this.performDelete("WHERE " + query, list, null);
        IOutputConnector connector = this.outputConnectorPool.grab(outputConnection);
        if (connector == null) {
            return;
        }
        try {
            connector.noteAllRecordsRemoved();
        }
        finally {
            this.outputConnectorPool.release(outputConnection, connector);
        }
    }

    protected void noteDocumentIngest(String outputConnectionName, String docKey, String componentHash, String documentVersion, String transformationVersion, String outputVersion, String packedForcedParameters, String authorityNameString, long ingestTime, String documentURI, String documentURIHash) throws ManifoldCFException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (true) {
            map.clear();
            if (componentHash != null) {
                map.put(componentHashField, componentHash);
            }
            map.put(lastVersionField, documentVersion);
            map.put(lastTransformationVersionField, transformationVersion);
            map.put(lastOutputVersionField, outputVersion);
            map.put(forcedParamsField, packedForcedParameters);
            map.put(lastIngestField, new Long(ingestTime));
            if (documentURI != null) {
                map.put(docURIField, documentURI);
                map.put(uriHashField, documentURIHash);
            }
            if (authorityNameString != null) {
                map.put(authorityNameField, authorityNameString);
            } else {
                map.put(authorityNameField, "");
            }
            while (true) {
                long sleepAmt = 0L;
                this.beginTransaction();
                try {
                    ArrayList list = new ArrayList();
                    String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(docKeyField, (Object)docKey), new UnitaryClause(outputConnNameField, (Object)outputConnectionName), componentHash == null ? new NullCheckClause(componentHashField, true) : new UnitaryClause(componentHashField, (Object)componentHash)});
                    IResultSet set = this.performQuery("SELECT id,changecount FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
                    IResultRow row = null;
                    if (set.getRowCount() > 0) {
                        row = set.getRow(0);
                    }
                    if (row != null) {
                        list.clear();
                        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, row.getValue(idField))});
                        long changeCount = (Long)row.getValue(changeCountField);
                        map.put(changeCountField, new Long(++changeCount));
                        this.performUpdate(map, "WHERE " + query, list, null);
                        this.performCommit();
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    this.signalRollback();
                    if (e.getErrorCode() == 6) {
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted transaction noting ingestion: " + e.getMessage()));
                        }
                        sleepAmt = this.getSleepAmt();
                        continue;
                    }
                    throw e;
                }
                catch (Error e) {
                    this.signalRollback();
                    throw e;
                }
                finally {
                    this.endTransaction();
                    this.sleepFor(sleepAmt);
                    continue;
                }
                break;
            }
            map.clear();
            if (componentHash != null) {
                map.put(componentHashField, componentHash);
            }
            map.put(lastVersionField, documentVersion);
            map.put(lastTransformationVersionField, transformationVersion);
            map.put(lastOutputVersionField, outputVersion);
            map.put(forcedParamsField, packedForcedParameters);
            map.put(lastIngestField, new Long(ingestTime));
            if (documentURI != null) {
                map.put(docURIField, documentURI);
                map.put(uriHashField, documentURIHash);
            }
            if (authorityNameString != null) {
                map.put(authorityNameField, authorityNameString);
            } else {
                map.put(authorityNameField, "");
            }
            Long id = new Long(IDFactory.make((IThreadContext)this.threadContext));
            map.put(idField, id);
            map.put(outputConnNameField, outputConnectionName);
            map.put(docKeyField, docKey);
            map.put(changeCountField, new Long(1L));
            map.put(firstIngestField, map.get(lastIngestField));
            this.beginTransaction();
            try {
                this.performInsert(map, null);
                this.noteModifications(1, 0, 0);
                this.performCommit();
                return;
            }
            catch (ManifoldCFException e) {
                this.signalRollback();
                if (e.getErrorCode() == 6) continue;
                throw e;
            }
            catch (Error e) {
                this.signalRollback();
                throw e;
            }
            finally {
                this.endTransaction();
                continue;
            }
            break;
        }
    }

    protected int maxClauseDocumentURIChunk(String outputConnectionName) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
    }

    protected void getDocumentURIChunk(List<DeleteInfo> rval, String outputConnectionName, List<String> list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(docKeyField, list), new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
        IResultSet set = this.performQuery("SELECT dockey,docuri,urihash,lastoutputversion FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            String lastURIHash;
            IResultRow row = set.getRow(i);
            String lastURI = (String)row.getValue(docURIField);
            if (lastURI != null && lastURI.length() == 0) {
                lastURI = null;
            }
            if ((lastURIHash = (String)row.getValue(uriHashField)) != null && lastURIHash.length() == 0) {
                lastURIHash = null;
            }
            String lastOutputVersion = (String)row.getValue(lastOutputVersionField);
            rval.add(new DeleteInfo(lastURI, lastURIHash, lastOutputVersion));
        }
    }

    protected int maxClauseDocumentURIChunk(String outputConnectionName, String componentHash) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName), componentHash == null ? new NullCheckClause(componentHashField, true) : new UnitaryClause(componentHashField, (Object)componentHash)});
    }

    protected void getDocumentURIChunk(List<DeleteInfo> rval, String outputConnectionName, List<String> list, String componentHash) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new MultiClause(docKeyField, list), new UnitaryClause(outputConnNameField, (Object)outputConnectionName), componentHash == null ? new NullCheckClause(componentHashField, true) : new UnitaryClause(componentHashField, (Object)componentHash)});
        IResultSet set = this.performQuery("SELECT dockey,docuri,urihash,lastoutputversion FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            String lastURIHash;
            IResultRow row = set.getRow(i);
            String lastURI = (String)row.getValue(docURIField);
            if (lastURI != null && lastURI.length() == 0) {
                lastURI = null;
            }
            if ((lastURIHash = (String)row.getValue(uriHashField)) != null && lastURIHash.length() == 0) {
                lastURIHash = null;
            }
            String lastOutputVersion = (String)row.getValue(lastOutputVersionField);
            rval.add(new DeleteInfo(lastURI, lastURIHash, lastOutputVersion));
        }
    }

    protected int maxClauseDocumentIngestDataChunk(String outputConnectionName) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(outputConnNameField, (Object)outputConnectionName)});
    }

    protected int maxClausePipelineDocumentIngestDataChunk(String[] outputConnectionNames) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new MultiClause(outputConnNameField, (Object[])outputConnectionNames)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocument(IOutputConnection connection, String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        IOutputConnector connector = this.outputConnectorPool.grab(connection);
        if (connector == null) {
            throw new ServiceInterruption("Output connector not installed", 0L);
        }
        try {
            connector.removeDocument(documentURI, outputDescription, activities);
        }
        finally {
            this.outputConnectorPool.release(connection, connector);
        }
    }

    protected static String makeKey(String documentClass, String documentHash) {
        return documentClass + ":" + documentHash;
    }

    protected static String[] computeLockArray(String documentURIHash, String oldURIHash, String outputConnectionName) {
        int uriCount = 0;
        if (documentURIHash != null) {
            ++uriCount;
        }
        if (!(oldURIHash == null || documentURIHash != null && documentURIHash.equals(oldURIHash))) {
            ++uriCount;
        }
        String[] lockArray = new String[uriCount];
        uriCount = 0;
        if (documentURIHash != null) {
            lockArray[uriCount++] = IncrementalIngester.createURILockName(outputConnectionName, documentURIHash);
        }
        if (!(oldURIHash == null || documentURIHash != null && documentURIHash.equals(oldURIHash))) {
            lockArray[uriCount++] = IncrementalIngester.createURILockName(outputConnectionName, oldURIHash);
        }
        return lockArray;
    }

    protected static class MonitoredAddActivityWrapper
    implements IOutputAddActivity {
        protected final IOutputAddActivity activities;
        protected boolean documentProcessed = false;

        public MonitoredAddActivityWrapper(IOutputAddActivity activities) {
            this.activities = activities;
        }

        public boolean wasDocumentActedUpon() {
            return this.documentProcessed;
        }

        @Override
        public int sendDocument(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            if (this.documentProcessed) {
                throw new IllegalStateException("Document cannot have multiple dispositions");
            }
            int rval = this.activities.sendDocument(documentURI, document);
            this.documentProcessed = true;
            return rval;
        }

        @Override
        public void noDocument() throws ManifoldCFException, ServiceInterruption {
            if (this.documentProcessed) {
                throw new IllegalStateException("Document cannot have multiple dispositions");
            }
            this.activities.noDocument();
            this.documentProcessed = true;
        }

        @Override
        public String qualifyAccessToken(String authorityNameString, String accessToken) throws ManifoldCFException {
            return this.activities.qualifyAccessToken(authorityNameString, accessToken);
        }

        @Override
        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.activities.recordActivity(startTime, activityType, dataSize, entityURI, resultCode, resultDescription);
        }

        @Override
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return this.activities.checkDateIndexable(date);
        }

        @Override
        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.activities.checkMimeTypeIndexable(mimeType);
        }

        @Override
        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.activities.checkDocumentIndexable(localFile);
        }

        @Override
        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return this.activities.checkLengthIndexable(length);
        }

        @Override
        public boolean checkURLIndexable(String url) throws ManifoldCFException, ServiceInterruption {
            return this.activities.checkURLIndexable(url);
        }
    }

    public class OutputAddEntryPoint
    extends PipelineAddEntryPoint {
        protected final IOutputConnector outputConnector;
        protected final String outputConnectionName;
        protected final String transformationVersion;
        protected final long ingestTime;
        protected final String documentVersion;
        protected final String parameterVersion;
        protected final String docKey;
        protected final String componentHash;
        protected final IOutputActivity activity;

        public OutputAddEntryPoint(IOutputConnector outputConnector, VersionContext outputDescriptionString, IOutputActivity activity, boolean isActive, String outputConnectionName, String transformationVersion, long ingestTime, String documentVersion, String parameterVersion, String docKey, String componentHash, String authorityNameString) {
            super(outputConnector, outputDescriptionString, authorityNameString, activity, isActive);
            this.outputConnector = outputConnector;
            this.outputConnectionName = outputConnectionName;
            this.transformationVersion = transformationVersion;
            this.ingestTime = ingestTime;
            this.documentVersion = documentVersion;
            this.parameterVersion = parameterVersion;
            this.docKey = docKey;
            this.componentHash = componentHash;
            this.activity = activity;
        }

        @Override
        public void noDocument() throws ManifoldCFException, ServiceInterruption {
            try {
                this.addOrReplaceDocumentWithException(null, null);
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected IOException: " + e.getMessage(), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addOrReplaceDocumentWithException(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            String documentURIHash = null;
            if (documentURI != null) {
                documentURIHash = ManifoldCF.hash((String)documentURI);
            }
            String oldURI = null;
            String oldURIHash = null;
            String oldOutputVersion = null;
            while (true) {
                long sleepAmt = 0L;
                try {
                    ArrayList list = new ArrayList();
                    String query = IncrementalIngester.this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(IncrementalIngester.docKeyField, (Object)this.docKey), new UnitaryClause(IncrementalIngester.outputConnNameField, (Object)this.outputConnectionName), this.componentHash == null || this.componentHash.length() == 0 ? new NullCheckClause(IncrementalIngester.componentHashField, true) : new UnitaryClause(IncrementalIngester.componentHashField, (Object)this.componentHash)});
                    IResultSet set = IncrementalIngester.this.performQuery("SELECT docuri,urihash,lastoutputversion FROM " + IncrementalIngester.this.getTableName() + " WHERE " + query, list, null, null);
                    if (set.getRowCount() <= 0) break;
                    IResultRow row = set.getRow(0);
                    oldURI = (String)row.getValue(IncrementalIngester.docURIField);
                    oldURIHash = (String)row.getValue(IncrementalIngester.uriHashField);
                    oldOutputVersion = (String)row.getValue(IncrementalIngester.lastOutputVersionField);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 6) {
                        if (Logging.perf.isDebugEnabled()) {
                            Logging.perf.debug((Object)("Aborted select looking for status: " + e.getMessage()));
                        }
                        sleepAmt = IncrementalIngester.this.getSleepAmt();
                        continue;
                    }
                    throw e;
                }
                finally {
                    IncrementalIngester.this.sleepFor(sleepAmt);
                    continue;
                }
                break;
            }
            String[] lockArray = IncrementalIngester.computeLockArray(documentURIHash, oldURIHash, this.outputConnectionName);
            IncrementalIngester.this.lockManager.enterLocks(null, null, lockArray);
            try {
                String query;
                ArrayList<String> list = new ArrayList<String>();
                if (!(oldURI == null || documentURI != null && oldURI.equals(documentURI))) {
                    list.clear();
                    query = IncrementalIngester.this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(IncrementalIngester.uriHashField, "=", (Object)oldURIHash), new UnitaryClause(IncrementalIngester.outputConnNameField, (Object)this.outputConnectionName)});
                    list.add(this.docKey);
                    IncrementalIngester.this.performDelete("WHERE " + query + " AND " + IncrementalIngester.docKeyField + "!=?", list, null);
                    this.outputConnector.removeDocument(oldURI, oldOutputVersion, this.activity);
                }
                if (documentURI != null) {
                    list.clear();
                    query = IncrementalIngester.this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(IncrementalIngester.uriHashField, "=", (Object)documentURIHash), new UnitaryClause(IncrementalIngester.outputConnNameField, (Object)this.outputConnectionName)});
                    list.add(this.docKey);
                    IncrementalIngester.this.performDelete("WHERE " + query + " AND " + IncrementalIngester.docKeyField + "!=?", list, null);
                    IncrementalIngester.this.noteDocumentIngest(this.outputConnectionName, this.docKey, this.componentHash, null, null, null, null, null, this.ingestTime, documentURI, documentURIHash);
                    int result = super.addOrReplaceDocumentWithException(documentURI, document);
                    IncrementalIngester.this.noteDocumentIngest(this.outputConnectionName, this.docKey, this.componentHash, this.documentVersion, this.transformationVersion, this.pipelineDescriptionString.getVersionString(), this.parameterVersion, this.authorityNameString, this.ingestTime, documentURI, documentURIHash);
                    int n = result;
                    return n;
                }
                IncrementalIngester.this.noteDocumentIngest(this.outputConnectionName, this.docKey, this.componentHash, this.documentVersion, this.transformationVersion, this.pipelineDescriptionString.getVersionString(), this.parameterVersion, this.authorityNameString, this.ingestTime, null, null);
                int n = 0;
                return n;
            }
            finally {
                IncrementalIngester.this.lockManager.leaveLocks(null, null, lockArray);
            }
        }
    }

    public static class PipelineAddEntryPoint {
        protected final IPipelineConnector pipelineConnector;
        protected final VersionContext pipelineDescriptionString;
        protected final String authorityNameString;
        protected final IOutputAddActivity addActivity;
        protected final boolean isActive;

        public PipelineAddEntryPoint(IPipelineConnector pipelineConnector, VersionContext pipelineDescriptionString, String authorityNameString, IOutputAddActivity addActivity, boolean isActive) {
            this.pipelineConnector = pipelineConnector;
            this.pipelineDescriptionString = pipelineDescriptionString;
            this.authorityNameString = authorityNameString;
            this.addActivity = addActivity;
            this.isActive = isActive;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkDateIndexable(this.pipelineDescriptionString, date, this.addActivity);
        }

        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkMimeTypeIndexable(this.pipelineDescriptionString, mimeType, this.addActivity);
        }

        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkDocumentIndexable(this.pipelineDescriptionString, localFile, this.addActivity);
        }

        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkLengthIndexable(this.pipelineDescriptionString, length, this.addActivity);
        }

        public boolean checkURLIndexable(String uri) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkURLIndexable(this.pipelineDescriptionString, uri, this.addActivity);
        }

        public int addOrReplaceDocumentWithException(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            MonitoredAddActivityWrapper wrapper = new MonitoredAddActivityWrapper(this.addActivity);
            int rval = this.pipelineConnector.addOrReplaceDocumentWithException(documentURI, this.pipelineDescriptionString, document, this.authorityNameString, wrapper);
            if (!wrapper.wasDocumentActedUpon()) {
                this.addActivity.noDocument();
            }
            return rval;
        }

        public void noDocument() throws ManifoldCFException, ServiceInterruption {
            this.addActivity.noDocument();
        }
    }

    public static class PipelineAddFanout
    implements IOutputAddActivity {
        protected final PipelineAddEntryPoint[] entryPoints;
        protected final IOutputHistoryActivity finalHistoryActivity;
        protected final IOutputQualifyActivity finalQualifyActivity;

        public PipelineAddFanout(PipelineAddEntryPoint[] entryPoints, IOutputHistoryActivity finalHistoryActivity, IOutputQualifyActivity finalQualifyActivity) {
            this.entryPoints = entryPoints;
            this.finalHistoryActivity = finalHistoryActivity;
            this.finalQualifyActivity = finalQualifyActivity;
        }

        public boolean checkNeedToReindex() {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.isActive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.checkDateIndexable(date)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.checkMimeTypeIndexable(mimeType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.checkDocumentIndexable(localFile)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.checkLengthIndexable(length)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkURLIndexable(String uri) throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.checkURLIndexable(uri)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sendDocument(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            int activeCount = 0;
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.isActive()) continue;
                ++activeCount;
            }
            if (activeCount <= 1) {
                int rval = 1;
                for (PipelineAddEntryPoint p : this.entryPoints) {
                    if (!p.isActive() || p.addOrReplaceDocumentWithException(documentURI, document) != 0) continue;
                    rval = 0;
                }
                return rval;
            }
            try (RepositoryDocumentFactory factory = new RepositoryDocumentFactory(document);){
                int rval = 1;
                for (PipelineAddEntryPoint p : this.entryPoints) {
                    if (!p.isActive() || p.addOrReplaceDocumentWithException(documentURI, factory.createDocument()) != 0) continue;
                    rval = 0;
                }
                int n = rval;
                return n;
            }
        }

        @Override
        public void noDocument() throws ManifoldCFException, ServiceInterruption {
            for (PipelineAddEntryPoint p : this.entryPoints) {
                if (!p.isActive()) continue;
                p.noDocument();
            }
        }

        @Override
        public String qualifyAccessToken(String authorityNameString, String accessToken) throws ManifoldCFException {
            return this.finalQualifyActivity.qualifyAccessToken(authorityNameString, accessToken);
        }

        @Override
        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.finalHistoryActivity.recordActivity(startTime, activityType, dataSize, entityURI, resultCode, resultDescription);
        }
    }

    public static class PipelineCheckEntryPoint {
        protected final IPipelineConnector pipelineConnector;
        protected final VersionContext pipelineDescriptionString;
        protected final IOutputCheckActivity checkActivity;

        public PipelineCheckEntryPoint(IPipelineConnector pipelineConnector, VersionContext pipelineDescriptionString, IOutputCheckActivity checkActivity) {
            this.pipelineConnector = pipelineConnector;
            this.pipelineDescriptionString = pipelineDescriptionString;
            this.checkActivity = checkActivity;
        }

        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkDateIndexable(this.pipelineDescriptionString, date, this.checkActivity);
        }

        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkMimeTypeIndexable(this.pipelineDescriptionString, mimeType, this.checkActivity);
        }

        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkDocumentIndexable(this.pipelineDescriptionString, localFile, this.checkActivity);
        }

        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkLengthIndexable(this.pipelineDescriptionString, length, this.checkActivity);
        }

        public boolean checkURLIndexable(String uri) throws ManifoldCFException, ServiceInterruption {
            return this.pipelineConnector.checkURLIndexable(this.pipelineDescriptionString, uri, this.checkActivity);
        }
    }

    public static class PipelineCheckFanout
    implements IOutputCheckActivity {
        protected final PipelineCheckEntryPoint[] entryPoints;

        public PipelineCheckFanout(PipelineCheckEntryPoint[] entryPoints) {
            this.entryPoints = entryPoints;
        }

        @Override
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            for (PipelineCheckEntryPoint p : this.entryPoints) {
                if (!p.checkDateIndexable(date)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            for (PipelineCheckEntryPoint p : this.entryPoints) {
                if (!p.checkMimeTypeIndexable(mimeType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            for (PipelineCheckEntryPoint p : this.entryPoints) {
                if (!p.checkDocumentIndexable(localFile)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            for (PipelineCheckEntryPoint p : this.entryPoints) {
                if (!p.checkLengthIndexable(length)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean checkURLIndexable(String uri) throws ManifoldCFException, ServiceInterruption {
            for (PipelineCheckEntryPoint p : this.entryPoints) {
                if (!p.checkURLIndexable(uri)) continue;
                return true;
            }
            return false;
        }
    }

    protected class PipelineObjectWithVersions
    extends PipelineObject {
        protected final IPipelineSpecificationWithVersions pipelineSpecificationWithVersions;

        public PipelineObjectWithVersions(IPipelineSpecificationWithVersions pipelineSpecificationWithVersions, ITransformationConnector[] transformationConnectors, IOutputConnector[] outputConnectors) {
            super(pipelineSpecificationWithVersions, transformationConnectors, outputConnectors);
            this.pipelineSpecificationWithVersions = pipelineSpecificationWithVersions;
        }

        public int addOrReplaceDocumentWithException(String docKey, String componentHash, String documentURI, RepositoryDocument document, String newDocumentVersion, String newParameterVersion, String authorityNameString, IOutputActivity finalActivity, long ingestTime) throws ManifoldCFException, ServiceInterruption, IOException {
            PipelineAddFanout entryPoint = this.buildAddPipeline(finalActivity, newDocumentVersion, newParameterVersion, authorityNameString, ingestTime, docKey, componentHash);
            return entryPoint.sendDocument(documentURI, document);
        }

        public void noDocument(String docKey, String componentHash, String newDocumentVersion, String newParameterVersion, String authorityNameString, IOutputActivity finalActivity, long ingestTime) throws ManifoldCFException, ServiceInterruption {
            PipelineAddFanout entryPoint = this.buildAddPipeline(finalActivity, newDocumentVersion, newParameterVersion, authorityNameString, ingestTime, docKey, componentHash);
            entryPoint.noDocument();
        }

        protected PipelineAddFanout buildAddPipeline(IOutputActivity finalActivity, String newDocumentVersion, String newParameterVersion, String newAuthorityNameString, long ingestTime, String docKey, String componentHash) {
            HashMap<Integer, PipelineAddEntryPoint> currentSet = new HashMap<Integer, PipelineAddEntryPoint>();
            IPipelineSpecificationWithVersions fullSpec = this.pipelineSpecificationWithVersions;
            int outputCount = fullSpec.getOutputCount();
            for (int i = 0; i < outputCount; ++i) {
                boolean needToReindex;
                int outputStage = fullSpec.getOutputStage(i);
                String oldDocumentVersion = fullSpec.getOutputDocumentVersionString(i);
                String oldParameterVersion = fullSpec.getOutputParameterVersionString(i);
                String oldOutputVersion = fullSpec.getOutputVersionString(i);
                String oldTransformationVersion = fullSpec.getOutputTransformationVersionString(i);
                String oldAuthorityName = fullSpec.getAuthorityNameString(i);
                String newTransformationVersion = IncrementalIngester.computePackedTransformationVersion(fullSpec, outputStage);
                boolean bl = needToReindex = oldDocumentVersion == null;
                if (!needToReindex) {
                    boolean bl2 = !oldDocumentVersion.equals(newDocumentVersion) || !oldParameterVersion.equals(newParameterVersion) || !oldOutputVersion.equals(fullSpec.getStageDescriptionString(outputStage).getVersionString()) || !oldAuthorityName.equals(newAuthorityNameString == null ? "" : newAuthorityNameString) ? true : (needToReindex = false);
                }
                if (!needToReindex) {
                    if (oldTransformationVersion == null || oldTransformationVersion.length() == 0) {
                        oldTransformationVersion = "0+0!";
                    }
                    needToReindex = !oldTransformationVersion.equals(newTransformationVersion);
                }
                int connectionIndex = fullSpec.getOutputConnectionIndex(outputStage);
                OutputAddEntryPoint outputStageEntryPoint = new OutputAddEntryPoint(this.outputConnectors[connectionIndex], fullSpec.getStageDescriptionString(outputStage), new OutputActivitiesWrapper(finalActivity, fullSpec.getStageConnectionName(outputStage)), needToReindex, fullSpec.getStageConnectionName(outputStage), newTransformationVersion, ingestTime, newDocumentVersion, newParameterVersion, docKey, componentHash, newAuthorityNameString);
                currentSet.put(new Integer(outputStage), outputStageEntryPoint);
            }
            while (true) {
                int parent = -1;
                int[] siblings = null;
                for (Integer outputStage : currentSet.keySet()) {
                    parent = fullSpec.getStageParent(outputStage);
                    siblings = fullSpec.getStageChildren(parent);
                    boolean skipToNext = false;
                    for (int sibling : siblings) {
                        if (currentSet.get(new Integer(sibling)) != null) continue;
                        skipToNext = true;
                        break;
                    }
                    if (!skipToNext) break;
                    siblings = null;
                }
                if (siblings == null) {
                    throw new IllegalStateException("Not at root but can't progress");
                }
                PipelineAddEntryPoint[] siblingEntryPoints = new PipelineAddEntryPoint[siblings.length];
                for (int j = 0; j < siblings.length; ++j) {
                    siblingEntryPoints[j] = (PipelineAddEntryPoint)currentSet.remove(new Integer(siblings[j]));
                }
                PipelineAddFanout pcf = new PipelineAddFanout(siblingEntryPoints, parent == -1 ? null : new TransformationRecordingActivity(finalActivity, fullSpec.getStageConnectionName(parent)), finalActivity);
                if (parent == -1) {
                    return pcf;
                }
                PipelineAddEntryPoint newEntry = new PipelineAddEntryPoint(this.transformationConnectors[fullSpec.getTransformationConnectionIndex(parent)], fullSpec.getStageDescriptionString(parent), newAuthorityNameString, pcf, pcf.checkNeedToReindex());
                currentSet.put(new Integer(parent), newEntry);
            }
        }
    }

    protected class PipelineObject {
        public final IPipelineSpecification pipelineConnections;
        public final IOutputConnector[] outputConnectors;
        public final ITransformationConnector[] transformationConnectors;

        public PipelineObject(IPipelineSpecification pipelineConnections, ITransformationConnector[] transformationConnectors, IOutputConnector[] outputConnectors) {
            this.pipelineConnections = pipelineConnections;
            this.transformationConnectors = transformationConnectors;
            this.outputConnectors = outputConnectors;
        }

        public boolean checkDateIndexable(Date date, IOutputCheckActivity finalActivity) throws ManifoldCFException, ServiceInterruption {
            PipelineCheckFanout entryPoint = this.buildCheckPipeline(finalActivity);
            return entryPoint.checkDateIndexable(date);
        }

        public boolean checkMimeTypeIndexable(String mimeType, IOutputCheckActivity finalActivity) throws ManifoldCFException, ServiceInterruption {
            PipelineCheckFanout entryPoint = this.buildCheckPipeline(finalActivity);
            return entryPoint.checkMimeTypeIndexable(mimeType);
        }

        public boolean checkDocumentIndexable(File localFile, IOutputCheckActivity finalActivity) throws ManifoldCFException, ServiceInterruption {
            PipelineCheckFanout entryPoint = this.buildCheckPipeline(finalActivity);
            return entryPoint.checkDocumentIndexable(localFile);
        }

        public boolean checkLengthIndexable(long length, IOutputCheckActivity finalActivity) throws ManifoldCFException, ServiceInterruption {
            PipelineCheckFanout entryPoint = this.buildCheckPipeline(finalActivity);
            return entryPoint.checkLengthIndexable(length);
        }

        public boolean checkURLIndexable(String uri, IOutputCheckActivity finalActivity) throws ManifoldCFException, ServiceInterruption {
            PipelineCheckFanout entryPoint = this.buildCheckPipeline(finalActivity);
            return entryPoint.checkURLIndexable(uri);
        }

        public void release() throws ManifoldCFException {
            IncrementalIngester.this.outputConnectorPool.releaseMultiple(this.pipelineConnections.getOutputConnections(), this.outputConnectors);
            IncrementalIngester.this.transformationConnectorPool.releaseMultiple(this.pipelineConnections.getTransformationConnections(), this.transformationConnectors);
        }

        protected PipelineCheckFanout buildCheckPipeline(IOutputCheckActivity finalActivity) {
            HashMap<Integer, PipelineCheckEntryPoint> currentSet = new HashMap<Integer, PipelineCheckEntryPoint>();
            int count = this.pipelineConnections.getOutputCount();
            for (int i = 0; i < count; ++i) {
                int outputStage = this.pipelineConnections.getOutputStage(i);
                PipelineCheckEntryPoint outputStageEntryPoint = new PipelineCheckEntryPoint(this.outputConnectors[this.pipelineConnections.getOutputConnectionIndex(outputStage)], this.pipelineConnections.getStageDescriptionString(outputStage), finalActivity);
                currentSet.put(new Integer(outputStage), outputStageEntryPoint);
            }
            while (true) {
                int parent = -1;
                int[] siblings = null;
                for (Integer outputStage : currentSet.keySet()) {
                    parent = this.pipelineConnections.getStageParent(outputStage);
                    siblings = this.pipelineConnections.getStageChildren(parent);
                    boolean skipToNext = false;
                    for (int sibling : siblings) {
                        if (currentSet.get(new Integer(sibling)) != null) continue;
                        skipToNext = true;
                        break;
                    }
                    if (!skipToNext) break;
                    siblings = null;
                }
                if (siblings == null) {
                    throw new IllegalStateException("Not at root but can't progress");
                }
                PipelineCheckEntryPoint[] siblingEntryPoints = new PipelineCheckEntryPoint[siblings.length];
                for (int j = 0; j < siblings.length; ++j) {
                    siblingEntryPoints[j] = (PipelineCheckEntryPoint)currentSet.remove(new Integer(siblings[j]));
                }
                PipelineCheckFanout pcf = new PipelineCheckFanout(siblingEntryPoints);
                if (parent == -1) {
                    return pcf;
                }
                PipelineCheckEntryPoint newEntry = new PipelineCheckEntryPoint(this.transformationConnectors[this.pipelineConnections.getTransformationConnectionIndex(parent)], this.pipelineConnections.getStageDescriptionString(parent), pcf);
                currentSet.put(new Integer(parent), newEntry);
            }
        }
    }

    protected static class OutputActivitiesWrapper
    extends OutputAddActivitiesWrapper
    implements IOutputActivity {
        protected final IOutputActivity activities;

        public OutputActivitiesWrapper(IOutputActivity activities, String outputConnectionName) {
            super(activities, outputConnectionName);
            this.activities = activities;
        }
    }

    protected static class OutputAddActivitiesWrapper
    extends OutputRecordingActivity
    implements IOutputAddActivity {
        protected final IOutputAddActivity addActivities;

        public OutputAddActivitiesWrapper(IOutputAddActivity addActivities, String outputConnectionName) {
            super(addActivities, outputConnectionName);
            this.addActivities = addActivities;
        }

        @Override
        public String qualifyAccessToken(String authorityNameString, String accessToken) throws ManifoldCFException {
            return this.addActivities.qualifyAccessToken(authorityNameString, accessToken);
        }

        @Override
        public int sendDocument(String documentURI, RepositoryDocument document) throws ManifoldCFException, ServiceInterruption, IOException {
            return this.addActivities.sendDocument(documentURI, document);
        }

        @Override
        public void noDocument() throws ManifoldCFException, ServiceInterruption {
            this.addActivities.noDocument();
        }

        @Override
        public boolean checkDateIndexable(Date date) throws ManifoldCFException, ServiceInterruption {
            return this.addActivities.checkDateIndexable(date);
        }

        @Override
        public boolean checkMimeTypeIndexable(String mimeType) throws ManifoldCFException, ServiceInterruption {
            return this.addActivities.checkMimeTypeIndexable(mimeType);
        }

        @Override
        public boolean checkDocumentIndexable(File localFile) throws ManifoldCFException, ServiceInterruption {
            return this.addActivities.checkDocumentIndexable(localFile);
        }

        @Override
        public boolean checkLengthIndexable(long length) throws ManifoldCFException, ServiceInterruption {
            return this.addActivities.checkLengthIndexable(length);
        }

        @Override
        public boolean checkURLIndexable(String url) throws ManifoldCFException, ServiceInterruption {
            return this.addActivities.checkURLIndexable(url);
        }
    }

    protected static class OutputRemoveActivitiesWrapper
    extends OutputRecordingActivity
    implements IOutputRemoveActivity {
        protected final IOutputRemoveActivity removeActivities;

        public OutputRemoveActivitiesWrapper(IOutputRemoveActivity removeActivities, String outputConnectionName) {
            super(removeActivities, outputConnectionName);
            this.removeActivities = removeActivities;
        }
    }

    protected static class TransformationRecordingActivity
    implements IOutputHistoryActivity {
        protected final IOutputHistoryActivity activityProvider;
        protected final String transformationConnectionName;

        public TransformationRecordingActivity(IOutputHistoryActivity activityProvider, String transformationConnectionName) {
            this.activityProvider = activityProvider;
            this.transformationConnectionName = transformationConnectionName;
        }

        @Override
        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.activityProvider.recordActivity(startTime, ManifoldCF.qualifyTransformationActivityName(activityType, this.transformationConnectionName), dataSize, entityURI, resultCode, resultDescription);
        }
    }

    protected static class OutputRecordingActivity
    implements IOutputHistoryActivity {
        protected final IOutputHistoryActivity activityProvider;
        protected final String outputConnectionName;

        public OutputRecordingActivity(IOutputHistoryActivity activityProvider, String outputConnectionName) {
            this.activityProvider = activityProvider;
            this.outputConnectionName = outputConnectionName;
        }

        @Override
        public void recordActivity(Long startTime, String activityType, Long dataSize, String entityURI, String resultCode, String resultDescription) throws ManifoldCFException {
            this.activityProvider.recordActivity(startTime, ManifoldCF.qualifyOutputActivityName(activityType, this.outputConnectionName), dataSize, entityURI, resultCode, resultDescription);
        }
    }

    protected static class DeleteInfo {
        protected String uriValue;
        protected String uriHashValue;
        protected String outputVersion;

        public DeleteInfo(String uriValue, String uriHashValue, String outputVersion) {
            this.uriValue = uriValue;
            this.uriHashValue = uriHashValue;
            this.outputVersion = outputVersion;
        }

        public String getURI() {
            return this.uriValue;
        }

        public String getURIHash() {
            return this.uriHashValue;
        }

        public String getOutputVersion() {
            return this.outputVersion;
        }
    }
}

