/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.opensearchserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.opensearchserver.Messages;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerConfig;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerConnection;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerDelete;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerIndex;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerParam;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerScheduler;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerSchema;
import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerSpecs;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class OpenSearchServerConnector
extends BaseOutputConnector {
    private static final String OPENSEARCHSERVER_INDEXATION_ACTIVITY = "Indexation";
    private static final String OPENSEARCHSERVER_DELETION_ACTIVITY = "Deletion";
    private static final String OPENSEARCHSERVER_SCHEDULER_ACTIVITY = "Scheduler";
    private static final String[] OPENSEARCHSERVER_ACTIVITIES = new String[]{"Indexation", "Deletion", "Scheduler"};
    private static final String OPENSEARCHSERVER_TAB_MESSAGE = "OpenSearchServerConnector.OpenSearchServer";
    private static final String PARAMETERS_TAB_MESSAGE = "OpenSearchServerConnector.Parameters";
    private static final String EDIT_CONFIG_FORWARD = "editConfiguration.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification.html";
    private static final String EDIT_SPEC_FORWARD = "editSpecification.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification.js";
    private static final long EXPIRATION_INTERVAL = 60000L;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient client = null;
    private long expirationTime = -1L;
    private static Map<String, Integer> ossInstances = new TreeMap<String, Integer>();

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    protected HttpClient getSession() throws ManifoldCFException {
        if (this.client == null) {
            int executorTimeout = 300000;
            int socketTimeout = 60000;
            int connectionTimeout = 60000;
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(60000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(60000).build());
            this.connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(60000).setExpectContinueEnabled(true).setConnectTimeout(60000).setConnectionRequestTimeout(60000);
            HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setRequestExecutor(new HttpRequestExecutor(300000));
            this.client = clientBuilder.build();
        }
        this.expirationTime = System.currentTimeMillis() + 60000L;
        return this.client;
    }

    protected void closeSession() {
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        this.client = null;
        this.expirationTime = -1L;
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
        this.closeSession();
    }

    public void poll() throws ManifoldCFException {
        super.poll();
        if (this.connectionManager != null && System.currentTimeMillis() > this.expirationTime) {
            this.closeSession();
        }
    }

    public boolean isConnected() {
        return this.connectionManager != null;
    }

    public String[] getActivitiesList() {
        return OPENSEARCHSERVER_ACTIVITIES;
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, OpenSearchServerParam params, String tabName, Integer sequenceNumber, Integer actualSequenceNumber) throws ManifoldCFException {
        Map<String, String> paramMap = null;
        if (params != null) {
            paramMap = params.buildMap();
            if (tabName != null) {
                paramMap.put("TabName", tabName);
            }
            if (actualSequenceNumber != null) {
                paramMap.put("SelectedNum", actualSequenceNumber.toString());
            }
        } else {
            paramMap = new HashMap<String, String>();
        }
        if (sequenceNumber != null) {
            paramMap.put("SeqNum", sequenceNumber.toString());
        }
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, false);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputConfigurationHeader(threadContext, out, locale, parameters, tabsArray);
        tabsArray.add(Messages.getString(locale, PARAMETERS_TAB_MESSAGE));
        OpenSearchServerConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, null, null, null, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        super.outputConfigurationBody(threadContext, out, locale, parameters, tabName);
        OpenSearchServerConfig config = this.getConfigParameters(parameters);
        OpenSearchServerConnector.outputResource(EDIT_CONFIG_FORWARD, out, locale, config, tabName, null, null);
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputSpecificationHeader(out, locale, os, connectionSequenceNumber, tabsArray);
        tabsArray.add(Messages.getString(locale, OPENSEARCHSERVER_TAB_MESSAGE));
        OpenSearchServerConnector.outputResource(EDIT_SPEC_HEADER_FORWARD, out, locale, null, null, new Integer(connectionSequenceNumber), null);
    }

    private final SpecificationNode getSpecNode(Specification os) {
        int l = os.getChildCount();
        for (int i = 0; i < l; ++i) {
            SpecificationNode node = os.getChild(i);
            if (!"OPENSEARCHSERVER_SPECS_NODE".equals(node.getType())) continue;
            return node;
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        OpenSearchServerSpecs specs = this.getSpecParameters(os);
        OpenSearchServerConnector.outputResource(EDIT_SPEC_FORWARD, out, locale, specs, tabName, new Integer(connectionSequenceNumber), new Integer(actualSequenceNumber));
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        boolean bAdd;
        SpecificationNode specNode = this.getSpecNode(os);
        boolean bl = bAdd = specNode == null;
        if (bAdd) {
            specNode = new SpecificationNode("OPENSEARCHSERVER_SPECS_NODE");
        }
        OpenSearchServerSpecs.contextToSpecNode(variableContext, (ConfigurationNode)specNode, connectionSequenceNumber);
        if (bAdd) {
            os.addChild(os.getChildCount(), (ConfigurationNode)specNode);
        }
        return null;
    }

    private final OpenSearchServerConfig getConfigParameters(ConfigParams configParams) {
        if (configParams == null) {
            configParams = this.getConfiguration();
        }
        return new OpenSearchServerConfig(configParams);
    }

    private final OpenSearchServerSpecs getSpecParameters(Specification os) throws ManifoldCFException {
        return new OpenSearchServerSpecs((ConfigurationNode)this.getSpecNode(os));
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException {
        OpenSearchServerSpecs specs = new OpenSearchServerSpecs((ConfigurationNode)this.getSpecNode(os));
        return new VersionContext(specs.toJson().toString(), this.params, os);
    }

    public boolean checkLengthIndexable(VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        OpenSearchServerSpecs specs = new OpenSearchServerSpecs((ConfigurationNode)this.getSpecNode(outputDescription.getSpecification()));
        long maxFileSize = specs.getMaxFileSize();
        return length <= maxFileSize;
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        OpenSearchServerSpecs specs = new OpenSearchServerSpecs((ConfigurationNode)this.getSpecNode(outputDescription.getSpecification()));
        return specs.checkMimeType(mimeType);
    }

    public boolean checkURLIndexable(VersionContext outputDescription, String url, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        OpenSearchServerSpecs specs = new OpenSearchServerSpecs((ConfigurationNode)this.getSpecNode(outputDescription.getSpecification()));
        return specs.checkExtension(FilenameUtils.getExtension((String)url));
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        OpenSearchServerConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, this.getConfigParameters(parameters), null, null, null);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        OpenSearchServerConnector.outputResource(VIEW_SPEC_FORWARD, out, locale, this.getSpecParameters(os), null, new Integer(connectionSequenceNumber), null);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        OpenSearchServerConfig.contextToConfig(variableContext, parameters);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Integer addInstance(OpenSearchServerConfig config) {
        Map<String, Integer> map = ossInstances;
        synchronized (map) {
            String uii = config.getUniqueIndexIdentifier();
            Integer count = ossInstances.get(uii);
            if (count == null) {
                count = new Integer(1);
                ossInstances.put(uii, count);
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeInstance(OpenSearchServerConfig config) {
        Map<String, Integer> map = ossInstances;
        synchronized (map) {
            String uii = config.getUniqueIndexIdentifier();
            Integer count = ossInstances.get(uii);
            if (count == null) {
                return;
            }
            if ((count = Integer.valueOf(count - 1)) == 0) {
                ossInstances.remove(uii);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        Integer count;
        HttpClient client = this.getSession();
        OpenSearchServerConfig config = this.getConfigParameters(null);
        Integer n = count = this.addInstance(config);
        synchronized (n) {
            try {
                long startTime = System.currentTimeMillis();
                OpenSearchServerIndex oi = new OpenSearchServerIndex(client, documentURI, config, document, authorityNameString, activities);
                activities.recordActivity(Long.valueOf(startTime), OPENSEARCHSERVER_INDEXATION_ACTIVITY, Long.valueOf(document.getBinaryLength()), documentURI, oi.getResultCode(), oi.getResultDescription());
                if (oi.getResult() != OpenSearchServerConnection.Result.OK) {
                    int n2 = 1;
                    return n2;
                }
            }
            finally {
                this.removeInstance(config);
            }
            return 0;
        }
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        HttpClient client = this.getSession();
        long startTime = System.currentTimeMillis();
        OpenSearchServerDelete od = new OpenSearchServerDelete(client, documentURI, this.getConfigParameters(null));
        activities.recordActivity(Long.valueOf(startTime), OPENSEARCHSERVER_DELETION_ACTIVITY, null, documentURI, od.getResultCode(), od.getResultDescription());
    }

    public String check() throws ManifoldCFException {
        HttpClient client = this.getSession();
        OpenSearchServerSchema oss = new OpenSearchServerSchema(client, this.getConfigParameters(null));
        return oss.getResult().name() + " " + oss.getResultDescription();
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        HttpClient client = this.getSession();
        long startTime = System.currentTimeMillis();
        OpenSearchServerConfig config = this.getConfigParameters(null);
        String schedulerJob = config.getSchedulerJob();
        if (schedulerJob != null && schedulerJob.trim().length() > 0) {
            OpenSearchServerScheduler oo = new OpenSearchServerScheduler(client, this.getConfigParameters(null), schedulerJob.trim());
            activities.recordActivity(Long.valueOf(startTime), OPENSEARCHSERVER_SCHEDULER_ACTIVITY, null, oo.getCallUrlSnippet(), oo.getResultCode(), oo.getResultDescription());
        }
    }
}

