/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.jdbcpool;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.manifoldcf.core.jdbcpool.WrappedConnection;
import org.apache.manifoldcf.core.system.Logging;

public class ConnectionPool {
    public static final String _rcsid = "@(#)$Id: ConnectionPool.java 1695841 2015-08-14 08:32:31Z kwright $";
    protected final String dbURL;
    protected final String userName;
    protected final String password;
    protected volatile int freePointer;
    protected volatile int activeConnections;
    protected volatile boolean closed;
    protected final Connection[] freeConnections;
    protected final long[] connectionCleanupTimeouts;
    protected final long expiration;
    protected final boolean debug;
    protected final Set<WrappedConnection> outstandingConnections = new HashSet<WrappedConnection>();

    public ConnectionPool(String dbURL, String userName, String password, int maxConnections, long expiration, boolean debug) {
        this.dbURL = dbURL;
        this.userName = userName;
        this.password = password;
        this.freeConnections = new Connection[maxConnections];
        this.connectionCleanupTimeouts = new long[maxConnections];
        this.freePointer = 0;
        this.activeConnections = 0;
        this.closed = false;
        this.expiration = expiration;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WrappedConnection getConnection() throws SQLException, InterruptedException {
        WrappedConnection wrappedConnection;
        block29: {
            Exception instantiationException = this.debug ? new Exception("Possibly leaked db connection") : null;
            Connection rval = null;
            boolean returnedValue = true;
            try {
                block28: {
                    while (true) {
                        ConnectionPool connectionPool = this;
                        synchronized (connectionPool) {
                            if (this.freePointer > 0) {
                                if (this.closed) {
                                    throw new InterruptedException("Pool already closed");
                                }
                                rval = this.freeConnections[--this.freePointer];
                                this.freeConnections[this.freePointer] = null;
                                boolean isValid = true;
                                try {
                                    isValid = rval.isValid(1);
                                }
                                catch (SQLException e) {
                                    // empty catch block
                                }
                                if (!isValid) {
                                    Connection closeValue = rval;
                                    rval = null;
                                    --this.activeConnections;
                                    try {
                                        closeValue.close();
                                    }
                                    catch (SQLException e) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                                break block28;
                            }
                            if (this.activeConnections != this.freeConnections.length) break;
                            if (this.debug) {
                                Set<WrappedConnection> set = this.outstandingConnections;
                                synchronized (set) {
                                    Logging.db.warn((Object)"Out of db connections, list of outstanding ones follows.");
                                    for (WrappedConnection c : this.outstandingConnections) {
                                        Logging.db.warn((Object)"Found a possibly leaked db connection", (Throwable)c.getInstantiationException());
                                    }
                                }
                            }
                            this.wait();
                        }
                    }
                    {
                        ++this.activeConnections;
                        rval = this.userName != null ? DriverManager.getConnection(this.dbURL, this.userName, this.password) : DriverManager.getConnection(this.dbURL);
                    }
                }
                WrappedConnection wc = new WrappedConnection(this, rval, instantiationException);
                if (this.debug) {
                    Set<WrappedConnection> set = this.outstandingConnections;
                    synchronized (set) {
                        this.outstandingConnections.add(wc);
                    }
                }
                wrappedConnection = wc;
                if (returnedValue) return wrappedConnection;
                if (rval == null) break block29;
            }
            catch (Error e) {
                try {
                    returnedValue = false;
                    throw e;
                    catch (RuntimeException e2) {
                        returnedValue = false;
                        throw e2;
                    }
                    catch (SQLException e3) {
                        returnedValue = false;
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    if (returnedValue) throw throwable;
                    if (rval != null) {
                        this.release(rval);
                        throw throwable;
                    }
                    ConnectionPool connectionPool = this;
                    synchronized (connectionPool) {
                        --this.activeConnections;
                        throw throwable;
                    }
                }
            }
            this.release(rval);
            return wrappedConnection;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            --this.activeConnections;
            return wrappedConnection;
        }
    }

    public synchronized void flushPool() {
        for (int i = 0; i < this.freePointer; ++i) {
            try {
                this.freeConnections[i].close();
            }
            catch (SQLException e) {
                Logging.db.warn((Object)("Error closing pooled connection: " + e.getMessage()), (Throwable)e);
            }
            this.freeConnections[i] = null;
            --this.activeConnections;
        }
        this.freePointer = 0;
        this.notifyAll();
    }

    public synchronized void closePool() {
        for (int i = 0; i < this.freePointer; ++i) {
            try {
                this.freeConnections[i].close();
            }
            catch (SQLException e) {
                Logging.db.warn((Object)("Error closing pooled connection: " + e.getMessage()), (Throwable)e);
            }
            this.freeConnections[i] = null;
        }
        this.freePointer = 0;
        this.closed = true;
        this.notifyAll();
    }

    public synchronized void cleanupExpiredConnections(long currentTime) {
        int i = 0;
        while (i < this.freePointer) {
            if (this.connectionCleanupTimeouts[i] <= currentTime) {
                Connection c = this.freeConnections[i];
                this.freeConnections[i] = null;
                --this.freePointer;
                --this.activeConnections;
                if (this.freePointer == i) {
                    this.freeConnections[i] = null;
                } else {
                    this.freeConnections[i] = this.freeConnections[this.freePointer];
                    this.connectionCleanupTimeouts[i] = this.connectionCleanupTimeouts[this.freePointer];
                    this.freeConnections[this.freePointer] = null;
                }
                try {
                    c.close();
                }
                catch (SQLException e) {
                    Logging.db.warn((Object)("Error closing pooled connection: " + e.getMessage()), (Throwable)e);
                }
                continue;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(WrappedConnection connection) {
        if (this.debug) {
            Set<WrappedConnection> set = this.outstandingConnections;
            synchronized (set) {
                if (!this.outstandingConnections.contains(connection)) {
                    Logging.db.warn((Object)"Released a connection that wasn't tracked!!");
                }
                this.outstandingConnections.remove(connection);
            }
        }
        this.release(connection.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(Connection c) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.freeConnections[this.freePointer] = c;
            this.connectionCleanupTimeouts[this.freePointer] = System.currentTimeMillis() + this.expiration;
            ++this.freePointer;
            this.notifyAll();
        }
    }
}

