/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchParam;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.json.JSONObject;

public class ElasticSearchSpecs
extends ElasticSearchParam {
    private static final long serialVersionUID = 1859653440572662025L;
    public static final ElasticSearchParam.ParameterEnum[] SPECIFICATIONLIST = new ElasticSearchParam.ParameterEnum[]{ElasticSearchParam.ParameterEnum.MAXFILESIZE, ElasticSearchParam.ParameterEnum.MIMETYPES, ElasticSearchParam.ParameterEnum.EXTENSIONS};
    public static final String ELASTICSEARCH_SPECS_NODE = "ELASTICSEARCH_SPECS_NODE";
    private Set<String> extensionSet;
    private Set<String> mimeTypeSet;

    public ElasticSearchSpecs(ConfigurationNode node) throws ManifoldCFException {
        super(SPECIFICATIONLIST);
        for (ElasticSearchParam.ParameterEnum param : SPECIFICATIONLIST) {
            String value = null;
            if (node != null) {
                value = node.getAttributeValue(param.name());
            }
            if (value == null) {
                value = param.defaultValue;
            }
            this.put(param, value);
        }
        this.extensionSet = ElasticSearchSpecs.createStringSet(this.getExtensions());
        this.mimeTypeSet = ElasticSearchSpecs.createStringSet(this.getMimeTypes());
    }

    public static void contextToSpecNode(IPostParameters variableContext, ConfigurationNode specNode, int sequenceNumber) {
        for (ElasticSearchParam.ParameterEnum param : SPECIFICATIONLIST) {
            String p = variableContext.getParameter("s" + sequenceNumber + "_" + param.name().toLowerCase());
            if (p == null) continue;
            specNode.setAttribute(param.name(), p);
        }
    }

    public JSONObject toJson() {
        return new JSONObject((Map)this);
    }

    public long getMaxFileSize() {
        return Long.parseLong((String)this.get((Object)ElasticSearchParam.ParameterEnum.MAXFILESIZE));
    }

    public String getMimeTypes() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.MIMETYPES);
    }

    public String getExtensions() {
        return (String)this.get((Object)ElasticSearchParam.ParameterEnum.EXTENSIONS);
    }

    private static final TreeSet<String> createStringSet(String content) throws ManifoldCFException {
        TreeSet<String> treeSet;
        block6: {
            TreeSet<String> set = new TreeSet<String>();
            BufferedReader br = null;
            StringReader sr = null;
            try {
                sr = new StringReader(content);
                br = new BufferedReader(sr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    set.add(line);
                }
                treeSet = set;
                if (br == null) break block6;
            }
            catch (IOException e) {
                try {
                    throw new ManifoldCFException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (br != null) {
                        IOUtils.closeQuietly(br);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)br);
        }
        return treeSet;
    }

    public boolean checkExtension(String extension) {
        if (extension == null || extension.length() == 0) {
            extension = ".";
        }
        return this.extensionSet.contains(extension);
    }

    public boolean checkMimeType(String mimeType) {
        if (mimeType == null) {
            mimeType = "application/unknown";
        }
        return this.mimeTypeSet.contains(mimeType);
    }
}

