/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.BinaryInput;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.jdbc.Messages;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.jdbc.IDynamicResultRow;
import org.apache.manifoldcf.jdbc.IDynamicResultSet;
import org.apache.manifoldcf.jdbc.JDBCConnection;
import org.apache.manifoldcf.jdbc.JDBCConstants;
import org.apache.manifoldcf.ui.util.Encoder;

public class JDBCConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: JDBCConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String ACTIVITY_EXTERNAL_QUERY = "external query";
    protected static final String ACTIVITY_FETCH = "fetch";
    protected static final String[] activitiesList = new String[]{"external query", "fetch"};
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected JDBCConnection connection = null;
    protected String jdbcProvider = null;
    protected String accessMethod = null;
    protected String host = null;
    protected String databaseName = null;
    protected String rawDriverString = null;
    protected String userName = null;
    protected String password = null;
    protected static HashMap documentKnownColumns = new HashMap();

    protected void getSession() throws ManifoldCFException {
        if (this.connection == null) {
            if (this.jdbcProvider == null || this.jdbcProvider.length() == 0) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.providerParameter + "'");
            }
            if (!(this.host != null && this.host.length() != 0 || this.rawDriverString != null && this.rawDriverString.length() != 0)) {
                throw new ManifoldCFException("Missing parameter '" + JDBCConstants.hostParameter + "' or '" + JDBCConstants.driverStringParameter + "'");
            }
            this.connection = new JDBCConnection(this.jdbcProvider, this.accessMethod == null || this.accessMethod.equals("name"), this.host, this.databaseName, this.rawDriverString, this.userName, this.password);
        }
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public int getConnectorModel() {
        return 2;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.jdbcProvider = configParams.getParameter(JDBCConstants.providerParameter);
        this.accessMethod = configParams.getParameter(JDBCConstants.methodParameter);
        this.host = configParams.getParameter(JDBCConstants.hostParameter);
        this.databaseName = configParams.getParameter(JDBCConstants.databaseNameParameter);
        this.rawDriverString = configParams.getParameter(JDBCConstants.driverStringParameter);
        this.userName = configParams.getParameter(JDBCConstants.databaseUserName);
        this.password = configParams.getObfuscatedParameter(JDBCConstants.databasePassword);
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.connection.testConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("Service interruption in check(): " + e.getMessage()), (Throwable)e);
            }
            return "Transient error: " + e.getMessage();
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.connection = null;
        this.host = null;
        this.jdbcProvider = null;
        this.accessMethod = null;
        this.databaseName = null;
        this.rawDriverString = null;
        this.userName = null;
        this.password = null;
        super.disconnect();
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.rawDriverString == null || this.rawDriverString.length() == 0 ? this.host : this.rawDriverString};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        block12: {
            startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
            this.getSession();
            ts = new TableSpec(spec);
            vm = new VariableMap();
            JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
            JDBCConnector.addVariable(vm, JDBCConstants.startTimeVariable, startTime);
            JDBCConnector.addVariable(vm, JDBCConstants.endTimeVariable, seedTime);
            paramList = new ArrayList<E>();
            sb = new StringBuilder();
            JDBCConnector.substituteQuery(ts.idQuery, vm, sb, paramList);
            queryText = sb.toString();
            startQueryTime = System.currentTimeMillis();
            try {
                idSet = this.connection.executeUncachedQuery(queryText, paramList, -1);
            }
            catch (ServiceInterruption e) {
                activities.recordActivity(new Long(startQueryTime), "external query", null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
                throw e;
            }
            catch (ManifoldCFException e) {
                activities.recordActivity(new Long(startQueryTime), "external query", null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
                throw e;
            }
            activities.recordActivity(new Long(startQueryTime), "external query", null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
            while (true) lbl-1000:
            // 3 sources

            {
                if ((row = idSet.getNextRow()) == null) {
                    break block12;
                }
                try {
                    o = row.getValue(JDBCConstants.idReturnColumnName);
                    if (o == null) {
                        throw new ManifoldCFException("Bad seed query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                    }
                    idValue = JDBCConnection.readAsString(o);
                    activities.addSeedDocument(idValue);
                }
                finally {
                    row.close();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                idSet.close();
            }
        }
        return new Long(seedTime).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        IDynamicResultSet result;
        TableSpec ts = new TableSpec(spec);
        Set<String> acls = ts.getAcls();
        String[] versionsReturned = new String[documentIdentifiers.length];
        HashMap<String, String> documentVersions = new HashMap<String, String>();
        if (ts.versionQuery != null && ts.versionQuery.length() > 0) {
            VariableMap vm = new VariableMap();
            JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
            JDBCConnector.addConstant(vm, JDBCConstants.versionReturnVariable, JDBCConstants.versionReturnColumnName);
            if (JDBCConnector.addIDList(vm, JDBCConstants.idListVariable, documentIdentifiers, null)) {
                IDynamicResultSet result2;
                ArrayList paramList = new ArrayList();
                StringBuilder sb = new StringBuilder();
                JDBCConnector.substituteQuery(ts.versionQuery, vm, sb, paramList);
                this.getSession();
                String queryText = sb.toString();
                long startTime = System.currentTimeMillis();
                try {
                    result2 = this.connection.executeUncachedQuery(queryText, paramList, -1);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() != 2) {
                        activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
                    }
                    throw e;
                }
                try {
                    IDynamicResultRow row;
                    activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
                    while ((row = result2.getNextRow()) != null) {
                        try {
                            Object o = row.getValue(JDBCConstants.idReturnColumnName);
                            if (o == null) {
                                throw new ManifoldCFException("Bad version query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                            }
                            String idValue = JDBCConnection.readAsString(o);
                            o = row.getValue(JDBCConstants.versionReturnColumnName);
                            String versionValue = o == null ? "" : JDBCConnection.readAsString(o);
                            documentVersions.put(idValue, versionValue);
                        }
                        finally {
                            row.close();
                        }
                    }
                }
                finally {
                    result2.close();
                }
            }
        } else {
            for (String documentIdentifier : documentIdentifiers) {
                documentVersions.put(documentIdentifier, "");
            }
        }
        Set<String> fetchDocuments = documentVersions.keySet();
        for (String documentIdentifier : documentIdentifiers) {
            String documentVersion = (String)documentVersions.get(documentIdentifier);
            if (documentVersion != null) continue;
            activities.deleteDocument(documentIdentifier);
        }
        HashMap<String, Set<String>> documentAcls = new HashMap<String, Set<String>>();
        if (ts.securityOn) {
            if (acls.size() == 0 && ts.aclQuery != null && ts.aclQuery.length() > 0) {
                VariableMap vm = new VariableMap();
                JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
                JDBCConnector.addConstant(vm, JDBCConstants.tokenReturnVariable, JDBCConstants.tokenReturnColumnName);
                if (JDBCConnector.addIDList(vm, JDBCConstants.idListVariable, documentIdentifiers, fetchDocuments)) {
                    IDynamicResultSet result3;
                    ArrayList paramList = new ArrayList();
                    StringBuilder sb = new StringBuilder();
                    JDBCConnector.substituteQuery(ts.aclQuery, vm, sb, paramList);
                    this.getSession();
                    String queryText = sb.toString();
                    long startTime = System.currentTimeMillis();
                    try {
                        result3 = this.connection.executeUncachedQuery(queryText, paramList, -1);
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() != 2) {
                            activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
                        }
                        throw e;
                    }
                    try {
                        IDynamicResultRow row;
                        activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
                        while ((row = result3.getNextRow()) != null) {
                            try {
                                Object o = row.getValue(JDBCConstants.idReturnColumnName);
                                if (o == null) {
                                    throw new ManifoldCFException("Bad acl query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\", or, for MySQL, select \"by label\" in your repository connection.");
                                }
                                String idValue = JDBCConnection.readAsString(o);
                                o = row.getValue(JDBCConstants.tokenReturnColumnName);
                                String tokenValue = o == null ? "" : JDBCConnection.readAsString(o);
                                HashSet<String> dcs = (HashSet<String>)documentAcls.get(idValue);
                                if (dcs == null) {
                                    dcs = new HashSet<String>();
                                    documentAcls.put(idValue, dcs);
                                }
                                dcs.add(tokenValue);
                            }
                            finally {
                                row.close();
                            }
                        }
                    }
                    finally {
                        result3.close();
                    }
                }
            } else {
                for (String documentIdentifier : fetchDocuments) {
                    documentAcls.put(documentIdentifier, acls);
                }
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String documentIdentifier : fetchDocuments) {
            String documentVersion = (String)documentVersions.get(documentIdentifier);
            if (documentVersion.length() == 0) {
                map.put(documentIdentifier, documentVersion);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            Set dAcls = (Set)documentAcls.get(documentIdentifier);
            if (dAcls == null) {
                sb.append('-');
            } else {
                sb.append('+');
                Object[] aclValues = new String[dAcls.size()];
                int k = 0;
                for (String acl : dAcls) {
                    aclValues[k++] = acl;
                }
                Arrays.sort(aclValues);
                JDBCConnector.packList((StringBuilder)sb, (String[])aclValues, (char)'+');
            }
            sb.append(documentVersion).append("=").append(ts.dataQuery);
            String versionValue = sb.toString();
            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionValue)) continue;
            map.put(documentIdentifier, versionValue);
        }
        VariableMap vm = new VariableMap();
        JDBCConnector.addConstant(vm, JDBCConstants.idReturnVariable, JDBCConstants.idReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.urlReturnVariable, JDBCConstants.urlReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.dataReturnVariable, JDBCConstants.dataReturnColumnName);
        JDBCConnector.addConstant(vm, JDBCConstants.contentTypeReturnVariable, JDBCConstants.contentTypeReturnColumnName);
        if (!JDBCConnector.addIDList(vm, JDBCConstants.idListVariable, documentIdentifiers, map.keySet())) {
            return;
        }
        ArrayList paramList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        JDBCConnector.substituteQuery(ts.dataQuery, vm, sb, paramList);
        this.getSession();
        String queryText = sb.toString();
        long startTime = System.currentTimeMillis();
        try {
            result = this.connection.executeUncachedQuery(queryText, paramList, -1);
        }
        catch (ManifoldCFException e) {
            activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "ERROR", e.getMessage(), null);
            throw e;
        }
        try {
            IDynamicResultRow row;
            activities.recordActivity(new Long(startTime), ACTIVITY_EXTERNAL_QUERY, null, JDBCConnector.createQueryString(queryText, paramList), "OK", null, null);
            while ((row = result.getNextRow()) != null) {
                try {
                    long fetchStartTime;
                    Long fileLengthLong;
                    String errorDesc;
                    String errorCode;
                    String id;
                    block115: {
                        block114: {
                            block113: {
                                block111: {
                                    block110: {
                                        block109: {
                                            block108: {
                                                block107: {
                                                    block106: {
                                                        Object o = row.getValue(JDBCConstants.idReturnColumnName);
                                                        if (o == null) {
                                                            throw new ManifoldCFException("Bad document query; doesn't return $(IDCOLUMN) column.  Try using quotes around $(IDCOLUMN) variable, e.g. \"$(IDCOLUMN)\".");
                                                        }
                                                        id = JDBCConnection.readAsString(o);
                                                        errorCode = null;
                                                        errorDesc = null;
                                                        fileLengthLong = null;
                                                        fetchStartTime = System.currentTimeMillis();
                                                        try {
                                                            InputStream is;
                                                            boolean validURL;
                                                            String version = (String)map.get(id);
                                                            if (version == null) continue;
                                                            if (Logging.connectors.isDebugEnabled()) {
                                                                Logging.connectors.debug((Object)("JDBC: Document data result found for '" + id + "'"));
                                                            }
                                                            if ((o = row.getValue(JDBCConstants.urlReturnColumnName)) == null) {
                                                                Logging.connectors.debug((Object)("JDBC: Document '" + id + "' has a null url - skipping"));
                                                                errorCode = "NULLURL";
                                                                errorDesc = "Excluded because document had a null URL";
                                                                activities.noDocument(id, version);
                                                                if (errorCode == null) continue;
                                                                break block106;
                                                            }
                                                            String url = JDBCConnection.readAsString(o);
                                                            try {
                                                                new URI(url);
                                                                validURL = true;
                                                            }
                                                            catch (URISyntaxException e) {
                                                                validURL = false;
                                                            }
                                                            if (!validURL) {
                                                                Logging.connectors.debug((Object)("JDBC: Document '" + id + "' has an illegal url: '" + url + "' - skipping"));
                                                                errorCode = "BADURL";
                                                                errorDesc = "Excluded because document had illegal URL ('" + url + "')";
                                                                activities.noDocument(id, version);
                                                                if (errorCode == null) continue;
                                                                break block107;
                                                            }
                                                            Object contents = row.getValue(JDBCConstants.dataReturnColumnName);
                                                            if (contents == null) {
                                                                Logging.connectors.debug((Object)("JDBC: Document '" + id + "' seems to have null data - skipping"));
                                                                errorCode = "NULLDATA";
                                                                errorDesc = "Excluded because document had null data";
                                                                activities.noDocument(id, version);
                                                                if (errorCode == null) continue;
                                                                break block108;
                                                            }
                                                            map.remove(id);
                                                            o = row.getValue(JDBCConstants.contentTypeReturnColumnName);
                                                            String contentType = o != null ? JDBCConnection.readAsString(o) : (contents instanceof BinaryInput ? "application/octet-stream" : (contents instanceof CharacterInput ? "text/plain; charset=utf-8" : "text/plain"));
                                                            if (!activities.checkMimeTypeIndexable(contentType)) {
                                                                Logging.connectors.debug((Object)("JDBC: Document '" + id + "' excluded because of mime type - skipping"));
                                                                errorCode = "EXCLUDEDMIMETYPE";
                                                                errorDesc = "Excluded because of mime type (" + contentType + ")";
                                                                activities.noDocument(id, version);
                                                                if (errorCode == null) continue;
                                                                break block109;
                                                            }
                                                            if (!activities.checkURLIndexable(url)) {
                                                                Logging.connectors.debug((Object)("JDBC: Document '" + id + "' excluded because of url - skipping"));
                                                                errorCode = "EXCLUDEDURL";
                                                                errorDesc = "Excluded because of URL ('" + url + "')";
                                                                activities.noDocument(id, version);
                                                                if (errorCode == null) continue;
                                                                break block110;
                                                            }
                                                            RepositoryDocument rd = new RepositoryDocument();
                                                            rd.setMimeType(contentType);
                                                            this.applyAccessTokens(rd, (Set)documentAcls.get(id));
                                                            this.applyMetadata(rd, row);
                                                            if (contents instanceof BinaryInput) {
                                                                BinaryInput bi = (BinaryInput)contents;
                                                                long fileLength = bi.getLength();
                                                                if (!activities.checkLengthIndexable(fileLength)) {
                                                                    Logging.connectors.debug((Object)("JDBC: Document '" + id + "' excluded because of length - skipping"));
                                                                    errorCode = "EXCLUDEDLENGTH";
                                                                    errorDesc = "Excluded because of length (" + fileLength + ")";
                                                                    activities.noDocument(id, version);
                                                                    if (errorCode == null) continue;
                                                                    break block111;
                                                                }
                                                                try {
                                                                    is = bi.getStream();
                                                                    try {
                                                                        rd.setBinary(is, fileLength);
                                                                        activities.ingestDocumentWithException(id, version, url, rd);
                                                                        errorCode = "OK";
                                                                        fileLengthLong = new Long(fileLength);
                                                                    }
                                                                    finally {
                                                                        is.close();
                                                                    }
                                                                }
                                                                catch (IOException e) {
                                                                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                                    errorDesc = e.getMessage();
                                                                    JDBCConnector.handleIOException(id, e);
                                                                }
                                                            } else if (contents instanceof CharacterInput) {
                                                                CharacterInput ci = (CharacterInput)contents;
                                                                long fileLength = ci.getUtf8StreamLength();
                                                                if (!activities.checkLengthIndexable(fileLength)) {
                                                                    Logging.connectors.debug((Object)("JDBC: Document '" + id + "' excluded because of length - skipping"));
                                                                    errorCode = "EXCLUDEDLENGTH";
                                                                    errorDesc = "Excluded because of length (" + fileLength + ")";
                                                                    activities.noDocument(id, version);
                                                                    if (errorCode == null) continue;
                                                                    break block113;
                                                                }
                                                                try {
                                                                    is = ci.getUtf8Stream();
                                                                    try {
                                                                        rd.setBinary(is, fileLength);
                                                                        activities.ingestDocumentWithException(id, version, url, rd);
                                                                        errorCode = "OK";
                                                                        fileLengthLong = new Long(fileLength);
                                                                    }
                                                                    finally {
                                                                        is.close();
                                                                    }
                                                                }
                                                                catch (IOException e) {
                                                                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                                    errorDesc = e.getMessage();
                                                                    JDBCConnector.handleIOException(id, e);
                                                                }
                                                            } else {
                                                                String value = contents.toString();
                                                                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                                                                long fileLength = bytes.length;
                                                                if (!activities.checkLengthIndexable(fileLength)) {
                                                                    Logging.connectors.debug((Object)("JDBC: Document '" + id + "' excluded because of length - skipping"));
                                                                    errorCode = "EXCLUDEDLENGTH";
                                                                    errorDesc = "Excluded because of length (" + fileLength + ")";
                                                                    activities.noDocument(id, version);
                                                                    if (errorCode == null) continue;
                                                                    break block114;
                                                                }
                                                                try (ByteArrayInputStream is2 = new ByteArrayInputStream(bytes);){
                                                                    rd.setBinary((InputStream)is2, fileLength);
                                                                    activities.ingestDocumentWithException(id, version, url, rd);
                                                                    errorCode = "OK";
                                                                    fileLengthLong = new Long(fileLength);
                                                                }
                                                                catch (IOException e) {
                                                                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                                                    errorDesc = e.getMessage();
                                                                    JDBCConnector.handleIOException(id, e);
                                                                }
                                                            }
                                                            if (errorCode == null) continue;
                                                            break block115;
                                                        }
                                                        catch (ManifoldCFException e) {
                                                            if (e.getErrorCode() == 2) {
                                                                errorCode = null;
                                                            }
                                                            throw e;
                                                        }
                                                    }
                                                    activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                                    continue;
                                                }
                                                activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                                continue;
                                            }
                                            activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                            continue;
                                        }
                                        activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                        continue;
                                    }
                                    activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                    continue;
                                }
                                activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                                continue;
                            }
                            activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                            continue;
                        }
                        activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                        continue;
                    }
                    activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                    continue;
                    finally {
                        if (errorCode == null) continue;
                        activities.recordActivity(new Long(fetchStartTime), ACTIVITY_FETCH, fileLengthLong, id, errorCode, errorDesc, null);
                    }
                }
                finally {
                    row.close();
                }
            }
        }
        finally {
            result.close();
        }
        String[] arr$ = documentIdentifiers;
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            String documentVersion;
            String documentIdentifier = arr$[i$];
            if (fetchDocuments.contains(documentIdentifier) && (documentVersion = (String)map.get(documentIdentifier)) != null) {
                activities.noDocument(documentIdentifier, documentVersion);
                activities.recordActivity(null, ACTIVITY_FETCH, null, documentIdentifier, "NOTFETCHED", "Document was not seen by processing query", null);
            }
            ++i$;
        }
        return;
    }

    protected static void handleIOException(String id, IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof SocketTimeoutException) {
            throw new ManifoldCFException("Socket timeout reading database data: " + e.getMessage(), (Throwable)e);
        }
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException("Error reading database data: " + e.getMessage(), (Throwable)e);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "JDBCConnector.DatabaseType"));
        tabsArray.add(Messages.getString(locale, "JDBCConnector.Server"));
        tabsArray.add(Messages.getString(locale, "JDBCConnector.Credentials"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfigForSave()\n{\n  if (editconnection.databasehost.value == \"\" && editconnection.rawjdbcstring.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.PleaseFillInADatabaseServerName") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.Server") + "\");\n" + "    editconnection.databasehost.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.databasename.value == \"\" && editconnection.rawjdbcstring.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.PleaseFillInTheNameOfTheDatabase") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.Server") + "\");\n" + "    editconnection.databasename.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.username.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.PleaseSupplyTheDatabaseUsernameForThisConnection") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.Credentials") + "\");\n" + "    editconnection.username.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "\n" + "//-->\n" + "</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String databasePassword;
        String databaseUser;
        String rawJDBCString;
        String databaseName;
        String host;
        String accessMethod;
        String jdbcProvider = parameters.getParameter(JDBCConstants.providerParameter);
        if (jdbcProvider == null) {
            jdbcProvider = "oracle:thin:@";
        }
        if ((accessMethod = parameters.getParameter(JDBCConstants.methodParameter)) == null) {
            accessMethod = "name";
        }
        if ((host = parameters.getParameter(JDBCConstants.hostParameter)) == null) {
            host = "localhost";
        }
        if ((databaseName = parameters.getParameter(JDBCConstants.databaseNameParameter)) == null) {
            databaseName = "database";
        }
        if ((rawJDBCString = parameters.getParameter(JDBCConstants.driverStringParameter)) == null) {
            rawJDBCString = "";
        }
        if ((databaseUser = parameters.getParameter(JDBCConstants.databaseUserName)) == null) {
            databaseUser = "";
        }
        databasePassword = (databasePassword = parameters.getObfuscatedParameter(JDBCConstants.databasePassword)) == null ? "" : out.mapPasswordToKey(databasePassword);
        if (tabName.equals(Messages.getString(locale, "JDBCConnector.DatabaseType"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.DatabaseType2") + "</nobr></td><td class=\"value\">\n" + "      <select multiple=\"false\" name=\"databasetype\" size=\"2\">\n" + "        <option value=\"oracle:thin:@\" " + (jdbcProvider.equals("oracle:thin:@") ? "selected=\"selected\"" : "") + ">Oracle</option>\n" + "        <option value=\"postgresql:\" " + (jdbcProvider.equals("postgresql:") ? "selected=\"selected\"" : "") + ">Postgres SQL</option>\n" + "        <option value=\"jtds:sqlserver:\" " + (jdbcProvider.equals("jtds:sqlserver:") ? "selected=\"selected\"" : "") + ">MS SQL Server (&gt; V6.5)</option>\n" + "        <option value=\"jtds:sybase:\" " + (jdbcProvider.equals("jtds:sybase:") ? "selected=\"selected\"" : "") + ">Sybase (&gt;= V10)</option>\n" + "        <option value=\"mysql:\" " + (jdbcProvider.equals("mysql:") ? "selected=\"selected\"" : "") + ">MySQL (&gt;= V5)</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.AccessMethod") + "</nobr></td><td class=\"value\">\n" + "      <select multiple=\"false\" name=\"accessmethod\" size=\"2\">\n" + "        <option value=\"name\" " + (accessMethod.equals("name") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "JDBCConnector.ByName") + "</option>\n" + "        <option value=\"label\" " + (accessMethod.equals("label") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "JDBCConnector.ByLabel") + "</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasetype\" value=\"" + jdbcProvider + "\"/>\n" + "<input type=\"hidden\" name=\"accessmethod\" value=\"" + accessMethod + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "JDBCConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.DatabaseHostAndPort") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"64\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)host) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.DatabaseServiceNameOrInstanceDatabase") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)databaseName) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.RawDatabaseConnectString") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"80\" name=\"rawjdbcstring\" value=\"" + Encoder.attributeEscape((String)rawJDBCString) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"databasehost\" value=\"" + Encoder.attributeEscape((String)host) + "\"/>\n" + "<input type=\"hidden\" name=\"databasename\" value=\"" + Encoder.attributeEscape((String)databaseName) + "\"/>\n" + "<input type=\"hidden\" name=\"rawjdbcstring\" value=\"" + Encoder.attributeEscape((String)rawJDBCString) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "JDBCConnector.Credentials"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.UserName") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.Password") + "</nobr></td><td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"username\" value=\"" + Encoder.attributeEscape((String)databaseUser) + "\"/>\n" + "<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)databasePassword) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String password;
        String userName;
        String rawJDBCString;
        String databaseName;
        String host;
        String accessMethod;
        String type = variableContext.getParameter("databasetype");
        if (type != null) {
            parameters.setParameter(JDBCConstants.providerParameter, type);
        }
        if ((accessMethod = variableContext.getParameter("accessmethod")) != null) {
            parameters.setParameter(JDBCConstants.methodParameter, accessMethod);
        }
        if ((host = variableContext.getParameter("databasehost")) != null) {
            parameters.setParameter(JDBCConstants.hostParameter, host);
        }
        if ((databaseName = variableContext.getParameter("databasename")) != null) {
            parameters.setParameter(JDBCConstants.databaseNameParameter, databaseName);
        }
        if ((rawJDBCString = variableContext.getParameter("rawjdbcstring")) != null) {
            parameters.setParameter(JDBCConstants.driverStringParameter, rawJDBCString);
        }
        if ((userName = variableContext.getParameter("username")) != null) {
            parameters.setParameter(JDBCConstants.databaseUserName, userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter(JDBCConstants.databasePassword, variableContext.mapKeyToPassword(password));
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.Parameters") + "</nobr></td>\n" + "    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "JDBCConnector.Queries"));
        tabsArray.add(Messages.getString(locale, "JDBCConnector.Security"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n" + "{\n" + "  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n" + "  postFormSetAnchor(anchorvalue);\n" + "}\n" + "\n" + "function " + seqPrefix + "SpecAddToken(anchorvalue)\n" + "{\n" + "  if (editjob." + seqPrefix + "spectoken.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.TypeInAnAccessToken") + "\");\n" + "    editjob." + seqPrefix + "spectoken.focus();\n" + "    return;\n" + "  }\n" + "  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n" + "}\n" + "\n" + "function " + seqPrefix + "checkSpecification()\n" + "{\n" + "  if (editjob." + seqPrefix + "idquery.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.EnterASeedingQuery") + "\");\n" + "    editjob." + seqPrefix + "idquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "idquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnIDCOLUMNInTheResult") + "\");\n" + "    editjob." + seqPrefix + "idquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "versionquery.value != \"\")\n" + "  {\n" + "    if (editjob." + seqPrefix + "versionquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnIDCOLUMNInTheResult") + "\");\n" + "      editjob." + seqPrefix + "versionquery.focus();\n" + "      return false;\n" + "    }\n" + "    if (editjob." + seqPrefix + "versionquery.value.indexOf(\"$(VERSIONCOLUMN)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnVERSIONCOLUMNInTheResult") + "\");\n" + "      editjob." + seqPrefix + "versionquery.focus();\n" + "      return false;\n" + "    }\n" + "    if (editjob." + seqPrefix + "versionquery.value.indexOf(\"$(IDLIST)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustUseIDLISTInWHEREClause") + "\");\n" + "      editjob." + seqPrefix + "versionquery.focus();\n" + "      return false;\n" + "    }\n" + "  }\n" + "  if (editjob." + seqPrefix + "aclquery.value != \"\")\n" + "  {\n" + "    if (editjob." + seqPrefix + "aclquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnIDCOLUMNInTheResult") + "\");\n" + "      editjob." + seqPrefix + "aclquery.focus();\n" + "      return false;\n" + "    }\n" + "    if (editjob." + seqPrefix + "aclquery.value.indexOf(\"$(TOKENCOLUMN)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnTOKENCOLUMNInTheResult") + "\");\n" + "      editjob." + seqPrefix + "aclquery.focus();\n" + "      return false;\n" + "    }\n" + "    if (editjob." + seqPrefix + "aclquery.value.indexOf(\"$(IDLIST)\") == -1)\n" + "    {\n" + "      alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustUseIDLISTInWHEREClause") + "\");\n" + "      editjob." + seqPrefix + "aclquery.focus();\n" + "      return false;\n" + "    }\n" + "  }\n" + "  if (editjob." + seqPrefix + "dataquery.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.EnterADataQuery") + "\");\n" + "    editjob." + seqPrefix + "dataquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "dataquery.value.indexOf(\"$(IDCOLUMN)\") == -1)\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnIDCOLUMNInTheResult2") + "\");\n" + "    editjob." + seqPrefix + "dataquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "dataquery.value.indexOf(\"$(URLCOLUMN)\") == -1)\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnURLCOLUMNInTheResult") + "\");\n" + "    editjob." + seqPrefix + "dataquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "dataquery.value.indexOf(\"$(DATACOLUMN)\") == -1)\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustReturnDATACOLUMNInTheResult") + "\");\n" + "    editjob." + seqPrefix + "dataquery.focus();\n" + "    return false;\n" + "  }\n" + "  if (editjob." + seqPrefix + "dataquery.value.indexOf(\"$(IDLIST)\") == -1)\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "JDBCConnector.MustUseIDLISTInWHEREClause") + "\");\n" + "    editjob." + seqPrefix + "dataquery.focus();\n" + "    return false;\n" + "  }\n" + "\n" + "  return true;\n" + "}\n" + "\n" + "//-->\n" + "</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        SpecificationNode sn;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String idQuery = "SELECT idfield AS $(IDCOLUMN) FROM documenttable WHERE modifydatefield > $(STARTTIME) AND modifydatefield <= $(ENDTIME)";
        String versionQuery = "SELECT idfield AS $(IDCOLUMN), versionfield AS $(VERSIONCOLUMN) FROM documenttable WHERE idfield IN $(IDLIST)";
        String dataQuery = "SELECT idfield AS $(IDCOLUMN), urlfield AS $(URLCOLUMN), datafield AS $(DATACOLUMN) FROM documenttable WHERE idfield IN $(IDLIST)";
        String aclQuery = "SELECT docidfield AS $(IDCOLUMN), aclfield AS $(TOKENCOLUMN) FROM acltable WHERE docidfield IN $(IDLIST)";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn2;
            if ((sn2 = ds.getChild(i++)).getType().equals(JDBCConstants.idQueryNode)) {
                idQuery = sn2.getValue();
                if (idQuery != null) continue;
                idQuery = "";
                continue;
            }
            if (sn2.getType().equals(JDBCConstants.versionQueryNode)) {
                versionQuery = sn2.getValue();
                if (versionQuery != null) continue;
                versionQuery = "";
                continue;
            }
            if (sn2.getType().equals(JDBCConstants.dataQueryNode)) {
                dataQuery = sn2.getValue();
                if (dataQuery != null) continue;
                dataQuery = "";
                continue;
            }
            if (!sn2.getType().equals(JDBCConstants.aclQueryNode) || (aclQuery = sn2.getValue()) != null) continue;
            aclQuery = "";
        }
        if (tabName.equals(Messages.getString(locale, "JDBCConnector.Queries")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.SeedingQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.returnIdsThatNeedToBeChecked") + "</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"" + seqPrefix + "idquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)idQuery) + "</textarea></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.VersionCheckQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.returnIdsAndVersionsForASetOfDocuments") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.leaveBlankIfNoVersioningCapability") + "</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"" + seqPrefix + "versionquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)versionQuery) + "</textarea></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.AccessTokenQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.returnIdsAndAccessTokensForASetOfDocuments") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.leaveBlankIfNoSecurityCapability") + "</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"" + seqPrefix + "aclquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)aclQuery) + "</textarea></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.DataQuery") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "JDBCConnector.returnIdsUrlsAndDataForASetOfDocuments") + "</nobr></td>\n" + "    <td class=\"value\"><textarea name=\"" + seqPrefix + "dataquery\" cols=\"64\" rows=\"6\">" + Encoder.bodyEscape((String)dataQuery) + "</textarea></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "idquery\" value=\"" + Encoder.attributeEscape((String)idQuery) + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "versionquery\" value=\"" + Encoder.attributeEscape((String)versionQuery) + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "aclquery\" value=\"" + Encoder.attributeEscape((String)aclQuery) + "\"/>\n" + "<input type=\"hidden\" name=\"" + seqPrefix + "dataquery\" value=\"" + Encoder.attributeEscape((String)dataQuery) + "\"/>\n");
        }
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            SpecificationNode sn3;
            if (!(sn3 = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn3.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        if (tabName.equals(Messages.getString(locale, "JDBCConnector.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.SecurityColon") + "</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"on\" " + (securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "JDBCConnector.Enabled") + "\n" + "      <input type=\"radio\" name=\"" + seqPrefix + "specsecurity\" value=\"off\" " + (!securityOn ? "checked=\"true\"" : "") + " />" + Messages.getBodyString(locale, "JDBCConnector.Disabled") + "\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Delete\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "JDBCConnector.DeleteToken") + "\"" + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "JDBCConnector.NoAccessTokensPresent") + "</td>\n" + "  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n" + "      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"Add\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "JDBCConnector.AddAccessToken") + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "specsecurity\" value=\"" + (securityOn ? "on" : "off") + "\"/>\n");
            i = 0;
            int k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        int i;
        String xc;
        SpecificationNode sn;
        int i2;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String idQuery = variableContext.getParameter(seqPrefix + "idquery");
        String versionQuery = variableContext.getParameter(seqPrefix + "versionquery");
        String dataQuery = variableContext.getParameter(seqPrefix + "dataquery");
        String aclQuery = variableContext.getParameter(seqPrefix + "aclquery");
        if (idQuery != null) {
            i2 = 0;
            while (i2 < ds.getChildCount()) {
                if (ds.getChild(i2).getType().equals(JDBCConstants.idQueryNode)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            sn = new SpecificationNode(JDBCConstants.idQueryNode);
            sn.setValue(idQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if (versionQuery != null) {
            i2 = 0;
            while (i2 < ds.getChildCount()) {
                if (ds.getChild(i2).getType().equals(JDBCConstants.versionQueryNode)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            sn = new SpecificationNode(JDBCConstants.versionQueryNode);
            sn.setValue(versionQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if (aclQuery != null) {
            i2 = 0;
            while (i2 < ds.getChildCount()) {
                if (ds.getChild(i2).getType().equals(JDBCConstants.aclQueryNode)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            sn = new SpecificationNode(JDBCConstants.aclQueryNode);
            sn.setValue(aclQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if (dataQuery != null) {
            i2 = 0;
            while (i2 < ds.getChildCount()) {
                if (ds.getChild(i2).getType().equals(JDBCConstants.dataQueryNode)) {
                    ds.removeChild(i2);
                    continue;
                }
                ++i2;
            }
            sn = new SpecificationNode(JDBCConstants.dataQueryNode);
            sn.setValue(dataQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("security")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode("security");
            node.setAttribute("value", xc);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            i = 0;
            while (i < ds.getChildCount()) {
                sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        String idQuery = "";
        String versionQuery = "";
        String dataQuery = "";
        String aclQuery = "";
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if ((sn = ds.getChild(i++)).getType().equals(JDBCConstants.idQueryNode)) {
                idQuery = sn.getValue();
                if (idQuery != null) continue;
                idQuery = "";
                continue;
            }
            if (sn.getType().equals(JDBCConstants.versionQueryNode)) {
                versionQuery = sn.getValue();
                if (versionQuery != null) continue;
                versionQuery = "";
                continue;
            }
            if (sn.getType().equals(JDBCConstants.dataQueryNode)) {
                dataQuery = sn.getValue();
                if (dataQuery != null) continue;
                dataQuery = "";
                continue;
            }
            if (!sn.getType().equals(JDBCConstants.aclQueryNode) || (aclQuery = sn.getValue()) != null) continue;
            aclQuery = "";
        }
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.SeedingQuery") + "</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)idQuery) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.VersionCheckQuery") + "</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)versionQuery) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.AccessTokenQuery") + "</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)aclQuery) + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.DataQuery") + "</nobr></td>\n" + "    <td class=\"value\">" + Encoder.bodyEscape((String)dataQuery) + "</td>\n" + "  </tr>\n" + "\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        i = 0;
        boolean securityOn = true;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("security")) continue;
            String securityValue = sn.getAttributeValue("value");
            if (securityValue.equals("off")) {
                securityOn = false;
                continue;
            }
            if (!securityValue.equals("on")) continue;
            securityOn = true;
        }
        out.print("  <tr>\n    <td class=\"description\">" + Messages.getBodyString(locale, "JDBCConnector.SecurityColon") + "</td>\n" + "    <td class=\"value\">" + (securityOn ? Messages.getBodyString(locale, "JDBCConnector.Enabled") : Messages.getBodyString(locale, "JDBCConnector.Disabled")) + "</td>\n" + "  </tr>\n" + "\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
        boolean seenAny = false;
        i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr><td class=\"description\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.AccessTokens") + "</nobr></td>\n" + "    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "JDBCConnector.NoAccessTokensSpecified") + "</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected void applyMetadata(RepositoryDocument rd, IResultRow row) throws ManifoldCFException {
        Iterator iter = row.getColumns();
        while (iter.hasNext()) {
            String columnName = (String)iter.next();
            if (documentKnownColumns.get(columnName) != null) continue;
            Object metadata = row.getValue(columnName);
            rd.addField(columnName, JDBCConnection.readAsString(metadata));
        }
    }

    protected void applyAccessTokens(RepositoryDocument rd, Set<String> accessTokens) throws ManifoldCFException {
        if (accessTokens == null) {
            return;
        }
        Object[] accessAcls = new String[accessTokens.size()];
        int i = 0;
        for (String accessToken : accessTokens) {
            accessAcls[i++] = accessToken;
        }
        Arrays.sort(accessAcls);
        String[] denyAcls = new String[]{defaultAuthorityDenyToken};
        rd.setSecurity("document", (String[])accessAcls, denyAcls);
    }

    public int getMaxDocumentRequest() {
        return 100;
    }

    protected static void addVariable(VariableMap map, String varName, long variable) {
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(new Long(variable));
        map.addVariable(varName, "?", params);
    }

    protected static void addVariable(VariableMap map, String varName, String variable) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(variable);
        map.addVariable(varName, "?", params);
    }

    protected static void addConstant(VariableMap map, String varName, String value) {
        map.addVariable(varName, value, null);
    }

    protected static boolean addIDList(VariableMap map, String varName, String[] documentIdentifiers, Set<String> fetchDocuments) {
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(" (");
        int k = 0;
        for (String documentIdentifier : documentIdentifiers) {
            if (fetchDocuments != null && !fetchDocuments.contains(documentIdentifier)) continue;
            if (k > 0) {
                sb.append(",");
            }
            sb.append("?");
            params.add(documentIdentifier);
            ++k;
        }
        sb.append(") ");
        map.addVariable(varName, sb.toString(), params);
        return k > 0;
    }

    protected static void substituteQuery(String inputString, VariableMap inputMap, StringBuilder outputQuery, ArrayList outputParams) throws ManifoldCFException {
        int startIndex = 0;
        while (true) {
            int nextIndex;
            if ((nextIndex = inputString.indexOf("$(", startIndex)) == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            int endIndex = inputString.indexOf(")", nextIndex);
            if (endIndex == -1) {
                outputQuery.append(inputString.substring(startIndex));
                break;
            }
            String variableName = inputString.substring(nextIndex + 2, endIndex);
            VariableMapItem item = inputMap.getVariable(variableName);
            if (item == null) {
                throw new ManifoldCFException("No such substitution variable: $(" + variableName + ")");
            }
            outputQuery.append(inputString.substring(startIndex, nextIndex));
            outputQuery.append(item.getValue());
            ArrayList inputParams = item.getParameters();
            if (inputParams != null) {
                int i = 0;
                while (i < inputParams.size()) {
                    Object x = inputParams.get(i++);
                    outputParams.add(x);
                }
            }
            startIndex = endIndex + 1;
        }
    }

    protected static String[] getAcls(DocumentSpecification spec) {
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            map.put(token, token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static String createQueryString(String queryText, ArrayList paramList) {
        StringBuilder sb = new StringBuilder(queryText);
        sb.append("; arguments = (");
        int i = 0;
        while (i < paramList.size()) {
            Object parameter;
            if (i > 0) {
                sb.append(",");
            }
            if ((parameter = paramList.get(i++)) instanceof String) {
                sb.append(JDBCConnector.quoteSQLString((String)parameter));
                continue;
            }
            sb.append(parameter.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    protected static String quoteSQLString(String input) {
        StringBuilder sb = new StringBuilder("'");
        int i = 0;
        while (i < input.length()) {
            char x;
            if ((x = input.charAt(i++)) == '\'') {
                sb.append('\'').append(x);
                continue;
            }
            if (x >= '\u0000' && x < ' ') {
                sb.append(' ');
                continue;
            }
            sb.append(x);
        }
        sb.append("'");
        return sb.toString();
    }

    static {
        documentKnownColumns.put(JDBCConstants.idReturnColumnName, "");
        documentKnownColumns.put(JDBCConstants.urlReturnColumnName, "");
        documentKnownColumns.put(JDBCConstants.dataReturnColumnName, "");
        documentKnownColumns.put(JDBCConstants.contentTypeReturnColumnName, "");
    }

    protected static class TableSpec {
        public final String idQuery;
        public final String versionQuery;
        public final String dataQuery;
        public final String aclQuery;
        public final boolean securityOn;
        public final Set<String> aclMap = new HashSet<String>();

        public TableSpec(Specification ds) {
            String idQuery = null;
            String versionQuery = null;
            String dataQuery = null;
            String aclQuery = null;
            boolean securityOn = false;
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(JDBCConstants.idQueryNode)) {
                    idQuery = sn.getValue();
                    if (idQuery != null) continue;
                    idQuery = "";
                    continue;
                }
                if (sn.getType().equals(JDBCConstants.versionQueryNode)) {
                    versionQuery = sn.getValue();
                    if (versionQuery != null) continue;
                    versionQuery = "";
                    continue;
                }
                if (sn.getType().equals(JDBCConstants.dataQueryNode)) {
                    dataQuery = sn.getValue();
                    if (dataQuery != null) continue;
                    dataQuery = "";
                    continue;
                }
                if (sn.getType().equals(JDBCConstants.aclQueryNode)) {
                    aclQuery = sn.getValue();
                    if (aclQuery != null) continue;
                    aclQuery = "";
                    continue;
                }
                if (sn.getType().equals("access")) {
                    String token = sn.getAttributeValue("token");
                    this.aclMap.add(token);
                    continue;
                }
                if (!sn.getType().equals("security")) continue;
                String value = sn.getAttributeValue("value");
                securityOn = value.equals("on");
            }
            this.idQuery = idQuery;
            this.versionQuery = versionQuery;
            this.dataQuery = dataQuery;
            this.aclQuery = aclQuery;
            this.securityOn = securityOn;
        }

        public Set<String> getAcls() {
            return this.aclMap;
        }

        public boolean isSecurityOn() {
            return this.securityOn;
        }
    }

    protected static class VariableMap {
        protected Map variableMap = new HashMap();

        public void addVariable(String variableName, String value, ArrayList parameters) {
            VariableMapItem e = new VariableMapItem(value, parameters);
            this.variableMap.put(variableName, e);
        }

        public VariableMapItem getVariable(String variableName) {
            return (VariableMapItem)this.variableMap.get(variableName);
        }
    }

    protected static class VariableMapItem {
        protected String value;
        protected ArrayList params;

        public VariableMapItem(String value, ArrayList params) {
            this.value = value;
            this.params = params;
        }

        public String getValue() {
            return this.value;
        }

        public ArrayList getParameters() {
            return this.params;
        }
    }
}

