/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.handler.WSDoAllHandler;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDoAllSender
extends WSDoAllHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$WSDoAllSender == null ? (class$org$apache$ws$axis$security$WSDoAllSender = WSDoAllSender.class$("org.apache.ws.axis.security.WSDoAllSender")) : class$org$apache$ws$axis$security$WSDoAllSender).getName());
    private static Log tlog = LogFactory.getLog((String)"org.apache.ws.security.TIME");
    static /* synthetic */ Class class$org$apache$ws$axis$security$WSDoAllSender;

    public void invoke(MessageContext mc) throws AxisFault {
        boolean doDebug = log.isDebugEnabled();
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        if (doDebug && mc.getCurrentMessage() != null && mc.getCurrentMessage().getMessageType() != null) {
            log.debug((Object)("WSDoAllSender: enter invoke() with msg type: " + mc.getCurrentMessage().getMessageType()));
        }
        RequestData reqData = new RequestData();
        reqData.setMsgContext(mc);
        try {
            Vector actions = new Vector();
            String action = this.getString("action", mc);
            if (action == null) {
                throw new AxisFault("WSDoAllSender: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction(action, actions);
            if (doAction == 0) {
                return;
            }
            reqData.setUsername((String)this.getOption("user"));
            if (reqData.getUsername() == null || reqData.getUsername().equals("")) {
                String username = (String)this.getProperty(reqData.getMsgContext(), "user");
                if (username != null) {
                    reqData.setUsername(username);
                } else {
                    reqData.setUsername(((MessageContext)reqData.getMsgContext()).getUsername());
                    ((MessageContext)reqData.getMsgContext()).setUsername(null);
                }
            }
            if ((doAction & 0x43) != 0 && (reqData.getUsername() == null || reqData.getUsername().equals(""))) {
                throw new AxisFault("WSDoAllSender: Empty username for specified action");
            }
            if (doDebug) {
                log.debug((Object)("Action: " + doAction));
                log.debug((Object)("Actor: " + reqData.getActor()));
            }
            Document doc = null;
            Message message = mc.getCurrentMessage();
            if (message == null) {
                return;
            }
            SOAPPart sPart = (SOAPPart)message.getSOAPPart();
            doc = (Document)((MessageContext)reqData.getMsgContext()).getProperty("SND_SECURITY");
            if (doc == null) {
                try {
                    doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
                }
                catch (Exception e) {
                    throw new AxisFault("WSDoAllSender: cannot get SOAP envlope from message" + e);
                }
            }
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            this.doSenderAction(doAction, doc, reqData, actions, !mc.getPastPivot());
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            if (reqData.isNoSerialization()) {
                ((MessageContext)reqData.getMsgContext()).setProperty("SND_SECURITY", (Object)doc);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
                sPart.setCurrentMessage((Object)os.toByteArray(), 4);
                if (doDebug) {
                    String osStr = null;
                    try {
                        osStr = os.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        osStr = os.toString();
                    }
                    log.debug((Object)"Send request:");
                    log.debug((Object)osStr);
                }
                ((MessageContext)reqData.getMsgContext()).setProperty("SND_SECURITY", null);
            }
            if (tlog.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
                tlog.debug((Object)("Send request: total= " + (t3 - t0) + " request preparation= " + (t1 - t0) + " request processing= " + (t2 - t1) + " request to Axis= " + (t3 - t2) + "\n"));
            }
            if (doDebug) {
                log.debug((Object)"WSDoAllSender: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

