/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hslf.model.TextPainter;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.ParagraphPropertyFetcher;
import org.apache.poi.xslf.usermodel.ListAutoNumber;
import org.apache.poi.xslf.usermodel.RenderableShape;
import org.apache.poi.xslf.usermodel.TextAlign;
import org.apache.poi.xslf.usermodel.TextFragment;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFFontManager;
import org.apache.poi.xslf.usermodel.XSLFLineBreak;
import org.apache.poi.xslf.usermodel.XSLFRenderingHint;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAutonumberScheme;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public class XSLFTextParagraph
implements Iterable<XSLFTextRun> {
    private final CTTextParagraph _p;
    private final List<XSLFTextRun> _runs;
    private final XSLFTextShape _shape;
    private List<TextFragment> _lines;
    private TextFragment _bullet;
    private double _maxLineHeight;

    XSLFTextParagraph(CTTextParagraph p, XSLFTextShape shape) {
        this._p = p;
        this._runs = new ArrayList<XSLFTextRun>();
        this._shape = shape;
        for (XmlObject ch : this._p.selectPath("*")) {
            CTRegularTextRun r;
            if (ch instanceof CTRegularTextRun) {
                CTRegularTextRun r2 = (CTRegularTextRun)ch;
                this._runs.add(new XSLFTextRun(r2, this));
                continue;
            }
            if (ch instanceof CTTextLineBreak) {
                CTTextLineBreak br = (CTTextLineBreak)ch;
                r = CTRegularTextRun.Factory.newInstance();
                r.setRPr(br.getRPr());
                r.setT("\n");
                this._runs.add(new XSLFTextRun(r, this));
                continue;
            }
            if (!(ch instanceof CTTextField)) continue;
            CTTextField f = (CTTextField)ch;
            r = CTRegularTextRun.Factory.newInstance();
            r.setRPr(f.getRPr());
            r.setT(f.getT());
            this._runs.add(new XSLFTextRun(r, this));
        }
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextRun r : this._runs) {
            out.append(r.getText());
        }
        return out.toString();
    }

    String getRenderableText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextRun r : this._runs) {
            out.append(r.getRenderableText());
        }
        return out.toString();
    }

    @Internal
    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    XSLFTextShape getParentShape() {
        return this._shape;
    }

    public List<XSLFTextRun> getTextRuns() {
        return this._runs;
    }

    @Override
    public Iterator<XSLFTextRun> iterator() {
        return this._runs.iterator();
    }

    public XSLFTextRun addNewTextRun() {
        CTRegularTextRun r = this._p.addNewR();
        CTTextCharacterProperties rPr = r.addNewRPr();
        rPr.setLang("en-US");
        XSLFTextRun run = new XSLFTextRun(r, this);
        this._runs.add(run);
        return run;
    }

    public XSLFTextRun addLineBreak() {
        CTTextLineBreak br = this._p.addNewBr();
        CTTextCharacterProperties brProps = br.addNewRPr();
        if (this._runs.size() > 0) {
            CTTextCharacterProperties prevRun = this._runs.get(this._runs.size() - 1).getRPr();
            brProps.set((XmlObject)prevRun);
        }
        CTRegularTextRun r = CTRegularTextRun.Factory.newInstance();
        r.setRPr(brProps);
        r.setT("\n");
        XSLFLineBreak run = new XSLFLineBreak(r, this, brProps);
        this._runs.add(run);
        return run;
    }

    public TextAlign getTextAlign() {
        ParagraphPropertyFetcher<TextAlign> fetcher = new ParagraphPropertyFetcher<TextAlign>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetAlgn()) {
                    TextAlign val = TextAlign.values()[props.getAlgn().intValue() - 1];
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? TextAlign.LEFT : (TextAlign)((Object)fetcher.getValue());
    }

    public void setTextAlign(TextAlign align) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (align == null) {
            if (pr.isSetAlgn()) {
                pr.unsetAlgn();
            }
        } else {
            pr.setAlgn(STTextAlignType.Enum.forInt((int)(align.ordinal() + 1)));
        }
    }

    public String getBulletFont() {
        ParagraphPropertyFetcher<String> fetcher = new ParagraphPropertyFetcher<String>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuFont()) {
                    this.setValue(props.getBuFont().getTypeface());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletFont(String typeface) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextFont font = pr.isSetBuFont() ? pr.getBuFont() : pr.addNewBuFont();
        font.setTypeface(typeface);
    }

    public String getBulletCharacter() {
        ParagraphPropertyFetcher<String> fetcher = new ParagraphPropertyFetcher<String>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuChar()) {
                    this.setValue(props.getBuChar().getChar());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletCharacter(String str) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextCharBullet c = pr.isSetBuChar() ? pr.getBuChar() : pr.addNewBuChar();
        c.setChar(str);
    }

    public Color getBulletFontColor() {
        final XSLFTheme theme = this.getParentShape().getSheet().getTheme();
        ParagraphPropertyFetcher<Color> fetcher = new ParagraphPropertyFetcher<Color>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuClr()) {
                    XSLFColor c = new XSLFColor((XmlObject)props.getBuClr(), theme, null);
                    this.setValue(c.getColor());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Color)fetcher.getValue();
    }

    public void setBulletFontColor(Color color) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTColor c = pr.isSetBuClr() ? pr.getBuClr() : pr.addNewBuClr();
        CTSRgbColor clr = c.isSetSrgbClr() ? c.getSrgbClr() : c.addNewSrgbClr();
        clr.setVal(new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()});
    }

    public double getBulletFontSize() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuSzPct()) {
                    this.setValue((double)props.getBuSzPct().getVal() * 0.001);
                    return true;
                }
                if (props.isSetBuSzPts()) {
                    this.setValue((double)(-props.getBuSzPts().getVal()) * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 100.0 : (Double)fetcher.getValue();
    }

    public void setBulletFontSize(double bulletSize) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (bulletSize >= 0.0) {
            CTTextBulletSizePercent pt = pr.isSetBuSzPct() ? pr.getBuSzPct() : pr.addNewBuSzPct();
            pt.setVal((int)(bulletSize * 1000.0));
            if (pr.isSetBuSzPts()) {
                pr.unsetBuSzPts();
            }
        } else {
            CTTextBulletSizePoint pt = pr.isSetBuSzPts() ? pr.getBuSzPts() : pr.addNewBuSzPts();
            pt.setVal((int)(-bulletSize * 100.0));
            if (pr.isSetBuSzPct()) {
                pr.unsetBuSzPct();
            }
        }
    }

    public void setIndent(double value) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (value == -1.0) {
            if (pr.isSetIndent()) {
                pr.unsetIndent();
            }
        } else {
            pr.setIndent(Units.toEMU((double)value));
        }
    }

    public double getIndent() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetIndent()) {
                    this.setValue(Units.toPoints((long)props.getIndent()));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setLeftMargin(double value) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (value == -1.0) {
            if (pr.isSetMarL()) {
                pr.unsetMarL();
            }
        } else {
            pr.setMarL(Units.toEMU((double)value));
        }
    }

    public double getLeftMargin() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetMarL()) {
                    double val = Units.toPoints((long)props.getMarL());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public double getDefaultTabSize() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetDefTabSz()) {
                    double val = Units.toPoints((long)props.getDefTabSz());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public double getTabStop(final int idx) {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                CTTextTabStopList tabStops;
                if (props.isSetTabLst() && idx < (tabStops = props.getTabLst()).sizeOfTabArray()) {
                    CTTextTabStop ts = tabStops.getTabArray(idx);
                    double val = Units.toPoints((long)ts.getPos());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void addTabStop(double value) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextTabStopList tabStops = pr.isSetTabLst() ? pr.getTabLst() : pr.addNewTabLst();
        tabStops.addNewTab().setPos(Units.toEMU((double)value));
    }

    public void setLineSpacing(double linespacing) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (linespacing >= 0.0) {
            spc.addNewSpcPct().setVal((int)(linespacing * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-linespacing * 100.0));
        }
        pr.setLnSpc(spc);
    }

    public double getLineSpacing() {
        CTTextNormalAutofit normAutofit;
        double lnSpc;
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetLnSpc()) {
                    CTTextSpacing spc = props.getLnSpc();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        double d = lnSpc = fetcher.getValue() == null ? 100.0 : (Double)fetcher.getValue();
        if (lnSpc > 0.0 && (normAutofit = this.getParentShape().getTextBodyPr().getNormAutofit()) != null) {
            double scale = 1.0 - (double)normAutofit.getLnSpcReduction() / 100000.0;
            lnSpc *= scale;
        }
        return lnSpc;
    }

    public void setSpaceBefore(double spaceBefore) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceBefore >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceBefore * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceBefore * 100.0));
        }
        pr.setSpcBef(spc);
    }

    public double getSpaceBefore() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcBef()) {
                    CTTextSpacing spc = props.getSpcBef();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        double spcBef = fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
        return spcBef;
    }

    public void setSpaceAfter(double spaceAfter) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceAfter >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceAfter * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceAfter * 100.0));
        }
        pr.setSpcAft(spc);
    }

    public double getSpaceAfter() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcAft()) {
                    CTTextSpacing spc = props.getSpcAft();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void setLevel(int level) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        pr.setLvl(level);
    }

    public int getLevel() {
        CTTextParagraphProperties pr = this._p.getPPr();
        if (pr == null) {
            return 0;
        }
        return pr.getLvl();
    }

    public boolean isBullet() {
        ParagraphPropertyFetcher<Boolean> fetcher = new ParagraphPropertyFetcher<Boolean>(this.getLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuNone()) {
                    this.setValue(false);
                    return true;
                }
                if (props.isSetBuFont() || props.isSetBuChar()) {
                    this.setValue(true);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setBullet(boolean flag) {
        CTTextParagraphProperties pr;
        if (this.isBullet() == flag) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (!flag) {
            pr.addNewBuNone();
        } else {
            pr.addNewBuFont().setTypeface("Arial");
            pr.addNewBuChar().setChar("\u2022");
        }
    }

    public void setBulletAutoNumber(ListAutoNumber scheme, int startAt) {
        if (startAt < 1) {
            throw new IllegalArgumentException("Start Number must be greater or equal that 1");
        }
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet lst = pr.isSetBuAutoNum() ? pr.getBuAutoNum() : pr.addNewBuAutoNum();
        lst.setType(STTextAutonumberScheme.Enum.forInt((int)(scheme.ordinal() + 1)));
        lst.setStartAt(startAt);
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    List<TextFragment> getTextLines() {
        return this._lines;
    }

    double getWrappingWidth(boolean firstLine, Graphics2D graphics) {
        double width;
        double leftInset = this._shape.getLeftInset();
        double rightInset = this._shape.getRightInset();
        RenderableShape rShape = new RenderableShape(this._shape);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        double leftMargin = this.getLeftMargin();
        double indent = this.getIndent();
        if (!this._shape.getWordWrap()) {
            width = this._shape.getSheet().getSlideShow().getPageSize().getWidth() - anchor.getX();
        } else {
            width = anchor.getWidth() - leftInset - rightInset - leftMargin;
            if (firstLine) {
                if (this.isBullet()) {
                    if (indent > 0.0) {
                        width -= indent;
                    }
                } else if (indent > 0.0) {
                    width -= indent;
                } else if (indent < 0.0) {
                    width += leftMargin;
                }
            }
        }
        return width;
    }

    public double draw(Graphics2D graphics, double x, double y) {
        double leftInset = this._shape.getLeftInset();
        double rightInset = this._shape.getRightInset();
        RenderableShape rShape = new RenderableShape(this._shape);
        Rectangle2D anchor = rShape.getAnchor(graphics);
        double penY = y;
        double leftMargin = this.getLeftMargin();
        boolean firstLine = true;
        double indent = this.getIndent();
        double spacing = this.getLineSpacing();
        for (TextFragment line : this._lines) {
            double penX = x + leftMargin;
            if (firstLine) {
                if (this._bullet != null) {
                    if (indent < 0.0) {
                        this._bullet.draw(graphics, penX + indent, penY);
                    } else if (indent > 0.0) {
                        this._bullet.draw(graphics, penX, penY);
                        penX += indent;
                    } else {
                        this._bullet.draw(graphics, penX, penY);
                        penX += (double)(this._bullet._layout.getAdvance() + 1.0f);
                    }
                } else {
                    penX += indent;
                }
            }
            switch (this.getTextAlign()) {
                case CENTER: {
                    penX += (anchor.getWidth() - leftMargin - (double)line.getWidth() - leftInset - rightInset) / 2.0;
                    break;
                }
                case RIGHT: {
                    penX += anchor.getWidth() - (double)line.getWidth() - leftInset - rightInset;
                    break;
                }
            }
            line.draw(graphics, penX, penY);
            penY = spacing > 0.0 ? (penY += spacing * 0.01 * (double)line.getHeight()) : (penY += -spacing);
            firstLine = false;
        }
        return penY - y;
    }

    AttributedString getAttributedString(Graphics2D graphics) {
        String text = this.getRenderableText();
        AttributedString string = new AttributedString(text);
        XSLFFontManager fontHandler = (XSLFFontManager)graphics.getRenderingHint(XSLFRenderingHint.FONT_HANDLER);
        int startIndex = 0;
        for (XSLFTextRun run : this._runs) {
            int length = run.getRenderableText().length();
            if (length == 0) continue;
            int endIndex = startIndex + length;
            string.addAttribute(TextAttribute.FOREGROUND, run.getFontColor(), startIndex, endIndex);
            String fontFamily = run.getFontFamily();
            Map fontMap = (Map)graphics.getRenderingHint((RenderingHints.Key)TextPainter.KEY_FONTMAP);
            if (fontMap != null && fontMap.containsKey(fontFamily)) {
                fontFamily = (String)fontMap.get(fontFamily);
            }
            if (fontHandler != null) {
                fontFamily = fontHandler.getRendererableFont(fontFamily, run.getPitchAndFamily());
            }
            string.addAttribute(TextAttribute.FAMILY, fontFamily, startIndex, endIndex);
            float fontSz = (float)run.getFontSize();
            string.addAttribute(TextAttribute.SIZE, Float.valueOf(fontSz), startIndex, endIndex);
            if (run.isBold()) {
                string.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIndex, endIndex);
            }
            if (run.isItalic()) {
                string.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIndex, endIndex);
            }
            if (run.isUnderline()) {
                string.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIndex, endIndex);
                string.addAttribute(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, startIndex, endIndex);
            }
            if (run.isStrikethrough()) {
                string.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, startIndex, endIndex);
            }
            if (run.isSubscript()) {
                string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, startIndex, endIndex);
            }
            if (run.isSuperscript()) {
                string.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, startIndex, endIndex);
            }
            startIndex = endIndex;
        }
        return string;
    }

    private void ensureNotEmpty() {
        XSLFTextRun r = this.addNewTextRun();
        r.setText(" ");
        CTTextCharacterProperties endPr = this._p.getEndParaRPr();
        if (endPr != null && endPr.isSetSz()) {
            r.setFontSize(endPr.getSz() / 100);
        }
    }

    List<TextFragment> breakText(Graphics2D graphics) {
        int endIndex;
        String text;
        boolean emptyParagraph;
        this._lines = new ArrayList<TextFragment>();
        boolean bl = emptyParagraph = this._runs.size() == 0;
        if (this._runs.size() == 0) {
            this.ensureNotEmpty();
        }
        if ((text = this.getRenderableText()).length() == 0) {
            return this._lines;
        }
        AttributedString at = this.getAttributedString(graphics);
        AttributedCharacterIterator it = at.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, graphics.getFontRenderContext());
        do {
            TextAlign hAlign;
            TextLayout layout;
            int nextBreak;
            int startIndex = measurer.getPosition();
            double wrappingWidth = this.getWrappingWidth(this._lines.size() == 0, graphics) + 1.0;
            if (wrappingWidth < 0.0) {
                wrappingWidth = 1.0;
            }
            if ((nextBreak = text.indexOf(10, startIndex + 1)) == -1) {
                nextBreak = it.getEndIndex();
            }
            if ((layout = measurer.nextLayout((float)wrappingWidth, nextBreak, true)) == null) {
                layout = measurer.nextLayout((float)wrappingWidth, nextBreak, false);
            }
            if (layout == null) break;
            endIndex = measurer.getPosition();
            if (endIndex < it.getEndIndex() && text.charAt(endIndex) == '\n') {
                measurer.setPosition(endIndex + 1);
            }
            if ((hAlign = this.getTextAlign()) == TextAlign.JUSTIFY || hAlign == TextAlign.JUSTIFY_LOW) {
                layout = layout.getJustifiedLayout((float)wrappingWidth);
            }
            AttributedString str = new AttributedString(it, startIndex, endIndex);
            TextFragment line = new TextFragment(layout, emptyParagraph ? null : str);
            this._lines.add(line);
            this._maxLineHeight = Math.max(this._maxLineHeight, (double)line.getHeight());
        } while (endIndex != it.getEndIndex());
        if (this.isBullet() && !emptyParagraph) {
            String buCharacter = this.getBulletCharacter();
            String buFont = this.getBulletFont();
            if (buFont == null) {
                buFont = this.getTextRuns().get(0).getFontFamily();
            }
            if (buCharacter != null && buFont != null && this._lines.size() > 0) {
                AttributedString str = new AttributedString(buCharacter);
                TextFragment firstLine = this._lines.get(0);
                AttributedCharacterIterator bit = firstLine._str.getIterator();
                Color buColor = this.getBulletFontColor();
                str.addAttribute(TextAttribute.FOREGROUND, buColor == null ? bit.getAttribute(TextAttribute.FOREGROUND) : buColor);
                str.addAttribute(TextAttribute.FAMILY, buFont);
                float fontSize = ((Float)bit.getAttribute(TextAttribute.SIZE)).floatValue();
                float buSz = (float)this.getBulletFontSize();
                fontSize = buSz > 0.0f ? (float)((double)fontSize * ((double)buSz * 0.01)) : -buSz;
                str.addAttribute(TextAttribute.SIZE, Float.valueOf(fontSize));
                TextLayout layout = new TextLayout(str.getIterator(), graphics.getFontRenderContext());
                this._bullet = new TextFragment(layout, str);
            }
        }
        return this._lines;
    }

    CTTextParagraphProperties getDefaultMasterStyle() {
        String defaultStyleSelector;
        CTPlaceholder ph = this._shape.getCTPlaceholder();
        if (ph == null) {
            defaultStyleSelector = "otherStyle";
        } else {
            switch (ph.getType().intValue()) {
                case 1: 
                case 3: {
                    defaultStyleSelector = "titleStyle";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    defaultStyleSelector = "otherStyle";
                    break;
                }
                default: {
                    defaultStyleSelector = "bodyStyle";
                }
            }
        }
        int level = this.getLevel();
        XSLFSheet masterSheet = this._shape.getSheet();
        while (masterSheet.getMasterSheet() != null) {
            masterSheet = masterSheet.getMasterSheet();
        }
        XmlObject[] o = masterSheet.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:txStyles/p:" + defaultStyleSelector + "/a:lvl" + (level + 1) + "pPr");
        if (o.length == 1) {
            return (CTTextParagraphProperties)o[0];
        }
        o = masterSheet.getXmlObject().selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:notesStyle/a:lvl" + (level + 1) + "pPr");
        if (o.length == 1) {
            return (CTTextParagraphProperties)o[0];
        }
        throw new IllegalArgumentException("Failed to fetch default style for " + defaultStyleSelector + " and level=" + level);
    }

    private <T> boolean fetchParagraphProperty(ParagraphPropertyFetcher<T> visitor) {
        XSLFTextShape shape;
        boolean ok = false;
        if (this._p.isSetPPr()) {
            ok = visitor.fetch(this._p.getPPr());
        }
        if (!ok && !(ok = (shape = this.getParentShape()).fetchShapeProperty(visitor))) {
            CTTextParagraphProperties defaultProps;
            XMLSlideShow ppt;
            CTTextParagraphProperties themeProps;
            CTPlaceholder ph = shape.getCTPlaceholder();
            if (ph == null && (themeProps = (ppt = this.getParentShape().getSheet().getSlideShow()).getDefaultParagraphStyle(this.getLevel())) != null) {
                ok = visitor.fetch(themeProps);
            }
            if (!ok && (defaultProps = this.getDefaultMasterStyle()) != null) {
                ok = visitor.fetch(defaultProps);
            }
        }
        return ok;
    }

    void copy(XSLFTextParagraph p) {
        double lineSpacing;
        double spaceBefore;
        double spaceAfter;
        double indent;
        double leftMargin;
        boolean isBullet;
        TextAlign srcAlign = p.getTextAlign();
        if (srcAlign != this.getTextAlign()) {
            this.setTextAlign(srcAlign);
        }
        if ((isBullet = p.isBullet()) != this.isBullet()) {
            this.setBullet(isBullet);
            if (isBullet) {
                double buSize;
                Color buColor;
                String buChar;
                String buFont = p.getBulletFont();
                if (buFont != null && !buFont.equals(this.getBulletFont())) {
                    this.setBulletFont(buFont);
                }
                if ((buChar = p.getBulletCharacter()) != null && !buChar.equals(this.getBulletCharacter())) {
                    this.setBulletCharacter(buChar);
                }
                if ((buColor = p.getBulletFontColor()) != null && !buColor.equals(this.getBulletFontColor())) {
                    this.setBulletFontColor(buColor);
                }
                if ((buSize = p.getBulletFontSize()) != this.getBulletFontSize()) {
                    this.setBulletFontSize(buSize);
                }
            }
        }
        if ((leftMargin = p.getLeftMargin()) != this.getLeftMargin()) {
            this.setLeftMargin(leftMargin);
        }
        if ((indent = p.getIndent()) != this.getIndent()) {
            this.setIndent(indent);
        }
        if ((spaceAfter = p.getSpaceAfter()) != this.getSpaceAfter()) {
            this.setSpaceAfter(spaceAfter);
        }
        if ((spaceBefore = p.getSpaceBefore()) != this.getSpaceBefore()) {
            this.setSpaceBefore(spaceBefore);
        }
        if ((lineSpacing = p.getLineSpacing()) != this.getLineSpacing()) {
            this.setLineSpacing(lineSpacing);
        }
        List<XSLFTextRun> srcR = p.getTextRuns();
        List<XSLFTextRun> tgtR = this.getTextRuns();
        for (int i = 0; i < srcR.size(); ++i) {
            XSLFTextRun r1 = srcR.get(i);
            XSLFTextRun r2 = tgtR.get(i);
            r2.copy(r1);
        }
    }
}

