/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.sharedrive;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SharedDriveHelpers {
    public static final String _rcsid = "@(#)$Id: SharedDriveHelpers.java 988245 2010-08-23 18:39:35Z kwright $";
    private NtlmPasswordAuthentication pa;
    private SmbFile smbconnection;

    public SharedDriveHelpers(String serverName, String userName, String password) throws ManifoldCFException {
        try {
            this.pa = new NtlmPasswordAuthentication(userName + ":" + password);
            this.smbconnection = new SmbFile("smb://" + serverName + "/", this.pa);
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Unable to access SMB/CIFS share: " + serverName, (Throwable)e, 3);
        }
    }

    public void close() throws ManifoldCFException {
        this.pa = null;
        this.smbconnection = null;
    }

    public String lookupDocument(String targetPath) throws ManifoldCFException {
        try {
            String identifier = this.mapToIdentifier(targetPath);
            SmbFile file = new SmbFile(identifier, this.pa);
            if (file.exists()) {
                return targetPath;
            }
            return "";
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDocument(String targetPath, String sourceFile) throws ManifoldCFException {
        try {
            String identifier = this.mapToIdentifier(targetPath);
            SmbFile file = new SmbFile(identifier, this.pa);
            try (FileInputStream is = new FileInputStream(sourceFile);){
                if (!file.exists()) {
                    file.createNewFile();
                    file = new SmbFile(identifier, this.pa);
                }
                try (OutputStream os = file.getOutputStream();){
                    int amt;
                    byte[] bytes = new byte[65536];
                    while ((amt = ((InputStream)is).read(bytes, 0, bytes.length)) != -1) {
                        if (amt <= 0) continue;
                        os.write(bytes, 0, amt);
                    }
                }
            }
            return targetPath;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteDocument(String targetPath) throws ManifoldCFException {
        try {
            String identifier = this.mapToIdentifier(targetPath);
            SmbFile file = new SmbFile(identifier, this.pa);
            file.delete();
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void addUserToFolder(String targetPath, String userName) throws ManifoldCFException {
    }

    public void removeUserFromFolder(String targetPath, String userName) throws ManifoldCFException {
    }

    protected String mapToIdentifier(String path) throws IOException {
        String smburi = this.smbconnection.getCanonicalPath();
        String uri = smburi + path + "/";
        return new SmbFile(uri, this.pa).getCanonicalPath();
    }
}

