/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.sharepoint;

import com.microsoft.schemas.sharepoint.dsp.DSQuery;
import com.microsoft.schemas.sharepoint.dsp.DocumentType;
import com.microsoft.schemas.sharepoint.dsp.DspQuery;
import com.microsoft.schemas.sharepoint.dsp.DspQueryWhere;
import com.microsoft.schemas.sharepoint.dsp.Field;
import com.microsoft.schemas.sharepoint.dsp.Fields;
import com.microsoft.schemas.sharepoint.dsp.MethodType;
import com.microsoft.schemas.sharepoint.dsp.QueryRequest;
import com.microsoft.schemas.sharepoint.dsp.QueryResponse;
import com.microsoft.schemas.sharepoint.dsp.RequestHeader;
import com.microsoft.schemas.sharepoint.dsp.ResultContentType;
import com.microsoft.schemas.sharepoint.dsp.StsAdapterLocator;
import com.microsoft.schemas.sharepoint.dsp.StsAdapterSoap;
import com.microsoft.schemas.sharepoint.dsp.StsAdapterSoapStub;
import com.microsoft.schemas.sharepoint.soap.GetAttachmentCollectionResponseGetAttachmentCollectionResult;
import com.microsoft.schemas.sharepoint.soap.GetListCollectionResponseGetListCollectionResult;
import com.microsoft.schemas.sharepoint.soap.GetListItemsQuery;
import com.microsoft.schemas.sharepoint.soap.GetListItemsQueryOptions;
import com.microsoft.schemas.sharepoint.soap.GetListItemsResponseGetListItemsResult;
import com.microsoft.schemas.sharepoint.soap.GetListItemsViewFields;
import com.microsoft.schemas.sharepoint.soap.GetListResponseGetListResult;
import com.microsoft.schemas.sharepoint.soap.GetVersionsResponseGetVersionsResult;
import com.microsoft.schemas.sharepoint.soap.GetWebCollectionResponseGetWebCollectionResult;
import com.microsoft.schemas.sharepoint.soap.ListsLocator;
import com.microsoft.schemas.sharepoint.soap.ListsSoap;
import com.microsoft.schemas.sharepoint.soap.ListsSoapStub;
import com.microsoft.schemas.sharepoint.soap.VersionsLocator;
import com.microsoft.schemas.sharepoint.soap.VersionsSoap;
import com.microsoft.schemas.sharepoint.soap.VersionsSoapStub;
import com.microsoft.schemas.sharepoint.soap.WebsLocator;
import com.microsoft.schemas.sharepoint.soap.WebsSoap;
import com.microsoft.schemas.sharepoint.soap.WebsSoapStub;
import com.microsoft.schemas.sharepoint.soap.directory.GetUserCollectionFromGroupResponseGetUserCollectionFromGroupResult;
import com.microsoft.schemas.sharepoint.soap.directory.GetUserCollectionFromRoleResponseGetUserCollectionFromRoleResult;
import com.microsoft.schemas.sharepoint.soap.directory.GetUserInfoResponseGetUserInfoResult;
import com.microsoft.schemas.sharepoint.soap.directory.PermissionsLocator;
import com.microsoft.schemas.sharepoint.soap.directory.PermissionsSoapStub;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupLocator;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupSoap;
import com.microsoft.schemas.sharepoint.soap.directory.UserGroupSoapStub;
import com.microsoft.sharepoint.webpartpages.GetPermissionCollectionResponseGetPermissionCollectionResult;
import com.microsoft.sharepoint.webpartpages.PermissionsSoap;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.http.client.HttpClient;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.common.XMLDoc;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.sharepoint.IFileStream;
import org.apache.manifoldcf.crawler.connectors.sharepoint.NameValue;
import org.apache.manifoldcf.crawler.connectors.sharepoint.VersionsHeader;
import org.apache.manifoldcf.crawler.system.Logging;
import org.w3c.dom.Element;

public class SPSProxyHelper {
    public static final String HTTPCLIENT_PROPERTY = "ManifoldCF_HttpClient";
    private String serverUrl;
    private String serverLocation;
    private String decodedServerLocation;
    private String baseUrl;
    private String userName;
    private String password;
    private EngineConfiguration configuration;
    private HttpClient httpClient;
    protected static Pattern subsPattern;

    public SPSProxyHelper(String serverUrl, String serverLocation, String decodedServerLocation, String userName, String password, Class resourceClass, String configFileName, HttpClient httpClient) {
        this.serverUrl = serverUrl;
        this.serverLocation = serverLocation;
        this.decodedServerLocation = decodedServerLocation;
        this.baseUrl = serverLocation.equals("/") ? serverUrl : serverUrl + serverLocation;
        this.userName = userName;
        this.password = password;
        this.configuration = new ResourceProvider(resourceClass, configFileName);
        this.httpClient = httpClient;
    }

    public String[] getACLs(String site, String guid, boolean activeDirectoryAuthority) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getACLs; site='" + site + "', guid='" + guid + "', activeDirectoryAuthority=" + activeDirectoryAuthority));
        }
        try {
            if (site.compareTo("/") == 0) {
                site = "";
            }
            UserGroupWS userService = new UserGroupWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            UserGroupSoap userCall = userService.getUserGroupSoapHandler();
            PermissionsWS aclService = new PermissionsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            com.microsoft.schemas.sharepoint.soap.directory.PermissionsSoap aclCall = aclService.getPermissionsSoapHandler();
            com.microsoft.schemas.sharepoint.soap.directory.GetPermissionCollectionResponseGetPermissionCollectionResult aclResult = aclCall.getPermissionCollection(guid, "List");
            MessageElement[] aclList = aclResult.get_any();
            String xmlResponse = aclList[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getACLs xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:GetPermissionCollection' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:GetPermissionCollection")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:GetPermissionCollection'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException(" No results found.");
            }
            parent = nodeList.get(0);
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            HashSet<String> sids = new HashSet<String>();
            for (int i = 0; i < nodeList.size(); ++i) {
                List<String> roleSids;
                Object node = nodeList.get(i);
                String mask = doc.getValue(node, "Mask");
                long maskValue = new Long(mask);
                if ((maskValue & 1L) != 1L) continue;
                String isUser = doc.getValue(node, "MemberIsUser");
                if (isUser.compareToIgnoreCase("True") == 0) {
                    String userLogin = doc.getValue(node, "UserLogin");
                    String userSid = this.getSidForUser(userCall, userLogin, activeDirectoryAuthority);
                    sids.add(userSid);
                    continue;
                }
                String roleName = doc.getValue(node, "RoleName");
                if (roleName.length() == 0) {
                    roleName = doc.getValue(node, "GroupName");
                    if (roleName != null && roleName.length() > 0) {
                        roleSids = this.getSidsForGroup(userCall, roleName, activeDirectoryAuthority);
                    } else {
                        Logging.connectors.warn((Object)("SharePoint: Unrecognized permission collection entry: no role, no group: " + doc.getXML()));
                        roleSids = new ArrayList<String>();
                    }
                } else {
                    roleSids = this.getSidsForRole(userCall, roleName, activeDirectoryAuthority);
                }
                for (String sid : roleSids) {
                    sids.add(sid);
                }
            }
            return sids.toArray(new String[0]);
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting the acls for site " + site + " guid " + guid + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + site + " did not exist; assuming list/library deleted"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to the permissions service for " + this.baseUrl + site + "; skipping documents within"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The list " + guid + " in site " + site + " did not exist; assuming list/library deleted"));
                        }
                        return null;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting permissions for the list " + guid + " in site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return null;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting the acls for site " + site + " guid " + guid + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting the acls for site " + site + " guid " + guid + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting the acls for site " + site + " guid " + guid), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public String[] getDocumentACLs(String site, String file, boolean activeDirectoryAuthority) throws ManifoldCFException, ServiceInterruption {
        try {
            String encodedRelativePath;
            if (site.compareTo("/") == 0) {
                site = "";
            }
            if ((encodedRelativePath = this.serverLocation + file).startsWith("/")) {
                encodedRelativePath = encodedRelativePath.substring(1);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: In getDocumentACLs for site '" + site + "', file '" + file + "': Encoded relative path is '" + encodedRelativePath + "'"));
            }
            UserGroupWS userService = new UserGroupWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            UserGroupSoap userCall = userService.getUserGroupSoapHandler();
            MCPermissionsWS aclService = new MCPermissionsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            PermissionsSoap aclCall = aclService.getPermissionsSoapHandler();
            GetPermissionCollectionResponseGetPermissionCollectionResult aclResult = aclCall.getPermissionCollection(encodedRelativePath, "Item");
            if (aclResult == null) {
                Logging.connectors.debug((Object)"SharePoint: getDocumentACLs: document acls were null");
                return null;
            }
            MessageElement[] aclList = aclResult.get_any();
            String xmlResponse = aclList[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getDocumentACLs xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:GetPermissionCollection' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("GetPermissionCollection")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'GetPermissionCollection'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException(" No results found.");
            }
            parent = nodeList.get(0);
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            HashSet<String> sids = new HashSet<String>();
            for (int i = 0; i < nodeList.size(); ++i) {
                List<String> roleSids;
                Object node = nodeList.get(i);
                String mask = doc.getValue(node, "Mask");
                long maskValue = new Long(mask);
                if ((maskValue & 1L) != 1L) continue;
                String isUser = doc.getValue(node, "MemberIsUser");
                if (isUser.compareToIgnoreCase("True") == 0) {
                    String userLogin = doc.getValue(node, "UserLogin");
                    String userSid = this.getSidForUser(userCall, userLogin, activeDirectoryAuthority);
                    sids.add(userSid);
                    continue;
                }
                String roleName = doc.getValue(node, "RoleName");
                if (roleName.length() == 0) {
                    roleName = doc.getValue(node, "GroupName");
                    roleSids = this.getSidsForGroup(userCall, roleName, activeDirectoryAuthority);
                } else {
                    roleSids = this.getSidsForRole(userCall, roleName, activeDirectoryAuthority);
                }
                for (String sid : roleSids) {
                    sids.add(sid);
                }
            }
            return sids.toArray(new String[0]);
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting the acls for site " + site + " file " + file + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + site + " did not exist; assuming library deleted"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to the MCPermissions service for " + this.baseUrl + site + "; skipping documents within"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The file " + file + " in site " + site + " did not exist; assuming file deleted"));
                        }
                        return null;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting permissions for the file " + file + " in site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return null;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting the acls for site " + site + " file " + file + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting the acls for site " + site + " file " + file + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting the acls for site " + site + " file " + file), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean getChildren(IFileStream fileStream, String site, String guid, boolean dspStsWorks) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getChildren; site='" + site + "', guid='" + guid + "', dspStsWorks=" + dspStsWorks));
        }
        try {
            if (site.equals("/")) {
                site = "";
            }
            if (dspStsWorks) {
                StsAdapterWS listService = new StsAdapterWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
                StsAdapterSoapStub stub = (StsAdapterSoapStub)listService.getStsAdapterSoapHandler();
                String[] vArray = new String[]{"1.0"};
                VersionsHeader myVersion = new VersionsHeader();
                myVersion.setVersion(vArray);
                stub.setHeader("http://schemas.microsoft.com/sharepoint/dsp", "versions", myVersion);
                RequestHeader reqHeader = new RequestHeader();
                reqHeader.setDocument(DocumentType.content);
                reqHeader.setMethod(MethodType.query);
                stub.setHeader("http://schemas.microsoft.com/sharepoint/dsp", "request", reqHeader);
                QueryRequest myRequest = new QueryRequest();
                DSQuery sQuery = new DSQuery();
                sQuery.setSelect("/list[@id='" + guid + "']");
                myRequest.setDsQuery(sQuery);
                StsAdapterSoapStub call = stub;
                ArrayList nodeList = new ArrayList();
                QueryResponse resp = call.query(myRequest);
                MessageElement[] list = resp.get_any();
                String xmlResponse = list[0].toString();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: getChildren xml response: " + xmlResponse));
                }
                XMLDoc doc = new XMLDoc(xmlResponse);
                doc.processPath(nodeList, "*", null);
                if (nodeList.size() != 1) {
                    throw new ManifoldCFException("Bad xml - missing outer 'ns1:dsQueryResponse' node - there are " + Integer.toString(nodeList.size()) + " nodes");
                }
                Object parent = nodeList.get(0);
                if (!doc.getNodeName(parent).equals("ns1:dsQueryResponse")) {
                    throw new ManifoldCFException("Bad xml - outer node is not 'ns1:dsQueryResponse'");
                }
                nodeList.clear();
                doc.processPath(nodeList, "*", parent);
                if (nodeList.size() != 2) {
                    throw new ManifoldCFException(" No results found.");
                }
                XMLDoc docs = doc;
                ArrayList nodeDocs = new ArrayList();
                docs.processPath(nodeDocs, "*", null);
                parent = nodeDocs.get(0);
                nodeDocs.clear();
                docs.processPath(nodeDocs, "*", parent);
                Object documents = nodeDocs.get(1);
                nodeDocs.clear();
                docs.processPath(nodeDocs, "*", documents);
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < nodeDocs.size(); ++j) {
                    Object node = nodeDocs.get(j);
                    Logging.connectors.debug((Object)node.toString());
                    String relPath = docs.getData(docs.getElement(node, "FileRef"));
                    fileStream.addFile(relPath, null);
                }
            } else {
                MCPermissionsWS itemService = new MCPermissionsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
                PermissionsSoap itemCall = itemService.getPermissionsSoapHandler();
                int startingIndex = 0;
                int amtToRequest = 10000;
                while (true) {
                    com.microsoft.sharepoint.webpartpages.GetListItemsResponseGetListItemsResult itemsResult = itemCall.getListItems(guid, Integer.toString(startingIndex), Integer.toString(amtToRequest));
                    MessageElement[] itemsList = itemsResult.get_any();
                    if (Logging.connectors.isDebugEnabled()) {
                        Logging.connectors.debug((Object)("SharePoint: getChildren xml response: " + itemsList[0].toString()));
                    }
                    if (itemsList.length != 1) {
                        throw new ManifoldCFException("Bad response - expecting one outer 'GetListItems' node, saw " + Integer.toString(itemsList.length));
                    }
                    MessageElement items = itemsList[0];
                    if (!items.getElementName().getLocalName().equals("GetListItems")) {
                        throw new ManifoldCFException("Bad response - outer node should have been 'GetListItems' node");
                    }
                    int resultCount = 0;
                    Iterator iter = items.getChildElements();
                    while (iter.hasNext()) {
                        MessageElement child = (MessageElement)iter.next();
                        if (!child.getElementName().getLocalName().equals("GetListItemsResponse")) continue;
                        Iterator resultIter = child.getChildElements();
                        while (resultIter.hasNext()) {
                            MessageElement result = (MessageElement)resultIter.next();
                            if (!result.getElementName().getLocalName().equals("GetListItemsResult")) continue;
                            ++resultCount;
                            String relPath = result.getAttribute("FileRef");
                            String displayURL = result.getAttribute("ListItemURL");
                            fileStream.addFile(relPath, displayURL);
                        }
                    }
                    if (resultCount < amtToRequest) break;
                    startingIndex += resultCount;
                }
            }
            return true;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting documents for site " + site + " guid " + guid + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + site + " did not exist; assuming library deleted"));
                        }
                        return false;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to list documents for " + this.baseUrl + site + "; skipping documents within"));
                        }
                        return false;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The list " + guid + " in site " + site + " did not exist; assuming library deleted"));
                        }
                        return false;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting child documents for the list " + guid + " in site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return false;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting child documents for site " + site + " guid " + guid + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting child documents for site " + site + " guid " + guid + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting child documents for site " + site + " guid " + guid), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getDocLibID(String parentSite, String parentSiteDecoded, String docLibrary) throws ServiceInterruption, ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getDocLibID; parentSite='" + parentSite + "', parentSiteDecoded='" + parentSiteDecoded + "', docLibrary='" + docLibrary + "'"));
        }
        try {
            String parentSiteRequest = parentSite;
            if (parentSiteRequest.equals("/")) {
                parentSiteRequest = "";
                parentSiteDecoded = "";
            }
            ListsWS listsService = new ListsWS(this.baseUrl + parentSiteRequest, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listsCall = listsService.getListsSoapHandler();
            GetListCollectionResponseGetListCollectionResult listResp = listsCall.getListCollection();
            MessageElement[] lists = listResp.get_any();
            String xmlResponse = lists[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getDocLibID xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:Lists' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:Lists")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:Lists'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            String prefixPath = this.decodedServerLocation + parentSiteDecoded + "/";
            int i = 0;
            while (i < nodeList.size()) {
                String urlPath;
                Object o;
                String baseType;
                if (!(baseType = doc.getValue(o = nodeList.get(i++), "BaseType")).equals("1") || (urlPath = doc.getValue(o, "DefaultViewUrl")) == null || urlPath.length() <= 0) continue;
                if (!urlPath.startsWith("/")) {
                    urlPath = prefixPath + urlPath;
                }
                if (urlPath.startsWith(prefixPath)) {
                    int index = (urlPath = urlPath.substring(prefixPath.length())).indexOf("/");
                    if (index == -1) {
                        throw new ManifoldCFException("Bad library view url without site: '" + urlPath + "'");
                    }
                    String pathpart = urlPath.substring(0, index);
                    if (!pathpart.equals(docLibrary)) continue;
                    return doc.getValue(o, "ID");
                }
                Logging.connectors.warn((Object)("SharePoint: Library view url is not in the expected form: '" + urlPath + "'; it should start with '" + prefixPath + "'; skipping"));
            }
            return null;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting the library ID for site " + parentSite + " library " + docLibrary + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + parentSite + " did not exist; assuming library deleted"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to list libraries for " + this.baseUrl + parentSite + "; skipping"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + parentSite + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + parentSite + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The list " + docLibrary + " in site " + parentSite + " did not exist; assuming library deleted"));
                        }
                        return null;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting library ID for the list " + docLibrary + " in site " + parentSite + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return null;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting library ID for site " + parentSite + " library " + docLibrary + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting library ID for site " + parentSite + " library " + docLibrary + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting library ID for site " + parentSite + " library " + docLibrary), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getListID(String parentSite, String parentSiteDecoded, String listName) throws ServiceInterruption, ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getListID; parentsite='" + parentSite + "', parentSiteDecoded='" + parentSiteDecoded + "', listName='" + listName + "'"));
        }
        try {
            String parentSiteRequest = parentSite;
            if (parentSiteRequest.equals("/")) {
                parentSiteRequest = "";
                parentSiteDecoded = "";
            }
            ListsWS listsService = new ListsWS(this.baseUrl + parentSiteRequest, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listsCall = listsService.getListsSoapHandler();
            GetListCollectionResponseGetListCollectionResult listResp = listsCall.getListCollection();
            MessageElement[] lists = listResp.get_any();
            String xmlResponse = lists[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getListID xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:Lists' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:Lists")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:Lists'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            String prefixPath = this.decodedServerLocation + parentSiteDecoded + "/";
            int i = 0;
            while (i < nodeList.size()) {
                String urlPath;
                Object o;
                String baseType;
                if (!(baseType = doc.getValue(o = nodeList.get(i++), "BaseType")).equals("0") || (urlPath = doc.getValue(o, "DefaultViewUrl")) == null || urlPath.length() <= 0) continue;
                if (!urlPath.startsWith("/")) {
                    urlPath = prefixPath + urlPath;
                }
                if (urlPath.startsWith(prefixPath)) {
                    int index = (urlPath = urlPath.substring(prefixPath.length())).indexOf("/");
                    if (index == -1) {
                        throw new ManifoldCFException("Bad list view url without site: '" + urlPath + "'");
                    }
                    String pathpart = urlPath.substring(0, index);
                    if ("Lists".equals(pathpart)) {
                        int k = urlPath.indexOf("/", index + 1);
                        if (k == -1) {
                            throw new ManifoldCFException("Bad list view url without 'Lists': '" + urlPath + "'");
                        }
                        pathpart = urlPath.substring(index + 1, k);
                    }
                    if (!pathpart.equals(listName)) continue;
                    return doc.getValue(o, "ID");
                }
                Logging.connectors.warn((Object)("SharePoint: List view url is not in the expected form: '" + urlPath + "'; expected something beginning with '" + prefixPath + "'; skipping"));
            }
            return null;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting the list ID for site " + parentSite + " list " + listName + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + parentSite + " did not exist; assuming list deleted"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to list lists for " + this.baseUrl + parentSite + "; skipping"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + parentSite + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + parentSite + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The list " + listName + " in site " + parentSite + " did not exist; assuming list deleted"));
                        }
                        return null;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting list ID for the list " + listName + " in site " + parentSite + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return null;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting list ID for site " + parentSite + " list " + listName + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting list ID for site " + parentSite + " list " + listName + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting list ID for site " + parentSite + " list " + listName), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public XMLDoc getVersions(String site, String docPath) throws ServiceInterruption, ManifoldCFException {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getVersions; site='" + site + "', docPath='" + docPath + "'"));
        }
        try {
            if (site.compareTo("/") == 0) {
                site = "";
            }
            VersionsWS versionsService = new VersionsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            VersionsSoap versionsCall = versionsService.getVersionsSoapHandler();
            GetVersionsResponseGetVersionsResult versionsResp = versionsCall.getVersions(docPath);
            MessageElement[] lists = versionsResp.get_any();
            String xmlResponse = lists[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getVersions response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'results' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("results")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'results'");
            }
            return doc;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting versions for site " + site + " docpath " + docPath + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            long currentTime = System.currentTimeMillis();
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The page at " + this.baseUrl + site + " did not exist; assuming library deleted"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The crawl user did not have access to get versions for " + this.baseUrl + site + "; skipping"));
                        }
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (sharepointErrorCode.equals("0x82000006")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: The docpath " + docPath + " in site " + site + " did not exist; assuming library deleted"));
                        }
                        return null;
                    }
                    if (Logging.connectors.isDebugEnabled()) {
                        Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                        String errorString = "";
                        if (elem != null) {
                            errorString = elem2.getFirstChild().getNodeValue().trim();
                        }
                        Logging.connectors.debug((Object)("SharePoint: Getting versions for the docpath " + docPath + " in site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString + " - Skipping"), (Throwable)e);
                    }
                    return null;
                }
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Unknown SharePoint server error getting versions for site " + site + " docpath " + docPath + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
                }
                throw new ServiceInterruption("Unknown SharePoint server error: " + e.getMessage() + " - retrying", (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unknown remote exception getting versions for site " + site + " docpath " + docPath + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString() + " - retrying"), (Throwable)e);
            }
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got an unexpected remote exception getting versions for site " + site + " docpath " + docPath), (Throwable)e);
            }
            throw new ManifoldCFException("Unexpected remote procedure exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getSidForUser(UserGroupSoap userCall, String userLogin, boolean activeDirectoryAuthority) throws ManifoldCFException, MalformedURLException, ServiceException, RemoteException {
        String rval;
        if (!activeDirectoryAuthority) {
            rval = "U" + userLogin;
        } else {
            GetUserInfoResponseGetUserInfoResult userResp = userCall.getUserInfo(userLogin);
            MessageElement[] userList = userResp.get_any();
            if (userList.length != 1) {
                throw new ManifoldCFException("Bad response - expecting one outer 'GetUserInfo' node, saw " + Integer.toString(userList.length));
            }
            MessageElement users = userList[0];
            if (!users.getElementName().getLocalName().equals("GetUserInfo")) {
                throw new ManifoldCFException("Bad response - outer node should have been 'GetUserInfo' node");
            }
            String userID = null;
            Iterator userIter = users.getChildElements();
            while (userIter.hasNext()) {
                MessageElement child = (MessageElement)userIter.next();
                if (!child.getElementName().getLocalName().equals("User")) continue;
                userID = child.getAttribute("Sid");
            }
            if (userID == null) {
                throw new ManifoldCFException("Could not find user login '" + userLogin + "' so could not get SID");
            }
            rval = userID;
        }
        return rval;
    }

    private List<String> getSidsForGroup(UserGroupSoap userCall, String groupName, boolean activeDirectoryAuthority) throws ManifoldCFException, MalformedURLException, ServiceException, RemoteException {
        ArrayList<String> rval = new ArrayList<String>();
        GetUserCollectionFromGroupResponseGetUserCollectionFromGroupResult roleResp = userCall.getUserCollectionFromGroup(groupName);
        MessageElement[] roleList = roleResp.get_any();
        if (roleList.length != 1) {
            throw new ManifoldCFException("Bad response - expecting one outer 'GetUserCollectionFromGroup' node, saw " + Integer.toString(roleList.length));
        }
        MessageElement roles = roleList[0];
        if (!roles.getElementName().getLocalName().equals("GetUserCollectionFromGroup")) {
            throw new ManifoldCFException("Bad response - outer node should have been 'GetUserCollectionFromGroup' node");
        }
        Iterator rolesIter = roles.getChildElements();
        if (!activeDirectoryAuthority) {
            rval.add("G" + groupName);
            while (rolesIter.hasNext()) {
                MessageElement child = (MessageElement)rolesIter.next();
                if (!child.getElementName().getLocalName().equals("Users")) continue;
                Iterator usersIterator = child.getChildElements();
                while (usersIterator.hasNext()) {
                    String isDomainGroup;
                    MessageElement user = (MessageElement)usersIterator.next();
                    if (!user.getElementName().getLocalName().equals("User") || (isDomainGroup = user.getAttribute("IsDomainGroup")) == null || !isDomainGroup.equals("True")) continue;
                    rval.add("U" + user.getAttribute("LoginName"));
                }
            }
        } else {
            while (rolesIter.hasNext()) {
                MessageElement child = (MessageElement)rolesIter.next();
                if (!child.getElementName().getLocalName().equals("Users")) continue;
                Iterator usersIterator = child.getChildElements();
                while (usersIterator.hasNext()) {
                    MessageElement user = (MessageElement)usersIterator.next();
                    if (!user.getElementName().getLocalName().equals("User")) continue;
                    rval.add(user.getAttribute("Sid"));
                }
            }
        }
        return rval;
    }

    private List<String> getSidsForRole(UserGroupSoap userCall, String roleName, boolean activeDirectoryAuthority) throws ManifoldCFException, MalformedURLException, ServiceException, RemoteException {
        ArrayList<String> rval = new ArrayList<String>();
        if (!activeDirectoryAuthority) {
            rval.add("R" + roleName);
        } else {
            GetUserCollectionFromRoleResponseGetUserCollectionFromRoleResult roleResp = userCall.getUserCollectionFromRole(roleName);
            MessageElement[] roleList = roleResp.get_any();
            if (roleList.length != 1) {
                throw new ManifoldCFException("Bad response - expecting one outer 'GetUserCollectionFromRole' node, saw " + Integer.toString(roleList.length));
            }
            MessageElement roles = roleList[0];
            if (!roles.getElementName().getLocalName().equals("GetUserCollectionFromRole")) {
                throw new ManifoldCFException("Bad response - outer node should have been 'GetUserCollectionFromRole' node");
            }
            Iterator rolesIter = roles.getChildElements();
            while (rolesIter.hasNext()) {
                MessageElement child = (MessageElement)rolesIter.next();
                if (!child.getElementName().getLocalName().equals("Users")) continue;
                Iterator usersIterator = child.getChildElements();
                while (usersIterator.hasNext()) {
                    MessageElement user = (MessageElement)usersIterator.next();
                    if (!user.getElementName().getLocalName().equals("User")) continue;
                    rval.add(user.getAttribute("Sid"));
                }
            }
        }
        return rval;
    }

    public boolean checkConnection(String site, boolean sps30) throws ManifoldCFException, ServiceInterruption {
        try {
            if (site.equals("/")) {
                site = "";
            }
            ListsWS listService = new ListsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listCall = listService.getListsSoapHandler();
            listCall.getListCollection();
            if (sps30) {
                MCPermissionsWS aclService = new MCPermissionsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
                PermissionsSoap aclCall = aclService.getPermissionsSoapHandler();
                aclCall.getPermissionCollection("/", "Web");
            }
            return true;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)"SharePoint: Got a service exception checking connection - retrying", (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        throw new ManifoldCFException("The site at " + this.baseUrl + site + " did not exist");
                    }
                    if (httpErrorCode.equals("401")) {
                        throw new ManifoldCFException("Crawl user did not authenticate properly, or has insufficient permissions to access " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Http error " + httpErrorCode + " while reading from " + this.baseUrl + site + " - check IIS and SharePoint security settings! " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("302")) {
                        throw new ManifoldCFException("The correct version of ManifoldCF's MCPermissions web service may not be installed on the target SharePoint server.  MCPermissions service is needed for SharePoint repositories version 3.0 or higher, to allow access to security information for files and folders.  Consult your system administrator.");
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"))) {
                Element elem = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorcode"));
                if (elem != null) {
                    elem.normalize();
                    String sharepointErrorCode = elem.getFirstChild().getNodeValue().trim();
                    Element elem2 = e.lookupFaultDetail(new QName("http://schemas.microsoft.com/sharepoint/soap/", "errorstring"));
                    String errorString = "";
                    if (elem != null) {
                        errorString = elem2.getFirstChild().getNodeValue().trim();
                    }
                    throw new ManifoldCFException("Accessing site " + site + " failed with unexpected SharePoint error code " + sharepointErrorCode + ": " + errorString, (Throwable)e);
                }
                throw new ManifoldCFException("Unknown SharePoint server error accessing site " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            throw new ManifoldCFException("Got an unknown remote exception accessing site " + site + " - axis fault = " + e.getFaultCode().getLocalPart() + ", detail = " + e.getFaultString(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Got an unexpected remote exception accessing site " + site + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public List<NameValue> getAttachmentNames(String site, String listName, String itemID) throws ManifoldCFException, ServiceInterruption {
        try {
            ArrayList<NameValue> result = new ArrayList<NameValue>();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: In getAttachmentNames; site='" + site + "', listName='" + listName + "', itemID='" + itemID + "'"));
            }
            if (site.compareTo("/") == 0) {
                site = "";
            }
            ListsWS listService = new ListsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listCall = listService.getListsSoapHandler();
            GetAttachmentCollectionResponseGetAttachmentCollectionResult listResponse = listCall.getAttachmentCollection(listName, itemID);
            MessageElement[] List2 = listResponse.get_any();
            String xmlResponse = List2[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getAttachmentNames response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object attachments = nodeList.get(0);
            if (!doc.getNodeName(attachments).equals("ns1:Attachments")) {
                throw new ManifoldCFException("Bad xml - outer node '" + doc.getNodeName(attachments) + "' is not 'ns1:Attachments'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", attachments);
            int i = 0;
            while (i < nodeList.size()) {
                Object o;
                if (!doc.getNodeName(o = nodeList.get(i++)).equals("ns1:Attachment")) {
                    throw new ManifoldCFException("Bad xml - inner node '" + doc.getNodeName(o) + "' is not 'ns1:Attachment'");
                }
                String attachmentURL = doc.getData(o);
                if (attachmentURL == null) continue;
                int index = attachmentURL.lastIndexOf("/");
                if (index == -1) {
                    throw new ManifoldCFException("Unexpected attachment URL form: '" + attachmentURL + "'");
                }
                result.add(new NameValue(attachmentURL.substring(index + 1), new URL(attachmentURL).getPath()));
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting attachments for site " + site + " listName " + listName + " itemID " + itemID + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to get attachment list for site " + site + " listName " + listName + " itemID " + itemID + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e.getMessage().indexOf("List does not exist") != -1) {
                return null;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception getting attachments for site " + site + " listName " + listName + " itemID " + itemID + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getFieldList(String site, String listName) throws ManifoldCFException, ServiceInterruption {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: In getFieldList; site='" + site + "', listName='" + listName + "'"));
            }
            if (site.compareTo("/") == 0) {
                site = "";
            }
            ListsWS listService = new ListsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listCall = listService.getListsSoapHandler();
            GetListResponseGetListResult listResponse = listCall.getList(listName);
            MessageElement[] List2 = listResponse.get_any();
            String xmlResponse = List2[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getFieldList xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:List")) {
                throw new ManifoldCFException("Bad xml - outer node is '" + doc.getNodeName(parent) + "' not 'ns1:List'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            for (Object metaField : nodeList) {
                if (!doc.getNodeName(metaField).equals("ns1:Fields")) continue;
                ArrayList fieldsList = new ArrayList();
                doc.processPath(fieldsList, "*", metaField);
                for (Object o : fieldsList) {
                    String name = doc.getValue(o, "DisplayName");
                    String fieldName = doc.getValue(o, "Name");
                    String hidden = doc.getValue(o, "Hidden");
                    if (name.length() == 0 || fieldName.length() == 0 || hidden.equalsIgnoreCase("true") || result.containsKey(fieldName)) continue;
                    result.put(fieldName, name);
                }
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting field list for site " + site + " listName " + listName + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to get field list for site " + site + " listName " + listName + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e.getMessage().indexOf("List does not exist") != -1) {
                return null;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception getting field list for site " + site + " listName " + listName + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, String> getFieldValues(String[] fieldNames, String site, String docLibrary, String docId, boolean dspStsWorks) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getFieldValues; fieldNames=" + fieldNames + ", site='" + site + "', docLibrary='" + docLibrary + "', docId='" + docId + "', dspStsWorks=" + dspStsWorks));
        }
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            if (site.compareTo("/") == 0) {
                site = "";
            }
            if (dspStsWorks) {
                StsAdapterWS listService = new StsAdapterWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
                StsAdapterSoapStub stub = (StsAdapterSoapStub)listService.getStsAdapterSoapHandler();
                String[] vArray = new String[]{"1.0"};
                VersionsHeader myVersion = new VersionsHeader();
                myVersion.setVersion(vArray);
                stub.setHeader("http://schemas.microsoft.com/sharepoint/dsp", "versions", myVersion);
                RequestHeader reqHeader = new RequestHeader();
                reqHeader.setDocument(DocumentType.content);
                reqHeader.setMethod(MethodType.query);
                stub.setHeader("http://schemas.microsoft.com/sharepoint/dsp", "request", reqHeader);
                QueryRequest myRequest = new QueryRequest();
                DSQuery sQuery = new DSQuery();
                sQuery.setSelect("/list[@id='" + docLibrary + "']");
                sQuery.setResultContent(ResultContentType.dataOnly);
                myRequest.setDsQuery(sQuery);
                DspQuery spQuery = new DspQuery();
                spQuery.setRowLimit(1L);
                if (fieldNames.length > 0) {
                    Fields spFields = new Fields();
                    Field[] fieldArray = new Field[]{};
                    ArrayList<Field> fields = new ArrayList<Field>();
                    Field spField = new Field();
                    for (String fieldName : fieldNames) {
                        spField = new Field();
                        spField.setName(fieldName);
                        spField.setAlias(fieldName);
                        fields.add(spField);
                    }
                    spFields.setField(fields.toArray(fieldArray));
                    spQuery.setFields(spFields);
                }
                DspQueryWhere spWhere = new DspQueryWhere();
                MessageElement criterion = new MessageElement((String)null, "Contains");
                SOAPElement seFieldRef = criterion.addChildElement("FieldRef");
                seFieldRef.addAttribute(SOAPFactory.newInstance().createName("Name"), "FileRef");
                SOAPElement seValue = criterion.addChildElement("Value");
                seValue.addAttribute(SOAPFactory.newInstance().createName("Type"), "String");
                seValue.setValue(docId);
                MessageElement[] criteria = new MessageElement[]{criterion};
                spWhere.set_any(criteria);
                spQuery.setWhere(spWhere);
                myRequest.getDsQuery().setQuery(spQuery);
                StsAdapterSoapStub call = stub;
                QueryResponse resp = call.query(myRequest);
                MessageElement[] list = resp.get_any();
                String xmlResponse = list[0].toString();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: getFieldValues xml response: '" + xmlResponse + "'"));
                }
                XMLDoc doc = new XMLDoc(xmlResponse);
                ArrayList nodeList = new ArrayList();
                doc.processPath(nodeList, "*", null);
                if (nodeList.size() != 1) {
                    throw new ManifoldCFException("Bad xml - missing outer 'ns1:dsQueryResponse' node - there are " + Integer.toString(nodeList.size()) + " nodes");
                }
                Object parent = nodeList.get(0);
                if (!doc.getNodeName(parent).equals("ns1:dsQueryResponse")) {
                    throw new ManifoldCFException("Bad xml - outer node is not 'ns1:dsQueryResponse'");
                }
                nodeList.clear();
                doc.processPath(nodeList, "*", parent);
                parent = nodeList.get(0);
                nodeList.clear();
                doc.processPath(nodeList, "*", parent);
                for (int i = 0; i < nodeList.size(); ++i) {
                    Object documentNode = nodeList.get(i);
                    ArrayList fieldList = new ArrayList();
                    doc.processPath(fieldList, "*", documentNode);
                    for (int j = 0; j < fieldList.size(); ++j) {
                        Object field = fieldList.get(j);
                        String fieldData = doc.getData(field);
                        String fieldName = doc.getNodeName(field);
                        result.put(fieldName, fieldData);
                    }
                }
            } else {
                GetListItemsViewFields viewFields;
                GetListItemsQuery q;
                GetListItemsResponseGetListItemsResult items;
                ListsWS lservice = new ListsWS(this.baseUrl + site, this.userName, this.password, this.configuration, this.httpClient);
                ListsSoapStub stub1 = (ListsSoapStub)lservice.getListsSoapHandler();
                String sitePlusDocId = this.serverLocation + site + docId;
                if (sitePlusDocId.startsWith("/")) {
                    sitePlusDocId = sitePlusDocId.substring(1);
                }
                if ((items = stub1.getListItems(docLibrary, "", q = SPSProxyHelper.buildMatchQuery("FileRef", "Text", sitePlusDocId), viewFields = SPSProxyHelper.buildViewFields(fieldNames), "1", SPSProxyHelper.buildNonPagingQueryOptions(), null)) == null) {
                    return result;
                }
                MessageElement[] list = items.get_any();
                String xmlResponse = list[0].toString();
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: getListItems FileRef value '" + sitePlusDocId + "', xml response: '" + xmlResponse + "'"));
                }
                ArrayList nodeList = new ArrayList();
                XMLDoc doc = new XMLDoc(xmlResponse);
                doc.processPath(nodeList, "*", null);
                if (nodeList.size() != 1) {
                    throw new ManifoldCFException("Bad xml - expecting one outer 'ns1:listitems' node - there are " + Integer.toString(nodeList.size()) + " nodes");
                }
                Object parent = nodeList.get(0);
                if (!"ns1:listitems".equals(doc.getNodeName(parent))) {
                    throw new ManifoldCFException("Bad xml - outer node is not 'ns1:listitems'");
                }
                nodeList.clear();
                doc.processPath(nodeList, "*", parent);
                if (nodeList.size() != 1) {
                    throw new ManifoldCFException("Expected rsdata result but no results found.");
                }
                Object rsData = nodeList.get(0);
                int itemCount = Integer.parseInt(doc.getValue(rsData, "ItemCount"));
                if (itemCount == 0) {
                    return result;
                }
                ArrayList nodeDocs = new ArrayList();
                doc.processPath(nodeDocs, "*", rsData);
                if (nodeDocs.size() != itemCount) {
                    throw new ManifoldCFException("itemCount does not match with nodeDocs.size()");
                }
                if (itemCount != 1) {
                    throw new ManifoldCFException("Expecting only one item, instead saw '" + itemCount + "'");
                }
                Object o = nodeDocs.get(0);
                for (String attrName : fieldNames) {
                    String attrValue = doc.getValue(o, "ows_" + attrName);
                    if (attrValue == null) continue;
                    result.put(attrName.toString(), SPSProxyHelper.valueMunge(attrValue));
                }
            }
            return result;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException("Soap exception: " + e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting field values for site " + site + " library " + docLibrary + " document '" + docId + "' - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to get field values for site " + site + " library " + docLibrary + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + site + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (e.getMessage().indexOf("List does not exist") != -1) {
                return null;
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception getting field values for site " + site + " library " + docLibrary + " document [" + docId + "] - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<NameValue> getSites(String parentSite) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getSites; parentSite='" + parentSite + "'"));
        }
        try {
            ArrayList<NameValue> result = new ArrayList<NameValue>();
            if (parentSite.equals("/")) {
                parentSite = "";
            }
            WebsWS webService = new WebsWS(this.baseUrl + parentSite, this.userName, this.password, this.configuration, this.httpClient);
            WebsSoap webCall = webService.getWebsSoapHandler();
            GetWebCollectionResponseGetWebCollectionResult webResp = webCall.getWebCollection();
            MessageElement[] webList = webResp.get_any();
            String xmlResponse = webList[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getSites xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:Webs' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:Webs")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:Webs'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            int i = 0;
            while (i < nodeList.size()) {
                String pathValue;
                int lastSlash;
                Object o = nodeList.get(i++);
                String url = doc.getValue(o, "Url");
                String title = doc.getValue(o, "Title");
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Subsite list: '" + url + "', '" + title + "'"));
                }
                if (url == null || url.length() <= 0 || (lastSlash = url.lastIndexOf("/")) == -1 || (pathValue = url.substring(lastSlash + 1)).length() <= 0) continue;
                if (title == null || title.length() == 0) {
                    title = pathValue;
                }
                result.add(new NameValue(pathValue, title));
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting subsites for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to get subsites of site " + parentSite + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + parentSite + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception getting subsites for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<NameValue> getDocumentLibraries(String parentSite, String parentSiteDecoded) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getDocumentLibraries; parentSite='" + parentSite + "', parentSiteDecoded='" + parentSiteDecoded + "'"));
        }
        try {
            ArrayList<NameValue> result = new ArrayList<NameValue>();
            String parentSiteRequest = parentSite;
            if (parentSiteRequest.equals("/")) {
                parentSiteRequest = "";
                parentSiteDecoded = "";
            }
            ListsWS listsService = new ListsWS(this.baseUrl + parentSiteRequest, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listsCall = listsService.getListsSoapHandler();
            GetListCollectionResponseGetListCollectionResult listResp = listsCall.getListCollection();
            MessageElement[] lists = listResp.get_any();
            String xmlResponse = lists[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getDocumentLibraries xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:Lists' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:Lists")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:Lists'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            String prefixPath = this.decodedServerLocation + parentSiteDecoded + "/";
            int i = 0;
            while (i < nodeList.size()) {
                Object o;
                String baseType;
                if (!(baseType = doc.getValue(o = nodeList.get(i++), "BaseType")).equals("1")) continue;
                String urlPath = doc.getValue(o, "DefaultViewUrl");
                String title = doc.getValue(o, "Title");
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: Library list: '" + urlPath + "', '" + title + "'"));
                }
                if (urlPath == null || urlPath.length() <= 0) continue;
                if (!urlPath.startsWith("/")) {
                    urlPath = prefixPath + urlPath;
                }
                if (urlPath.startsWith(prefixPath)) {
                    int index = (urlPath = urlPath.substring(prefixPath.length())).indexOf("/");
                    if (index == -1) {
                        throw new ManifoldCFException("Bad library view url without site: '" + urlPath + "'");
                    }
                    String pathpart = urlPath.substring(0, index);
                    if (pathpart.length() == 0 || pathpart.equals("_catalogs")) continue;
                    if (title == null || title.length() == 0) {
                        title = pathpart;
                    }
                    result.add(new NameValue(pathpart, title));
                    continue;
                }
                Logging.connectors.warn((Object)("SharePoint: Library view url is not in the expected form: '" + urlPath + "'; expected something beginning with '" + prefixPath + "'; skipping"));
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting document libraries for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to read document libraries for site " + parentSite + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + parentSite + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception reading document libraries for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<NameValue> getLists(String parentSite, String parentSiteDecoded) throws ManifoldCFException, ServiceInterruption {
        if (Logging.connectors.isDebugEnabled()) {
            Logging.connectors.debug((Object)("SharePoint: In getLists; parentSite='" + parentSite + "', parentSiteDecoded='" + parentSiteDecoded + "'"));
        }
        try {
            ArrayList<NameValue> result = new ArrayList<NameValue>();
            String parentSiteRequest = parentSite;
            if (parentSiteRequest.equals("/")) {
                parentSiteRequest = "";
                parentSiteDecoded = "";
            }
            ListsWS listsService = new ListsWS(this.baseUrl + parentSiteRequest, this.userName, this.password, this.configuration, this.httpClient);
            ListsSoap listsCall = listsService.getListsSoapHandler();
            GetListCollectionResponseGetListCollectionResult listResp = listsCall.getListCollection();
            MessageElement[] lists = listResp.get_any();
            String xmlResponse = lists[0].toString();
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: getLists xml response: " + xmlResponse));
            }
            XMLDoc doc = new XMLDoc(xmlResponse);
            ArrayList nodeList = new ArrayList();
            doc.processPath(nodeList, "*", null);
            if (nodeList.size() != 1) {
                throw new ManifoldCFException("Bad xml - missing outer 'ns1:Lists' node - there are " + Integer.toString(nodeList.size()) + " nodes");
            }
            Object parent = nodeList.get(0);
            if (!doc.getNodeName(parent).equals("ns1:Lists")) {
                throw new ManifoldCFException("Bad xml - outer node is not 'ns1:Lists'");
            }
            nodeList.clear();
            doc.processPath(nodeList, "*", parent);
            String prefixPath = this.decodedServerLocation + parentSiteDecoded + "/";
            int i = 0;
            while (i < nodeList.size()) {
                Object o;
                String baseType;
                if (!(baseType = doc.getValue(o = nodeList.get(i++), "BaseType")).equals("0")) continue;
                String urlPath = doc.getValue(o, "DefaultViewUrl");
                String title = doc.getValue(o, "Title");
                if (Logging.connectors.isDebugEnabled()) {
                    Logging.connectors.debug((Object)("SharePoint: List: '" + urlPath + "', '" + title + "'"));
                }
                if (urlPath == null || urlPath.length() <= 0) continue;
                if (!urlPath.startsWith("/")) {
                    urlPath = prefixPath + urlPath;
                }
                if (urlPath.startsWith(prefixPath)) {
                    int index = (urlPath = urlPath.substring(prefixPath.length())).indexOf("/");
                    if (index == -1) {
                        throw new ManifoldCFException("Bad list view url without site: '" + urlPath + "'");
                    }
                    String pathpart = urlPath.substring(0, index);
                    if ("Lists".equals(pathpart)) {
                        int k = urlPath.indexOf("/", index + 1);
                        if (k == -1) {
                            throw new ManifoldCFException("Bad list view url without 'Lists': '" + urlPath + "'");
                        }
                        pathpart = urlPath.substring(index + 1, k);
                    }
                    if (pathpart.length() == 0 || pathpart.equals("_catalogs")) continue;
                    if (title == null || title.length() == 0) {
                        title = pathpart;
                    }
                    result.add(new NameValue(pathpart, title));
                    continue;
                }
                Logging.connectors.warn((Object)("SharePoint: List view url is not in the expected form: '" + urlPath + "'; expected something beginning with '" + prefixPath + "'; skipping"));
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new ManifoldCFException("Bad SharePoint url: " + e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a service exception getting lists for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Service exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 43200000L, -1, true);
        }
        catch (AxisFault e) {
            String exceptionName;
            if (e.getFaultCode().equals(new QName("http://xml.apache.org/axis/", "HTTP"))) {
                Element elem = e.lookupFaultDetail(new QName("http://xml.apache.org/axis/", "HttpErrorCode"));
                if (elem != null) {
                    elem.normalize();
                    String httpErrorCode = elem.getFirstChild().getNodeValue().trim();
                    if (httpErrorCode.equals("404")) {
                        return null;
                    }
                    if (httpErrorCode.equals("403")) {
                        throw new ManifoldCFException("Remote procedure exception: " + e.getMessage(), (Throwable)e);
                    }
                    if (httpErrorCode.equals("401")) {
                        if (Logging.connectors.isDebugEnabled()) {
                            Logging.connectors.debug((Object)("SharePoint: Crawl user does not have sufficient privileges to read lists for site " + parentSite + " - skipping"), (Throwable)e);
                        }
                        return null;
                    }
                    throw new ManifoldCFException("Unexpected http error code " + httpErrorCode + " accessing SharePoint at " + this.baseUrl + parentSite + ": " + e.getMessage(), (Throwable)e);
                }
                throw new ManifoldCFException("Unknown http error occurred: " + e.getMessage(), (Throwable)e);
            }
            if (e.getFaultCode().equals(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server.userException")) && (exceptionName = e.getFaultString()).equals("java.lang.InterruptedException")) {
                throw new ManifoldCFException("Interrupted", 2);
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("SharePoint: Got a remote exception reading lists for site " + parentSite + " - retrying"), (Throwable)e);
            }
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Remote procedure exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
        }
        catch (RemoteException e) {
            throw new ManifoldCFException("Unexpected remote exception occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    protected static String valueMunge(String value) {
        Matcher matcher = subsPattern.matcher(value);
        if (matcher.matches()) {
            return value.substring(value.indexOf("#") + 1);
        }
        return value;
    }

    protected static GetListItemsViewFields buildViewFields(String[] fieldNames) throws ManifoldCFException {
        try {
            GetListItemsViewFields rval = new GetListItemsViewFields();
            MessageElement viewFieldsNode = new MessageElement((String)null, "ViewFields");
            rval.set_any(new MessageElement[]{viewFieldsNode});
            for (String fieldName : fieldNames) {
                MessageElement child = new MessageElement((String)null, "FieldRef");
                viewFieldsNode.addChild(child);
                child.addAttribute(null, "Name", fieldName);
            }
            return rval;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static GetListItemsQuery buildMatchQuery(String fieldName, String type, String value) throws ManifoldCFException {
        try {
            GetListItemsQuery rval = new GetListItemsQuery();
            MessageElement queryNode = new MessageElement((String)null, "Query");
            rval.set_any(new MessageElement[]{queryNode});
            MessageElement whereNode = new MessageElement((String)null, "Where");
            queryNode.addChild(whereNode);
            MessageElement eqNode = new MessageElement((String)null, "Eq");
            whereNode.addChild(eqNode);
            MessageElement fieldRefNode = new MessageElement((String)null, "FieldRef");
            eqNode.addChild(fieldRefNode);
            fieldRefNode.addAttribute(null, "Name", fieldName);
            MessageElement valueNode = new MessageElement((String)null, "Value");
            eqNode.addChild(valueNode);
            valueNode.addAttribute(null, "Type", type);
            valueNode.addTextNode(value);
            return rval;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static GetListItemsQuery buildOrderedQuery(String indexedColumn) throws ManifoldCFException {
        try {
            GetListItemsQuery rval = new GetListItemsQuery();
            MessageElement queryNode = new MessageElement((String)null, "Query");
            rval.set_any(new MessageElement[]{queryNode});
            MessageElement orderByNode = new MessageElement((String)null, "OrderBy");
            queryNode.addChild(orderByNode);
            orderByNode.addAttribute(null, "Override", "TRUE");
            orderByNode.addAttribute(null, "UseIndexForOrderBy", "TRUE");
            MessageElement fieldRefNode = new MessageElement((String)null, "FieldRef");
            orderByNode.addChild(fieldRefNode);
            fieldRefNode.addAttribute(null, "Ascending", "TRUE");
            fieldRefNode.addAttribute(null, "Name", indexedColumn);
            return rval;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static GetListItemsQueryOptions buildPagingQueryOptions(String pageNextString) throws ManifoldCFException {
        try {
            GetListItemsQueryOptions rval = new GetListItemsQueryOptions();
            MessageElement queryOptionsNode = new MessageElement((String)null, "QueryOptions");
            rval.set_any(new MessageElement[]{queryOptionsNode});
            MessageElement pagingNode = new MessageElement((String)null, "Paging");
            queryOptionsNode.addChild(pagingNode);
            pagingNode.addAttribute(null, "ListItemCollectionPositionNext", pageNextString);
            MessageElement viewAttributesNode = new MessageElement((String)null, "ViewAttributes");
            queryOptionsNode.addChild(viewAttributesNode);
            viewAttributesNode.addAttribute(null, "Scope", "Recursive");
            return rval;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static GetListItemsQueryOptions buildNonPagingQueryOptions() throws ManifoldCFException {
        try {
            GetListItemsQueryOptions rval = new GetListItemsQueryOptions();
            MessageElement queryOptionsNode = new MessageElement((String)null, "QueryOptions");
            rval.set_any(new MessageElement[]{queryOptionsNode});
            MessageElement viewAttributesNode = new MessageElement((String)null, "ViewAttributes");
            queryOptionsNode.addChild(viewAttributesNode);
            viewAttributesNode.addAttribute(null, "Scope", "Recursive");
            return rval;
        }
        catch (SOAPException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            subsPattern = Pattern.compile("[0-9]*;#.*");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-100);
        }
    }

    protected static class ResourceProvider
    implements WSDDEngineConfiguration {
        private WSDDDeployment deployment = null;
        private Class resourceClass;
        private String resourceName;

        public ResourceProvider(Class resourceClass, String resourceName) {
            this.resourceClass = resourceClass;
            this.resourceName = resourceName;
        }

        public WSDDDeployment getDeployment() {
            return this.deployment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureEngine(AxisEngine engine) throws ConfigurationException {
            try {
                InputStream resourceStream = this.resourceClass.getResourceAsStream(this.resourceName);
                if (resourceStream == null) {
                    throw new ConfigurationException("Resource not found: '" + this.resourceName + "'");
                }
                try {
                    WSDDDocument doc = new WSDDDocument(XMLUtils.newDocument((InputStream)resourceStream));
                    this.deployment = doc.getDeployment();
                    this.deployment.configureEngine(engine);
                    engine.refreshGlobalOptions();
                }
                finally {
                    resourceStream.close();
                }
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }

        public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
        }

        public Handler getHandler(QName qname) throws ConfigurationException {
            return this.deployment.getHandler(qname);
        }

        public SOAPService getService(QName qname) throws ConfigurationException {
            SOAPService service = this.deployment.getService(qname);
            if (service == null) {
                throw new ConfigurationException(Messages.getMessage((String)"noService10", (String)qname.toString()));
            }
            return service;
        }

        public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
            return this.deployment.getServiceByNamespaceURI(namespace);
        }

        public Handler getTransport(QName qname) throws ConfigurationException {
            return this.deployment.getTransport(qname);
        }

        public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
            return this.deployment.getTypeMappingRegistry();
        }

        public Handler getGlobalRequest() throws ConfigurationException {
            return this.deployment.getGlobalRequest();
        }

        public Handler getGlobalResponse() throws ConfigurationException {
            return this.deployment.getGlobalResponse();
        }

        public Hashtable getGlobalOptions() throws ConfigurationException {
            WSDDGlobalConfiguration globalConfig = this.deployment.getGlobalConfiguration();
            if (globalConfig != null) {
                return globalConfig.getParametersTable();
            }
            return null;
        }

        public Iterator getDeployedServices() throws ConfigurationException {
            return this.deployment.getDeployedServices();
        }

        public List getRoles() {
            return this.deployment.getRoles();
        }
    }

    protected static class WebsWS
    extends WebsLocator {
        private static final long serialVersionUID = 6879757392680147691L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public WebsWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/webs.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public WebsSoap getWebsSoapHandler() throws ServiceException, AxisFault {
            WebsSoapStub _stub = new WebsSoapStub(this.endPoint, this);
            _stub.setPortName(this.getWebsSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class VersionsWS
    extends VersionsLocator {
        private static final long serialVersionUID = 4903552161088337964L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public VersionsWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/versions.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public VersionsSoap getVersionsSoapHandler() throws ServiceException, AxisFault {
            VersionsSoapStub _stub = new VersionsSoapStub(this.endPoint, this);
            _stub.setPortName(this.getVersionsSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class ListsWS
    extends ListsLocator {
        private static final long serialVersionUID = 5506842429029882999L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public ListsWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/lists.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public ListsSoap getListsSoapHandler() throws ServiceException, AxisFault {
            ListsSoapStub _stub = new ListsSoapStub(this.endPoint, this);
            _stub.setPortName(this.getListsSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class StsAdapterWS
    extends StsAdapterLocator {
        private static final long serialVersionUID = -731937337802481409L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public StsAdapterWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/dspsts.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public StsAdapterSoap getStsAdapterSoapHandler() throws ServiceException, AxisFault {
            StsAdapterSoapStub _stub = new StsAdapterSoapStub(this.endPoint, this);
            _stub.setPortName(this.getStsAdapterSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class UserGroupWS
    extends UserGroupLocator {
        private static final long serialVersionUID = -2052484076803624502L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public UserGroupWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/usergroup.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public UserGroupSoap getUserGroupSoapHandler() throws ServiceException, AxisFault {
            UserGroupSoapStub _stub = new UserGroupSoapStub(this.endPoint, this);
            _stub.setPortName(this.getUserGroupSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class MCPermissionsWS
    extends com.microsoft.sharepoint.webpartpages.PermissionsLocator {
        private static final long serialVersionUID = -2542430113046450051L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public MCPermissionsWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/MCPermissions.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public PermissionsSoap getPermissionsSoapHandler() throws ServiceException, AxisFault {
            com.microsoft.sharepoint.webpartpages.PermissionsSoapStub _stub = new com.microsoft.sharepoint.webpartpages.PermissionsSoapStub(this.endPoint, this);
            _stub.setPortName(this.getPermissionsSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }

    protected static class PermissionsWS
    extends PermissionsLocator {
        private static final long serialVersionUID = -2542430113046450050L;
        private URL endPoint;
        private String userName;
        private String password;
        private HttpClient httpClient;

        public PermissionsWS(String siteUrl, String userName, String password, EngineConfiguration configuration, HttpClient httpClient) throws MalformedURLException {
            super(configuration);
            this.endPoint = new URL(siteUrl + "/_vti_bin/Permissions.asmx");
            this.userName = userName;
            this.password = password;
            this.httpClient = httpClient;
        }

        public com.microsoft.schemas.sharepoint.soap.directory.PermissionsSoap getPermissionsSoapHandler() throws ServiceException, AxisFault {
            PermissionsSoapStub _stub = new PermissionsSoapStub(this.endPoint, this);
            _stub.setPortName(this.getPermissionsSoapWSDDServiceName());
            _stub.setUsername(this.userName);
            _stub.setPassword(this.password);
            _stub._setProperty(SPSProxyHelper.HTTPCLIENT_PROPERTY, this.httpClient);
            return _stub;
        }
    }
}

