/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;

class DatingService {
    ClassLoader loader;
    Hashtable clsMolders;
    Vector needExtendsClassMolder;
    Vector needDependsClassMolder;
    Vector needFieldClass;
    Hashtable javaClasses;

    DatingService(ClassLoader loader) {
        this.loader = loader;
    }

    void close() throws MappingException {
        ClassMolder targetCm;
        ClassMolder initiateCm;
        Pair pair;
        Enumeration e;
        if (this.needExtendsClassMolder != null) {
            e = this.needExtendsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                initiateCm = (ClassMolder)pair.value;
                targetCm = (ClassMolder)this.clsMolders.get(pair.key);
                if (targetCm == null) {
                    throw new MappingException("Extended element, \"" + pair.key + "\"  not found!");
                }
                initiateCm.setExtends(targetCm);
                ((SQLEngine)initiateCm.getPersistence()).setExtends((SQLEngine)targetCm.getPersistence());
            }
        }
        if (this.needDependsClassMolder != null) {
            e = this.needDependsClassMolder.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                initiateCm = (ClassMolder)pair.value;
                targetCm = (ClassMolder)this.clsMolders.get(pair.key);
                if (targetCm == null) {
                    throw new MappingException("Depended element, \"" + pair.key + "\"  not found!");
                }
                initiateCm.setDepends(targetCm);
            }
        }
        if (this.needFieldClass != null) {
            e = this.needFieldClass.elements();
            while (e.hasMoreElements()) {
                pair = (Pair)e.nextElement();
                FieldMolder initiateFm = (FieldMolder)pair.value;
                targetCm = (ClassMolder)this.clsMolders.get(pair.key);
                if (targetCm == null) {
                    throw new MappingException("Field element, \"" + pair.key + "\"  not found!");
                }
                initiateFm.setFieldClassMolder(targetCm);
            }
        }
    }

    boolean pairExtends(ClassMolder me, String extName) throws MappingException {
        if (extName == null || extName.equals("")) {
            throw new IllegalArgumentException("Null classname not allowed!");
        }
        ClassMolder clsMold = (ClassMolder)this.clsMolders.get(extName);
        if (clsMold != null) {
            me.setExtends(clsMold);
            SQLEngine sql = (SQLEngine)me.getPersistence();
            if (sql == null) {
                throw new MappingException("Class " + me + " extends on " + extName + " which is not persistence capable!");
            }
            sql.setExtends((SQLEngine)clsMold.getPersistence());
            return true;
        }
        if (this.needExtendsClassMolder == null) {
            this.needExtendsClassMolder = new Vector();
        }
        this.needExtendsClassMolder.add(new Pair(extName, me));
        return false;
    }

    boolean pairDepends(ClassMolder me, String depName) {
        if (depName == null || depName.equals("")) {
            return true;
        }
        ClassMolder clsMold = (ClassMolder)this.clsMolders.get(depName);
        if (clsMold != null) {
            me.setDepends(clsMold);
            return true;
        }
        if (this.needDependsClassMolder == null) {
            this.needDependsClassMolder = new Vector();
        }
        this.needDependsClassMolder.add(new Pair(depName, me));
        return false;
    }

    Class resolve(String className) throws ClassNotFoundException {
        if (this.javaClasses == null) {
            this.javaClasses = new Hashtable();
        } else if (this.javaClasses.contains(className)) {
            return (Class)this.javaClasses.get(className);
        }
        Class resolved = Types.typeFromName(this.loader, className);
        this.javaClasses.put(className, resolved);
        return resolved;
    }

    boolean pairFieldClass(FieldMolder fieldMolder, String typeName) throws MappingException {
        try {
            if (typeName == null || typeName.equals("")) {
                return true;
            }
            if (Types.isSimpleType(this.resolve(typeName))) {
                return true;
            }
            if (Types.isEnumType(this.resolve(typeName))) {
                return true;
            }
            ClassMolder clsMold = (ClassMolder)this.clsMolders.get(typeName);
            if (clsMold != null) {
                fieldMolder.setFieldClassMolder(clsMold);
                return true;
            }
            if (this.needFieldClass == null) {
                this.needFieldClass = new Vector();
            }
            this.needFieldClass.add(new Pair(typeName, fieldMolder));
            return false;
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("ClassNotFound :\n" + e);
        }
    }

    void register(String name, ClassMolder clsMold) {
        if (this.clsMolders == null) {
            this.clsMolders = new Hashtable();
        }
        this.clsMolders.put(name, clsMold);
    }

    private class Pair {
        public Object key;
        public Object value;

        private Pair(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

