/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.encoding;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Encoding {
    public static final int NUMBER_OF_MAC_GLYPHS = 258;
    public static final String[] MAC_GLYPH_NAMES = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    public static Map<String, Integer> MAC_GLYPH_NAMES_INDICES = new HashMap<String, Integer>();
    private static final String NOTDEF = ".notdef";
    protected Map<Integer, String> codeToName = new HashMap<Integer, String>();
    protected Map<String, Integer> nameToCode = new HashMap<String, Integer>();
    private static final Map<String, String> NAME_TO_CHARACTER;
    private static final Map<String, String> CHARACTER_TO_NAME;

    protected void addCharacterEncoding(int code, String name) {
        this.codeToName.put(code, name);
        this.nameToCode.put(name, code);
    }

    public int getCode(String name) throws IOException {
        Integer code = this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name + "'");
        }
        return code;
    }

    public String getName(int code) throws IOException {
        String name = this.codeToName.get(code);
        if (name == null) {
            name = NOTDEF;
        }
        return name;
    }

    public String getNameFromCharacter(char c) throws IOException {
        String name = CHARACTER_TO_NAME.get(Character.valueOf(c));
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        return Encoding.getCharacter(this.getName(code));
    }

    public static String getCharacter(String name) {
        String character = NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name;
        }
        return character;
    }

    static {
        for (int i = 0; i < 258; ++i) {
            MAC_GLYPH_NAMES_INDICES.put(MAC_GLYPH_NAMES[i], i);
        }
        NAME_TO_CHARACTER = new HashMap<String, String>();
        CHARACTER_TO_NAME = new HashMap<String, String>();
    }
}

