/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.Build;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Serializable {
    public static final int V_0_18_0_ID = 180099;
    public static final Version V_0_18_0 = new Version(180099, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_1_ID = 180199;
    public static final Version V_0_18_1 = new Version(180199, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_2_ID = 180299;
    public static final Version V_0_18_2 = new Version(180299, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_3_ID = 180399;
    public static final Version V_0_18_3 = new Version(180399, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_4_ID = 180499;
    public static final Version V_0_18_4 = new Version(180499, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_5_ID = 180599;
    public static final Version V_0_18_5 = new Version(180599, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_6_ID = 180699;
    public static final Version V_0_18_6 = new Version(180699, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_7_ID = 180799;
    public static final Version V_0_18_7 = new Version(180799, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_18_8_ID = 180899;
    public static final Version V_0_18_8 = new Version(180899, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_0_RC1_ID = 190051;
    public static final Version V_0_19_0_RC1 = new Version(190051, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_0_RC2_ID = 190052;
    public static final Version V_0_19_0_RC2 = new Version(190052, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_0_RC3_ID = 190053;
    public static final Version V_0_19_0_RC3 = new Version(190053, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_0_ID = 190099;
    public static final Version V_0_19_0 = new Version(190099, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_1_ID = 190199;
    public static final Version V_0_19_1 = new Version(190199, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_2_ID = 190299;
    public static final Version V_0_19_2 = new Version(190299, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_3_ID = 190399;
    public static final Version V_0_19_3 = new Version(190399, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_4_ID = 190499;
    public static final Version V_0_19_4 = new Version(190499, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_5_ID = 190599;
    public static final Version V_0_19_5 = new Version(190599, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_6_ID = 190699;
    public static final Version V_0_19_6 = new Version(190699, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_7_ID = 190799;
    public static final Version V_0_19_7 = new Version(190799, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_8_ID = 190899;
    public static final Version V_0_19_8 = new Version(190899, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_9_ID = 190999;
    public static final Version V_0_19_9 = new Version(190999, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_10_ID = 191099;
    public static final Version V_0_19_10 = new Version(191099, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_11_ID = 191199;
    public static final Version V_0_19_11 = new Version(191199, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_12_ID = 191299;
    public static final Version V_0_19_12 = new Version(191299, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_19_13_ID = 191399;
    public static final Version V_0_19_13 = new Version(191399, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_0_RC1_ID = 200051;
    public static final Version V_0_20_0_RC1 = new Version(200051, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_0_ID = 200099;
    public static final Version V_0_20_0 = new Version(200099, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_1_ID = 200199;
    public static final Version V_0_20_1 = new Version(200199, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_2_ID = 200299;
    public static final Version V_0_20_2 = new Version(200299, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_3_ID = 200399;
    public static final Version V_0_20_3 = new Version(200399, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_4_ID = 200499;
    public static final Version V_0_20_4 = new Version(200499, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_5_ID = 200599;
    public static final Version V_0_20_5 = new Version(200599, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_6_ID = 200699;
    public static final Version V_0_20_6 = new Version(200699, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_20_7_ID = 200799;
    public static final Version V_0_20_7 = new Version(200799, false, org.apache.lucene.util.Version.LUCENE_36);
    public static final int V_0_90_0_Beta1_ID = 900001;
    public static final Version V_0_90_0_Beta1 = new Version(900001, false, org.apache.lucene.util.Version.LUCENE_41);
    public static final int V_0_90_0_RC1_ID = 900051;
    public static final Version V_0_90_0_RC1 = new Version(900051, false, org.apache.lucene.util.Version.LUCENE_41);
    public static final int V_0_90_0_RC2_ID = 900052;
    public static final Version V_0_90_0_RC2 = new Version(900052, false, org.apache.lucene.util.Version.LUCENE_42);
    public static final int V_0_90_0_ID = 900099;
    public static final Version V_0_90_0 = new Version(900099, false, org.apache.lucene.util.Version.LUCENE_42);
    public static final int V_0_90_1_ID = 900199;
    public static final Version V_0_90_1 = new Version(900199, false, org.apache.lucene.util.Version.LUCENE_43);
    public static final int V_0_90_2_ID = 900299;
    public static final Version V_0_90_2 = new Version(900299, false, org.apache.lucene.util.Version.LUCENE_43);
    public static final int V_0_90_3_ID = 900399;
    public static final Version V_0_90_3 = new Version(900399, false, org.apache.lucene.util.Version.LUCENE_44);
    public static final int V_0_90_4_ID = 900499;
    public static final Version V_0_90_4 = new Version(900499, false, org.apache.lucene.util.Version.LUCENE_44);
    public static final int V_0_90_5_ID = 900599;
    public static final Version V_0_90_5 = new Version(900599, false, org.apache.lucene.util.Version.LUCENE_44);
    public static final int V_0_90_6_ID = 900699;
    public static final Version V_0_90_6 = new Version(900699, false, org.apache.lucene.util.Version.LUCENE_45);
    public static final int V_0_90_7_ID = 900799;
    public static final Version V_0_90_7 = new Version(900799, false, org.apache.lucene.util.Version.LUCENE_45);
    public static final int V_0_90_8_ID = 900899;
    public static final Version V_0_90_8 = new Version(900899, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_0_90_9_ID = 900999;
    public static final Version V_0_90_9 = new Version(900999, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_0_90_10_ID = 901099;
    public static final Version V_0_90_10 = new Version(901099, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_0_90_11_ID = 901199;
    public static final Version V_0_90_11 = new Version(901199, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_0_90_12_ID = 901299;
    public static final Version V_0_90_12 = new Version(901299, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_1_0_0_Beta1_ID = 1000001;
    public static final Version V_1_0_0_Beta1 = new Version(1000001, false, org.apache.lucene.util.Version.LUCENE_45);
    public static final int V_1_0_0_Beta2_ID = 1000002;
    public static final Version V_1_0_0_Beta2 = new Version(1000002, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_1_0_0_RC1_ID = 1000051;
    public static final Version V_1_0_0_RC1 = new Version(1000051, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_1_0_0_RC2_ID = 1000052;
    public static final Version V_1_0_0_RC2 = new Version(1000052, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_1_0_0_ID = 1000099;
    public static final Version V_1_0_0 = new Version(1000099, false, org.apache.lucene.util.Version.LUCENE_46);
    public static final int V_1_0_1_ID = 1000199;
    public static final Version V_1_0_1;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final Boolean snapshot;
    public final org.apache.lucene.util.Version luceneVersion;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        switch (id) {
            case 1000199: {
                return V_1_0_1;
            }
            case 1000099: {
                return V_1_0_0;
            }
            case 1000052: {
                return V_1_0_0_RC2;
            }
            case 1000051: {
                return V_1_0_0_RC1;
            }
            case 1000002: {
                return V_1_0_0_Beta2;
            }
            case 1000001: {
                return V_1_0_0_Beta1;
            }
            case 901299: {
                return V_0_90_12;
            }
            case 901199: {
                return V_0_90_11;
            }
            case 901099: {
                return V_0_90_10;
            }
            case 900999: {
                return V_0_90_9;
            }
            case 900899: {
                return V_0_90_8;
            }
            case 900799: {
                return V_0_90_7;
            }
            case 900699: {
                return V_0_90_6;
            }
            case 900599: {
                return V_0_90_5;
            }
            case 900499: {
                return V_0_90_4;
            }
            case 900399: {
                return V_0_90_3;
            }
            case 900299: {
                return V_0_90_2;
            }
            case 900199: {
                return V_0_90_1;
            }
            case 900099: {
                return V_0_90_0;
            }
            case 900052: {
                return V_0_90_0_RC2;
            }
            case 900051: {
                return V_0_90_0_RC1;
            }
            case 900001: {
                return V_0_90_0_Beta1;
            }
            case 200799: {
                return V_0_20_7;
            }
            case 200699: {
                return V_0_20_6;
            }
            case 200599: {
                return V_0_20_5;
            }
            case 200499: {
                return V_0_20_4;
            }
            case 200399: {
                return V_0_20_3;
            }
            case 200299: {
                return V_0_20_2;
            }
            case 200199: {
                return V_0_20_1;
            }
            case 200099: {
                return V_0_20_0;
            }
            case 200051: {
                return V_0_20_0_RC1;
            }
            case 190051: {
                return V_0_19_0_RC1;
            }
            case 190052: {
                return V_0_19_0_RC2;
            }
            case 190053: {
                return V_0_19_0_RC3;
            }
            case 190099: {
                return V_0_19_0;
            }
            case 190199: {
                return V_0_19_1;
            }
            case 190299: {
                return V_0_19_2;
            }
            case 190399: {
                return V_0_19_3;
            }
            case 190499: {
                return V_0_19_4;
            }
            case 190599: {
                return V_0_19_5;
            }
            case 190699: {
                return V_0_19_6;
            }
            case 190799: {
                return V_0_19_7;
            }
            case 190899: {
                return V_0_19_8;
            }
            case 190999: {
                return V_0_19_9;
            }
            case 191099: {
                return V_0_19_10;
            }
            case 191199: {
                return V_0_19_11;
            }
            case 191299: {
                return V_0_19_12;
            }
            case 191399: {
                return V_0_19_13;
            }
            case 180099: {
                return V_0_18_0;
            }
            case 180199: {
                return V_0_18_1;
            }
            case 180299: {
                return V_0_18_2;
            }
            case 180399: {
                return V_0_18_3;
            }
            case 180499: {
                return V_0_18_4;
            }
            case 180599: {
                return V_0_18_5;
            }
            case 180699: {
                return V_0_18_6;
            }
            case 180799: {
                return V_0_18_7;
            }
            case 180899: {
                return V_0_18_8;
            }
        }
        return new Version(id, null, Lucene.VERSION);
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static Version smallest(Version version1, Version version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    Version(int id, @Nullable Boolean snapshot, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.snapshot = snapshot;
        this.luceneVersion = luceneVersion;
    }

    public boolean snapshot() {
        return this.snapshot != null && this.snapshot != false;
    }

    public boolean after(Version version) {
        return version.id < this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id <= this.id;
    }

    public boolean before(Version version) {
        return version.id > this.id;
    }

    public boolean onOrBefore(Version version) {
        return version.id >= this.id;
    }

    public String number() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.build < 50) {
            sb.append(".Beta").append(this.build);
        } else if (this.build < 99) {
            sb.append(".RC").append(this.build - 50);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("Version: " + CURRENT + ", Build: " + Build.CURRENT.hashShort() + "/" + Build.CURRENT.timestamp() + ", JVM: " + JvmInfo.jvmInfo().version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.number());
        if (this.snapshot()) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    static {
        CURRENT = V_1_0_1 = new Version(1000199, false, org.apache.lucene.util.Version.LUCENE_46);
        assert (Version.CURRENT.luceneVersion == Lucene.VERSION) : "Version must be upgraded to [" + Lucene.VERSION + "] is still set to [" + Version.CURRENT.luceneVersion + "]";
    }

    public static class Module
    extends AbstractModule {
        private final Version version;

        public Module(Version version) {
            this.version = version;
        }

        @Override
        protected void configure() {
            this.bind(Version.class).toInstance(this.version);
        }
    }
}

