/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class MultiPercolateResponse
extends ActionResponse
implements Iterable<Item>,
ToXContent {
    private Item[] items;

    public MultiPercolateResponse(Item[] items) {
        this.items = items;
    }

    public MultiPercolateResponse() {
        this.items = new Item[0];
    }

    @Override
    public Iterator<Item> iterator() {
        return Iterators.forArray(this.items);
    }

    public Item[] items() {
        return this.items;
    }

    public Item[] getItems() {
        return this.items;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(Fields.RESPONSES);
        for (Item item : this.items) {
            if (item.isFailure()) {
                builder.startObject();
                builder.field(Fields.ERROR, item.getErrorMessage());
                builder.endObject();
                continue;
            }
            item.getResponse().toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.items.length);
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.items = new Item[size];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Item();
            this.items[i].readFrom(in);
        }
    }

    static final class Fields {
        static final XContentBuilderString RESPONSES = new XContentBuilderString("responses");
        static final XContentBuilderString ERROR = new XContentBuilderString("error");

        Fields() {
        }
    }

    public static class Item
    implements Streamable {
        private PercolateResponse response;
        private String errorMessage;

        public Item(PercolateResponse response) {
            this.response = response;
        }

        public Item(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Item() {
        }

        public PercolateResponse response() {
            return this.response;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public PercolateResponse getResponse() {
            return this.response;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean isFailure() {
            return this.errorMessage != null;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new PercolateResponse();
                this.response.readFrom(in);
            } else {
                this.errorMessage = in.readString();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (this.response != null) {
                out.writeBoolean(true);
                this.response.writeTo(out);
            } else {
                out.writeBoolean(false);
                out.writeString(this.errorMessage);
            }
        }
    }
}

