/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.object;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.object.DynamicTemplate;
import org.elasticsearch.index.mapper.object.ObjectMapper;

public class RootObjectMapper
extends ObjectMapper {
    private final FormatDateTimeFormatter[] dynamicDateTimeFormatters;
    private final boolean dateDetection;
    private final boolean numericDetection;
    private volatile DynamicTemplate[] dynamicTemplates;

    RootObjectMapper(String name, boolean enabled, ObjectMapper.Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers, FormatDateTimeFormatter[] dynamicDateTimeFormatters, DynamicTemplate[] dynamicTemplates, boolean dateDetection, boolean numericDetection) {
        super(name, name, enabled, ObjectMapper.Nested.NO, dynamic, pathType, mappers);
        this.dynamicTemplates = dynamicTemplates;
        this.dynamicDateTimeFormatters = dynamicDateTimeFormatters;
        this.dateDetection = dateDetection;
        this.numericDetection = numericDetection;
    }

    public boolean dateDetection() {
        return this.dateDetection;
    }

    public boolean numericDetection() {
        return this.numericDetection;
    }

    public FormatDateTimeFormatter[] dynamicDateTimeFormatters() {
        return this.dynamicDateTimeFormatters;
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, String dynamicType) {
        return this.findTemplateBuilder(context, name, dynamicType, dynamicType);
    }

    public Mapper.Builder findTemplateBuilder(ParseContext context, String name, String dynamicType, String matchType) {
        String mappingType;
        DynamicTemplate dynamicTemplate = this.findTemplate(context.path(), name, matchType);
        if (dynamicTemplate == null) {
            return null;
        }
        Mapper.TypeParser.ParserContext parserContext = context.docMapperParser().parserContext();
        Mapper.TypeParser typeParser = parserContext.typeParser(mappingType = dynamicTemplate.mappingType(dynamicType));
        if (typeParser == null) {
            throw new MapperParsingException("failed to find type parsed [" + mappingType + "] for [" + name + "]");
        }
        return typeParser.parse(name, dynamicTemplate.mappingForName(name, dynamicType), parserContext);
    }

    public DynamicTemplate findTemplate(ContentPath path, String name, String matchType) {
        for (DynamicTemplate dynamicTemplate : this.dynamicTemplates) {
            if (!dynamicTemplate.match(path, name, matchType)) continue;
            return dynamicTemplate;
        }
        return null;
    }

    @Override
    protected boolean allowValue() {
        return true;
    }

    @Override
    protected void doMerge(ObjectMapper mergeWith, MergeContext mergeContext) {
        RootObjectMapper mergeWithObject = (RootObjectMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            ArrayList<DynamicTemplate> mergedTemplates = Lists.newArrayList(Arrays.asList(this.dynamicTemplates));
            for (DynamicTemplate template : mergeWithObject.dynamicTemplates) {
                boolean replaced = false;
                for (int i = 0; i < mergedTemplates.size(); ++i) {
                    if (!((DynamicTemplate)mergedTemplates.get(i)).name().equals(template.name())) continue;
                    mergedTemplates.set(i, template);
                    replaced = true;
                }
                if (replaced) continue;
                mergedTemplates.add(template);
            }
            this.dynamicTemplates = mergedTemplates.toArray(new DynamicTemplate[mergedTemplates.size()]);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dynamicDateTimeFormatters != Defaults.DYNAMIC_DATE_TIME_FORMATTERS && this.dynamicDateTimeFormatters.length > 0) {
            builder.startArray("dynamic_date_formats");
            for (FormatDateTimeFormatter dateTimeFormatter : this.dynamicDateTimeFormatters) {
                builder.value(dateTimeFormatter.format());
            }
            builder.endArray();
        }
        if (this.dynamicTemplates != null && this.dynamicTemplates.length > 0) {
            builder.startArray("dynamic_templates");
            for (DynamicTemplate dynamicTemplate : this.dynamicTemplates) {
                builder.startObject();
                builder.field(dynamicTemplate.name());
                builder.map(dynamicTemplate.conf());
                builder.endObject();
            }
            builder.endArray();
        }
        if (!this.dateDetection) {
            builder.field("date_detection", this.dateDetection);
        }
        if (this.numericDetection) {
            builder.field("numeric_detection", this.numericDetection);
        }
    }

    public static class TypeParser
    extends ObjectMapper.TypeParser {
        @Override
        protected ObjectMapper.Builder createBuilder(String name) {
            return new Builder(name);
        }

        @Override
        protected void processField(ObjectMapper.Builder builder, String fieldName, Object fieldNode) {
            if (fieldName.equals("date_formats") || fieldName.equals("dynamic_date_formats")) {
                ArrayList<FormatDateTimeFormatter> dateTimeFormatters = Lists.newArrayList();
                if (fieldNode instanceof List) {
                    for (Object node1 : (List)fieldNode) {
                        dateTimeFormatters.add(TypeParsers.parseDateTimeFormatter(fieldName, node1));
                    }
                } else if ("none".equals(fieldNode.toString())) {
                    dateTimeFormatters = null;
                } else {
                    dateTimeFormatters.add(TypeParsers.parseDateTimeFormatter(fieldName, fieldNode));
                }
                if (dateTimeFormatters == null) {
                    ((Builder)builder).noDynamicDateTimeFormatter();
                } else {
                    ((Builder)builder).dynamicDateTimeFormatter(dateTimeFormatters);
                }
            } else if (fieldName.equals("dynamic_templates")) {
                List tmplNodes = (List)fieldNode;
                for (Object tmplNode : tmplNodes) {
                    Map tmpl = (Map)tmplNode;
                    if (tmpl.size() != 1) {
                        throw new MapperParsingException("A dynamic template must be defined with a name");
                    }
                    Map.Entry entry = tmpl.entrySet().iterator().next();
                    ((Builder)builder).add(DynamicTemplate.parse((String)entry.getKey(), (Map)entry.getValue()));
                }
            } else if (fieldName.equals("date_detection")) {
                ((Builder)builder).dateDetection = XContentMapValues.nodeBooleanValue(fieldNode);
            } else if (fieldName.equals("numeric_detection")) {
                ((Builder)builder).numericDetection = XContentMapValues.nodeBooleanValue(fieldNode);
            }
        }
    }

    public static class Builder
    extends ObjectMapper.Builder<Builder, RootObjectMapper> {
        protected final List<DynamicTemplate> dynamicTemplates = Lists.newArrayList();
        protected Set<String> seenDateFormats = Sets.newHashSet();
        protected List<FormatDateTimeFormatter> dynamicDateTimeFormatters = Lists.newArrayList();
        protected boolean dateDetection = true;
        protected boolean numericDetection = false;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder noDynamicDateTimeFormatter() {
            this.dynamicDateTimeFormatters = null;
            return (Builder)this.builder;
        }

        public Builder dynamicDateTimeFormatter(Iterable<FormatDateTimeFormatter> dateTimeFormatters) {
            for (FormatDateTimeFormatter dateTimeFormatter : dateTimeFormatters) {
                if (this.seenDateFormats.contains(dateTimeFormatter.format())) continue;
                this.seenDateFormats.add(dateTimeFormatter.format());
                this.dynamicDateTimeFormatters.add(dateTimeFormatter);
            }
            return (Builder)this.builder;
        }

        public Builder add(DynamicTemplate dynamicTemplate) {
            this.dynamicTemplates.add(dynamicTemplate);
            return this;
        }

        public Builder add(DynamicTemplate ... dynamicTemplate) {
            for (DynamicTemplate template : dynamicTemplate) {
                this.dynamicTemplates.add(template);
            }
            return this;
        }

        @Override
        protected ObjectMapper createMapper(String name, String fullPath, boolean enabled, ObjectMapper.Nested nested, ObjectMapper.Dynamic dynamic, ContentPath.Type pathType, Map<String, Mapper> mappers) {
            assert (!nested.isNested());
            FormatDateTimeFormatter[] dates = null;
            dates = this.dynamicDateTimeFormatters == null ? new FormatDateTimeFormatter[]{} : (this.dynamicDateTimeFormatters.isEmpty() ? Defaults.DYNAMIC_DATE_TIME_FORMATTERS : this.dynamicDateTimeFormatters.toArray(new FormatDateTimeFormatter[this.dynamicDateTimeFormatters.size()]));
            return new RootObjectMapper(name, enabled, dynamic, pathType, mappers, dates, this.dynamicTemplates.toArray(new DynamicTemplate[this.dynamicTemplates.size()]), this.dateDetection, this.numericDetection);
        }
    }

    public static class Defaults {
        public static final FormatDateTimeFormatter[] DYNAMIC_DATE_TIME_FORMATTERS = new FormatDateTimeFormatter[]{DateFieldMapper.Defaults.DATE_TIME_FORMATTER, Joda.forPattern("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd")};
        public static final boolean DATE_DETECTION = true;
        public static final boolean NUMERIC_DETECTION = false;
    }
}

