/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.index.query.support.QueryParsers;

public class RegexpQueryParser
implements QueryParser {
    public static final String NAME = "regexp";

    @Inject
    public RegexpQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[regexp] query malformed, no field");
        }
        String fieldName = parser.currentName();
        String rewriteMethod = null;
        Object value = null;
        float boost = 1.0f;
        int flagsValue = -1;
        String queryName = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("value".equals(currentFieldName)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if ("rewrite".equals(currentFieldName)) {
                        rewriteMethod = parser.textOrNull();
                        continue;
                    }
                    if ("flags".equals(currentFieldName)) {
                        String flags = parser.textOrNull();
                        flagsValue = RegexpFlag.resolveValue(flags);
                        continue;
                    }
                    if ("flags_value".equals(currentFieldName)) {
                        flagsValue = parser.intValue();
                        if (flagsValue >= 0) continue;
                        flagsValue = 65535;
                        continue;
                    }
                    if (!"_name".equals(currentFieldName)) continue;
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[regexp] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.objectBytes();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for regexp query");
        }
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(rewriteMethod, null);
        Query query = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    query = smartNameFieldMappers.mapper().regexpQuery(value, flagsValue, method, parseContext);
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            } else {
                query = smartNameFieldMappers.mapper().regexpQuery(value, flagsValue, method, parseContext);
            }
        }
        if (query == null) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(fieldName, BytesRefs.toBytesRef(value)), flagsValue);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query = regexpQuery;
        }
        query.setBoost(boost);
        query = QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, parseContext);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

