/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class MultiGetRequest
extends ActionRequest<MultiGetRequest> {
    private boolean listenerThreaded = false;
    String preference;
    Boolean realtime;
    boolean refresh;
    List<Item> items = new ArrayList<Item>();

    public MultiGetRequest add(Item item) {
        this.items.add(item);
        return this;
    }

    public MultiGetRequest add(String index, @Nullable String type, String id) {
        this.items.add(new Item(index, type, id));
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.items.isEmpty()) {
            validationException = ValidateActions.addValidationError("no documents to get", validationException);
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                if (item.index() == null) {
                    validationException = ValidateActions.addValidationError("index is missing for doc " + i, validationException);
                }
                if (item.id() != null) continue;
                validationException = ValidateActions.addValidationError("id is missing for doc " + i, validationException);
            }
        }
        return validationException;
    }

    public MultiGetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public MultiGetRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, byte[] data, int from, int length) throws Exception {
        return this.add(defaultIndex, defaultType, defaultFields, defaultFetchSource, new BytesArray(data, from, length), true);
    }

    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, BytesReference data) throws Exception {
        return this.add(defaultIndex, defaultType, defaultFields, defaultFetchSource, data, true);
    }

    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, BytesReference data, boolean allowExplicitIndex) throws Exception {
        return this.add(defaultIndex, defaultType, defaultFields, defaultFetchSource, null, data, allowExplicitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String defaultType, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting, BytesReference data, boolean allowExplicitIndex) throws Exception {
        XContentParser parser = XContentFactory.xContent(data).createParser(data);
        try {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY) continue;
                if ("docs".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token != XContentParser.Token.START_OBJECT) {
                            throw new ElasticsearchIllegalArgumentException("docs array element should include an object");
                        }
                        String index = defaultIndex;
                        String type = defaultType;
                        String id = null;
                        String routing = defaultRouting;
                        String parent = null;
                        ArrayList<String> fields = null;
                        long version = 0L;
                        VersionType versionType = VersionType.INTERNAL;
                        FetchSourceContext fetchSourceContext = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if ("_index".equals(currentFieldName)) {
                                    if (!allowExplicitIndex) {
                                        throw new ElasticsearchIllegalArgumentException("explicit index in multi get is not allowed");
                                    }
                                    index = parser.text();
                                    continue;
                                }
                                if ("_type".equals(currentFieldName)) {
                                    type = parser.text();
                                    continue;
                                }
                                if ("_id".equals(currentFieldName)) {
                                    id = parser.text();
                                    continue;
                                }
                                if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                                    routing = parser.text();
                                    continue;
                                }
                                if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                                    parent = parser.text();
                                    continue;
                                }
                                if ("fields".equals(currentFieldName)) {
                                    fields = new ArrayList();
                                    fields.add(parser.text());
                                    continue;
                                }
                                if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                                    version = parser.longValue();
                                    continue;
                                }
                                if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                                    versionType = VersionType.fromString(parser.text());
                                    continue;
                                }
                                if (!"_source".equals(currentFieldName)) continue;
                                if (parser.isBooleanValue()) {
                                    fetchSourceContext = new FetchSourceContext(parser.booleanValue());
                                    continue;
                                }
                                if (token == XContentParser.Token.VALUE_STRING) {
                                    fetchSourceContext = new FetchSourceContext(new String[]{parser.text()});
                                    continue;
                                }
                                throw new ElasticsearchParseException("illegal type for _source: [" + (Object)((Object)token) + "]");
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                if ("fields".equals(currentFieldName)) {
                                    fields = new ArrayList<String>();
                                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                        fields.add(parser.text());
                                    }
                                    continue;
                                }
                                if (!"_source".equals(currentFieldName)) continue;
                                ArrayList<String> includes = new ArrayList<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    includes.add(parser.text());
                                }
                                fetchSourceContext = new FetchSourceContext(includes.toArray(Strings.EMPTY_ARRAY));
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT || !"_source".equals(currentFieldName)) continue;
                            List currentList = null;
                            ArrayList includes = null;
                            ArrayList excludes = null;
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    currentFieldName = parser.currentName();
                                    if ("includes".equals(currentFieldName) || "include".equals(currentFieldName)) {
                                        currentList = includes != null ? includes : new ArrayList(2);
                                        continue;
                                    }
                                    if ("excludes".equals(currentFieldName) || "exclude".equals(currentFieldName)) {
                                        currentList = excludes != null ? excludes : new ArrayList(2);
                                        continue;
                                    }
                                    throw new ElasticsearchParseException("Source definition may not contain " + parser.text());
                                }
                                if (token == XContentParser.Token.START_ARRAY) {
                                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                        currentList.add(parser.text());
                                    }
                                    continue;
                                }
                                if (token.isValue()) {
                                    currentList.add(parser.text());
                                    continue;
                                }
                                throw new ElasticsearchParseException("unexpected token while parsing source settings");
                            }
                            fetchSourceContext = new FetchSourceContext(includes == null ? Strings.EMPTY_ARRAY : includes.toArray(new String[includes.size()]), excludes == null ? Strings.EMPTY_ARRAY : excludes.toArray(new String[excludes.size()]));
                        }
                        String[] aFields = fields != null ? fields.toArray(new String[fields.size()]) : defaultFields;
                        this.add(new Item(index, type, id).routing(routing).fields(aFields).parent(parent).version(version).versionType(versionType).fetchSourceContext(fetchSourceContext == null ? defaultFetchSource : fetchSourceContext));
                    }
                    continue;
                }
                if (!"ids".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new ElasticsearchIllegalArgumentException("ids array element should only contain ids");
                    }
                    this.add(new Item(defaultIndex, defaultType, parser.text()).fields(defaultFields).fetchSourceContext(defaultFetchSource).routing(defaultRouting));
                }
            }
        }
        finally {
            parser.close();
        }
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        byte realtime = in.readByte();
        if (realtime == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
        int size = in.readVInt();
        this.items = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(Item.readItem(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out);
        }
    }

    public static class Item
    implements Streamable {
        private String index;
        private String type;
        private String id;
        private String routing;
        private String[] fields;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;
        private FetchSourceContext fetchSourceContext;

        Item() {
        }

        public Item(String index, @Nullable String type, String id) {
            this.index = index;
            this.type = type;
            this.id = id;
        }

        public String index() {
            return this.index;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item parent(String parent) {
            if (this.routing == null) {
                this.routing = parent;
            }
            return this;
        }

        public Item fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public String[] fields() {
            return this.fields;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public FetchSourceContext fetchSourceContext() {
            return this.fetchSourceContext;
        }

        public Item fetchSourceContext(FetchSourceContext fetchSourceContext) {
            this.fetchSourceContext = fetchSourceContext;
            return this;
        }

        public static Item readItem(StreamInput in) throws IOException {
            Item item = new Item();
            item.readFrom(in);
            return item;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readSharedString();
            this.type = in.readOptionalSharedString();
            this.id = in.readString();
            this.routing = in.readOptionalString();
            int size = in.readVInt();
            if (size > 0) {
                this.fields = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.fields[i] = in.readString();
                }
            }
            this.version = in.readVLong();
            this.versionType = VersionType.fromValue(in.readByte());
            this.fetchSourceContext = FetchSourceContext.optionalReadFromStream(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeSharedString(this.index);
            out.writeOptionalSharedString(this.type);
            out.writeString(this.id);
            out.writeOptionalString(this.routing);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.length);
                for (String field : this.fields) {
                    out.writeString(field);
                }
            }
            out.writeVLong(this.version);
            out.writeByte(this.versionType.getValue());
            FetchSourceContext.optionalWriteToStream(this.fetchSourceContext, out);
        }
    }
}

