/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvector;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hppc.ObjectLongOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectLongCursor;
import org.elasticsearch.common.io.stream.BytesStreamInput;

public final class TermVectorFields
extends Fields {
    private final ObjectLongOpenHashMap<String> fieldMap;
    private final BytesReference termVectors;
    final boolean hasTermStatistic;
    final boolean hasFieldStatistic;

    public TermVectorFields(BytesReference headerRef, BytesReference termVectors) throws IOException {
        BytesStreamInput header = new BytesStreamInput(headerRef);
        this.fieldMap = new ObjectLongOpenHashMap();
        String headerString = header.readString();
        assert (headerString.equals("TV"));
        int version = header.readInt();
        assert (version == -1);
        this.hasTermStatistic = header.readBoolean();
        this.hasFieldStatistic = header.readBoolean();
        int numFields = header.readVInt();
        for (int i = 0; i < numFields; ++i) {
            this.fieldMap.put(header.readString(), header.readVLong());
        }
        header.close();
        this.termVectors = termVectors;
    }

    public Iterator<String> iterator() {
        final Iterator<ObjectLongCursor<String>> iterator = this.fieldMap.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)((ObjectLongCursor)iterator.next()).key;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Terms terms(String field) throws IOException {
        if (!this.fieldMap.containsKey(field)) {
            return null;
        }
        long offset = this.fieldMap.lget();
        final BytesStreamInput perFieldTermVectorInput = new BytesStreamInput(this.termVectors);
        perFieldTermVectorInput.reset();
        perFieldTermVectorInput.skip(offset);
        final long numTerms = perFieldTermVectorInput.readVLong();
        final boolean hasPositions = perFieldTermVectorInput.readBoolean();
        final boolean hasOffsets = perFieldTermVectorInput.readBoolean();
        final boolean hasPayloads = perFieldTermVectorInput.readBoolean();
        final long sumTotalTermFreq = this.hasFieldStatistic ? this.readPotentiallyNegativeVLong(perFieldTermVectorInput) : -1L;
        final long sumDocFreq = this.hasFieldStatistic ? this.readPotentiallyNegativeVLong(perFieldTermVectorInput) : -1L;
        final int docCount = this.hasFieldStatistic ? this.readPotentiallyNegativeVInt(perFieldTermVectorInput) : -1;
        return new Terms(){

            public TermsEnum iterator(TermsEnum reuse) throws IOException {
                return new TermsEnum(){
                    int currentTerm = 0;
                    int freq = 0;
                    int docFreq = -1;
                    long totalTermFrequency = -1L;
                    int[] positions = new int[1];
                    int[] startOffsets = new int[1];
                    int[] endOffsets = new int[1];
                    BytesRef[] payloads = new BytesRef[1];
                    final BytesRef spare = new BytesRef();

                    public BytesRef next() throws IOException {
                        if ((long)this.currentTerm++ < numTerms) {
                            int termVectorSize = perFieldTermVectorInput.readVInt();
                            this.spare.grow(termVectorSize);
                            perFieldTermVectorInput.readBytes(this.spare.bytes, 0, termVectorSize);
                            this.spare.length = termVectorSize;
                            if (TermVectorFields.this.hasTermStatistic) {
                                this.docFreq = TermVectorFields.this.readPotentiallyNegativeVInt(perFieldTermVectorInput);
                                this.totalTermFrequency = TermVectorFields.this.readPotentiallyNegativeVLong(perFieldTermVectorInput);
                            }
                            this.freq = TermVectorFields.this.readPotentiallyNegativeVInt(perFieldTermVectorInput);
                            this.growBuffers();
                            this.writeInfos(perFieldTermVectorInput);
                            return this.spare;
                        }
                        return null;
                    }

                    private void writeInfos(BytesStreamInput input) throws IOException {
                        for (int i = 0; i < this.freq; ++i) {
                            if (hasPositions) {
                                this.positions[i] = input.readVInt();
                            }
                            if (hasOffsets) {
                                this.startOffsets[i] = input.readVInt();
                                this.endOffsets[i] = input.readVInt();
                            }
                            if (!hasPayloads) continue;
                            int payloadLength = input.readVInt();
                            if (this.payloads[i] == null) {
                                this.payloads[i] = new BytesRef(payloadLength);
                            } else {
                                this.payloads[i].grow(payloadLength);
                            }
                            input.readBytes(this.payloads[i].bytes, 0, payloadLength);
                            this.payloads[i].length = payloadLength;
                            this.payloads[i].offset = 0;
                        }
                    }

                    private void growBuffers() {
                        if (hasPositions) {
                            this.positions = ArrayUtil.grow((int[])this.positions, (int)this.freq);
                        }
                        if (hasOffsets) {
                            this.startOffsets = ArrayUtil.grow((int[])this.startOffsets, (int)this.freq);
                            this.endOffsets = ArrayUtil.grow((int[])this.endOffsets, (int)this.freq);
                        }
                        if (hasPayloads && this.payloads.length < this.freq) {
                            BytesRef[] newArray = new BytesRef[ArrayUtil.oversize((int)this.freq, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                            System.arraycopy(this.payloads, 0, newArray, 0, this.payloads.length);
                            this.payloads = newArray;
                        }
                    }

                    public Comparator<BytesRef> getComparator() {
                        return BytesRef.getUTF8SortedAsUnicodeComparator();
                    }

                    public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public void seekExact(long ord) throws IOException {
                        throw new UnsupportedOperationException("Seek is not supported");
                    }

                    public BytesRef term() throws IOException {
                        return this.spare;
                    }

                    public long ord() throws IOException {
                        throw new UnsupportedOperationException("ordinals are not supported");
                    }

                    public int docFreq() throws IOException {
                        return this.docFreq;
                    }

                    public long totalTermFreq() throws IOException {
                        return this.totalTermFrequency;
                    }

                    public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
                        return this.docsAndPositions(liveDocs, reuse instanceof DocsAndPositionsEnum ? (DocsAndPositionsEnum)reuse : null, 0);
                    }

                    public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
                        TermVectorsDocsAndPosEnum retVal = reuse instanceof TermVectorsDocsAndPosEnum ? (TermVectorsDocsAndPosEnum)reuse : new TermVectorsDocsAndPosEnum();
                        return retVal.reset(hasPositions ? this.positions : null, hasOffsets ? this.startOffsets : null, hasOffsets ? this.endOffsets : null, hasPayloads ? this.payloads : null, this.freq);
                    }
                };
            }

            public Comparator<BytesRef> getComparator() {
                return BytesRef.getUTF8SortedAsUnicodeComparator();
            }

            public long size() throws IOException {
                return numTerms;
            }

            public long getSumTotalTermFreq() throws IOException {
                return sumTotalTermFreq;
            }

            public long getSumDocFreq() throws IOException {
                return sumDocFreq;
            }

            public int getDocCount() throws IOException {
                return docCount;
            }

            public boolean hasFreqs() {
                return true;
            }

            public boolean hasOffsets() {
                return hasOffsets;
            }

            public boolean hasPositions() {
                return hasPositions;
            }

            public boolean hasPayloads() {
                return hasPayloads;
            }
        };
    }

    public int size() {
        return this.fieldMap.size();
    }

    int readPotentiallyNegativeVInt(BytesStreamInput stream) throws IOException {
        return stream.readVInt() - 1;
    }

    long readPotentiallyNegativeVLong(BytesStreamInput stream) throws IOException {
        return stream.readVLong() - 1L;
    }

    private final class TermVectorsDocsAndPosEnum
    extends DocsAndPositionsEnum {
        private boolean hasPositions;
        private boolean hasOffsets;
        private boolean hasPayloads;
        int curPos = -1;
        int doc = -1;
        private int freq;
        private int[] startOffsets;
        private int[] positions;
        private BytesRef[] payloads;
        private int[] endOffsets;

        private TermVectorsDocsAndPosEnum() {
        }

        private DocsAndPositionsEnum reset(int[] positions, int[] startOffsets, int[] endOffsets, BytesRef[] payloads, int freq) {
            this.curPos = -1;
            this.doc = -1;
            this.hasPositions = positions != null;
            this.hasOffsets = startOffsets != null;
            this.hasPayloads = payloads != null;
            this.freq = freq;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.payloads = payloads;
            this.positions = positions;
            return this;
        }

        public int nextDoc() throws IOException {
            this.doc = this.doc == -1 ? 0 : Integer.MAX_VALUE;
            return this.doc;
        }

        public int docID() {
            return this.doc;
        }

        public int advance(int target) throws IOException {
            while (this.nextDoc() < target && this.doc != Integer.MAX_VALUE) {
            }
            return this.doc;
        }

        public int freq() throws IOException {
            return this.freq;
        }

        public int startOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.startOffsets[this.curPos] : -1;
        }

        public int nextPosition() throws IOException {
            assert (this.curPos + 1 < this.freq);
            ++this.curPos;
            return this.hasPositions ? this.positions[this.curPos] : -1;
        }

        public BytesRef getPayload() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasPayloads ? this.payloads[this.curPos] : null;
        }

        public int endOffset() throws IOException {
            assert (this.curPos < this.freq && this.curPos >= 0);
            return this.hasOffsets ? this.endOffsets[this.curPos] : -1;
        }

        public long cost() {
            return 1L;
        }
    }
}

