/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.memory;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.CachingByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.PlainByteBufferAllocator;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class ByteBufferCache
extends AbstractComponent
implements ByteBufferAllocator {
    private final boolean direct;
    private final ByteSizeValue smallBufferSize;
    private final ByteSizeValue largeBufferSize;
    private final ByteSizeValue smallCacheSize;
    private final ByteSizeValue largeCacheSize;
    private final ByteBufferAllocator allocator;

    public ByteBufferCache() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public ByteBufferCache(int bufferSizeInBytes, int cacheSizeInBytes, boolean direct) {
        this(ImmutableSettings.settingsBuilder().put("cache.memory.small_buffer_size", bufferSizeInBytes).put("cache.memory.small_cache_size", cacheSizeInBytes).put("cache.memory.large_buffer_size", bufferSizeInBytes).put("cache.memory.large_cache_size", cacheSizeInBytes).put("cache.memory.direct", direct).build());
    }

    @Inject
    public ByteBufferCache(Settings settings) {
        super(settings);
        this.direct = this.componentSettings.getAsBoolean("direct", (Boolean)true);
        this.smallBufferSize = this.componentSettings.getAsBytesSize("small_buffer_size", new ByteSizeValue(1L, ByteSizeUnit.KB));
        this.largeBufferSize = this.componentSettings.getAsBytesSize("large_buffer_size", new ByteSizeValue(1L, ByteSizeUnit.MB));
        this.smallCacheSize = this.componentSettings.getAsBytesSize("small_cache_size", new ByteSizeValue(10L, ByteSizeUnit.MB));
        this.largeCacheSize = this.componentSettings.getAsBytesSize("large_cache_size", new ByteSizeValue(500L, ByteSizeUnit.MB));
        this.allocator = this.smallCacheSize.bytes() == 0L || this.largeCacheSize.bytes() == 0L ? new PlainByteBufferAllocator(this.direct, (int)this.smallBufferSize.bytes(), (int)this.largeBufferSize.bytes()) : new CachingByteBufferAllocator(this.direct, (int)this.smallBufferSize.bytes(), (int)this.largeBufferSize.bytes(), (int)this.smallCacheSize.bytes(), (int)this.largeCacheSize.bytes());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using bytebuffer cache with small_buffer_size [{}], large_buffer_size [{}], small_cache_size [{}], large_cache_size [{}], direct [{}]", this.smallBufferSize, this.largeBufferSize, this.smallCacheSize, this.largeCacheSize, this.direct);
        }
    }

    public boolean direct() {
        return this.direct;
    }

    @Override
    public void close() {
        this.allocator.close();
    }

    @Override
    public int sizeInBytes(ByteBufferAllocator.Type type) {
        return this.allocator.sizeInBytes(type);
    }

    @Override
    public ByteBuffer allocate(ByteBufferAllocator.Type type) throws IOException {
        return this.allocator.allocate(type);
    }

    @Override
    public void release(ByteBuffer buffer) {
        this.allocator.release(buffer);
    }
}

