/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.text.UTF8SortedAsUnicodeComparator;

public class StringText
implements Text {
    public static final Text[] EMPTY_ARRAY = new Text[0];
    private final String text;
    private int hash;

    public static Text[] convertFromStringArray(String[] strings) {
        if (strings.length == 0) {
            return EMPTY_ARRAY;
        }
        Text[] texts = new Text[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            texts[i] = new StringText(strings[i]);
        }
        return texts;
    }

    public StringText(String text) {
        this.text = text;
    }

    @Override
    public boolean hasBytes() {
        return false;
    }

    @Override
    public BytesReference bytes() {
        return new BytesArray(this.text.getBytes(Charsets.UTF_8));
    }

    @Override
    public boolean hasString() {
        return true;
    }

    @Override
    public String string() {
        return this.text;
    }

    @Override
    public String toString() {
        return this.string();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.bytes().hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return this.bytes().equals(((Text)obj).bytes());
    }

    @Override
    public int compareTo(Text text) {
        return UTF8SortedAsUnicodeComparator.utf8SortedAsUnicodeSortOrder.compare(this.bytes(), text.bytes());
    }
}

