/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.CloseableComponent;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public interface Engine
extends IndexShardComponent,
CloseableComponent {
    public static final String INDEX_CODEC = "index.codec";
    public static final ByteSizeValue INACTIVE_SHARD_INDEXING_BUFFER = ByteSizeValue.parseBytesSizeValue("500kb");

    public TimeValue defaultRefreshInterval();

    public void enableGcDeletes(boolean var1);

    public void updateIndexingBufferSize(ByteSizeValue var1);

    public void addFailedEngineListener(FailedEngineListener var1);

    public void start() throws EngineException;

    public void create(Create var1) throws EngineException;

    public void index(Index var1) throws EngineException;

    public void delete(Delete var1) throws EngineException;

    public void delete(DeleteByQuery var1) throws EngineException;

    public GetResult get(Get var1) throws EngineException;

    public Searcher acquireSearcher(String var1) throws EngineException;

    public SegmentsStats segmentsStats();

    public List<Segment> segments();

    public boolean refreshNeeded();

    public boolean possibleMergeNeeded();

    public void maybeMerge() throws EngineException;

    public void refresh(Refresh var1) throws EngineException;

    public void flush(Flush var1) throws EngineException, FlushNotAllowedEngineException;

    public void optimize(Optimize var1) throws EngineException;

    public <T> T snapshot(SnapshotHandler<T> var1) throws EngineException;

    public SnapshotIndexCommit snapshotIndex() throws EngineException;

    public void recover(RecoveryHandler var1) throws EngineException;

    public static class GetResult {
        private final boolean exists;
        private final long version;
        private final Translog.Source source;
        private final Versions.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null);

        public GetResult(boolean exists, long version, @Nullable Translog.Source source) {
            this.source = source;
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = null;
            this.searcher = null;
        }

        public GetResult(Searcher searcher, Versions.DocIdAndVersion docIdAndVersion) {
            this.exists = true;
            this.source = null;
            this.version = docIdAndVersion.version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        @Nullable
        public Translog.Source source() {
            return this.source;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public Versions.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        public void release() {
            if (this.searcher != null) {
                this.searcher.release();
            }
        }
    }

    public static class Get {
        private final boolean realtime;
        private final Term uid;
        private boolean loadSource = true;
        private long version;
        private VersionType versionType;

        public Get(boolean realtime, Term uid) {
            this.realtime = realtime;
            this.uid = uid;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public Term uid() {
            return this.uid;
        }

        public boolean loadSource() {
            return this.loadSource;
        }

        public Get loadSource(boolean loadSource) {
            this.loadSource = loadSource;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }
    }

    public static class DeleteByQuery {
        private final Query query;
        private final BytesReference source;
        private final String[] filteringAliases;
        private final Filter aliasFilter;
        private final String[] types;
        private final Filter parentFilter;
        private Operation.Origin origin = Operation.Origin.PRIMARY;
        private long startTime;
        private long endTime;

        public DeleteByQuery(Query query, BytesReference source, @Nullable String[] filteringAliases, @Nullable Filter aliasFilter, Filter parentFilter, String ... types) {
            this.query = query;
            this.source = source;
            this.types = types;
            this.filteringAliases = filteringAliases;
            this.aliasFilter = aliasFilter;
            this.parentFilter = parentFilter;
        }

        public Query query() {
            return this.query;
        }

        public BytesReference source() {
            return this.source;
        }

        public String[] types() {
            return this.types;
        }

        public String[] filteringAliases() {
            return this.filteringAliases;
        }

        public Filter aliasFilter() {
            return this.aliasFilter;
        }

        public boolean nested() {
            return this.parentFilter != null;
        }

        public Filter parentFilter() {
            return this.parentFilter;
        }

        public DeleteByQuery origin(Operation.Origin origin) {
            this.origin = origin;
            return this;
        }

        public Operation.Origin origin() {
            return this.origin;
        }

        public DeleteByQuery startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public long startTime() {
            return this.startTime;
        }

        public DeleteByQuery endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static class Delete
    implements Operation {
        private final String type;
        private final String id;
        private final Term uid;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;
        private Operation.Origin origin = Operation.Origin.PRIMARY;
        private boolean found;
        private long startTime;
        private long endTime;

        public Delete(String type, String id, Term uid) {
            this.type = type;
            this.id = id;
            this.uid = uid;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.DELETE;
        }

        public Delete origin(Operation.Origin origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public String type() {
            return this.type;
        }

        public String id() {
            return this.id;
        }

        public Term uid() {
            return this.uid;
        }

        public Delete version(long version) {
            this.version = version;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Delete versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public boolean found() {
            return this.found;
        }

        public Delete found(boolean found) {
            this.found = found;
            return this;
        }

        public Delete startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public long startTime() {
            return this.startTime;
        }

        public Delete endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static class Index
    implements IndexingOperation {
        private final DocumentMapper docMapper;
        private final Term uid;
        private final ParsedDocument doc;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;
        private Operation.Origin origin = Operation.Origin.PRIMARY;
        private boolean created;
        private long startTime;
        private long endTime;

        public Index(DocumentMapper docMapper, Term uid, ParsedDocument doc) {
            this.docMapper = docMapper;
            this.uid = uid;
            this.doc = doc;
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.INDEX;
        }

        public Index origin(Operation.Origin origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        public Term uid() {
            return this.uid;
        }

        @Override
        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        public Index version(long version) {
            this.version = version;
            this.doc.version().setLongValue(version);
            return this;
        }

        public long version() {
            return this.version;
        }

        public Index versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        @Override
        public List<ParseContext.Document> docs() {
            return this.doc.docs();
        }

        public Analyzer analyzer() {
            return this.doc.analyzer();
        }

        public String id() {
            return this.doc.id();
        }

        public String type() {
            return this.doc.type();
        }

        public String routing() {
            return this.doc.routing();
        }

        public String parent() {
            return this.doc.parent();
        }

        public long timestamp() {
            return this.doc.timestamp();
        }

        public long ttl() {
            return this.doc.ttl();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        public Index startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public long startTime() {
            return this.startTime;
        }

        public Index endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }

        public boolean created() {
            return this.created;
        }

        public void created(boolean created) {
            this.created = created;
        }
    }

    public static class Create
    implements IndexingOperation {
        private final DocumentMapper docMapper;
        private final Term uid;
        private final ParsedDocument doc;
        private long version = 0L;
        private VersionType versionType = VersionType.INTERNAL;
        private Operation.Origin origin = Operation.Origin.PRIMARY;
        private long startTime;
        private long endTime;

        public Create(DocumentMapper docMapper, Term uid, ParsedDocument doc) {
            this.docMapper = docMapper;
            this.uid = uid;
            this.doc = doc;
        }

        @Override
        public DocumentMapper docMapper() {
            return this.docMapper;
        }

        @Override
        public Operation.Type opType() {
            return Operation.Type.CREATE;
        }

        public Create origin(Operation.Origin origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public Operation.Origin origin() {
            return this.origin;
        }

        @Override
        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        public Term uid() {
            return this.uid;
        }

        public String type() {
            return this.doc.type();
        }

        public String id() {
            return this.doc.id();
        }

        public String routing() {
            return this.doc.routing();
        }

        public long timestamp() {
            return this.doc.timestamp();
        }

        public long ttl() {
            return this.doc.ttl();
        }

        public long version() {
            return this.version;
        }

        public Create version(long version) {
            this.version = version;
            this.doc.version().setLongValue(version);
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Create versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public String parent() {
            return this.doc.parent();
        }

        @Override
        public List<ParseContext.Document> docs() {
            return this.doc.docs();
        }

        public Analyzer analyzer() {
            return this.doc.analyzer();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        public Create startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public long startTime() {
            return this.startTime;
        }

        public Create endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public long endTime() {
            return this.endTime;
        }
    }

    public static interface IndexingOperation
    extends Operation {
        public ParsedDocument parsedDoc();

        public List<ParseContext.Document> docs();

        public DocumentMapper docMapper();
    }

    public static interface Operation {
        public Type opType();

        public Origin origin();

        public static enum Origin {
            PRIMARY,
            REPLICA,
            RECOVERY;

        }

        public static enum Type {
            CREATE,
            INDEX,
            DELETE;

        }
    }

    public static class Optimize {
        private boolean waitForMerge = true;
        private int maxNumSegments = -1;
        private boolean onlyExpungeDeletes = false;
        private boolean flush = false;

        public boolean waitForMerge() {
            return this.waitForMerge;
        }

        public Optimize waitForMerge(boolean waitForMerge) {
            this.waitForMerge = waitForMerge;
            return this;
        }

        public int maxNumSegments() {
            return this.maxNumSegments;
        }

        public Optimize maxNumSegments(int maxNumSegments) {
            this.maxNumSegments = maxNumSegments;
            return this;
        }

        public boolean onlyExpungeDeletes() {
            return this.onlyExpungeDeletes;
        }

        public Optimize onlyExpungeDeletes(boolean onlyExpungeDeletes) {
            this.onlyExpungeDeletes = onlyExpungeDeletes;
            return this;
        }

        public boolean flush() {
            return this.flush;
        }

        public Optimize flush(boolean flush) {
            this.flush = flush;
            return this;
        }

        public String toString() {
            return "waitForMerge[" + this.waitForMerge + "], maxNumSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "]";
        }
    }

    public static class Flush {
        private Type type = Type.COMMIT_TRANSLOG;
        private boolean force = false;
        private boolean waitIfOngoing = false;

        public Type type() {
            return this.type;
        }

        public Flush type(Type type) {
            this.type = type;
            return this;
        }

        public boolean force() {
            return this.force;
        }

        public Flush force(boolean force) {
            this.force = force;
            return this;
        }

        public boolean waitIfOngoing() {
            return this.waitIfOngoing;
        }

        public Flush waitIfOngoing(boolean waitIfOngoing) {
            this.waitIfOngoing = waitIfOngoing;
            return this;
        }

        public String toString() {
            return "type[" + (Object)((Object)this.type) + "], force[" + this.force + "]";
        }

        public static enum Type {
            NEW_WRITER,
            COMMIT,
            COMMIT_TRANSLOG;

        }
    }

    public static class Refresh {
        private final String source;
        private boolean force = false;

        public Refresh(String source) {
            this.source = source;
        }

        public Refresh force(boolean force) {
            this.force = force;
            return this;
        }

        public boolean force() {
            return this.force;
        }

        public String source() {
            return this.source;
        }

        public String toString() {
            return "force[" + this.force + "], source [" + this.source + "]";
        }
    }

    public static class SimpleSearcher
    implements Searcher {
        private final String source;
        private final IndexSearcher searcher;

        public SimpleSearcher(String source, IndexSearcher searcher) {
            this.source = source;
            this.searcher = searcher;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public boolean release() throws ElasticsearchException {
            return true;
        }
    }

    public static interface Searcher
    extends Releasable {
        public String source();

        public IndexReader reader();

        public IndexSearcher searcher();
    }

    public static interface SnapshotHandler<T> {
        public T snapshot(SnapshotIndexCommit var1, Translog.Snapshot var2) throws EngineException;
    }

    public static interface RecoveryHandler {
        public void phase1(SnapshotIndexCommit var1) throws ElasticsearchException;

        public void phase2(Translog.Snapshot var1) throws ElasticsearchException;

        public void phase3(Translog.Snapshot var1) throws ElasticsearchException;
    }

    public static interface FailedEngineListener {
        public void onFailedEngine(ShardId var1, Throwable var2);
    }
}

