/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.mapping.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestGetMappingAction
extends BaseRestHandler {
    @Inject
    public RestGetMappingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        this.client.admin().indices().getMappings(getMappingsRequest, new ActionListener<GetMappingsResponse>(){

            @Override
            public void onResponse(GetMappingsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                    if (mappingsByIndex.isEmpty()) {
                        if (indices.length != 0 && types.length != 0) {
                            channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, RestXContentBuilder.emptyBuilder(request)));
                        } else if (indices.length != 0) {
                            channel.sendResponse(new XContentThrowableRestResponse(request, new IndexMissingException(new Index(indices[0]))));
                        } else if (types.length != 0) {
                            channel.sendResponse(new XContentThrowableRestResponse(request, new TypeMissingException(new Index("_all"), new String[]{types[0]})));
                        } else {
                            builder.endObject();
                            channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                        }
                        return;
                    }
                    for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : mappingsByIndex) {
                        if (((ImmutableOpenMap)objectObjectCursor.value).isEmpty()) continue;
                        builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject(Fields.MAPPINGS);
                        for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                            builder.field((String)typeEntry.key);
                            builder.map(((MappingMetaData)typeEntry.value).sourceAsMap());
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetMappingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static class Fields {
        static final XContentBuilderString MAPPINGS = new XContentBuilderString("mappings");

        Fields() {
        }
    }
}

