/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;
import org.elasticsearch.search.aggregations.support.numeric.ValueFormatter;
import org.elasticsearch.search.aggregations.support.numeric.ValueParser;
import org.elasticsearch.search.internal.SearchContext;

public class TermsParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return StringTerms.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        ValuesSourceConfig<ValuesSource> config;
        XContentParser.Token token;
        String field = null;
        String script = null;
        String scriptLang = null;
        Map<String, Object> scriptParams = null;
        Terms.ValueType valueType = null;
        int requiredSize = 10;
        int shardSize = -1;
        String orderKey = "_count";
        boolean orderAsc = false;
        String format = null;
        boolean assumeUnique = false;
        String include = null;
        int includeFlags = 0;
        String exclude = null;
        int excludeFlags = 0;
        String executionHint = null;
        long minDocCount = 1L;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("field".equals(currentFieldName)) {
                    field = parser.text();
                    continue;
                }
                if ("script".equals(currentFieldName)) {
                    script = parser.text();
                    continue;
                }
                if ("lang".equals(currentFieldName)) {
                    scriptLang = parser.text();
                    continue;
                }
                if ("value_type".equals(currentFieldName) || "valueType".equals(currentFieldName)) {
                    valueType = Terms.ValueType.resolveType(parser.text());
                    continue;
                }
                if ("format".equals(currentFieldName)) {
                    format = parser.text();
                    continue;
                }
                if ("include".equals(currentFieldName)) {
                    include = parser.text();
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    exclude = parser.text();
                    continue;
                }
                if ("execution_hint".equals(currentFieldName) || "executionHint".equals(currentFieldName)) {
                    executionHint = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("script_values_unique".equals(currentFieldName) || "scriptValuesUnique".equals(currentFieldName)) {
                    assumeUnique = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("size".equals(currentFieldName)) {
                    requiredSize = parser.intValue();
                    continue;
                }
                if ("shard_size".equals(currentFieldName) || "shardSize".equals(currentFieldName)) {
                    shardSize = parser.intValue();
                    continue;
                }
                if ("min_doc_count".equals(currentFieldName) || "minDocCount".equals(currentFieldName)) {
                    minDocCount = parser.intValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentFieldName)) {
                    scriptParams = parser.map();
                    continue;
                }
                if ("order".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            orderKey = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            String dir = parser.text();
                            if ("asc".equalsIgnoreCase(dir)) {
                                orderAsc = true;
                                continue;
                            }
                            if ("desc".equalsIgnoreCase(dir)) {
                                orderAsc = false;
                                continue;
                            }
                            throw new SearchParseException(context, "Unknown terms order direction [" + dir + "] in terms aggregation [" + aggregationName + "]");
                        }
                        throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " for [order] in [" + aggregationName + "].");
                    }
                    continue;
                }
                if ("include".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                include = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            includeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        includeFlags = parser.intValue();
                    }
                    continue;
                }
                if ("exclude".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("pattern".equals(currentFieldName)) {
                                exclude = parser.text();
                                continue;
                            }
                            if (!"flags".equals(currentFieldName)) continue;
                            excludeFlags = Regex.flagsFromString(parser.text());
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_NUMBER || !"flags".equals(currentFieldName)) continue;
                        excludeFlags = parser.intValue();
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        IncludeExclude includeExclude = null;
        if (include != null || exclude != null) {
            Pattern includePattern = include != null ? Pattern.compile(include, includeFlags) : null;
            Pattern excludePattern = exclude != null ? Pattern.compile(exclude, excludeFlags) : null;
            includeExclude = new IncludeExclude(includePattern, excludePattern);
        }
        InternalOrder order = TermsParser.resolveOrder(orderKey, orderAsc);
        SearchScript searchScript = null;
        if (script != null) {
            searchScript = context.scriptService().search(context.lookup(), scriptLang, script, scriptParams);
        }
        if (field == null) {
            Class<ValuesSource> valueSourceType = script == null ? ValuesSource.class : (valueType != null ? valueType.scriptValueType.getValuesSourceType() : BytesValuesSource.class);
            ValuesSourceConfig<ValuesSource> config2 = new ValuesSourceConfig<ValuesSource>(valueSourceType);
            if (valueType != null) {
                config2.scriptValueType(valueType.scriptValueType);
            }
            config2.script(searchScript);
            if (!assumeUnique) {
                config2.ensureUnique(true);
            }
            return new TermsAggregatorFactory(aggregationName, config2, order, requiredSize, shardSize, minDocCount, includeExclude, executionHint);
        }
        FieldMapper mapper = context.smartNameFieldMapper(field);
        if (mapper == null) {
            ValuesSourceConfig<BytesValuesSource> config3 = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
            config3.unmapped(true);
            return new TermsAggregatorFactory(aggregationName, config3, order, requiredSize, shardSize, minDocCount, includeExclude, executionHint);
        }
        Object indexFieldData = context.fieldData().getForField(mapper);
        if (mapper instanceof DateFieldMapper) {
            DateFieldMapper dateMapper = (DateFieldMapper)mapper;
            ValueFormatter.DateTime formatter = format == null ? new ValueFormatter.DateTime(dateMapper.dateTimeFormatter()) : new ValueFormatter.DateTime(format);
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class).formatter(formatter).parser(new ValueParser.DateMath(dateMapper.dateMathParser()));
        } else if (mapper instanceof IpFieldMapper) {
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class).formatter(ValueFormatter.IPv4).parser(ValueParser.IPv4);
        } else if (indexFieldData instanceof IndexNumericFieldData) {
            config = new ValuesSourceConfig<NumericValuesSource>(NumericValuesSource.class);
            if (format != null) {
                config.formatter(new ValueFormatter.Number.Pattern(format));
            }
        } else {
            config = new ValuesSourceConfig<BytesValuesSource>(BytesValuesSource.class);
            config.needsHashes(true);
        }
        config.script(searchScript);
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData));
        if (!assumeUnique) {
            config.ensureUnique(true);
        }
        return new TermsAggregatorFactory(aggregationName, config, order, requiredSize, shardSize, minDocCount, includeExclude, executionHint);
    }

    static InternalOrder resolveOrder(String key, boolean asc) {
        if ("_term".equals(key)) {
            return asc ? InternalOrder.TERM_ASC : InternalOrder.TERM_DESC;
        }
        if ("_count".equals(key)) {
            return asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC;
        }
        int i = key.indexOf(46);
        if (i < 0) {
            return new InternalOrder.Aggregation(key, asc);
        }
        return new InternalOrder.Aggregation(key.substring(0, i), key.substring(i + 1), asc);
    }
}

