/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListWriter;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.store.IndexOutput;

class SepSkipListWriter
extends MultiLevelSkipListWriter {
    private int[] lastSkipDoc;
    private int[] lastSkipPayloadLength;
    private long[] lastSkipPayloadPointer;
    private IntIndexOutput.Index[] docIndex;
    private IntIndexOutput.Index[] freqIndex;
    private IntIndexOutput.Index[] posIndex;
    private IntIndexOutput freqOutput;
    IntIndexOutput posOutput;
    IndexOutput payloadOutput;
    private int curDoc;
    private boolean curStorePayloads;
    private int curPayloadLength;
    private long curPayloadPointer;
    FieldInfo.IndexOptions indexOptions;

    SepSkipListWriter(int skipInterval, int numberOfSkipLevels, int docCount, IntIndexOutput freqOutput, IntIndexOutput docOutput, IntIndexOutput posOutput, IndexOutput payloadOutput) throws IOException {
        super(skipInterval, numberOfSkipLevels, docCount);
        this.freqOutput = freqOutput;
        this.posOutput = posOutput;
        this.payloadOutput = payloadOutput;
        this.lastSkipDoc = new int[numberOfSkipLevels];
        this.lastSkipPayloadLength = new int[numberOfSkipLevels];
        this.lastSkipPayloadPointer = new long[numberOfSkipLevels];
        this.freqIndex = new IntIndexOutput.Index[numberOfSkipLevels];
        this.docIndex = new IntIndexOutput.Index[numberOfSkipLevels];
        this.posIndex = new IntIndexOutput.Index[numberOfSkipLevels];
        for (int i = 0; i < numberOfSkipLevels; ++i) {
            if (freqOutput != null) {
                this.freqIndex[i] = freqOutput.index();
            }
            this.docIndex[i] = docOutput.index();
            if (posOutput == null) continue;
            this.posIndex[i] = posOutput.index();
        }
    }

    void setIndexOptions(FieldInfo.IndexOptions v) {
        this.indexOptions = v;
    }

    void setPosOutput(IntIndexOutput posOutput) throws IOException {
        this.posOutput = posOutput;
        for (int i = 0; i < this.numberOfSkipLevels; ++i) {
            this.posIndex[i] = posOutput.index();
        }
    }

    void setPayloadOutput(IndexOutput payloadOutput) {
        this.payloadOutput = payloadOutput;
    }

    void setSkipData(int doc, boolean storePayloads, int payloadLength) {
        this.curDoc = doc;
        this.curStorePayloads = storePayloads;
        this.curPayloadLength = payloadLength;
        if (this.payloadOutput != null) {
            this.curPayloadPointer = this.payloadOutput.getFilePointer();
        }
    }

    protected void resetSkip(IntIndexOutput.Index topDocIndex, IntIndexOutput.Index topFreqIndex, IntIndexOutput.Index topPosIndex) throws IOException {
        super.resetSkip();
        Arrays.fill(this.lastSkipDoc, 0);
        Arrays.fill(this.lastSkipPayloadLength, -1);
        for (int i = 0; i < this.numberOfSkipLevels; ++i) {
            this.docIndex[i].copyFrom(topDocIndex, true);
            if (this.freqOutput != null) {
                this.freqIndex[i].copyFrom(topFreqIndex, true);
            }
            if (this.posOutput == null) continue;
            this.posIndex[i].copyFrom(topPosIndex, true);
        }
        if (this.payloadOutput != null) {
            Arrays.fill(this.lastSkipPayloadPointer, this.payloadOutput.getFilePointer());
        }
    }

    protected void writeSkipData(int level, IndexOutput skipBuffer) throws IOException {
        assert (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !this.curStorePayloads);
        if (this.curStorePayloads) {
            int delta = this.curDoc - this.lastSkipDoc[level];
            if (this.curPayloadLength == this.lastSkipPayloadLength[level]) {
                skipBuffer.writeVInt(delta << 1);
            } else {
                skipBuffer.writeVInt(delta << 1 | 1);
                skipBuffer.writeVInt(this.curPayloadLength);
                this.lastSkipPayloadLength[level] = this.curPayloadLength;
            }
        } else {
            skipBuffer.writeVInt(this.curDoc - this.lastSkipDoc[level]);
        }
        if (this.indexOptions != FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqIndex[level].mark();
            this.freqIndex[level].write(skipBuffer, false);
        }
        this.docIndex[level].mark();
        this.docIndex[level].write(skipBuffer, false);
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
            this.posIndex[level].mark();
            this.posIndex[level].write(skipBuffer, false);
            if (this.curStorePayloads) {
                skipBuffer.writeVInt((int)(this.curPayloadPointer - this.lastSkipPayloadPointer[level]));
            }
        }
        this.lastSkipDoc[level] = this.curDoc;
        this.lastSkipPayloadPointer[level] = this.curPayloadPointer;
    }
}

