/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt;

import com.healthmarketscience.jackcess.crypt.PasswordCallback;
import com.healthmarketscience.jackcess.crypt.impl.JetCryptCodecHandler;
import com.healthmarketscience.jackcess.crypt.impl.MSISAMCryptCodecHandler;
import com.healthmarketscience.jackcess.crypt.impl.OfficeCryptCodecHandler;
import com.healthmarketscience.jackcess.impl.CodecHandler;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.impl.DefaultCodecProvider;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PageChannel;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;

public class CryptCodecProvider
implements CodecProvider,
PasswordCallback {
    private String _password;
    private Supplier<String> _callback;

    public CryptCodecProvider() {
        this(null, null);
    }

    public CryptCodecProvider(String password) {
        this(password, null);
    }

    public CryptCodecProvider(PasswordCallback callback) {
        this(null, callback);
    }

    public CryptCodecProvider(Supplier<String> callback) {
        this(null, callback);
    }

    protected CryptCodecProvider(String password, Supplier<String> callback) {
        this._password = password;
        this._callback = callback;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public CryptCodecProvider setPassword(String newPassword) {
        this._password = newPassword;
        return this;
    }

    public PasswordCallback getPasswordCallback() {
        return (PasswordCallback)this.getPasswordSupplier();
    }

    public Supplier<String> getPasswordSupplier() {
        return this._callback;
    }

    public CryptCodecProvider setPasswordCallback(PasswordCallback newCallback) {
        return this.setPasswordSupplier(newCallback);
    }

    public CryptCodecProvider setPasswordSupplier(Supplier<String> newCallback) {
        this._callback = newCallback;
        return this;
    }

    public CodecHandler createHandler(PageChannel channel, Charset charset) throws IOException {
        CryptCodecProvider callback = this.getPasswordSupplier();
        if (callback == null) {
            callback = this;
        }
        JetFormat format = channel.getFormat();
        switch (format.CODEC_TYPE) {
            case NONE: {
                return DefaultCodecProvider.DUMMY_HANDLER;
            }
            case JET: {
                return JetCryptCodecHandler.create(channel);
            }
            case MSISAM: {
                return MSISAMCryptCodecHandler.create(callback, channel, charset);
            }
            case OFFICE: {
                return OfficeCryptCodecHandler.create(callback, channel, charset);
            }
        }
        throw new RuntimeException("Unknown codec type " + format.CODEC_TYPE);
    }
}

