/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetFetchRequest
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentRequestSchema(ApiKeys.OFFSET_FETCH.id);
    private static String GROUP_ID_KEY_NAME = "group_id";
    private static String TOPICS_KEY_NAME = "topics";
    private static String TOPIC_KEY_NAME = "topic";
    private static String PARTITIONS_KEY_NAME = "partitions";
    private static String PARTITION_KEY_NAME = "partition";
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_CONSUMER_ID = "";
    private final String groupId;
    private final List<TopicPartition> partitions;

    public OffsetFetchRequest(String groupId, List<TopicPartition> partitions) {
        super(new Struct(curSchema));
        Map<String, List<Integer>> topicsData = CollectionUtils.groupDataByTopic(partitions);
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, List<Integer>> entries : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Integer partiitonId : entries.getValue()) {
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partiitonId);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        this.groupId = groupId;
        this.partitions = partitions;
    }

    public OffsetFetchRequest(Struct struct) {
        super(struct);
        this.partitions = new ArrayList<TopicPartition>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                this.partitions.add(new TopicPartition(topic, partition));
            }
        }
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
    }

    public String groupId() {
        return this.groupId;
    }

    public List<TopicPartition> partitions() {
        return this.partitions;
    }

    public static OffsetFetchRequest parse(ByteBuffer buffer) {
        return new OffsetFetchRequest((Struct)curSchema.read(buffer));
    }
}

