/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractControlRequest {
    private final LeaderAndIsrRequestData data;

    LeaderAndIsrRequest(LeaderAndIsrRequestData data, short version) {
        super(ApiKeys.LEADER_AND_ISR, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (this.version() >= 2) {
            for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
                for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState : topicState.partitionStates()) {
                    partitionState.setTopicName(topicState.topicName());
                }
            }
        }
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaderAndIsrResponseData responseData = new LeaderAndIsrResponseData();
        Errors error = Errors.forException(e);
        responseData.setErrorCode(error.code());
        if (this.version() < 5) {
            ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : this.partitionStates()) {
                partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(partition.topicName()).setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
            }
            responseData.setPartitionErrors(partitions);
        } else {
            for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
                ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>(topicState.partitionStates().size());
                for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : topicState.partitionStates()) {
                    partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
                }
                responseData.topics().add(new LeaderAndIsrResponseData.LeaderAndIsrTopicError().setTopicId(topicState.topicId()).setPartitionErrors(partitions));
            }
        }
        return new LeaderAndIsrResponse(responseData, this.version());
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public boolean isKRaftController() {
        return this.data.isKRaftController();
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    public Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates() {
        if (this.version() >= 2) {
            return () -> new FlattenedIterator(this.data.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return this.data.ungroupedPartitionStates();
    }

    public Map<String, Uuid> topicIds() {
        return this.data.topicStates().stream().collect(Collectors.toMap(LeaderAndIsrRequestData.LeaderAndIsrTopicState::topicName, LeaderAndIsrRequestData.LeaderAndIsrTopicState::topicId));
    }

    public List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> liveLeaders() {
        return Collections.unmodifiableList(this.data.liveLeaders());
    }

    @Override
    public LeaderAndIsrRequestData data() {
        return this.data;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(new LeaderAndIsrRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractControlRequest.Builder<LeaderAndIsrRequest> {
        private final List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates;
        private final Map<String, Uuid> topicIds;
        private final Collection<Node> liveLeaders;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, Collection<Node> liveLeaders) {
            this(version, controllerId, controllerEpoch, brokerEpoch, partitionStates, topicIds, liveLeaders, false);
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, Collection<Node> liveLeaders, boolean kraftController) {
            super(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch, kraftController);
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.liveLeaders = liveLeaders;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> leaders = this.liveLeaders.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            LeaderAndIsrRequestData data = new LeaderAndIsrRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveLeaders(leaders);
            if (version >= 7) {
                data.setIsKRaftController(this.kraftController);
            }
            if (version >= 2) {
                Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStatesMap = Builder.groupByTopic(this.partitionStates, this.topicIds);
                data.setTopicStates(new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            return new LeaderAndIsrRequest(data, version);
        }

        private static Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> groupByTopic(List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds) {
            HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStates = new HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : partitionStates) {
                LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t -> new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName(partition.topicName()).setTopicId(topicIds.getOrDefault(partition.topicName(), Uuid.ZERO_UUID)));
                topicState.partitionStates().add(partition);
            }
            return topicStates;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", topicIds=").append(this.topicIds).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

