/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.lang.reflect.Constructor;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.SimpleStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;

public class BlockObjectStore
extends SimpleStore {
    Class objectClass;
    Constructor constructor;
    int storageSize;
    int blockSize;

    public BlockObjectStore(DataFileCache dataFileCache, TableSpaceManager tableSpaceManager, Class clazz, int n, int n2) {
        this.cache = dataFileCache;
        this.spaceManager = tableSpaceManager;
        this.objectClass = clazz;
        this.blockSize = n2;
        this.storageSize = n;
        try {
            this.constructor = clazz.getConstructor(Integer.TYPE);
        }
        catch (Exception exception) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
    }

    @Override
    public CachedObject get(long l) {
        try {
            return this.cache.get(l, this.storageSize, this, false);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        try {
            return this.cache.get(cachedObject, (PersistentStore)this, bl);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        try {
            return this.cache.get(l, this.storageSize, this, bl);
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        int n = cachedObject.getRealSize(this.cache.rowOut);
        if ((n = this.cache.rowOut.getStorageSize(n)) > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        cachedObject.setStorageSize(this.storageSize);
        long l = this.spaceManager.getFilePosition(n, true);
        cachedObject.setPos(l);
        this.cache.add(cachedObject);
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        CachedObject cachedObject = this.getNewInstance(this.blockSize);
        cachedObject.read(rowInputInterface);
        int n = cachedObject.getRealSize(this.cache.rowOut);
        n = this.cache.rowOut.getStorageSize(n);
        if (n > this.storageSize) {
            throw Error.runtimeError(201, "BlockObjectStore");
        }
        cachedObject.setStorageSize(this.storageSize);
        return cachedObject;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        try {
            CachedObject cachedObject = (CachedObject)this.constructor.newInstance(n);
            return cachedObject;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

