/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.NoSuchElementException;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.tika.parser.microsoft.AbstractListManager;

public class ListManager
extends AbstractListManager {
    private final ListTables listTables;

    public ListManager(HWPFDocument document) {
        this.listTables = document.getListTables();
    }

    public String getFormattedNumber(Paragraph paragraph) {
        if (paragraph == null) {
            throw new IllegalArgumentException("Given paragraph cannot be null.");
        }
        if (!paragraph.isInList()) {
            throw new IllegalArgumentException("Can only process list paragraphs.");
        }
        int currAbNumId = -1;
        try {
            currAbNumId = paragraph.getList().getLsid();
        }
        catch (NoSuchElementException e) {
            return "";
        }
        catch (IllegalArgumentException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
        int currNumId = paragraph.getIlfo();
        AbstractListManager.ParagraphLevelCounter lc = (AbstractListManager.ParagraphLevelCounter)this.listLevelMap.get(currAbNumId);
        AbstractListManager.LevelTuple[] overrideTuples = (AbstractListManager.LevelTuple[])this.overrideTupleMap.get(currNumId);
        if (lc == null) {
            ListData listData = this.listTables.getListData(paragraph.getList().getLsid());
            if (listData == null) {
                return "";
            }
            AbstractListManager.LevelTuple[] levelTuples = new AbstractListManager.LevelTuple[listData.getLevels().length];
            for (int i = 0; i < listData.getLevels().length; ++i) {
                levelTuples[i] = this.buildTuple(i, listData.getLevels()[i]);
            }
            lc = new AbstractListManager.ParagraphLevelCounter(levelTuples);
        }
        if (overrideTuples == null) {
            overrideTuples = this.buildOverrideTuples(paragraph, lc.getNumberOfLevels());
        }
        String formattedString = lc.incrementLevel(paragraph.getIlvl(), overrideTuples);
        this.listLevelMap.put(currAbNumId, lc);
        this.overrideTupleMap.put(currNumId, overrideTuples);
        return formattedString;
    }

    private AbstractListManager.LevelTuple buildTuple(int i, ListLevel listLevel) {
        boolean isLegal = false;
        int start = 1;
        int restart = -1;
        String lvlText = "%" + i + ".";
        String numFmt = "decimal";
        start = listLevel.getStartAt();
        restart = listLevel.getRestart();
        isLegal = listLevel.isLegalNumbering();
        numFmt = this.convertToNewNumFormat(listLevel.getNumberFormat());
        lvlText = this.convertToNewNumberText(listLevel.getNumberText(), listLevel.getLevelNumberingPlaceholderOffsets());
        return new AbstractListManager.LevelTuple(start, restart, lvlText, numFmt, isLegal);
    }

    private AbstractListManager.LevelTuple[] buildOverrideTuples(Paragraph par, int length) {
        if (this.listTables.getLfoData(par.getIlfo()).getRgLfoLvl().length == 0) {
            return null;
        }
        ListFormatOverrideLevel overrideLevel = this.listTables.getLfoData(par.getIlfo()).getRgLfoLvl()[0];
        if (overrideLevel == null) {
            return null;
        }
        AbstractListManager.LevelTuple[] levelTuples = new AbstractListManager.LevelTuple[length];
        ListLevel listLevel = overrideLevel.getLevel();
        if (listLevel == null) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            levelTuples[i] = this.buildTuple(i, listLevel);
        }
        return levelTuples;
    }

    private String convertToNewNumberText(String numberText, byte[] numberOffsets) {
        int offset;
        StringBuilder sb = new StringBuilder();
        int last = 0;
        for (int i = 0; i < numberOffsets.length && (offset = numberOffsets[i]) != 0 && offset - 1 >= last && offset <= numberText.length(); ++i) {
            sb.append(numberText.substring(last, offset - 1));
            int lvlNum = numberText.charAt(offset - 1) + '\u0001';
            sb.append("%" + lvlNum);
            last = offset;
        }
        if (last < numberText.length()) {
            sb.append(numberText.substring(last));
        }
        return sb.toString();
    }

    private String convertToNewNumFormat(int numberFormat) {
        switch (numberFormat) {
            case -1: {
                return "none";
            }
            case 0: {
                return "decimal";
            }
            case 1: {
                return "upperRoman";
            }
            case 2: {
                return "lowerRoman";
            }
            case 3: {
                return "upperLetter";
            }
            case 4: {
                return "lowerLetter";
            }
            case 5: {
                return "ordinal";
            }
            case 22: {
                return "decimalZero";
            }
            case 23: {
                return "bullet";
            }
            case 47: {
                return "none";
            }
        }
        return "decimal";
    }
}

