/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class HostFile {
    public static final String HOSTS = "testng.hosts";
    public static final String STRATEGY = "testng.strategy";
    public static final String VERBOSE = "testng.verbose";
    public static final String STRATEGY_TEST = "test";
    public static final String STRATEGY_SUITE = "suite";
    private Properties m_properties = new Properties();

    public HostFile(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(new File(fileName));
            this.m_properties.load(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getHosts() {
        String hostLine = this.m_properties.getProperty(HOSTS);
        return hostLine.split(" ");
    }

    public boolean isStrategyTest() {
        String strategy = this.m_properties.getProperty(STRATEGY, STRATEGY_SUITE);
        boolean result = false;
        if (STRATEGY_TEST.equalsIgnoreCase(strategy)) {
            result = true;
        }
        return result;
    }

    public int getVerbose() {
        String v = this.m_properties.getProperty(VERBOSE, "1");
        return Integer.parseInt(v);
    }
}

