/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.inject.Provider;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public abstract class AbstractLifecycleProvider
implements Provider<Lifecycle> {
    private final Lifecycle lifecycle;

    protected AbstractLifecycleProvider(String id, String[] phases, String[] pluginBindings) {
        LinkedHashMap<String, LifecyclePhase> defaultBindings = null;
        if (pluginBindings != null) {
            int len = pluginBindings.length;
            if (len < 2 || len % 2 != 0) {
                throw new IllegalArgumentException("Plugin bindings must have more than 0, even count of elements");
            }
            defaultBindings = new LinkedHashMap<String, LifecyclePhase>(len / 2);
            for (int i = 0; i < len; i += 2) {
                defaultBindings.put(pluginBindings[i], new LifecyclePhase(pluginBindings[i + 1]));
            }
        }
        this.lifecycle = new Lifecycle(id, Collections.unmodifiableList(Arrays.asList(phases)), defaultBindings == null ? null : Collections.unmodifiableMap(defaultBindings));
    }

    public Lifecycle get() {
        return this.lifecycle;
    }
}

