/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class DeploymentRepository
extends Repository
implements Serializable,
InputLocationTracker {
    final boolean uniqueVersion;

    protected DeploymentRepository(Builder builder) {
        super(builder);
        this.uniqueVersion = builder.uniqueVersion != null ? builder.uniqueVersion : (builder.base != null ? builder.base.uniqueVersion : true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DeploymentRepository)) {
            return false;
        }
        DeploymentRepository that = (DeploymentRepository)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean isUniqueVersion() {
        return this.uniqueVersion;
    }

    @Override
    @Nonnull
    public Builder with() {
        return DeploymentRepository.newBuilder(this);
    }

    @Override
    @Nonnull
    public DeploymentRepository withId(String id) {
        return DeploymentRepository.newBuilder(this, true).id(id).build();
    }

    @Override
    @Nonnull
    public DeploymentRepository withName(String name) {
        return DeploymentRepository.newBuilder(this, true).name(name).build();
    }

    @Override
    @Nonnull
    public DeploymentRepository withUrl(String url) {
        return DeploymentRepository.newBuilder(this, true).url(url).build();
    }

    @Override
    @Nonnull
    public DeploymentRepository withLayout(String layout) {
        return DeploymentRepository.newBuilder(this, true).layout(layout).build();
    }

    @Override
    @Nonnull
    public DeploymentRepository withReleases(RepositoryPolicy releases) {
        return DeploymentRepository.newBuilder(this, true).releases(releases).build();
    }

    @Override
    @Nonnull
    public DeploymentRepository withSnapshots(RepositoryPolicy snapshots) {
        return DeploymentRepository.newBuilder(this, true).snapshots(snapshots).build();
    }

    @Nonnull
    public DeploymentRepository withUniqueVersion(boolean uniqueVersion) {
        return DeploymentRepository.newBuilder(this, true).uniqueVersion(uniqueVersion).build();
    }

    @Nonnull
    public static DeploymentRepository newInstance() {
        return DeploymentRepository.newInstance(true);
    }

    @Nonnull
    public static DeploymentRepository newInstance(boolean withDefaults) {
        return DeploymentRepository.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return DeploymentRepository.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(DeploymentRepository from) {
        return DeploymentRepository.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(DeploymentRepository from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends Repository.Builder {
        DeploymentRepository base;
        Boolean uniqueVersion;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.uniqueVersion = true;
            }
        }

        protected Builder(DeploymentRepository base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.uniqueVersion = base.uniqueVersion;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        @Override
        @Nonnull
        public Builder releases(RepositoryPolicy releases) {
            this.releases = releases;
            return this;
        }

        @Override
        @Nonnull
        public Builder snapshots(RepositoryPolicy snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Nonnull
        public Builder uniqueVersion(boolean uniqueVersion) {
            this.uniqueVersion = uniqueVersion;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public DeploymentRepository build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.layout != null && this.layout != this.base.layout || this.releases != null && this.releases != this.base.releases || this.snapshots != null && this.snapshots != this.base.snapshots || this.uniqueVersion != null && this.uniqueVersion != this.base.uniqueVersion)) {
                return this.base;
            }
            return new DeploymentRepository(this);
        }
    }
}

