/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.apache.myfaces.shared.resource.ContractResource;
import org.apache.myfaces.shared.resource.ResourceELUtils;
import org.apache.myfaces.shared.resource.ResourceImpl;
import org.apache.myfaces.shared.util.io.DynamicPushbackInputStream;

public class ValueExpressionFilterInputStream
extends InputStream {
    private PushbackInputStream delegate;
    private String libraryName;
    private String resourceName;
    private String contractName;

    public ValueExpressionFilterInputStream(InputStream in, String libraryName, String resourceName) {
        this.delegate = new DynamicPushbackInputStream(in, 300);
        this.libraryName = libraryName;
        this.resourceName = resourceName;
        this.contractName = null;
    }

    public ValueExpressionFilterInputStream(InputStream in, Resource resource) {
        this.delegate = new DynamicPushbackInputStream(in, 300);
        this.libraryName = resource.getLibraryName();
        this.resourceName = resource.getResourceName();
        this.contractName = resource instanceof ContractResource ? ((ContractResource)((Object)resource)).getContractName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int c1 = this.delegate.read();
        if (c1 == -1) {
            return -1;
        }
        if ((char)c1 == '#') {
            int c2 = this.delegate.read();
            if (c2 == -1) {
                return -1;
            }
            if ((char)c2 == '{') {
                ArrayList<Integer> expressionList = new ArrayList<Integer>();
                int c3 = this.delegate.read();
                while (c3 != -1 && (char)c3 != '}') {
                    expressionList.add(c3);
                    c3 = this.delegate.read();
                }
                if (c3 == -1) {
                    for (int i = 0; i < expressionList.size(); ++i) {
                        this.delegate.unread((Integer)expressionList.get(i));
                    }
                    this.delegate.unread(c2);
                    return c1;
                }
                FacesContext context = FacesContext.getCurrentInstance();
                ELContext elContext = context.getELContext();
                try {
                    if (this.libraryName != null) {
                        ResourceELUtils.saveResourceLibraryForResolver(context, this.libraryName);
                    }
                    if (this.contractName != null) {
                        ResourceELUtils.saveResourceContractForResolver(context, this.contractName);
                    }
                    ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + this.convertToExpression(expressionList) + "}", String.class);
                    String value = (String)ve.getValue(elContext);
                    for (int i = value.length() - 1; i >= 0; --i) {
                        this.delegate.unread(value.charAt(i));
                    }
                }
                catch (ELException e) {
                    ExceptionQueuedEventContext equecontext = new ExceptionQueuedEventContext(context, e, null);
                    context.getApplication().publishEvent(context, ExceptionQueuedEvent.class, equecontext);
                    Logger log = Logger.getLogger(ResourceImpl.class.getName());
                    if (log.isLoggable(Level.SEVERE)) {
                        log.severe("Cannot evaluate EL expression " + this.convertToExpression(expressionList) + " in resource " + (this.libraryName == null ? "" : this.libraryName) + ":" + (this.resourceName == null ? "" : this.resourceName));
                    }
                    this.delegate.unread(c3);
                    for (int i = expressionList.size() - 1; i >= 0; --i) {
                        this.delegate.unread((Integer)expressionList.get(i));
                    }
                    this.delegate.unread(c2);
                    int n = c1;
                    return n;
                }
                finally {
                    if (this.libraryName != null) {
                        ResourceELUtils.removeResourceLibraryForResolver(context);
                    }
                    if (this.contractName != null) {
                        ResourceELUtils.removeResourceContractForResolver(context);
                    }
                }
                return this.delegate.read();
            }
            this.delegate.unread(c2);
            return c1;
        }
        return c1;
    }

    private String convertToExpression(List<Integer> expressionList) {
        char[] exprArray = new char[expressionList.size()];
        for (int i = 0; i < expressionList.size(); ++i) {
            exprArray[i] = (char)expressionList.get(i).intValue();
        }
        return String.valueOf(exprArray);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

