/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentPropertyDescriptor;
import org.apache.myfaces.view.facelets.tag.composite.CompositeTagAttributeUtils;
import org.apache.myfaces.view.facelets.tag.composite.InterfaceDescriptorCreator;

public class AttributeHandler
extends TagHandler
implements InterfaceDescriptorCreator {
    private static final Logger log = Logger.getLogger(AttributeHandler.class.getName());
    private static final String[] STANDARD_ATTRIBUTES_SORTED = new String[]{"default", "displayName", "expert", "hidden", "method-signature", "name", "preferred", "required", "shortDescription", "targetAttributeName", "targets", "type"};
    private final TagAttribute _name = this.getRequiredAttribute("name");
    private final TagAttribute _targets = this.getAttribute("targets");
    private final TagAttribute _default = this.getAttribute("default");
    private final TagAttribute _displayName = this.getAttribute("displayName");
    private final TagAttribute _required = this.getAttribute("required");
    private final TagAttribute _preferred = this.getAttribute("preferred");
    private final TagAttribute _expert = this.getAttribute("expert");
    private final TagAttribute _shortDescription = this.getAttribute("shortDescription");
    private final TagAttribute _methodSignature = this.getAttribute("method-signature");
    private final TagAttribute _type = this.getAttribute("type");
    protected final TagAttribute _hidden = this.getAttribute("hidden");
    private final TagAttribute _targetAttributeName = this.getAttribute("targetAttributeName");
    private boolean _cacheable;
    private PropertyDescriptor _propertyDescriptor;

    public AttributeHandler(TagConfig config) {
        super(config);
        boolean development = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
        if (this._name.isLiteral() && (!development || this._areDevelopmentAttributesLiteral())) {
            this._cacheable = true;
            if (this._targets == null && this._default == null && this._required == null && this._methodSignature == null && this._type == null && this._targetAttributeName == null && !CompositeTagAttributeUtils.containsUnspecifiedAttributes(this.tag, STANDARD_ATTRIBUTES_SORTED)) {
                this._propertyDescriptor = this._createPropertyDescriptor(development);
            }
        } else {
            this._cacheable = false;
        }
    }

    private boolean _areDevelopmentAttributesLiteral() {
        return CompositeTagAttributeUtils.areAttributesLiteral(this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIComponent compositeBaseParent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
        CompositeComponentBeanInfo beanInfo = (CompositeComponentBeanInfo)compositeBaseParent.getAttributes().get("javax.faces.component.BEANINFO_KEY");
        if (beanInfo == null) {
            if (log.isLoggable(Level.SEVERE)) {
                log.severe("Cannot find composite bean descriptor UIComponent.BEANINFO_KEY ");
            }
            return;
        }
        List<PropertyDescriptor> attributeList = beanInfo.getPropertyDescriptorsList();
        if (this.isCacheable()) {
            if (this._propertyDescriptor == null) {
                this._propertyDescriptor = this._createPropertyDescriptor(ctx);
            }
            attributeList.add(this._propertyDescriptor);
        } else {
            PropertyDescriptor attribute = this._createPropertyDescriptor(ctx);
            attributeList.add(attribute);
        }
    }

    private PropertyDescriptor _createPropertyDescriptor(boolean development) {
        try {
            CompositeComponentPropertyDescriptor attributeDescriptor = new CompositeComponentPropertyDescriptor(this._name.getValue());
            if (development) {
                CompositeTagAttributeUtils.addDevelopmentAttributesLiteral(attributeDescriptor, this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
            }
            return attributeDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for attribute ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    private PropertyDescriptor _createPropertyDescriptor(FaceletContext ctx) throws TagException, IOException {
        try {
            CompositeComponentPropertyDescriptor attributeDescriptor = new CompositeComponentPropertyDescriptor(this._name.getValue(ctx));
            if (this._targets != null) {
                attributeDescriptor.setValue("targets", this._targets.getValueExpression(ctx, String.class));
            }
            if (this._default != null) {
                if (this._type != null) {
                    String type = this._type.getValue(ctx);
                    Class clazz = String.class;
                    if (type != null) {
                        try {
                            clazz = ClassUtils.javaDefaultTypeToClass(type);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (this._default.isLiteral()) {
                        attributeDescriptor.setValue("default", this._default.getObject(ctx, clazz));
                    } else {
                        attributeDescriptor.setValue("default", this._default.getValueExpression(ctx, clazz));
                    }
                } else {
                    attributeDescriptor.setValue("default", this._default.getValueExpression(ctx, String.class));
                }
            }
            if (this._required != null) {
                attributeDescriptor.setValue("required", this._required.getValueExpression(ctx, Boolean.class));
            }
            if (this._methodSignature != null) {
                attributeDescriptor.setValue("method-signature", this._methodSignature.getValueExpression(ctx, String.class));
            }
            if (this._type != null) {
                attributeDescriptor.setValue("type", this._type.getValueExpression(ctx, String.class));
            }
            if (this._targetAttributeName != null) {
                attributeDescriptor.setValue("targetAttributeName", this._targetAttributeName.getValueExpression(ctx, String.class));
            }
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                CompositeTagAttributeUtils.addDevelopmentAttributes(attributeDescriptor, ctx, this._displayName, this._shortDescription, this._expert, this._hidden, this._preferred);
            }
            CompositeTagAttributeUtils.addUnspecifiedAttributes(attributeDescriptor, this.tag, STANDARD_ATTRIBUTES_SORTED, ctx);
            return attributeDescriptor;
        }
        catch (IntrospectionException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, "Cannot create PropertyDescriptor for attribute ", e);
            }
            throw new TagException(this.tag, (Throwable)e);
        }
    }

    @Override
    public boolean isCacheable() {
        return this._cacheable;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this._cacheable = cacheable;
    }
}

