/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;

class PhaseListenerManager {
    private Lifecycle lifecycle;
    private FacesContext facesContext;
    private PhaseListener[] phaseListeners;
    private Map<PhaseId, boolean[]> listenerSuccessMap;

    PhaseListenerManager(Lifecycle lifecycle, FacesContext facesContext, PhaseListener[] phaseListeners) {
        this.lifecycle = lifecycle;
        this.facesContext = facesContext;
        this.phaseListeners = phaseListeners;
        this.listenerSuccessMap = new HashMap<PhaseId, boolean[]>(PhaseId.VALUES.size(), 1.0f);
    }

    private boolean isListenerForThisPhase(PhaseListener phaseListener, PhaseId phaseId) {
        int listenerPhaseId = phaseListener.getPhaseId().getOrdinal();
        return listenerPhaseId == PhaseId.ANY_PHASE.getOrdinal() || listenerPhaseId == phaseId.getOrdinal();
    }

    void informPhaseListenersBefore(PhaseId phaseId) {
        boolean[] beforePhaseSuccess = new boolean[this.phaseListeners.length];
        this.listenerSuccessMap.put(phaseId, beforePhaseSuccess);
        PhaseEvent event = new PhaseEvent(this.facesContext, phaseId, this.lifecycle);
        for (int i = 0; i < this.phaseListeners.length; ++i) {
            PhaseListener phaseListener = this.phaseListeners[i];
            if (!this.isListenerForThisPhase(phaseListener, phaseId)) continue;
            try {
                phaseListener.beforePhase(event);
                beforePhaseSuccess[i] = true;
                continue;
            }
            catch (Throwable e) {
                beforePhaseSuccess[i] = false;
                this.publishException(e, phaseId, ExceptionQueuedEventContext.IN_BEFORE_PHASE_KEY);
                return;
            }
        }
    }

    void informPhaseListenersAfter(PhaseId phaseId) {
        boolean[] beforePhaseSuccess = this.listenerSuccessMap.get(phaseId);
        if (beforePhaseSuccess == null) {
            return;
        }
        PhaseEvent event = null;
        for (int i = this.phaseListeners.length - 1; i >= 0; --i) {
            PhaseListener phaseListener = this.phaseListeners[i];
            if (!this.isListenerForThisPhase(phaseListener, phaseId) || !beforePhaseSuccess[i]) continue;
            if (event == null) {
                event = new PhaseEvent(this.facesContext, phaseId, this.lifecycle);
            }
            try {
                phaseListener.afterPhase(event);
                continue;
            }
            catch (Throwable e) {
                this.publishException(e, phaseId, ExceptionQueuedEventContext.IN_AFTER_PHASE_KEY);
            }
        }
    }

    private void publishException(Throwable e, PhaseId phaseId, String key) {
        ExceptionQueuedEventContext context = new ExceptionQueuedEventContext(this.facesContext, e, null, phaseId);
        context.getAttributes().put(key, Boolean.TRUE);
        this.facesContext.getApplication().publishEvent(this.facesContext, ExceptionQueuedEvent.class, (Object)context);
    }
}

