/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.MethodExpressionActionListener;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.validator.MethodExpressionValidator;

public class UIComponentELTagUtils {
    private static final Logger log = Logger.getLogger(UIComponentELTagUtils.class.getName());

    private UIComponentELTagUtils() {
    }

    public static void setIntegerProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setIntegerProperty(component, propName, value, null);
    }

    public static void setIntegerProperty(UIComponent component, String propName, ValueExpression value, Integer defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component.getAttributes().put(propName, Integer.valueOf(value.getExpressionString()));
            } else {
                component.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setLongProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setLongProperty(component, propName, value, null);
    }

    public static void setLongProperty(UIComponent component, String propName, ValueExpression value, Long defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component.getAttributes().put(propName, Long.valueOf(value.getExpressionString()));
            } else {
                component.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setStringProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setStringProperty(component, propName, value, null);
    }

    public static void setStringProperty(UIComponent component, String propName, ValueExpression value, String defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component.getAttributes().put(propName, value.getExpressionString());
            } else {
                component.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setBooleanProperty(UIComponent component, String propName, ValueExpression value) {
        UIComponentELTagUtils.setBooleanProperty(component, propName, value, null);
    }

    public static void setBooleanProperty(UIComponent component, String propName, ValueExpression value, Boolean defaultValue) {
        if (value != null) {
            if (value.isLiteralText()) {
                component.getAttributes().put(propName, Boolean.valueOf(value.getExpressionString()));
            } else {
                component.setValueExpression(propName, value);
            }
        } else if (defaultValue != null) {
            component.getAttributes().put(propName, defaultValue);
        }
    }

    public static void setValueProperty(FacesContext context, UIComponent component, ValueExpression value) {
        if (value != null) {
            if (!value.isLiteralText()) {
                component.setValueExpression("value", value);
            } else if (component instanceof UICommand) {
                ((UICommand)component).setValue(value.getExpressionString());
            } else if (component instanceof UIParameter) {
                ((UIParameter)component).setValue(value.getExpressionString());
            } else if (component instanceof UISelectBoolean) {
                ((UISelectBoolean)component).setValue(Boolean.valueOf(value.getExpressionString()));
            } else if (component instanceof UIGraphic) {
                ((UIGraphic)component).setValue(value.getExpressionString());
            } else if (component instanceof ValueHolder) {
                ((ValueHolder)((Object)component)).setValue(value.getExpressionString());
            } else {
                log.severe("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value.");
            }
        }
    }

    public static void setConverterProperty(FacesContext context, UIComponent component, ValueExpression value) {
        if (value != null) {
            if (component instanceof ValueHolder) {
                if (value.isLiteralText()) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value.getExpressionString());
                    ((ValueHolder)((Object)component)).setConverter(converter);
                } else {
                    component.setValueExpression("converter", value);
                }
            } else {
                log.severe("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value.");
            }
        }
    }

    public static void addValidatorProperty(FacesContext context, UIComponent component, MethodExpression validator) {
        if (validator != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            ((EditableValueHolder)((Object)component)).addValidator(new MethodExpressionValidator(validator));
        }
    }

    public static void setValueBinding(FacesContext context, UIComponent component, String propName, ValueExpression value) {
        if (value != null) {
            if (!value.isLiteralText()) {
                component.setValueExpression(propName, value);
            } else {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " attribute " + propName + " must be a value reference, was " + value);
            }
        }
    }

    public static void setActionProperty(FacesContext context, UIComponent component, MethodExpression action) {
        if (action != null) {
            if (!(component instanceof ActionSource2)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource2");
            }
            ((ActionSource2)((Object)component)).setActionExpression(action);
        }
    }

    public static void addActionListenerProperty(FacesContext context, UIComponent component, MethodExpression actionListener) {
        if (actionListener != null) {
            if (!(component instanceof ActionSource2)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource");
            }
            ((ActionSource2)((Object)component)).addActionListener(new MethodExpressionActionListener(actionListener));
        }
    }

    public static void addValueChangedListenerProperty(FacesContext context, UIComponent component, MethodExpression valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            ((EditableValueHolder)((Object)component)).addValueChangeListener(new MethodExpressionValueChangeListener(valueChangedListener));
        }
    }

    public static Object evaluateValueExpression(ELContext elContext, ValueExpression valueExpression) {
        return valueExpression.isLiteralText() ? valueExpression.getExpressionString() : valueExpression.getValue(elContext);
    }

    public static Boolean getBooleanValue(ELContext elContext, ValueExpression valueExpression) {
        if (valueExpression.isLiteralText()) {
            return Boolean.valueOf(valueExpression.getExpressionString());
        }
        return (Boolean)valueExpression.getValue(elContext);
    }

    public static Integer getIntegerValue(ELContext elContext, ValueExpression valueExpression) {
        if (valueExpression.isLiteralText()) {
            return Integer.valueOf(valueExpression.getExpressionString());
        }
        return (Integer)valueExpression.getValue(elContext);
    }
}

