/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PostRenderViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.shared.config.MyfacesConfig;

class RenderResponseExecutor
extends PhaseExecutor {
    private static final Logger log = Logger.getLogger(RenderResponseExecutor.class.getName());
    private MyfacesConfig _myfacesConfig;

    RenderResponseExecutor() {
    }

    @Override
    public boolean execute(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        int loops = 0;
        int maxLoops = 15;
        if (facesContext.getViewRoot() == null) {
            throw new ViewNotFoundException("A view is required to execute " + facesContext.getCurrentPhaseId());
        }
        this.forceSessionCreation(facesContext);
        try {
            UIViewRoot root;
            boolean isNotSameRoot;
            String viewId;
            String newViewId;
            do {
                UIViewRoot previousRoot = root = facesContext.getViewRoot();
                viewId = root.getViewId();
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, viewId);
                if (vdl != null) {
                    vdl.buildView(facesContext, root);
                }
                application.publishEvent(facesContext, PreRenderViewEvent.class, root);
                if (facesContext.getResponseComplete()) {
                    return false;
                }
                root = facesContext.getViewRoot();
                newViewId = root.getViewId();
                boolean bl = isNotSameRoot = !(newViewId == null ? newViewId == viewId : newViewId.equals(viewId)) || !previousRoot.equals(root);
            } while (newViewId == null && viewId != null || newViewId != null && (!newViewId.equals(viewId) || isNotSameRoot) && ++loops < maxLoops);
            if (loops == maxLoops) {
                Level level;
                boolean production = facesContext.isProjectStage(ProjectStage.Production);
                Level level2 = level = production ? Level.FINE : Level.WARNING;
                if (log.isLoggable(level)) {
                    log.log(level, "Cicle over buildView-PreRenderViewEvent on RENDER_RESPONSE phase reaches maximal limit, please check listeners for infinite recursion.");
                }
            }
            viewHandler.renderView(facesContext, root);
            application.publishEvent(facesContext, PostRenderViewEvent.class, root);
            List<FacesMessage> messageList = facesContext.getMessageList();
            if (!messageList.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                boolean shouldLog = false;
                int size = messageList.size();
                for (int i = 0; i < size; ++i) {
                    FacesMessage message = messageList.get(i);
                    if (message.isRendered()) continue;
                    builder.append("\n- ");
                    builder.append(message.getDetail());
                    shouldLog = true;
                }
                if (shouldLog) {
                    log.log(Level.WARNING, "There are some unhandled FacesMessages, this means not every FacesMessage had a chance to be rendered.\nThese unhandled FacesMessages are: " + builder.toString());
                }
            }
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void forceSessionCreation(FacesContext context) {
        if (context.getExternalContext().getSession(false) == null) {
            if (this._myfacesConfig == null) {
                this._myfacesConfig = MyfacesConfig.getCurrentInstance(context.getExternalContext());
            }
            if (this._myfacesConfig.isAlwaysForceSessionCreation() || !context.getViewRoot().isTransient() && !context.getApplication().getStateManager().isSavingStateInClient(context)) {
                context.getExternalContext().getSession(true);
            }
        }
    }
}

