/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.Advanced;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfiguredValueDescriptor;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfiguredValueResolver;
import org.apache.myfaces.extensions.cdi.core.api.tools.InvocationOrderComparator;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;
import org.apache.myfaces.extensions.cdi.core.impl.provider.DefaultServiceProvider;
import org.apache.myfaces.extensions.cdi.core.impl.util.ArtifactCacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class ConfiguredArtifactUtils {
    private static Map<ClassLoader, Map<ArtifactCacheKey<String>, Set<Serializable>>> apiToImplCache = new ConcurrentHashMap<ClassLoader, Map<ArtifactCacheKey<String>, Set<Serializable>>>();
    private static Map<ClassLoader, Map<String, Set<String>>> configuredValueCache = new ConcurrentHashMap<ClassLoader, Map<String, Set<String>>>();

    protected ConfiguredArtifactUtils() {
    }

    protected void reset() {
        apiToImplCache.clear();
        configuredValueCache.clear();
    }

    static <T extends Serializable> List<T> getCachedArtifact(String key, Class<T> targetClass) {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        if (String.class.isAssignableFrom(targetClass)) {
            Map<String, Set<String>> cachedValueMap = configuredValueCache.get(classLoader);
            if (cachedValueMap != null) {
                ArrayList<String> result = new ArrayList<String>();
                Set<String> cachedValues = cachedValueMap.get(key);
                if (cachedValues != null && !cachedValues.isEmpty()) {
                    result.addAll(cachedValues);
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return null;
        }
        Map<ArtifactCacheKey<String>, Set<Serializable>> artifactCache = apiToImplCache.get(classLoader);
        if (artifactCache == null) {
            return null;
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        Set<Serializable> cachedInstances = artifactCache.get(new ArtifactCacheKey<String>(key, targetClass));
        if (cachedInstances == null) {
            return null;
        }
        for (Serializable currentClass : cachedInstances) {
            result.add(currentClass);
        }
        Collections.sort(result, new InvocationOrderComparator());
        return result;
    }

    static <T> List<T> resolveFromEnvironment(final String key, final Class<T> targetType, boolean supportOfMultipleArtifacts, T defaultImplementation) {
        ArrayList results = new ArrayList();
        List<ConfiguredValueResolver> resolvers = ConfiguredArtifactUtils.getConfiguredValueResolvers();
        for (ConfiguredValueResolver configuredValueResolver : resolvers) {
            List resolverResult = configuredValueResolver.resolveInstances(new ConfiguredValueDescriptor<String, T>(){

                public String getKey() {
                    return key;
                }

                public Class<T> getTargetType() {
                    return targetType;
                }
            });
            if (resolverResult == null) continue;
            for (Object currentResult : resolverResult) {
                block5: {
                    Field defaultInjectionPoint;
                    if (defaultImplementation != null && currentResult.getClass().isAnnotationPresent(Advanced.class) && (defaultInjectionPoint = ConfiguredArtifactUtils.findInjectionPointForDefaultImplementation(currentResult, targetType)) != null) {
                        try {
                            defaultInjectionPoint.setAccessible(true);
                            defaultInjectionPoint.set(currentResult, defaultImplementation);
                        }
                        catch (Exception e) {
                            Logger logger = Logger.getLogger(ConfiguredArtifactUtils.class.getName());
                            if (!logger.isLoggable(Level.SEVERE)) break block5;
                            logger.log(Level.SEVERE, currentResult.getClass().getName() + " is annotated with" + Advanced.class.getName() + " but it wasn't possible to inject the default" + " implementation into " + defaultInjectionPoint.getName() + "." + " Please contact the community or remove the annotation.", e);
                        }
                    }
                }
                results.add(currentResult);
            }
        }
        ConfiguredArtifactUtils.checkArtifacts(targetType, results, supportOfMultipleArtifacts);
        return results;
    }

    private static <T> Field findInjectionPointForDefaultImplementation(T instance, Class<T> targetType) {
        for (Class<?> currentParamClass = instance.getClass(); currentParamClass != null && !Object.class.getName().equals(currentParamClass.getName()); currentParamClass = currentParamClass.getSuperclass()) {
            for (Field currentField : currentParamClass.getDeclaredFields()) {
                if (!currentField.getName().endsWith("default" + targetType.getSimpleName()) || !targetType.isAssignableFrom(currentField.getType())) continue;
                return currentField;
            }
        }
        return null;
    }

    private static List<ConfiguredValueResolver> getConfiguredValueResolvers() {
        List configuredValueResolvers = DefaultServiceProvider.loadServices(ConfiguredValueResolver.class);
        ArrayList<ConfiguredValueResolver> resolvers = new ArrayList<ConfiguredValueResolver>();
        InvocationOrderComparator comparator = new InvocationOrderComparator();
        for (ConfiguredValueResolver currentResolver : configuredValueResolvers) {
            if (!currentResolver.isActivated()) continue;
            resolvers.add(currentResolver);
        }
        Collections.sort(resolvers, comparator);
        return resolvers;
    }

    static void processConfiguredArtifact(String key, List<String> results) {
        ConfiguredArtifactUtils.processFoundArtifact(key, String.class, results);
    }

    static <T extends Serializable> void processFoundArtifact(String key, Class<T> targetType, List<T> artifacts) {
        for (Serializable currentArtifact : artifacts) {
            ConfiguredArtifactUtils.cacheArtifact(key, currentArtifact);
        }
    }

    private static <T extends Serializable> void cacheArtifact(String key, T artifact) {
        ClassLoader classLoader = ClassUtils.getClassLoader(null);
        if (String.class.isAssignableFrom(artifact.getClass())) {
            Set<String> configuredValues;
            Map<String, Set<String>> configuredValueMapping = configuredValueCache.get(classLoader);
            if (configuredValueMapping == null) {
                configuredValueMapping = new HashMap<String, Set<String>>();
                configuredValueCache.put(classLoader, configuredValueMapping);
            }
            if ((configuredValues = configuredValueMapping.get(key)) == null) {
                configuredValues = new HashSet<String>();
                configuredValueMapping.put(key, configuredValues);
            }
            configuredValues.add((String)((Object)artifact));
        } else {
            ArtifactCacheKey<String> cacheKey;
            Set<Serializable> configuredValues;
            Map<ArtifactCacheKey<String>, Set<Serializable>> configuredValueMapping = apiToImplCache.get(classLoader);
            if (configuredValueMapping == null) {
                configuredValueMapping = new HashMap<ArtifactCacheKey<String>, Set<Serializable>>();
                apiToImplCache.put(classLoader, configuredValueMapping);
            }
            if ((configuredValues = configuredValueMapping.get(cacheKey = new ArtifactCacheKey<String>(key, artifact.getClass()))) == null) {
                configuredValues = new HashSet<Serializable>();
                configuredValueMapping.put(cacheKey, configuredValues);
            }
            configuredValues.add(artifact);
        }
    }

    private static <T> void checkArtifacts(Class<T> targetType, List<T> results, boolean supportOfMultipleArtifacts) {
        if (!supportOfMultipleArtifacts && results.size() > 1) {
            StringBuilder message = new StringBuilder();
            if (String.class.equals(targetType)) {
                message.append("Multiple values ");
                message.append(" aren't allowed. Found values: \n");
            } else {
                message.append("Multiple implementations for ");
                message.append(targetType.getName());
                message.append(" aren't allowed. Found implementations: \n");
            }
            for (T artifact : results) {
                if (artifact instanceof String) {
                    message.append("'");
                    message.append(artifact);
                    message.append("'");
                } else {
                    message.append(artifact.getClass().getName());
                }
                message.append("\n");
            }
            throw new IllegalStateException(message.toString());
        }
    }
}

