/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationAspect;
import org.apache.myfaces.orchestra.conversation.ConversationAspects;
import org.apache.myfaces.orchestra.conversation.ConversationBinder;
import org.apache.myfaces.orchestra.conversation.ConversationBindingEvent;
import org.apache.myfaces.orchestra.conversation.ConversationBindingListener;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationFactory;
import org.apache.myfaces.orchestra.conversation.CurrentConversationInfo;

public class Conversation {
    private static final ThreadLocal CURRENT_CONVERSATION = new ThreadLocal();
    private final Log log = LogFactory.getLog(Conversation.class);
    private final String name;
    private final ConversationFactory factory;
    private final ConversationContext conversationContext;
    private ConversationBinder binder;
    private Map beans = new TreeMap();
    private ConversationAspects conversationAspects = new ConversationAspects();
    private boolean invalid = false;
    private boolean queueInvalid = false;
    private long lastAccess;
    private Object activeCountMutex = new Object();
    private int activeCount;

    public Conversation(ConversationContext conversationContext, String name, ConversationFactory factory) {
        this.conversationContext = conversationContext;
        this.name = name;
        this.factory = factory;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start conversation:" + name));
        }
        this.touch();
    }

    public void setBinder(ConversationBinder binder) {
        this.binder = binder;
    }

    protected void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object bean) {
        this.checkValid();
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            this.removeAttribute(name);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("put bean to conversation:" + name + "(bean=" + bean + ")"));
            }
            this.beans.put(name, bean);
        }
        if (bean instanceof ConversationBindingListener) {
            ((ConversationBindingListener)bean).valueBound(new ConversationBindingEvent(this, name));
        }
    }

    protected void checkValid() {
        if (this.isInvalid()) {
            throw new IllegalStateException("conversation '" + this.getName() + "' closed");
        }
    }

    public String getName() {
        return this.name;
    }

    public ConversationFactory getFactory() {
        return this.factory;
    }

    public void invalidate() {
        if (!this.isActive()) {
            this.destroy();
        } else {
            this.queueInvalid = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("conversation '" + this.name + "' queued for destroy."));
            }
        }
    }

    public Conversation invalidateAndRestart() {
        String conversationName = this.getName();
        ConversationFactory factory = this.getFactory();
        this.destroy();
        return this.conversationContext.startConversation(conversationName, factory);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    boolean isQueueInvalid() {
        return this.queueInvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("destroy conversation:" + this.name));
        }
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            String[] beanNames = this.beans.keySet().toArray(new String[this.beans.size()]);
            for (int i = 0; i < beanNames.length; ++i) {
                this.removeAttribute(beanNames[i]);
            }
        }
        this.conversationContext.removeConversation(this.getName());
        this.invalid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String name) {
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            return this.beans.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            return this.beans.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String name) {
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            Object bean = this.beans.remove(name);
            if (bean instanceof ConversationBindingListener) {
                ((ConversationBindingListener)bean).valueUnbound(new ConversationBindingEvent(this, name));
            }
            return bean;
        }
    }

    public static Conversation getCurrentInstance() {
        CurrentConversationInfo conversation = Conversation.getCurrentInstanceInfo();
        if (conversation != null) {
            return conversation.getConversation();
        }
        return null;
    }

    static void setCurrentInstance(CurrentConversationInfo conversation) {
        CURRENT_CONVERSATION.set(conversation);
    }

    static CurrentConversationInfo getCurrentInstanceInfo() {
        CurrentConversationInfo conversationInfo = (CurrentConversationInfo)CURRENT_CONVERSATION.get();
        if (conversationInfo != null && conversationInfo.getConversation() != null) {
            conversationInfo.getConversation().touch();
            return conversationInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterConversation() {
        this.checkValid();
        Object object = this.activeCountMutex;
        synchronized (object) {
            ++this.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveConversation() {
        Object object = this.activeCountMutex;
        synchronized (object) {
            --this.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive() {
        Object object = this.activeCountMutex;
        synchronized (object) {
            return this.activeCount > 0;
        }
    }

    ConversationAspects getAspects() {
        return this.conversationAspects;
    }

    public ConversationAspect getAspect(Class conversationAspectClass) {
        return this.conversationAspects.getAspect(conversationAspectClass);
    }

    public void addAspect(ConversationAspect aspect) {
        this.conversationAspects.addAspect(aspect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getBeans() {
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            return this.beans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBeans(Map beans) {
        ConversationContext conversationContext = this.conversationContext;
        synchronized (conversationContext) {
            this.beans = beans;
        }
    }

    public Object bind(Object instance) {
        if (this.binder == null) {
            throw new UnsupportedOperationException("No beanBinder instance");
        }
        return this.binder.bind(instance);
    }
}

